package com.elitesland.yst.production.sale.controller.shop;

import com.elitesland.yst.production.sale.api.service.shop.BipCouponCustService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCouponCustCurrentParam;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCouponCustShopCartParam;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCouponQueryParam;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCouponCustVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCouponIndexVO;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;


/**
 * <p>
 * 优惠卷控制器
 * </p>
 *
 * @author Shadow
 * @since 2021-08-11 09:45:54
 */
@RestController
@RequestMapping("/bip/couponcust")
@Api(value = "优惠券领用记录", tags = {"优惠券领用记录"})
@RequiredArgsConstructor
public class BipCouponCustController {

    private final BipCouponCustService bipCouponCustService;

    @PostMapping("/currentUserCouponCust")
    @ApiOperation("加购物车时候查询可用优惠券")
    ApiResult<List<BipCouponCustVO>> currentUserCouponCust(@RequestBody BipCouponCustCurrentParam param){
        List<BipCouponCustVO> list = bipCouponCustService.currentUserCouponCust(param);
        return ApiResult.ok(list);
    }

    @GetMapping("/paySuccessUpdateCouponStatus/{id}/{useStatus}")
    @ApiOperation("支付成功优惠券更新状态")
    ApiResult<Object> paySuccessUpdateCouponStatus(@PathVariable Long id,@PathVariable String useStatus){
        bipCouponCustService.modifyCouponCustUseStatus(id,useStatus);
        return ApiResult.ok();
    }

    @GetMapping("/modifyCouponCustUseStatus/{id}/{status}")
    @ApiOperation("修改优惠券使用状态")
    ApiResult<Object> modifyCouponCustUseStatus(@PathVariable Long id,@PathVariable String status){
        bipCouponCustService.paySuccessUpdateCouponStatus(id,status);
        return ApiResult.ok();
    }

    /**
     * 首页弹出未使用优惠券
     *优惠券使用状态 未使用:NOTUSED   已使用:USED  已删除:DEL  已过期：OVERDUE
     * @return
     */
    @GetMapping("/indexPageShow")
    @ApiOperation("首页弹出未使用优惠券")
    ApiResult<BipCouponIndexVO> indexPageShow(){
        BipCouponIndexVO vo = bipCouponCustService.indexPageShow();
        return ApiResult.ok(vo);
    }

    /**
     * 分页查询已领取优惠券列表
     * @param param 优惠券使用状态 未使用:NOTUSED   已使用:USED  已删除:DEL  已过期：OVERDUE
     * @return
     */
    @PostMapping("/pageSearch")
    @ApiOperation("分页查询优惠券列表")
    ApiResult<PagingVO<BipCouponCustVO>> pageSearch(@RequestBody BipCouponQueryParam param){
        PagingVO<BipCouponCustVO> page = bipCouponCustService.pageSearch(param);
        return ApiResult.ok(page);
    }

    /**
     * 查询领取过的优惠券
     * @param useStatus 优惠券使用状态 未使用:NOTUSED   已使用:USED  已删除:DEL  已过期：OVERDUE
     * @return
     */
    @GetMapping("/searchCouponCust/{useStatus}/{userId}")
    @ApiOperation("查询领取过的优惠券")
    ApiResult<List<BipCouponCustVO>> searchCouponCust(@PathVariable String useStatus,@PathVariable Long userId){
        List<BipCouponCustVO> page = bipCouponCustService.searchCouponCust(useStatus,userId);
        return ApiResult.ok(page);
    }

    /**
     * 领取优惠券
     * @param ids 优惠券ID
     * @return 领取优惠券
     */
    @GetMapping("/receiveCoupon/{ids}")
    @ApiOperation("领取优惠券")
    ApiResult<Object> receiveCoupon(@PathVariable List<Long> ids){
        return ApiResult.ok(bipCouponCustService.receiveCoupon(ids));
    }

    /**
     * 新用户自动领取优惠券
     * @param
     * @return 新用户自动领取优惠券
     */
    @GetMapping("/newUserReceiveCoupon")
    @ApiOperation("新用户自动领取优惠券")
    ApiResult<Object> newUserReceiveCoupon(){
        bipCouponCustService.newUserReceiveCoupon();
        return ApiResult.ok();
    }

    /**
     * 删除优惠券
     * @param id 优惠券ID
     * @return 删除用户优惠券
     */
    @GetMapping("/deleteCouponCust/{id}")
    @ApiOperation("删除用户优惠券")
    ApiResult<Object> deleteCouponCust(@PathVariable Long id){
        bipCouponCustService.deleteCouponCust(id);
        return ApiResult.ok();
    }




}
