package com.elitesland.yst.production.sale.controller.shop;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Validator;
import com.elitesland.yst.production.sale.api.service.shop.BipFeedBackService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipFeedBackParam;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipFeedBackQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipFeedBackRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipFeedBackSaveVO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author Joker (Xing Shixiang)
 * @create 2021-08-11 13:11
 */
@RestController
@RequestMapping(value = "/bip/feedBack", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(tags = "意见反馈")
@ApiSupport(author = "Xing", order = 1)
@Slf4j
public class BipFeedBackController {
    @Autowired
    private BipFeedBackService bipFeedBackService;

    @PostMapping(value = "/add")
    @ApiOperation(value = "(客户)新增意见反馈")
    @ApiOperationSupport(order = 1)
    public ApiResult<Long> addFeedBack(@RequestBody BipFeedBackParam param) {
        Assert.isFalse(Validator.isEmpty(param.getContext()), "意见内容不能为空");
        return ApiResult.ok(bipFeedBackService.addFeedBack(param));
    }

    @GetMapping(value = "/getAll")
    @ApiOperation(value = "根据用户账户ID查找意见反馈")
    @ApiOperationSupport(order = 2)
    public ApiResult<List<BipFeedBackRespVO>> getFeedBackAllById() {
        List<BipFeedBackRespVO> feedBacks = bipFeedBackService.getFeedBackAllById();
        return ApiResult.ok(feedBacks);
    }
    @GetMapping(value = "/findOneById/{id}")
    @ApiOperation(value = "根据主键ID查找信息详情")
    @ApiOperationSupport(order = 3)
    public ApiResult<BipFeedBackRespVO> findOneById(@PathVariable Long id) {
        BipFeedBackRespVO feedBacks = bipFeedBackService.findOneById(id);
        return ApiResult.ok(feedBacks);
    }

    @PostMapping(value = "/query")
    @ApiOperation(value = "(管理端)客户意见反馈(分页查询)")
    @ApiOperationSupport(order = 4)
    public ApiResult<PagingVO<BipFeedBackRespVO>> query(@RequestBody BipFeedBackQueryParamVO queryParamVO) {
        PagingVO<BipFeedBackRespVO> query = bipFeedBackService.query(queryParamVO);
        return ApiResult.ok(query);
    }

    @PostMapping(value = "/reply")
    @ApiOperation(value = "(管理端)客户意见反馈(信息回复)")
    @ApiOperationSupport(order = 5)
    public ApiResult<Object> reply(@RequestBody BipFeedBackSaveVO saveVO) {
        bipFeedBackService.reply(saveVO);
        return ApiResult.ok();
    }

}
