package com.elitesland.yst.production.sale.convert;


import com.elitesland.yst.production.sale.api.vo.resp.crm.*;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCrmCustInfoVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipCustQualifyRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipCustQualifySaveVO;
import com.elitesland.yst.production.sale.api.vo.save.*;
import com.elitesland.yst.production.sale.api.vo.save.exter.CrmCustSaveDTO;
import com.elitesland.yst.production.sale.core.mapstruct.CustomMapperConfig;
import com.elitesland.yst.production.sale.dto.CrmCustDTO;
import com.elitesland.yst.production.sale.dto.SalemanCustDTO;
import com.elitesland.yst.production.sale.dto.save.CrmCustRpcSaveDto;
import com.elitesland.yst.production.sale.entity.CrmCustDO;
import com.elitesland.yst.production.support.provider.org.dto.OrgAddrAddressRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgAddrBankAccRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgAddrQualifyRpcDTO;
import com.elitesland.yst.production.support.provider.org.param.OrgAddrAddressRpcSaveParam;
import com.elitesland.yst.production.support.provider.org.param.OrgAddrBankAccRpcSaveParam;
import com.elitesland.yst.production.support.provider.org.param.OrgAddrQualifyRpcSaveParam;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021-05-14
 */
@Mapper(config = CustomMapperConfig.class)
public interface CrmCustConvert {

    CrmCustConvert INSTANCE = Mappers.getMapper(CrmCustConvert.class);

    /**
     * do转dto
     *
     * @return dto
     */
    CrmCustDTO do2Dto(CrmCustDO custDO);

    CrmCustPageRespVO doToPageRespVO(CrmCustDO crmCustDO);

    CrmCustSaveVO doToSaveVO(CrmCustDO crmCustDO);

    CrmCustDO pageToDO(CrmCustPageRespVO crmCustPageRespVO);

    @Mappings({
            @Mapping(source = "addrNo", target = "recvAddrNo")
    })
    CrmCustPlugInRespVO doToPlugInRespVO(CrmCustDO crmCustDO);

    CrmCustDetailRespVO doToDetailRespVO(CrmCustDO crmCustDO);

    /**
     * saveVo转do
     *
     * @param saveVO    saveVo
     * @param crmCustDO do
     */
    void copyVoToDo(CrmCustSaveVO saveVO, @MappingTarget CrmCustDO crmCustDO);

    /**
     * detailVo转do
     *
     * @param detailRespVO detailVo
     */
    CrmCustDO detailVoToDo(CrmCustDetailRespVO detailRespVO);

    /**
     * importVo转do
     *
     * @param crmCustImportSaveVO
     */
    CrmCustDO importVoToDo(CrmCustImportSaveVO crmCustImportSaveVO);

    /**
     * importVo转RpcSave
     *
     * @param crmAddrImplSaveVO
     */
    OrgAddrAddressRpcSaveParam addrImportVoToDo(CrmAddrImplSaveVO crmAddrImplSaveVO);

    @Mappings({
            @Mapping(source = "id", target = "addrId"),
            @Mapping(source = "tel", target = "contTel"),
            @Mapping(source = "mobile", target = "contMobile"),
            @Mapping(source = "detailAddr", target = "detailaddr"),
            @Mapping(source = "fax", target = "contFax"),
            @Mapping(source = "email", target = "contEmail")
    })
    CrmCustAddrRespVO addrRpcToAddrVo(OrgAddrAddressRpcDTO orgAddrAddressRpcDTO);

    OrgAddrBankAccRespVO bankRpcToAddrVo(OrgAddrBankAccRpcDTO orgAddrBankAccRpcDTO);

    CrmCustQualifyRespVO qualifyRpcToAddrVo(OrgAddrQualifyRpcDTO orgAddrQualifyRpcDTO);

    BipCustQualifyRespVO qualifyRpcToBipAddrVo(OrgAddrQualifyRpcDTO orgAddrQualifyRpcDTO);

    @Mappings({
            @Mapping(source = "contTel", target = "tel"),
            @Mapping(source = "contMobile", target = "mobile"),
            @Mapping(source = "detailaddr", target = "detailAddr"),
            @Mapping(source = "contFax", target = "fax"),
            @Mapping(source = "contEmail", target = "email")
    })
    OrgAddrAddressRpcSaveParam saveVoToAddrRpc(CrmCustAddrSaveVO crmCustAddrSaveVO);

    OrgAddrBankAccRpcSaveParam saveVoToBankRpc(OrgAddrBankAccSaveVO orgAddrBankAccSaveVO);




    OrgAddrQualifyRpcSaveParam saveVoToQualifyRpc(CrmCustQualifySaveVO crmCustQualifySaveVO);

    OrgAddrQualifyRpcSaveParam bipSaveVoToQualifyRpc(BipCustQualifySaveVO crmCustQualifySaveVO);

    BipCrmCustInfoVO doToBaseInfoVO(CrmCustDO crmCustDO);

    CrmCustSaveVO saveRpcToVO(CrmCustRpcSaveDto crmCustRpcSaveDto);

    CrmCustSaveVO saveLmToVo(LmCrmCustSaveVO vo);

    CrmCustSaveVO saveDtoToSaveVO(CrmCustSaveDTO crmCustSaveDTO);

    CrmCustSimpleVO do2SimpleVo(CrmCustDO t);

    SalemanCustDTO dtoConvertLmSaveCustRespVO(LmSaveCustRespVO save);
}
