package com.elitesland.yst.production.sale.convert;

import com.elitesland.yst.production.sale.api.vo.param.pri.PriCrossPriceQueryParam;
import com.elitesland.yst.production.sale.api.vo.param.pri.PriSalePriceQueryParam;
import com.elitesland.yst.production.sale.api.vo.resp.pri.*;
import com.elitesland.yst.production.sale.core.mapstruct.CustomMapperConfig;
import com.elitesland.yst.production.sale.dto.PriBasePriceDTO;
import com.elitesland.yst.production.sale.dto.PriCrossPriceDTO;
import com.elitesland.yst.production.sale.dto.PriSalePriceDTO;
import com.elitesland.yst.production.sale.dto.query.PriBasePriceReqDTO;
import com.elitesland.yst.production.sale.dto.query.PriCrossPriceReqDTO;
import com.elitesland.yst.production.sale.dto.query.PriSalePriceReqDTO;
import com.elitesland.yst.production.sale.entity.PriSalePriceDO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;

/**
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/5/26 11:48 上午
 */
@Mapper(config = CustomMapperConfig.class)
public interface PriSalePriceConvert {
    PriSalePriceConvert INSTANCE = Mappers.getMapper(PriSalePriceConvert.class);

    PriSalePricePageRespVO doToPageRespVo(PriSalePriceDO priSalePriceDO);

    PriCrossPriceRespVO paramToVo(PriCrossPriceQueryParam crossParam);

    PriSalePriceRespVO paramToVo(PriSalePriceQueryParam saleParam);

    PriCrossPriceDTO reqDtoToRespDto(PriCrossPriceReqDTO reqDTO);

    PriSalePriceDTO reqDtoToRespDto(PriSalePriceReqDTO reqDTO);

    PriBasePriceDTO reqDtoToRespDto(PriBasePriceReqDTO reqDTO);

    PriSalePriceTypeRespVO doToTypeVo(PriSalePriceDO priSalePriceDO);

    @Mappings({
            @Mapping(source = "itemCatePath",target = "itemCateCode")
    })
    PriSalePriceExportVO respVoToExport(PriSalePricePageRespVO priSalePricePageRespVO);
}

