package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/03/16:19
 * @Description: 专区设置表实体类
 */

@Entity
@Table(name = "bip_special_area_config")
@org.hibernate.annotations.Table(appliesTo = "bip_special_area_config", comment = "专区设置表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class BipSpeciacAreaConfigDo extends BaseModel implements Serializable {

    private static final long serialVersionUID = -4377488049394841765L;

    @Column(name = "code", columnDefinition = "varchar(32)   comment '专区编码'")
    private String code;


    @Column(name = "name", columnDefinition = "varchar(32)   comment '专区名称'")
    private String name;


    @Column(name = "priority", columnDefinition = "varchar(32)    comment '优先级'")
    private String priority;


    @Column(name = "status", columnDefinition = "varchar(32)    comment '专区状态'")
    private String status;


    @Column(name = "ou_id", columnDefinition = "bigInt(20)    comment '公司ID'")
    private Long ouId;



    @Column(name = "ou_code", columnDefinition = "varchar(32)    comment '公司编码'")
    private String ouCode;

    @Column(name = "ou_name", columnDefinition = "varchar(32)    comment '公司名称'")
    private String ouName;


    @Column(name = "show_index", columnDefinition = "varchar(32)    comment '是否首页展示'")
    private String showIndex;
}
