package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * (CrmScust)实体类
 *
 * @author zhao.zhi.hao
 * @since 2021-06-04 10:44:17
 */
@Entity
@Table(name = "crm_scust", indexes = {
        @Index(name = "idx_crm_scust_cust_code", columnList = "cust_code", unique = true),
        @Index(name = "idx_crm_scust_cust_name", columnList = "cust_name"),
})
@org.hibernate.annotations.Table(appliesTo = "crm_scust",comment = "潜在客户")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class CrmScustDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = -72622622889488593L;

    @ApiModelProperty("公司ID")
    @Column(name = "ou_id", columnDefinition = "bigint(18) default null comment '公司ID'")
    private Long ouId;

    @ApiModelProperty("公司编号")
    @Column(name = "ou_code", columnDefinition = "longtext default null comment '公司编号'")
    private String ouCode;

    @ApiModelProperty("公司名称")
    @Column(name = "ou_name", columnDefinition = "varchar(200) default null comment '公司名称'")
    private String ouName;

    @ApiModelProperty("BUID")
    @Column(name = "bu_id", columnDefinition = "bigint(18) default null comment 'BUID'")
    private Long buId;

    @ApiModelProperty("BU编号")
    @Column(name = "bu_code", columnDefinition = "longtext default null comment 'BU编号'")
    private String buCode;

    @ApiModelProperty("BU名称")
    @Column(name = "bu_name", columnDefinition = "varchar(200) default null comment 'BU名称'")
    private String buName;

    @ApiModelProperty("客户编号")
    @Column(name = "cust_code", columnDefinition = "varchar(40) default null comment '客户编号'")
    private String custCode;

    @ApiModelProperty("客户编号2")
    @Column(name = "cust_code2", columnDefinition = "varchar(40) default null comment '客户编号2'")
    private String custCode2;

    @ApiModelProperty("客户名称")
    @Column(name = "cust_name", columnDefinition = "varchar(200) default null comment '客户名称'")
    private String custName;

    @ApiModelProperty("客户名称2")
    @Column(name = "cust_name2", columnDefinition = "varchar(200) default null comment '客户名称2'")
    private String custName2;
  
    @ApiModelProperty("客户名称3")
    @Column(name = "cust_name3", columnDefinition = "varchar(200) default null comment '客户名称3'")
    private String custName3;
 
    @ApiModelProperty("客户简称")
    @Column(name = "cust_abbr", columnDefinition = "varchar(100) default null comment '客户简称'")
    private String custAbbr;
  
    @ApiModelProperty("客户描述")
    @Column(name = "cust_desc", columnDefinition = "longtext default null comment '客户描述'")
    private String custDesc;
  
    @ApiModelProperty("客户类型")
    @Column(name = "cust_type", columnDefinition = "varchar(40) default null comment '客户类型'")
    private String custType;

    @ApiModelProperty("客户类型2")
    @Column(name = "cust_type2", columnDefinition = "varchar(40) default null comment '客户类型2'")
    private String custType2;

    @ApiModelProperty("客户类型3")
    @Column(name = "cust_type3", columnDefinition = "varchar(40) default null comment '客户类型3'")
    private String custType3;

    @ApiModelProperty("客户类型4")
    @Column(name = "cust_type4", columnDefinition = "varchar(40) default null comment '客户类型4'")
    private String custType4;

    @ApiModelProperty("客户类型5")
    @Column(name = "cust_type5", columnDefinition = "varchar(40) default null comment '客户类型5'")
    private String custType5;
 
    @ApiModelProperty("客户状态")
    @Column(name = "cust_status", columnDefinition = "varchar(40) default null comment '客户状态'")
    private String custStatus;

    @ApiModelProperty("客户状态2")
    @Column(name = "cust_status2", columnDefinition = "varchar(40) default null comment '客户状态2'")
    private String custStatus2;

    @ApiModelProperty("客户状态3")
    @Column(name = "cust_status3", columnDefinition = "varchar(40) default null comment '客户状态3'")
    private String custStatus3;
 
    @ApiModelProperty("意向等级")
    @Column(name = "intent_level", columnDefinition = "longtext default null comment '意向等级'")
    private String intentLevel;
 
    @ApiModelProperty("意向描述")
    @Column(name = "intent_desc", columnDefinition = "longtext default null comment '意向描述'")
    private String intentDesc;

    @ApiModelProperty("最后跟进日期")
    @Column(name = "last_followup_date", columnDefinition = "datetime default null comment '最后跟进日期'")
    private LocalDateTime lastFollowupDate;

    @ApiModelProperty("大类编号")
    @Column(name = "c1_code", columnDefinition = "varchar(40) default null comment '大类编号'")
    private String c1Code;
  
    @ApiModelProperty("中类编号")
    @Column(name = "c2_code", columnDefinition = "varchar(40) default null comment '中类编号'")
    private String c2Code;
 
    @ApiModelProperty("小类编号")
    @Column(name = "c3_code", columnDefinition = "varchar(40) default null comment '小类编号'")
    private String c3Code;

    @ApiModelProperty("上级id")
    @Column(name = "pid", columnDefinition = "bigint(18) default null comment '上级id'")
    private Long pid;

    @ApiModelProperty("路径")
    @Column(name = "cust_path", columnDefinition = "varchar(500) default null comment '路径'")
    private String custPath;
 
    @ApiModelProperty("地址号")
    @Column(name = "addr_no", columnDefinition = "bigint(18) default null comment '地址号'")
    private Long addrNo;
  
    @ApiModelProperty("拼音")
    @Column(name = "pinyin", columnDefinition = "varchar(40) default null comment '拼音'")
    private String pinyin;
 
    @ApiModelProperty("拼音简称")
    @Column(name = "pinyin_sh", columnDefinition = "varchar(40) default null comment '拼音简称'")
    private String pinyinSh;
 
    @ApiModelProperty("业务员员工id")
    @Column(name = "agent_emp_id", columnDefinition = "bigint(18) default null comment '业务员员工id'")
    private Long agentEmpId;

    @ApiModelProperty("付款方式")
    @Column(name = "pay_method", columnDefinition = "varchar(40) default null comment '付款方式'")
    private String payMethod;
 
    @ApiModelProperty("币种")
    @Column(name = "cust_curr", columnDefinition = "varchar(40) default null comment '币种'")
    private String custCurr;

    @ApiModelProperty("支付条款")
    @Column(name = "payment_term", columnDefinition = "varchar(40) default null comment '支付条款'")
    private String paymentTerm;
 
    @ApiModelProperty("结算方式")
    @Column(name = "settle_type", columnDefinition = "varchar(40) default null comment '结算方式'")
    private String settleType;
  
    @ApiModelProperty("区域")
    @Column(name = "region", columnDefinition = "varchar(40) default null comment '区域'")
    private String region;
  
    @ApiModelProperty("客户等级")
    @Column(name = "cust_level", columnDefinition = "varchar(40) default null comment '客户等级'")
    private String custLevel;
  
    @ApiModelProperty("渠道类型")
    @Column(name = "channel_type", columnDefinition = "longtext default null comment '渠道类型'")
    private String channelType;
  
    @ApiModelProperty("渠道类型2")
    @Column(name = "channel_type2", columnDefinition = "longtext default null comment '渠道类型2'")
    private String channelType2;
  
    @ApiModelProperty("客户行业")
    @Column(name = "cust_industry", columnDefinition = "longtext default null comment '客户行业'")
    private String custIndustry;
  
    @ApiModelProperty("客户来源")
    @Column(name = "cust_source", columnDefinition = "varchar(20) default null comment '客户来源'")
    private String custSource;

    @ApiModelProperty("工商登记号")
    @Column(name = "ic_register_no", columnDefinition = "varchar(40) default null comment '工商登记号'")
    private String icRegisterNo;
  
    @ApiModelProperty("注册日期")
    @Column(name = "register_date", columnDefinition = "datetime default null comment '注册日期'")
    private LocalDateTime registerDate;
  
    @ApiModelProperty("注册地址")
    @Column(name = "register_address", columnDefinition = "varchar(200) default null comment '注册地址'")
    private String registerAddress;
 
    @ApiModelProperty("注册商标编码")
    @Column(name = "register_trademark_no", columnDefinition = "varchar(40) default null comment '注册商标编码'")
    private String registerTrademarkNo;
 
    @ApiModelProperty("注册资金")
    @Column(name = "register_fund", columnDefinition = "varchar(40) default null comment '注册资金'")
    private String registerFund;
  
    @ApiModelProperty("注册资金货币")
    @Column(name = "register_fund_curry", columnDefinition = "varchar(40) default null comment '注册资金货币'")
    private String registerFundCurry;
 
    @ApiModelProperty("工商登记注册机关")
    @Column(name = "ic_issued", columnDefinition = "varchar(40) default null comment '工商登记注册机关'")
    private String icIssued;

    @ApiModelProperty("工商登记日期")
    @Column(name = "ic_issued_date", columnDefinition = "datetime default null comment '工商登记日期'")
    private LocalDateTime icIssuedDate;
 
    @ApiModelProperty("组织机构代码证")
    @Column(name = "biz_code_cert", columnDefinition = "varchar(40) default null comment '组织机构代码证'")
    private String bizCodeCert;
 
    @ApiModelProperty("机构类型")
    @Column(name = "biz_type", columnDefinition = "varchar(40) default null comment '机构类型'")
    private String bizType;
   
    @ApiModelProperty("组织机构代码证颁发单位")
    @Column(name = "biz_issued", columnDefinition = "varchar(40) default null comment '组织机构代码证颁发单位'")
    private String bizIssued;
 
    @ApiModelProperty("统一信用代码")
    @Column(name = "cert_no", columnDefinition = "varchar(40) default null comment '统一信用代码'")
    private String certNo;
 
    @ApiModelProperty("税务登记证编号")
    @Column(name = "tax_reg_no", columnDefinition = "varchar(40) default null comment '税务登记证编号'")
    private String taxRegNo;
 
    @ApiModelProperty("纳税人识别号")
    @Column(name = "taxpayer_id", columnDefinition = "varchar(40) default null comment '纳税人识别号'")
    private String taxpayerId;

    @ApiModelProperty("法人代表")
    @Column(name = "repr", columnDefinition = "varchar(40) default null comment '法人代表'")
    private String repr;
 
    @ApiModelProperty("法人证件类型")
    @Column(name = "repr_cert_type", columnDefinition = "varchar(40) default null comment '法人证件类型'")
    private String reprCertType;
 
    @ApiModelProperty("法人证件编号")
    @Column(name = "repr_cert_no", columnDefinition = "varchar(40) default null comment '法人证件编号'")
    private String reprCertNo;

    @ApiModelProperty("法人手机号")
    @Column(name = "repr_cert_mobile", columnDefinition = "varchar(40) default null comment '法人手机号'")
    private String reprCertMobile;

    @ApiModelProperty("公司名称")
    @Column(name = "comp_name", columnDefinition = "varchar(40) default null comment '公司名称'")
    private String compName;

    @ApiModelProperty("公司性质")
    @Column(name = "comp_prop", columnDefinition = "varchar(40) default null comment '公司性质'")
    private String compProp;
   
    @ApiModelProperty("公司规模")
    @Column(name = "comp_scale", columnDefinition = "varchar(40) default null comment '公司规模'")
    private String compScale;
  
    @ApiModelProperty("年营业额")
    @Column(name = "comp_turnover", columnDefinition = "longtext default null comment '年营业额'")
    private String compTurnover;
  
    @ApiModelProperty("经营地点")
    @Column(name = "comp_bussaddr", columnDefinition = "varchar(40) default null comment '经营地点'")
    private String compBussaddr;
   
    @ApiModelProperty("主营业务")
    @Column(name = "comp_mainbuss", columnDefinition = "varchar(40) default null comment '主营业务'")
    private String compMainbuss;
  
    @ApiModelProperty("经营范围")
    @Column(name = "comp_bussrange", columnDefinition = "longtext default null comment '经营范围'")
    private String compBussrange;
  
    @ApiModelProperty("标签")
    @Column(name = "tags", columnDefinition = "varchar(200) default null comment '标签'")
    private String tags;
 
    @ApiModelProperty("类别码1")
    @Column(name = "cat", columnDefinition = "varchar(40) default null comment '类别码1'")
    private String cat;
  
    @ApiModelProperty("类别码2")
    @Column(name = "cat2", columnDefinition = "varchar(40) default null comment '类别码2'")
    private String cat2;
  
    @ApiModelProperty("类别码3")
    @Column(name = "cat3", columnDefinition = "varchar(40) default null comment '类别码3'")
    private String cat3;

    @ApiModelProperty("类别码4")
    @Column(name = "cat4", columnDefinition = "varchar(40) default null comment '类别码4'")
    private String cat4;

    @ApiModelProperty("类别码5")
    @Column(name = "cat5", columnDefinition = "varchar(40) default null comment '类别码5'")
    private String cat5;
  
    @ApiModelProperty("类别码6")
    @Column(name = "cat6", columnDefinition = "varchar(40) default null comment '类别码6'")
    private String cat6;
  
    @ApiModelProperty("类别码7")
    @Column(name = "cat7", columnDefinition = "varchar(40) default null comment '类别码7'")
    private String cat7;
  
    @ApiModelProperty("类别码8")
    @Column(name = "cat8", columnDefinition = "varchar(40) default null comment '类别码8'")
    private String cat8;
   
    @ApiModelProperty("类别码9")
    @Column(name = "cat9", columnDefinition = "varchar(40) default null comment '类别码9'")
    private String cat9;
   
    @ApiModelProperty("类别码10")
    @Column(name = "cat10", columnDefinition = "varchar(40) default null comment '类别码10'")
    private String cat10;
  
    @ApiModelProperty("类别码11")
    @Column(name = "cat11", columnDefinition = "varchar(40) default null comment '类别码11'")
    private String cat11;

    @ApiModelProperty("类别码12")
    @Column(name = "cat12", columnDefinition = "varchar(40) default null comment '类别码12'")
    private String cat12;
  
    @ApiModelProperty("类别码13")
    @Column(name = "cat13", columnDefinition = "varchar(40) default null comment '类别码13'")
    private String cat13;
 
    @ApiModelProperty("类别码14")
    @Column(name = "cat14", columnDefinition = "varchar(40) default null comment '类别码14'")
    private String cat14;
  
    @ApiModelProperty("类别码15")
    @Column(name = "cat15", columnDefinition = "varchar(40) default null comment '类别码15'")
    private String cat15;
  
    @ApiModelProperty("类别码16")
    @Column(name = "cat16", columnDefinition = "varchar(40) default null comment '类别码16'")
    private String cat16;
 
    @ApiModelProperty("类别码17")
    @Column(name = "cat17", columnDefinition = "varchar(40) default null comment '类别码17'")
    private String cat17;
   
    @ApiModelProperty("类别码18")
    @Column(name = "cat18", columnDefinition = "varchar(40) default null comment '类别码18'")
    private String cat18;
   
    @ApiModelProperty("类别码19")
    @Column(name = "cat19", columnDefinition = "varchar(40) default null comment '类别码19'")
    private String cat19;
  
    @ApiModelProperty("类别码20")
    @Column(name = "cat20", columnDefinition = "varchar(40) default null comment '类别码20'")
    private String cat20;
  
    @ApiModelProperty("类别码21")
    @Column(name = "cat21", columnDefinition = "varchar(40) default null comment '类别码21'")
    private String cat21;
  
    @ApiModelProperty("类别码22")
    @Column(name = "cat22", columnDefinition = "varchar(40) default null comment '类别码22'")
    private String cat22;
 
    @ApiModelProperty("类别码23")
    @Column(name = "cat23", columnDefinition = "varchar(40) default null comment '类别码23'")
    private String cat23;
  
    @ApiModelProperty("类别码24")
    @Column(name = "cat24", columnDefinition = "varchar(40) default null comment '类别码24'")
    private String cat24;
  
    @ApiModelProperty("类别码25")
    @Column(name = "cat25", columnDefinition = "varchar(40) default null comment '类别码25'")
    private String cat25;
  
    @ApiModelProperty("类别码26")
    @Column(name = "cat26", columnDefinition = "varchar(40) default null comment '类别码26'")
    private String cat26;
  
    @ApiModelProperty("类别码27")
    @Column(name = "cat27", columnDefinition = "varchar(40) default null comment '类别码27'")
    private String cat27;
  
    @ApiModelProperty("类别码28")
    @Column(name = "cat28", columnDefinition = "varchar(40) default null comment '类别码28'")
    private String cat28;
  
    @ApiModelProperty("类别码29")
    @Column(name = "cat29", columnDefinition = "varchar(40) default null comment '类别码29'")
    private String cat29;
  
    @ApiModelProperty("类别码30")
    @Column(name = "cat30", columnDefinition = "varchar(40) default null comment '类别码30'")
    private String cat30;
    
    @ApiModelProperty("es1")
    @Column(name = "es1", columnDefinition = "longtext default null comment 'es1'")
    private String es1;
  
    @ApiModelProperty("es2")
    @Column(name = "es2", columnDefinition = "longtext default null comment 'es2'")
    private String es2;
 
    @ApiModelProperty("es3")
    @Column(name = "es3", columnDefinition = "longtext default null comment 'es3'")
    private String es3;
  
    @ApiModelProperty("es4")
    @Column(name = "es4", columnDefinition = "longtext default null comment 'es4'")
    private String es4;
  
    @ApiModelProperty("es5")
    @Column(name = "es5", columnDefinition = "longtext default null comment 'es5'")
    private String es5;

    @ApiModelProperty("es6")
    @Column(name = "es6", columnDefinition = "longtext default null comment 'es6'")
    private String es6;
  
    @ApiModelProperty("es7")
    @Column(name = "es7", columnDefinition = "longtext default null comment 'es7'")
    private String es7;
  
    @ApiModelProperty("es8")
    @Column(name = "es8", columnDefinition = "longtext default null comment 'es8'")
    private String es8;
   
    @ApiModelProperty("es9")
    @Column(name = "es9", columnDefinition = "longtext default null comment 'es9'")
    private String es9;
 
    @ApiModelProperty("es10")
    @Column(name = "es10", columnDefinition = "longtext default null comment 'es10'")
    private String es10;
 
    @ApiModelProperty("en1")
    @Column(name = "en1", columnDefinition = "decimal(20, 2) default null comment 'en1'")
    private BigDecimal en1;
 
    @ApiModelProperty("en2")
    @Column(name = "en2", columnDefinition = "decimal(20, 2) default null comment 'en2'")
    private BigDecimal en2;
  
    @ApiModelProperty("en3")
    @Column(name = "en3", columnDefinition = "decimal(20, 2) default null comment 'en3'")
    private BigDecimal en3;
   
    @ApiModelProperty("en4")
    @Column(name = "en4", columnDefinition = "decimal(20, 2) default null comment 'en4'")
    private BigDecimal en4;
    
    @ApiModelProperty("en5")
    @Column(name = "en5", columnDefinition = "decimal(20, 4) default null comment 'en5'")
    private BigDecimal en5;


}
