package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: ssy
 * @Date: 2021/08/17
 * @Description:满减折扣实体类
 */

@Entity
@Table(name = "mkt_discount_offset")
@org.hibernate.annotations.Table(appliesTo = "mkt_discount_offset", comment = "满减折扣主表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class MktDiscountOffsetDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -8738611365363611280L;

    @Column(name = "code", columnDefinition = "varchar(20)  comment '折扣编码'")
    private String code;

    @Column(name = "name", columnDefinition = "varchar(40)   comment '折扣名称'")
    private String name;

    @Column(name = "valid_stime", columnDefinition = "datetime   comment '折扣生效时间'")
    private LocalDateTime validStime;

    @Column(name = "valid_etime", columnDefinition = "datetime   comment '折扣失效时间'")
    private LocalDateTime validEtime;

    @Column(name = "custom_level", columnDefinition = "varchar(20)   comment '客户等级'")
    private String customLevel;

    @Column(name = "ou_id", columnDefinition = "bigInt(20)   comment '公司id'")
    private Long ouId;

    @Column(name = "ou_code", columnDefinition = "varchar(20)   comment '公司编码'")
    private String ouCode;

    @Column(name = "ou_name", columnDefinition = "varchar(40)   comment '公司名称'")
    private String ouName;

    @Column(name = "bu_id", columnDefinition = "bigInt(20)   comment '组织id'")
    private Long buId;

    @Column(name = "bu_name", columnDefinition = "varchar(40)   comment '组织名称'")
    private String buName;

    @Column(name = "bu_code", columnDefinition = "varchar(20)   comment '组织编码'")
    private String buCode;

    @Column(name = "curr_code", columnDefinition = "varchar(20) comment '币种'")
    private String currCode;

    @Column(name = "type", columnDefinition = "varchar(20)   comment '促销条件: 0 件数 1 金额'")
    private String type;

    @Column(name = "status", columnDefinition = "varchar(20)   comment '状态'")
    private String status;
}
