package com.elitesland.yst.production.sale.entity;

import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @author Eric.li (Li Jia Zhe)
 * @date 2021-06-21 15:07
 */
@Entity
@Table(name = "sal_acceptance")
@org.hibernate.annotations.Table(appliesTo = "sal_acceptance", comment = "合同验收主表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class SalAcceptanceDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 3157453116257302549L;

    @ApiModelProperty(value = "验收单号")
    @Column(name = "doc_no", columnDefinition = "varchar(40) comment '验收单号'")
    private String docNo;

    @ApiModelProperty(value = "公司ID")
    @Column(name = "ou_id", columnDefinition = "bigint(20) default null  comment '公司ID'")
    private Long ouId;

    @ApiModelProperty(value = "buID")
    @Column(name = "bu_id", columnDefinition = "bigint(20) default null  comment 'buID'")
    private Long buId;

    @ApiModelProperty(value = "公司编码")
    @Column(name = "ou_code", columnDefinition = "varchar(40) comment '公司编码'")
    private String ouCode;

    @ApiModelProperty(value = "申请人ID")
    @Column(name = "apply_emp_id", columnDefinition = "bigint(20) default null  comment '申请人ID'")
    private Long applyEmpId;

    @ApiModelProperty(value = "申请时间")
    @Column(name = "apply_date", columnDefinition = "datetime  comment '申请时间'")
    private LocalDate applyDate;

    @ApiModelProperty(value = "审批人ID")
    @Column(name = "appr_user_id", columnDefinition = "bigint(20) default null  comment '审批人ID'")
    private Long apprUserId;

//    @ApiModelProperty("审批意见")
//    @Column(name = "appr_comment", columnDefinition = "varchar(200) comment '审批意见'")
//    private String apprComment;

//    @ApiModelProperty("审批状态")
//    @Column(name = "appr_status", columnDefinition = "varchar(40) comment '审批状态 [UDC]COM:APPR_STATUS'")
//    private String apprStatus;

    @ApiModelProperty(value = "验收时间")
    @Column(name = "ac_date", columnDefinition = "datetime  comment '申请时间'")
    private LocalDate acDate;

    @ApiModelProperty(value = "客户ID")
    @Column(name = "cust_id", columnDefinition = "bigint(20) default null  comment '客户ID'")
    private Long custId;

    @ApiModelProperty("客户编码")
    @Column(name = "cust_code", columnDefinition = "varchar(40) comment '客户编码'")
    private String custCode;

    @ApiModelProperty("客户名称")
    @Column(name = "cust_name", columnDefinition = "varchar(40) comment '客户名称'")
    private String custName;

    @Column(name = "contract_id", columnDefinition = "bigint(20) comment '合同ID'")
    private Long contractId;

    @Column(name = "contract_no", columnDefinition = "varchar(40) comment '合同编号'")
    private String contractNo;

    @ApiModelProperty("合同名称")
    @Column(name = "contract_name", columnDefinition = "varchar(200) comment '合同名称'")
    private String contractName;

    @ApiModelProperty("项目编号")
    @Column(name = "proj_no", columnDefinition = "varchar(40) comment '项目编号'")
    private String projNo;

    @ApiModelProperty("项目名称")
    @Column(name = "proj_name", columnDefinition = "varchar(200) comment '项目名称'")
    private String projName;

    @ApiModelProperty("验收金额（含税）")
    @Column(name = "amt", columnDefinition = "decimal(20, 8) comment '验收金额（含税）'")
    private BigDecimal amt;

    @ApiModelProperty("状态")
    @Column(name = "ac_status", columnDefinition = "varchar(40) comment '项目状态 UDC'")
    private String acStatus;

    /**
     * 审批流字段
     */
    @ApiModelProperty("流程实例ID")
    @Column
    @Comment("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程实例状态")
    @Column
    @Comment("流程实例状态")
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;

    @ApiModelProperty(value = "提交时间")
    @Comment("提交时间")
    @Column
    private LocalDateTime submitTime;

    @ApiModelProperty(value = "审批通过时间")
    @Comment("审批通过时间")
    @Column
    private LocalDateTime approvedTime;

}
