package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * SAL_RECEIPT(销售收款单).
 * <p>
 * 销售收款单
 *
 * @auther JinXK
 * @date 2021/6/11 18:08
 */
@Entity
@Table(name = "sal_receipt")
@org.hibernate.annotations.Table(appliesTo = "sal_receipt", comment = "销售收款单")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class SalReceiptDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 8678482831493703909L;

    @Column(name = "ou_id", columnDefinition = "bigint(18) default 0 comment '公司ID'")
    private Long ouId;

    @Column(name = "ou_code", columnDefinition = "varchar(40) default null  comment '公司编号'")
    private String ouCode;

    @Column(name = "ou_name", columnDefinition = "varchar(200) default null  comment '公司名称'")
    private String ouName;

    @Column(name = "bu_id", columnDefinition = "bigint(18) default null  comment 'BUID'")
    private Long buId;
    @Column(name = "bu_name", columnDefinition = "varchar(200) default null  comment 'BUNAME'")
    private String buName;

    @Column(name = "doc_no", columnDefinition = "varchar(40) default null  comment '单据编号'")
    private String docNo;

    @Column(name = "doc_type", columnDefinition = "varchar(40) default null  comment '单据类型 [UDC]FIN:AR_TYPE'")
    private String docType;

    @Column(name = "doc_status", columnDefinition = "varchar(40) default null  comment '单据状态'")
    private String docStatus;

    @Column(name = "apply_emp_id", columnDefinition = "bigint(18) default 0 comment '申请人员工ID'")
    private Long applyEmpId;

    @Column(name = "apply_name", columnDefinition = "longtext default null  comment '申请人姓名'")
    private String applyName;

    @Column(name = "apply_date", columnDefinition = "datetime default null  comment '申请日期'")
    private LocalDateTime applyDate;

    @Column(name = "apply_desc", columnDefinition = "varchar(100) default null  comment '申请描述'")
    private String applyDesc;

    @Column(name = "appr_status", columnDefinition = "longtext default null  comment '审批状态 [UDC]COM:APPR_STATUS'")
    private String apprStatus;

    @Column(name = "appr_time", columnDefinition = "datetime default null  comment '审批时间'")
    private LocalDateTime apprTime;

    @Column(name = "appr_user_id", columnDefinition = "bigint(18) default 0 comment '审批人ID'")
    private Long apprUserId;

    @Column(name = "appr_user_Name", columnDefinition = "varchar(40) default null comment '审批人Name'")
    private String apprUserName;

    @Column(name = "appr_comment", columnDefinition = "varchar(500) default null  comment '审批意见'")
    private String apprComment;

    @Column(name = "contract_code", columnDefinition = "longtext default null  comment '合同编号'")
    private String contractCode;

    @Column(name = "pay_method", columnDefinition = "longtext default null  comment '收款方式 [UDC]COM:PAY_METHOD'")
    private String payMethod;

    @Column(name = "store_id", columnDefinition = "bigint(18) default 0 comment '店铺ID'")
    private Long storeId;

    @Column(name = "store_code", columnDefinition = "longtext default null  comment '店铺编号'")
    private String storeCode;

    @Column(name = "store_name", columnDefinition = "longtext default null  comment '店铺名称'")
    private String storeName;

    @Column(name = "plan_receipt_date", columnDefinition = "datetime default null  comment '预计到款日期'")
    private LocalDateTime planReceiptDate;

    @Column(name = "b2b_flag", columnDefinition = "varchar(256) default null  comment '是否公对公收款'")
    private String b2bFlag;

    @Column(name = "off_flag", columnDefinition = "varchar(256) default null  comment '是否红冲'")
    private String offFlag;

    @Column(name = "offed_amt", columnDefinition = "decimal(20, 4) default null  comment '已红冲金额'")
    private BigDecimal offedAmt;

    @Column(name = "offing_amt", columnDefinition = "decimal(20, 4) default null  comment '红冲中金额'")
    private BigDecimal offingAmt;

    @Column(name = "relate_doc_id", columnDefinition = "bigint(18) default null comment '相关单据ID'")
    private Long relateDocId;

    @Column(name = "relate_doc_no", columnDefinition = "longtext default null  comment '相关单据编号 原始单号'")
    private String relateDocNo;

    @Column(name = "receipt_type", columnDefinition = "longtext default null  comment '收款类型 [UDC]SAL:RECEIPT_TYPE'")
    private String receiptType;

    @Column(name = "amt", columnDefinition = "decimal(20, 4) default null  comment '收款金额'")
    private BigDecimal amt;

    @Column(name = "tax", columnDefinition = "decimal(20, 4) default null  comment '税额'")
    private BigDecimal tax;

    @Column(name = "ck_name", columnDefinition = "longtext default null  comment '出票人全称'")
    private String ckName;

    @Column(name = "ck_acc_no", columnDefinition = "longtext default null  comment '出票人账号'")
    private String ckAccNo;

    @Column(name = "ck_bank", columnDefinition = "longtext default null  comment '出票人开户银行'")
    private String ckBank;

    @Column(name = "ck_bank1", columnDefinition = "varchar(100) default null  comment '出票银行'")
    private String ckBank1;

    @Column(name = "ck_date", columnDefinition = "datetime default null  comment '出票日期'")
    private LocalDateTime ckDate;

    @Column(name = "ck_duedate", columnDefinition = "datetime default null  comment '汇票到期日'")
    private LocalDateTime ckDuedate;

    @Column(name = "ck_no", columnDefinition = "longtext default null  comment '票号'")
    private String ckNo;

    @Column(name = "ck_amt", columnDefinition = "decimal(20, 4) default null  comment '票据金额'")
    private BigDecimal ckAmt;

    @Column(name = "ck_status", columnDefinition = "longtext default null  comment '票据状态'")
    private String ckStatus;

    @Column(name = "ck_accepter", columnDefinition = "varchar(100) default null  comment '承兑人及信息'")
    private String ckAccepter;

    @Column(name = "ck_allowtr_flag", columnDefinition = "varchar(256) default null  comment '能否转让'")
    private String ckAllowtrFlag;

    @Column(name = "so_source", columnDefinition = "varchar(40) default null  comment '下单渠道 [UDC]SAL:SO_SOURCE'")
    private String soSource;

    @Column(name = "sale_region", columnDefinition = "varchar(40) default null  comment '销售区域 [UDC]SAL:SAL_REGION'")
    private String saleRegion;

    @Column(name = "contract_name", columnDefinition = "longtext default null  comment '合同名称'")
    private String contractName;

    @Column(name = "contract_id", columnDefinition = "bigint(100) default null  comment '合同ID'")
    private Long contractId;

    @Column(name = "cust_name", columnDefinition = "varchar(100) default null  comment '客户名称'")
    private String custName;

    @Column(name = "cust_code", columnDefinition = "varchar(40) default null  comment '客户编号'")
    private String custCode;

    @Column(name = "cust_id", columnDefinition = "bigint(18) default 0 comment '客户ID'")
    private Long custId;

    @Column(name = "writeoff_amt", columnDefinition = "decimal(20, 4) default null comment '已核销金额'")
    private BigDecimal writeoffAmt;

    @Column(name = "transfer_amt", columnDefinition = "decimal(20, 4) default null comment '已转货款金额'")
    private BigDecimal transferAmt;

    @Column(name = "transfering_amt", columnDefinition = "decimal(20, 4) default null comment '转货款中金额'")
    private BigDecimal transferingAmt;

    @Column(name = "return_amt", columnDefinition = "decimal(20, 4) default null comment '已退款金额'")
    private BigDecimal returnAmt;

    @Column(name = "returning_amt", columnDefinition = "decimal(20, 4) default null comment '退款中金额'")
    private BigDecimal returningAmt;

    @Column(name = "open_amt", columnDefinition = "decimal(20, 4) default null comment '押金余额'")
    private BigDecimal openAmt;

    @Column(name = "so_no", columnDefinition = "varchar(40) default null  comment '销售单号'")
    private String soNo;

    @Column(name = "doc_status2", columnDefinition = "varchar(40) default null comment '核销状态 [UDC]SAL:SAL_REGION'")
    private String docStatus2;

    @Column(name = "soa_or_so", columnDefinition = "varchar(40) default null  comment '对账单或销售单'")
    private String soaOrSo;

    @Column(name = "bank_id", columnDefinition = "bigint(18) default null comment '银行ID'")
    private Long bankId;

    @Column(name = "bank_code", columnDefinition = "varchar(40) default null  comment '开户行代码'")
    private String bankCode;

    @Column(name = "bank_name", columnDefinition = "varchar(40) default null  comment '开户行名称'")
    private String bankName;

    @Column(name = "bank_acc", columnDefinition = "varchar(100) default null  comment '开户行账号'")
    private String bankAcc;

    @Column(name = "holder_name", columnDefinition = "varchar(40) default null  comment '开户姓名'")
    private String holderName;

    @Column(name = "demand_payment_date", columnDefinition = "datetime default null  comment '要求支付日期'")
    private LocalDateTime demandPaymentDate;

    @Column(name = "return_date", columnDefinition = "datetime default null  comment '实际退还日期'")
    private LocalDateTime returnDate;

    @Column(name = "plan_return_date", columnDefinition = "datetime default null  comment '预计退还日期'")
    private LocalDateTime planReturnDate;

    @Column(name = "deposit_description", columnDefinition = "varchar(200) default null  comment '押金说明'")
    private String depositDescription;

    @Column(name = "reason", columnDefinition = "varchar(200) default null  comment '退款原因'")
    private String reason;

    @Column(name = "cust_contact_name", columnDefinition = "varchar(40) default null  comment '客户联系人'")
    private String custContactName;

    @Column(name = "cust_contact_tel", columnDefinition = "varchar(40) default null  comment '客户联系人电话'")
    private String custContactTel;


    @Column(name = "curr_code", columnDefinition = "varchar(40) default null  comment '币种编码'")
    private String currCode;

    @Column(name = "curr_name", columnDefinition = "varchar(40) default null  comment '币种名称'")
    private String currName;

    @Column(name = "ou_bank_acc", columnDefinition = "varchar(255) default null  comment '收款账号'")
    private String ouBankAcc;

    @Column(name = "ou_holder_name", columnDefinition = "varchar(40) default null  comment '收款户名'")
    private String ouHolderName;

}
