package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * SAL_SOA_D(客户对账单明细).
 * <p>
 * 客户对账单明细
 *
 * @auther JinXK
 * @date 2021/7/5 18:09
 */
@Entity
@Table(name = "sal_soa_d")
@org.hibernate.annotations.Table(appliesTo = "sal_soa_d", comment = "客户对账单明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class SalSoaDDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 3410041064360763186L;

    @Column(name = "mas_id", columnDefinition = "bigint(18) not null  comment '主表ID'")
    private Long masId;

    @Column(name = "doc_no", columnDefinition = "varchar(40) default null  comment '对账单号'")
    private String docNo;

    @Column(name = "line_no", columnDefinition = "decimal(20, 2) default null  comment '行号'")
    private BigDecimal lineNo;

    @Column(name = "cust_id", columnDefinition = "bigint(18) default null  comment '客户ID'")
    private Long custId;

    @Column(name = "line_status", columnDefinition = "varchar(40) default null  comment '行状态'")
    private String lineStatus;

    @Column(name = "so_id", columnDefinition = "bigint(18) default null  comment '订单ID'")
    private Long soId;

    @Column(name = "so_no", columnDefinition = "varchar(40) default null  comment '订单编号'")
    private String soNo;

    @Column(name = "so_d_id", columnDefinition = "bigint(18) default null  comment '销售订单明细ID'")
    private Long soDId;

    @Column(name = "so_line_no", columnDefinition = "decimal(20, 4) default null  comment '行号'")
    private BigDecimal soLineNo;

    @Column(name = "doc_cls", columnDefinition = "varchar(40) default null  comment '单据类别 [UDC]COM:DOC_CLS'")
    private String docCls;

    @Column(name = "do_doc_no", columnDefinition = "varchar(40) default null  comment '订单编号'")
    private String doDocNo;

    @Column(name = "dod_id", columnDefinition = "bigint(18) not null  comment '发货单编号'")
    private Long dodId;

    @Column(name = "item_id", columnDefinition = "bigint(18) default null  comment '商品ID'")
    private Long itemId;

    @Column(name = "item_code", columnDefinition = "varchar(40) default null  comment '商品编码'")
    private String itemCode;

    @Column(name = "item_name", columnDefinition = "varchar(255) default null  comment '商品名称2'")
    private String itemName;

    @Column(name = "item_spec", columnDefinition = "varchar(255) default null  comment '商品规格'")
    private String itemSpec;

    @Column(name = "item_brand", columnDefinition = "varchar(40) default null  comment '品牌'")
    private String itemBrand;

    @Column(name = "so_qty", columnDefinition = "decimal(20, 4) default null  comment '订单数量'")
    private BigDecimal soQty;

    @Column(name = "so_uom", columnDefinition = "varchar(10) default null  comment '单位'")
    private String soUom;

    @Column(name = "so_tax_rate_no", columnDefinition = "varchar(40) default null  comment '税率编号'")
    private String soTaxRateNo;

    @Column(name = "so_tax_rate", columnDefinition = "decimal(20, 4) default null  comment '税率'")
    private BigDecimal soTaxRate;

    @Column(name = "so_amt", columnDefinition = "decimal(20, 4) default null  comment '含税金额'")
    private BigDecimal soAmt;

    @Column(name = "so_tax_amt", columnDefinition = "decimal(20, 4) default null  comment '税额'")
    private BigDecimal soTaxAmt;

    @Column(name = "do_qty", columnDefinition = "decimal(20, 4) default null  comment '发货数量'")
    private BigDecimal doQty;

    @Column(name = "do_amt", columnDefinition = "decimal(20, 4) default null  comment '发货含税金额'")
    private BigDecimal doAmt;

    @Column(name = "do_tax_amt", columnDefinition = "decimal(20, 4) default null  comment '发货税额'")
    private BigDecimal doTaxAmt;

    @Column(name = "confirm_qty", columnDefinition = "decimal(20, 4) default null  comment '签收数量'")
    private BigDecimal confirmQty;

    @Column(name = "confirm_amt", columnDefinition = "decimal(20, 4) default null  comment '签收含税金额'")
    private BigDecimal confirmAmt;

    @Column(name = "confirm_tax_amt", columnDefinition = "decimal(20, 4) default null  comment '签收税额'")
    private BigDecimal confirmTaxAmt;

    @Column(name = "soa_qty", columnDefinition = "decimal(20, 4) default null  comment '本次对账数量'")
    private BigDecimal soaQty;

    @Column(name = "soa_amt", columnDefinition = "decimal(20, 4) default null  comment '对账含税金额'")
    private BigDecimal soaAmt;

    @Column(name = "soa_tax_amt", columnDefinition = "decimal(20, 4) default null  comment '对账税额'")
    private BigDecimal soaTaxAmt;

    @Column(name = "confirm_time", columnDefinition = "datetime default null  comment '签收日期'")
    private LocalDateTime confirmTime;

    @Column(name = "doc_time", columnDefinition = "datetime default null  comment '发货时间'")
    private LocalDateTime docTime;

    @Column(name = "do_qty2", columnDefinition = "decimal(20, 4) default null  comment '实发数量'")
    private BigDecimal doQty2;

    @Column(name = "confirm_net_amt", columnDefinition = "decimal(20, 4) default null  comment '签收不含税金额'")
    private BigDecimal confirmNetAmt;

    @Column(name = "so_net_amt", columnDefinition = "decimal(20, 4) default null  comment '订单不含税金额'")
    private BigDecimal soNetAmt;

    @Column(name = "so_price", columnDefinition = "decimal(20, 4) default null  comment '订单含税价格'")
    private BigDecimal soPrice;

    @Column(name = "so_net_price", columnDefinition = "decimal(20, 4) default null  comment '订单未含税价格'")
    private BigDecimal soNetPrice;

    @Column(name = "tax_class_desc", columnDefinition = "varchar(100) default null  comment '应税物货应税劳务、服务名称'")
    private String taxClassDesc;

    @Column(name = "tax_class", columnDefinition = "varchar(40) default null  comment '税收分类编码'")
    private String taxClass;

    @Column(name = "contract_id", columnDefinition = "bigint(20) default null comment '合同ID'")
    private Long contractId;

    @Column(name = "contract_code", columnDefinition = "longtext default null  comment '合同编号'")
    private String contractCode;

    @Column(name = "contract_name", columnDefinition = "longtext default null  comment '合同名称'")
    private String contractName;

}
