package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 专区设置
 */
@Entity
@Table(name = "zone_setting")
@org.hibernate.annotations.Table(appliesTo = "zone_setting", comment = "专区设置")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class ZoneSettingDO  extends BaseModel implements Serializable {

    @ApiModelProperty("专区编码")
    @Column(name = "zone_code", columnDefinition = "varchar(64)  comment '专区编码'")
    private String zoneCode;


    @ApiModelProperty("专区名称")
    @Column(name = "zone_name", columnDefinition = "varchar(64)  comment '专区名称'")
    private String zoneName;

    @ApiModelProperty("排序")
    @Column(name = "sort", columnDefinition = "int(10) comment '排序'")
    private Integer sort;

    @ApiModelProperty("所属公司")
    @Column(name = "ou_id", columnDefinition = "bigint(18)  comment '所属公司'")
    private Long ouId;

    @ApiModelProperty("所属公司名称")
    @Column(name = "ou_name", columnDefinition = "varchar(256)  comment '所属公司名称'")
    private String ouName;

    @ApiModelProperty("状态")
    @Column(name = "status", columnDefinition = "varchar(256)  comment '状态'")
    private String status;



}
