package com.elitesland.yst.production.sale.repo;


import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustSimpleVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmScustPageRespVO;
import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import com.elitesland.yst.production.sale.entity.QCrmScustDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.jpa.impl.JPAQueryFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.stream.Collectors;


/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/6/4
 */
@Repository
public class CrmScustRepoProc {

    @Autowired
    private JPAQueryFactory jpaQueryFactory;
    private final QCrmScustDO qCrmScustDO = QCrmScustDO.crmScustDO;

    /**
     * 判断客户名称是否已存在
     *
     * @param id 客户ID
     * @return 客户名称
     */
    public Boolean exists(String custName, Long id) {
        Predicate predicate = qCrmScustDO.deleteFlag.eq(0).or(qCrmScustDO.deleteFlag.isNull());
        predicate = StringUtils.isEmpty(custName) ? predicate : ExpressionUtils.and(predicate, qCrmScustDO.custName.eq(custName));
        predicate = StringUtils.isEmpty(id) ? predicate : ExpressionUtils.and(predicate, qCrmScustDO.id.ne(id));
        return jpaQueryFactory.select(qCrmScustDO)
                .from(qCrmScustDO)
                .where(predicate)
                .fetchCount() > 0;
    }

    /**
     * 判断客户名称是否已存在
     *
     * @param id       客户ID
     * @param taxRegNo 税务登记号
     */
    public Boolean existsTaxRegNo(String taxRegNo, Long id) {
        Predicate predicate = qCrmScustDO.deleteFlag.eq(0).or(qCrmScustDO.deleteFlag.isNull());
        predicate = StringUtils.isEmpty(taxRegNo) ? predicate : ExpressionUtils.and(predicate, qCrmScustDO.taxRegNo.eq(taxRegNo));
        predicate = StringUtils.isEmpty(id) ? predicate : ExpressionUtils.and(predicate, qCrmScustDO.id.ne(id));
        return jpaQueryFactory.select(qCrmScustDO)
                .from(qCrmScustDO)
                .where(predicate)
                .fetchCount() > 0;
    }

    /**
     * 判断客户编码是否已存在
     *
     * @param id 客户ID
     * @return 客户名称
     */
    public Boolean existsCode(String custCode, Long id) {
        Predicate predicate = qCrmScustDO.deleteFlag.eq(0).or(qCrmScustDO.deleteFlag.isNull());
        predicate = StringUtils.isEmpty(custCode) ? predicate : ExpressionUtils.and(predicate, qCrmScustDO.custCode.eq(custCode));
        predicate = StringUtils.isEmpty(id) ? predicate : ExpressionUtils.and(predicate, qCrmScustDO.id.ne(id));
        return jpaQueryFactory.select(qCrmScustDO)
                .from(qCrmScustDO)
                .where(predicate)
                .fetchCount() > 0;
    }

    public List<CrmScustPageRespVO> findIdByNameAndTaxRegNo(String custName, String taxRegNo) {
        Predicate predicate = qCrmScustDO.deleteFlag.eq(0).or(qCrmScustDO.deleteFlag.isNull());
        predicate = StringUtils.isEmpty(custName) ? predicate : ExpressionUtils.and(predicate, qCrmScustDO.custName.eq(custName));
        predicate = StringUtils.isEmpty(taxRegNo) ? predicate : ExpressionUtils.and(predicate, qCrmScustDO.taxRegNo.eq(taxRegNo));
        return jpaQueryFactory.select(qCrmScustDO.id, qCrmScustDO.custCode,qCrmScustDO.addrNo)
                .from(qCrmScustDO)
                .where(predicate)
                .fetch()
                .stream()
                .map(tuple -> {
                    CrmScustPageRespVO dto = new CrmScustPageRespVO();
                    dto.setId(tuple.get(qCrmScustDO.id));
                    dto.setCustCode(tuple.get(qCrmScustDO.custCode));
                    dto.setAddrNo(tuple.get(qCrmScustDO.addrNo));
                    return dto;
                }).collect(Collectors.toList());
    }

    public List<CrmScustPageRespVO> getScustByCodes(List<String> custCodes) {
        return jpaQueryFactory.select(qCrmScustDO.custCode,
                qCrmScustDO.id, qCrmScustDO.custName, qCrmScustDO.custAbbr)
                .from(qCrmScustDO)
                .where(qCrmScustDO.custCode.in(custCodes).and(qCrmScustDO.deleteFlag.ne(ConstantsSale.COMMON_DELETE_YSE)))
                .fetch()
                .parallelStream()
                .map(tuple -> {
                    CrmScustPageRespVO crmScustPageRespVO = new CrmScustPageRespVO();
                    crmScustPageRespVO.setId(tuple.get(qCrmScustDO.id));
                    crmScustPageRespVO.setCustName(tuple.get(qCrmScustDO.custName));
                    crmScustPageRespVO.setCustCode(tuple.get(qCrmScustDO.custCode));
                    crmScustPageRespVO.setCustAbbr(tuple.get(qCrmScustDO.custAbbr));
                    return crmScustPageRespVO;
                }).collect(Collectors.toList());
    }
}
