package com.elitesland.yst.production.sale.repo.shop;

import com.elitesland.yst.production.sale.api.vo.param.shop.BipInvQueryParam;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipInvVO;
import com.elitesland.yst.production.sale.entity.BipInvDO;
import com.elitesland.yst.production.sale.entity.QBipInvDO;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import lombok.val;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author jokers xing
 * @since 2021-09-06 13:51:25
 */
@Component
@RequiredArgsConstructor
public class BipInvRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    /**
     * 查询字段
     */
    public JPAQuery<BipInvVO> select(BipInvQueryParam param) {
        QBipInvDO qBipInvDO = QBipInvDO.bipInvDO;
        Predicate predicate = qBipInvDO.isNotNull();
        JPAQuery<BipInvVO> jpaQuery = jpaQueryFactory.select(Projections.bean(BipInvVO.class,
                qBipInvDO.id,
                qBipInvDO.orderTime,
                qBipInvDO.orderId,
                qBipInvDO.docNo,
                qBipInvDO.invNo,
                qBipInvDO.invCode,
                qBipInvDO.invType,
                qBipInvDO.invTitle,
                qBipInvDO.taxNo,
                qBipInvDO.bank,
                qBipInvDO.companyAddress,
                qBipInvDO.companyTel,
                qBipInvDO.bankAccount,
                qBipInvDO.ownedCompany,
                qBipInvDO.custAccountId,
                qBipInvDO.status,
                qBipInvDO.isRed,
                qBipInvDO.totalAmt,
                qBipInvDO.invTitleType
        )).from(qBipInvDO);
        if (param != null) {
            jpaQuery.where(where(param));
        }
        jpaQuery.where(predicate, qBipInvDO.deleteFlag.eq(0).or(qBipInvDO.deleteFlag.isNull()));
        return jpaQuery;
    }


    public JPAQuery<BipInvVO> findByinvId(Long invId) {
        QBipInvDO qBipInvDO = QBipInvDO.bipInvDO;
        Predicate predicate = qBipInvDO.isNotNull();
        JPAQuery<BipInvVO> jpaQuery = jpaQueryFactory.select(Projections.bean(BipInvVO.class,
                qBipInvDO.id,
                qBipInvDO.orderId,
                qBipInvDO.invNo,
                qBipInvDO.invCode,
                qBipInvDO.docNo,
                qBipInvDO.invType,
                qBipInvDO.orderTime,
                qBipInvDO.invTitleType,
                qBipInvDO.invTitle,
                qBipInvDO.invSerialNum,
                qBipInvDO.bank,
                qBipInvDO.bankAccount,
                qBipInvDO.companyAddress,
                qBipInvDO.companyTel,
                qBipInvDO.isRed,
                qBipInvDO.totalAmt,
                qBipInvDO.status,
                qBipInvDO.taxNo

        )).from(qBipInvDO);
        jpaQuery.where(predicate, qBipInvDO.id.eq(invId));
        return jpaQuery;
    }

    public JPAQuery<BipInvVO> findAllByUserId(Long userId) {
        QBipInvDO qBipInvDO = QBipInvDO.bipInvDO;
        Predicate predicate = qBipInvDO.isNotNull();
        JPAQuery<BipInvVO> jpaQuery = jpaQueryFactory.select(Projections.bean(BipInvVO.class,
                qBipInvDO.id,
                qBipInvDO.orderId,
                qBipInvDO.docNo,
                qBipInvDO.invType,
                qBipInvDO.invTitle,
                qBipInvDO.invTitleType,
                qBipInvDO.ownedCompany,
                qBipInvDO.createTime,
                qBipInvDO.orderTime,
                qBipInvDO.totalAmt,
                qBipInvDO.isRed,
                qBipInvDO.taxNo

        )).from(qBipInvDO).orderBy(qBipInvDO.createTime.desc());
        jpaQuery.where(predicate, qBipInvDO.custAccountId
                //当前用户的
                .eq(userId)
                //不被红冲的
                //.and(qBipInvDO.isRed.eq("0").or(qBipInvDO.isRed.isNull()))
        );
        return jpaQuery;
    }

    /**
     * 条件查询
     *
     * @param param 查询条件
     */
    public Predicate where(BipInvQueryParam param) {
        val qBipOnvDO = QBipInvDO.bipInvDO;
        Predicate predicate = Expressions.ONE.eq(Expressions.ONE);
        if (!StringUtils.isEmpty(param.getId())) {
            predicate = ExpressionUtils.and(predicate, qBipOnvDO.id.eq(param.getId()));
        }
        if (!StringUtils.isEmpty(param.getDocNo())) {
            predicate = ExpressionUtils.and(predicate, qBipOnvDO.docNo.like("%"+param.getDocNo()+"%"));
        }
        if (!StringUtils.isEmpty(param.getInvNo())) {
            predicate = ExpressionUtils.and(predicate, qBipOnvDO.invNo.like("%"+param.getInvNo()+"%"));
        }
        if (!StringUtils.isEmpty(param.getInvCode())) {
            predicate = ExpressionUtils.and(predicate, qBipOnvDO.invCode.like("%"+param.getInvCode()+"%"));
        }
        if (!StringUtils.isEmpty(param.getInvType())) {
            predicate = ExpressionUtils.and(predicate, qBipOnvDO.invType.eq(param.getInvType()));
        }
        if (!StringUtils.isEmpty(param.getInvTitle())) {
            predicate = ExpressionUtils.and(predicate, qBipOnvDO.invTitle.like("%"+param.getInvTitle()+"%"));
        }
        if (!StringUtils.isEmpty(param.getTaxNo())) {
            predicate = ExpressionUtils.and(predicate, qBipOnvDO.taxNo.like("%"+param.getTaxNo()+"%"));
        }
        if (!StringUtils.isEmpty(param.getBank())) {
            predicate = ExpressionUtils.and(predicate, qBipOnvDO.bank.like("%"+param.getBank()+"%"));
        }
        if (!StringUtils.isEmpty(param.getCompanyAddress())) {
            predicate = ExpressionUtils.and(predicate, qBipOnvDO.companyAddress.like("%"+param.getCompanyAddress()+"%"));
        }
        if (!StringUtils.isEmpty(param.getCompanyTel())) {
            predicate = ExpressionUtils.and(predicate, qBipOnvDO.companyTel.like("%"+param.getCompanyTel()+"%"));
        }
        if (!StringUtils.isEmpty(param.getBankAccount())) {
            predicate = ExpressionUtils.and(predicate, qBipOnvDO.bankAccount.like("%"+param.getBankAccount()+"%"));
        }
        if (!StringUtils.isEmpty(param.getOwnedCompany())) {
            predicate = ExpressionUtils.and(predicate, qBipOnvDO.ownedCompany.like("%"+param.getOwnedCompany()+"%"));
        }
        if (!StringUtils.isEmpty(param.getInvTitleType())) {
            predicate = ExpressionUtils.and(predicate, qBipOnvDO.invTitleType.eq(param.getInvTitleType()));
        }

        //添加权限处理
        predicate = ExpressionUtils.and(predicate, DataAuthJpaUtil.dataAuthJpaPredicate(qBipOnvDO.getMetadata()));
        return predicate;
    }

    public List<BipInvDO> findByDoc(String docNo){
        QBipInvDO qBipInvDO = QBipInvDO.bipInvDO;
        return jpaQueryFactory.select(qBipInvDO).from(qBipInvDO).where(qBipInvDO.docNo.eq(docNo)).fetch();
    }

}

