package com.elitesland.yst.production.sale.rmi.ystsupport;

import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.yst.production.support.provider.org.service.OrgStoreRpcService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/04/18
 * @Version 1.0
 * @Content:
 */
@Component
@Slf4j
public class RmiOrgStoreRpcService {
    @Autowired
    private OrgStoreRpcService orgStoreRpcService;

    /**
     * 根据门店ID查询门店信息
     *
     * @param id 门店ID
     * @return 门店信息
     */
    public OrgStoreDetailRpcDTO findStoreById(Long id) {
        log.info("调用support域:根据门店ID查询门店信息,时间：{},入参：{}", LocalDateTime.now(), id);
        try {
            if (Objects.isNull(id)) {
                return null;
            }
            OrgStoreDetailRpcDTO orgStoreDetailRpcDTO = orgStoreRpcService.get(id);
            log.info("调用support域:根据门店ID查询门店信息,时间：{},出参：{}", LocalDateTime.now(), orgStoreDetailRpcDTO);
            return orgStoreDetailRpcDTO;
        } catch (Exception e) {
            log.error("调用support域:根据门店ID查询门店信息,error：{}", e.getMessage());
            throw new BusinessException("调用support域:" + e.getMessage());
        }
    }

    /**
     * 根据门店编码批量查询门店
     *
     * @param storeCodes 门店编码
     * @return 门店信息
     */
    public List<OrgStoreDetailRpcDTO> findStoreByStoreCodes(List<String> storeCodes) {
        log.info("调用support域:根据门店编码批量查询门店,时间：{},入参：{}", LocalDateTime.now(), storeCodes);
        if (CollectionUtils.isEmpty(storeCodes)) {
            return Collections.emptyList();
        }
        try {
            List<OrgStoreDetailRpcDTO> orgStoreDetailRpcDTOList = orgStoreRpcService.queryByStoreCodes(storeCodes);
            log.info("调用support域:根据门店编码批量查询门店,时间：{},出参：{}", LocalDateTime.now(), orgStoreDetailRpcDTOList);
            if (CollectionUtils.isEmpty(orgStoreDetailRpcDTOList)) {
                return Collections.EMPTY_LIST;
            }
            return orgStoreDetailRpcDTOList;
        } catch (Exception e) {
            log.error("调用support域:根据门店编码批量查询门店,error：{}", e.getMessage());
            throw new BusinessException("调用support域:" + e.getMessage());
        }
    }

}
