package com.elitesland.yst.production.sale.rmi.ystsystem;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.system.dto.SysEmployeeDetailDTO;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeeUpsertDTO;
import com.elitescloud.cloudt.system.dto.req.UserCreateDTO;
import com.elitescloud.cloudt.system.dto.req.UserQueryDTO;
import com.elitescloud.cloudt.system.param.SysOrgQueryDTO;
import com.elitescloud.cloudt.system.provider.org.EmployeeRpcService;
import com.elitescloud.cloudt.system.provider.org.OrgRpcService;
import com.elitescloud.cloudt.system.provider.org.UserRpcService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

/**
 * 系统域组织接口
 *
 * @author : JS
 * @date 2023/03/23 16:24
 */
@Slf4j
@Component
@RequiredArgsConstructor
public class RmiSysOrgService {

    private final EmployeeRpcService employeeRpcService;

    private final UserRpcService userRpcService;

    private final OrgRpcService orgRpcService;

    public List<SysEmployeeDetailDTO> findEmpByCode(List<String> codes) {
        Function<Set<String>, List<SysEmployeeDetailDTO>> function = queryParam -> {
            var apiResult = employeeRpcService.getDetailListByCode(queryParam);
            return this.getData(apiResult);
        };
        return this.execute(function, new HashSet<>(codes), "员工查询接口");
    }

    public SysEmployeeDetailDTO findEmpByCode(String code) {
        Function<String, SysEmployeeDetailDTO> function = queryParam -> {
            var apiResult = employeeRpcService.getDetailByCode(queryParam);
            return this.getData(apiResult);
        };
        return this.execute(function, code, "员工查询接口");
    }




    public String saveEmp(EmployeeUpsertDTO param) {
        Function<EmployeeUpsertDTO, String> function = queryParam -> {
            var apiResult = employeeRpcService.upsert(queryParam);
            return this.getData(apiResult);
        };
        return this.execute(function, param, "员工保存接口");
    }

    public SysUserBasicDTO findUserById(Long userId) {
        Function<Long, SysUserBasicDTO> function = queryParam -> {
            var apiResult = userRpcService.getById(queryParam);
            return this.getData(apiResult);
        };

        return this.execute(function, userId, "用户查询接口");
    }

    public List<SysUserBasicDTO> findUserByUsername(List<String> usenames) {
        UserQueryDTO param = new UserQueryDTO();
        param.setUsernames(new HashSet<>(usenames));
        return this.findUserByParam(param);
    }

    public List<SysUserBasicDTO> findUserByParam(UserQueryDTO param) {
        Function<UserQueryDTO, List<SysUserBasicDTO>> function = queryParam -> {
            var apiResult = userRpcService.queryUser(queryParam);
            return this.getData(apiResult);
        };

        return this.execute(function, param, "用户查询接口");
    }

    public Long saveUser(UserCreateDTO param) {
        Function<UserCreateDTO, Long> function = queryParam -> {
            var apiResult = userRpcService.upsert(queryParam);
            return this.getData(apiResult);
        };

        return this.execute(function, param, "用户保存接口");
    }

    public List<SysOrgBasicDTO> findOrgByCodes(List<String> orgCodes){
        SysOrgQueryDTO param = new SysOrgQueryDTO();
        param.setCodes(new HashSet<>(orgCodes));
        return this.findOrgByParam(param);
    }

    public List<SysOrgBasicDTO> findOrgByParam(SysOrgQueryDTO param){
        Function<SysOrgQueryDTO, List<SysOrgBasicDTO>> function = queryParam -> {
            var apiResult = orgRpcService.queryList(queryParam);
            return this.getData(apiResult);
        };

        return this.execute(function, param, "组织查询接口");
    }



    /**
     * 根据编码获取组织上级信息
     *
     * @param codes 组织编码
     * @param
     * @return
     */
    public Map<String, SysOrgBasicDTO> selectOrgParentByCodes(Set<String> codes) {
        if (CollectionUtil.isEmpty(codes)) {
            return null;
        }

        Function<Set<String>, Map<String, SysOrgBasicDTO>> function = queryParam -> {
            var apiResult = orgRpcService.getParentByCode(queryParam,"COMPANY");;
            return this.getData(apiResult);
        };
        return this.execute(function, new HashSet<>(codes), "根据编码获取上级组织信息接口");

        /*try {
            ApiResult<Map<String, SysOrgBasicDTO>> apiResult = orgRpcService.getParentByCode(codes,parentType);
            if (apiResult.isSuccess()) {
                Map<String, SysOrgBasicDTO> map = apiResult.getData();
                return map;
            } else {
                throw new BusinessException(ApiCode.FAIL, "调用系统域(getParentByCode)根据编码获取上级组织信息失败：" + apiResult.getMsg());
            }
        } catch (Exception e) {
            log.error("getParentByCodesAndParentType error:", e);
            throw new BusinessException(ApiCode.FAIL, "调用系统中心dubbo服务异常：" + e);
        }*/

    }

    private <T> T getData(ApiResult<T> apiResult) {
        if (apiResult.isSuccess()) {
            return apiResult.getData();
        } else {
            log.error("调用系统域接口失败:{}", apiResult.getErrorMsg());
            throw new BusinessException(apiResult.getErrorMsg());
        }
    }

    private <T, R> R execute(Function<T, R> function, T param, String interfaceName) {
        try {
            return function.apply(param);
        } catch (Exception e) {
            log.error("调用系统域" + interfaceName + "失败", e);
            throw new BusinessException("调用系统域" + interfaceName + "失败:" + e.getMessage());
        }
    }
}
