package com.elitesland.yst.production.sale.search.service.impl;

import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.MapBuilder;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.StatisticsDealerDtlService;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsDealerDtlQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsDealerQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsDealerDtlRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsDealerRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.StatisticsDealerSumRespVO;
import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import com.elitesland.yst.production.sale.entity.SaleStatisticsDealerDO;
import com.elitesland.yst.production.sale.repo.SaleStatisticsDealerRepo;
import com.elitesland.yst.production.sale.repo.SaleStatisticsDealerRepoProc;
import com.elitesland.yst.production.sale.repo.SaleStatisticsDealerRepoSqlProc;
import com.elitesland.yst.production.sale.search.bean.StatisticsDealerDtlSearchBean;
import com.elitesland.yst.production.sale.search.bean.StatisticsDealerSearchBean;
import com.elitesland.yst.production.sale.search.service.SearchBeanService;
import com.elitesland.yst.production.sale.search.service.StatisticsDealerSearchService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/07/04
 * @Version 1.0
 * @Content:
 */
@Service
public class StatisticsDealerSearchServiceImpl implements StatisticsDealerSearchService {

    @Autowired
    private SearchBeanService searchBeanService;

    @Autowired
    private StatisticsDealerDtlService statisticsDealerDtlService;
    @Autowired
    private SaleStatisticsDealerRepo saleStatisticsDealerRepo;
    @Autowired
    private SaleStatisticsDealerRepoProc statisticsDealerRepoProc;

    @Autowired
    private SaleStatisticsDealerRepoSqlProc saleStatisticsDealerRepoSqlProc;

    /**
     * 经销商销售业绩分页查询
     *
     * @param pageParam 入参
     * @return 经销商销售业绩信息集合
     */
    @Override
    @SysCodeProc
    public PagingVO<SaleStatisticsDealerRespVO> page(SaleStatisticsDealerQueryVO pageParam) {
        //根据统计月份的日期拼装入参里的统计时间起始、统计时间截至
        assembleDocTime(pageParam);

//        if (Objects.nonNull(pageParam.getDocTimeStart())) {
//            String timeStrStart = pageParam.getDocTimeStart().format(DateTimeFormatter.ofPattern("yyyyMM"));
//            Integer integerStart = Integer.valueOf(timeStrStart);
//            pageParam.setDocTimeItStart(integerStart);
//        }
//        if (Objects.nonNull(pageParam.getDocTimeEnd())) {
//            String timeStrEnd = pageParam.getDocTimeEnd().format(DateTimeFormatter.ofPattern("yyyyMM"));
//            Integer integerEnd = Integer.valueOf(timeStrEnd);
//            pageParam.setDocTimeItEnd(integerEnd);
//
//        }

//        //明细入参查询
//        SaleStatisticsDealerDtlQueryVO dealerDtlQueryVO = new SaleStatisticsDealerDtlQueryVO();
//        if (StringUtils.isNotBlank(pageParam.getAgentEmp())) {
//            dealerDtlQueryVO.setCode(pageParam.getAgentEmp());
//        }
//        //List<Long> masIdList = selectMasIdByDtlParam(dealerDtlQueryVO);
//        //通过分页分批查询任务主表数据-不是分页列表查询
//        MapBuilder mapBuilderDtl = this.setDtlMapBuilder(dealerDtlQueryVO);
//        List<StatisticsDealerDtlSearchBean> searchBeanSearchResultDtl = searchBeanService.getBeanSearcher().searchAll(StatisticsDealerDtlSearchBean.class, mapBuilderDtl.build());
//        if (CollectionUtils.isEmpty(searchBeanSearchResultDtl)) {
//            return PagingVO.<SaleStatisticsDealerRespVO>builder().total(0L).records(Collections.EMPTY_LIST).build();
//        }
//        List<Long> masIdList = searchBeanSearchResultDtl.stream().map(StatisticsDealerDtlSearchBean::getPid).filter(Objects::nonNull).distinct().collect(Collectors.toList());
//        if (CollectionUtils.isEmpty(masIdList)) {
//            return PagingVO.<SaleStatisticsDealerRespVO>builder().total(0L).records(Collections.EMPTY_LIST).build();
//        }
//        List<Long> ids = CollectionUtils.isEmpty(pageParam.getIds()) ? Collections.EMPTY_LIST : pageParam.getIds();
//        List<Long> idList = Stream.of(ids, masIdList).flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toList());
//        pageParam.setIds(idList);

        PagingVO<SaleStatisticsDealerRespVO> pagingVO = statisticsDealerRepoProc.page(pageParam);
        if (CollectionUtils.isEmpty(pagingVO.getRecords())) {
            return PagingVO.<SaleStatisticsDealerRespVO>builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        List<SaleStatisticsDealerRespVO> respVOList = pagingVO.getRecords();

        //组装填充经销商销售业绩的相关信息
        translateDealer(respVOList);

        return PagingVO.<SaleStatisticsDealerRespVO>builder()
                .total(pagingVO.getTotal())
                .records(respVOList)
                .build();
    }

    /**
     * 经销商销售业绩分页查询-APP端
     *
     * @param pageParam 入参
     * @return 经销商销售业绩信息集合
     */
    @Override
    @SysCodeProc
    public PagingVO<SaleStatisticsDealerRespVO> appPage(SaleStatisticsDealerQueryVO pageParam) {
        //根据统计月份的日期拼装入参里的统计时间起始、统计时间截至
        assembleDocTime(pageParam);


//        if (Objects.nonNull(pageParam.getDocTimeStart())) {
//            String timeStrStart = pageParam.getDocTimeStart().format(DateTimeFormatter.ofPattern("yyyyMM"));
//            Integer integerStart = Integer.valueOf(timeStrStart);
//            pageParam.setDocTimeItStart(integerStart);
//        }
//        if (Objects.nonNull(pageParam.getDocTimeEnd())) {
//            String timeStrEnd = pageParam.getDocTimeEnd().format(DateTimeFormatter.ofPattern("yyyyMM"));
//            Integer integerEnd = Integer.valueOf(timeStrEnd);
//            pageParam.setDocTimeItEnd(integerEnd);
//
//        }


//        //明细入参查询
//        SaleStatisticsDealerDtlQueryVO dealerDtlQueryVO = new SaleStatisticsDealerDtlQueryVO();
//        if (StringUtils.isNotBlank(pageParam.getAgentEmp())) {
//            dealerDtlQueryVO.setCode(pageParam.getAgentEmp());
//        }
//        //List<Long> masIdList = selectMasIdByDtlParam(dealerDtlQueryVO);
//        MapBuilder mapBuilderDtl = this.setDtlMapBuilder(dealerDtlQueryVO);
//        List<StatisticsDealerDtlSearchBean> searchBeanSearchResultDtl = searchBeanService.getBeanSearcher().searchAll(StatisticsDealerDtlSearchBean.class, mapBuilderDtl.build());
//        if (CollectionUtils.isEmpty(searchBeanSearchResultDtl)) {
//            return PagingVO.<SaleStatisticsDealerRespVO>builder().total(0L).records(Collections.EMPTY_LIST).build();
//        }
//        List<Long> masIdList = searchBeanSearchResultDtl.stream().map(StatisticsDealerDtlSearchBean::getPid).filter(Objects::nonNull).distinct().collect(Collectors.toList());
//        if (CollectionUtils.isEmpty(masIdList)) {
//            return PagingVO.<SaleStatisticsDealerRespVO>builder().total(0L).records(Collections.EMPTY_LIST).build();
//        }
//        List<Long> ids = CollectionUtils.isEmpty(pageParam.getIds()) ? Collections.EMPTY_LIST : pageParam.getIds();
//        List<Long> idList = Stream.of(ids, masIdList).flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toList());
//        pageParam.setIds(idList);


        PagingVO<SaleStatisticsDealerRespVO> pagingVO = statisticsDealerRepoProc.appPage(pageParam);
        if (CollectionUtils.isEmpty(pagingVO.getRecords())) {
            return PagingVO.<SaleStatisticsDealerRespVO>builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        List<SaleStatisticsDealerRespVO> respVOList = pagingVO.getRecords();

        //组装填充经销商销售业绩的相关信息
        translateDealer(respVOList);

        return PagingVO.<SaleStatisticsDealerRespVO>builder()
                .total(pagingVO.getTotal())
                .records(respVOList)
                .build();
    }

    /**
     * 经销商销售业绩统计汇总
     *
     * @param pageParam 入参
     * @return 统计汇总信息
     */
    @Override
    public StatisticsDealerSumRespVO pageSum(SaleStatisticsDealerQueryVO pageParam) {
        StatisticsDealerSumRespVO sumRespVO = new StatisticsDealerSumRespVO();

        //根据统计月份的日期拼装入参里的统计时间起始、统计时间截至
        assembleDocTime(pageParam);

//        if (Objects.nonNull(pageParam.getDocTimeStart())) {
//            String timeStrStart = pageParam.getDocTimeStart().format(DateTimeFormatter.ofPattern("yyyyMM"));
//            Integer integerStart = Integer.valueOf(timeStrStart);
//            pageParam.setDocTimeItStart(integerStart);
//        }
//        if (Objects.nonNull(pageParam.getDocTimeEnd())) {
//            String timeStrEnd = pageParam.getDocTimeEnd().format(DateTimeFormatter.ofPattern("yyyyMM"));
//            Integer integerEnd = Integer.valueOf(timeStrEnd);
//            pageParam.setDocTimeItEnd(integerEnd);
//
//        }

//        //明细入参查询
//        SaleStatisticsDealerDtlQueryVO dealerDtlQueryVO = new SaleStatisticsDealerDtlQueryVO();
//        if (StringUtils.isNotBlank(pageParam.getAgentEmp())) {
//            dealerDtlQueryVO.setCode(pageParam.getAgentEmp());
//        }
//        //List<Long> masIdList = selectMasIdByDtlParam(dealerDtlQueryVO);
//        MapBuilder mapBuilderDtl = this.setDtlMapBuilder(dealerDtlQueryVO);
//        List<StatisticsDealerDtlSearchBean> searchBeanSearchResultDtl = searchBeanService.getBeanSearcher().searchAll(StatisticsDealerDtlSearchBean.class, mapBuilderDtl.build());
//        if (CollectionUtils.isEmpty(searchBeanSearchResultDtl)) {
//            return sumRespVO;
//        }
//        List<Long> masIdList = searchBeanSearchResultDtl.stream().map(StatisticsDealerDtlSearchBean::getPid).filter(Objects::nonNull).distinct().collect(Collectors.toList());
//        if (CollectionUtils.isEmpty(masIdList)) {
//            return sumRespVO;
//        }
//        List<Long> ids = CollectionUtils.isEmpty(pageParam.getIds()) ? Collections.EMPTY_LIST : pageParam.getIds();
//        List<Long> idList = Stream.of(ids, masIdList).flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toList());
//        pageParam.setIds(idList);

        StatisticsDealerSumRespVO dealerSumRespVO = saleStatisticsDealerRepoSqlProc.pageSum2(pageParam);
        if (Objects.isNull(dealerSumRespVO)) {
            return sumRespVO;
        }

        return dealerSumRespVO;
    }

    /**
     * 经销商销售业绩统计汇总-APP端
     *
     * @param pageParam 入参
     * @return 统计汇总信息
     */
    @Override
    public StatisticsDealerSumRespVO appPageSum(SaleStatisticsDealerQueryVO pageParam) {
        StatisticsDealerSumRespVO sumRespVO = new StatisticsDealerSumRespVO();

        //根据统计月份的日期拼装入参里的统计时间起始、统计时间截至
        assembleDocTime(pageParam);


//        if (Objects.nonNull(pageParam.getDocTimeStart())) {
//            String timeStrStart = pageParam.getDocTimeStart().format(DateTimeFormatter.ofPattern("yyyyMM"));
//            Integer integerStart = Integer.valueOf(timeStrStart);
//            pageParam.setDocTimeItStart(integerStart);
//        }
//        if (Objects.nonNull(pageParam.getDocTimeEnd())) {
//            String timeStrEnd = pageParam.getDocTimeEnd().format(DateTimeFormatter.ofPattern("yyyyMM"));
//            Integer integerEnd = Integer.valueOf(timeStrEnd);
//            pageParam.setDocTimeItEnd(integerEnd);
//
//        }

//        //明细入参查询
//        SaleStatisticsDealerDtlQueryVO dealerDtlQueryVO = new SaleStatisticsDealerDtlQueryVO();
//        if (StringUtils.isNotBlank(pageParam.getAgentEmp())) {
//            dealerDtlQueryVO.setCode(pageParam.getAgentEmp());
//        }
//        //List<Long> masIdList = selectMasIdByDtlParam(dealerDtlQueryVO);
//        MapBuilder mapBuilderDtl = this.setDtlMapBuilder(dealerDtlQueryVO);
//        List<StatisticsDealerDtlSearchBean> searchBeanSearchResultDtl = searchBeanService.getBeanSearcher().searchAll(StatisticsDealerDtlSearchBean.class, mapBuilderDtl.build());
//        if (CollectionUtils.isEmpty(searchBeanSearchResultDtl)) {
//            return sumRespVO;
//        }
//        List<Long> masIdList = searchBeanSearchResultDtl.stream().map(StatisticsDealerDtlSearchBean::getPid).filter(Objects::nonNull).distinct().collect(Collectors.toList());
//        if (CollectionUtils.isEmpty(masIdList)) {
//            return sumRespVO;
//        }
//        List<Long> ids = CollectionUtils.isEmpty(pageParam.getIds()) ? Collections.EMPTY_LIST : pageParam.getIds();
//        List<Long> idList = Stream.of(ids, masIdList).flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toList());
//        pageParam.setIds(idList);

        StatisticsDealerSumRespVO dealerSumRespVO = saleStatisticsDealerRepoSqlProc.pageSum2(pageParam);
        if (Objects.isNull(dealerSumRespVO)) {
            return sumRespVO;
        }

        return dealerSumRespVO;
    }

    /**
     * 经销商销售业绩详情-头部信息和车型分页明细数据
     *
     * @param pageParam 入参
     * @return 经销商销售业绩详情信息
     */
    @Override
    @SysCodeProc
    public PagingVO<SaleStatisticsDealerRespVO> appDetails(SaleStatisticsDealerQueryVO pageParam) {

        // 当有id存在时，以下参数由id的数据获取
        if(pageParam.getId() != null){
            Optional<SaleStatisticsDealerDO> byId = saleStatisticsDealerRepo.findById(pageParam.getId());
            if(byId.isPresent()){
                pageParam.setRegion(byId.get().getRegion());
                pageParam.setSalesmanPath(byId.get().getSalesmanPath());
                pageParam.setDealerCode(byId.get().getDealerCode());
                pageParam.setDocTimeStart(LocalDateTime.of(byId.get().getDocTime().toLocalDate(),LocalTime.MIN));
                pageParam.setDocTimeEnd(LocalDateTime.of(byId.get().getDocTime().toLocalDate(),ConstantsSale.LOCAL_TIME_MAX));
            }
            pageParam.setId(null);
        }
        //校验入参必填项
        appDetailsCheck(pageParam);


//        //明细入参查询
//        SaleStatisticsDealerDtlQueryVO dealerDtlQueryVO = new SaleStatisticsDealerDtlQueryVO();
//        if (StringUtils.isNotBlank(pageParam.getAgentEmp())) {
//            dealerDtlQueryVO.setCode(pageParam.getAgentEmp());
//        }
//        //List<Long> masIdList = selectMasIdByDtlParam(dealerDtlQueryVO);
//        MapBuilder mapBuilderDtl = this.setDtlMapBuilder(dealerDtlQueryVO);
//        List<StatisticsDealerDtlSearchBean> searchBeanSearchResultDtl = searchBeanService.getBeanSearcher().searchAll(StatisticsDealerDtlSearchBean.class, mapBuilderDtl.build());
//        if (CollectionUtils.isEmpty(searchBeanSearchResultDtl)) {
//            return PagingVO.<SaleStatisticsDealerRespVO>builder().total(0L).records(Collections.EMPTY_LIST).build();
//        }
//        List<Long> masIdList = searchBeanSearchResultDtl.stream().map(StatisticsDealerDtlSearchBean::getPid).filter(Objects::nonNull).distinct().collect(Collectors.toList());
//        if (CollectionUtils.isEmpty(masIdList)) {
//            return PagingVO.<SaleStatisticsDealerRespVO>builder().total(0L).records(Collections.EMPTY_LIST).build();
//        }
//        List<Long> ids = CollectionUtils.isEmpty(pageParam.getIds()) ? Collections.EMPTY_LIST : pageParam.getIds();
//        List<Long> idList = Stream.of(ids, masIdList).flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toList());
//        pageParam.setIds(idList);

        if (StringUtils.isBlank(pageParam.getRegion())){
            pageParam.setRegionFlag(1);
        }
        if (StringUtils.isBlank(pageParam.getAgentEmp())){
            pageParam.setSalesmanPathFlag(1);
        }
        // 分页100条
        pageParam.setSize(100);
        PagingVO<SaleStatisticsDealerRespVO> pagingVO = statisticsDealerRepoProc.appDetailsPage(pageParam);
        if (CollectionUtils.isEmpty(pagingVO.getRecords())) {
            return PagingVO.<SaleStatisticsDealerRespVO>builder().total(0L).records(Collections.EMPTY_LIST).build();
        }

        return pagingVO;
    }


    private MapBuilder setMapBuilder(SaleStatisticsDealerQueryVO queryVO) {
        var whereSqlMapBuilder = cn.zhxu.bs.util.MapUtils.builder()
                .page(queryVO.getPageRequest().getPageNumber(), queryVO.getPageRequest().getPageSize());
        whereSqlMapBuilder.field(StatisticsDealerSearchBean::getDeleteFlag, 0).op(FieldOps.Equal);
        if (!Objects.isNull(queryVO.getId())) {
            whereSqlMapBuilder.field(StatisticsDealerSearchBean::getId, queryVO.getId()).op(FieldOps.Equal);
        }
        if (!CollectionUtils.isEmpty(queryVO.getIds())) {
            whereSqlMapBuilder.field(StatisticsDealerSearchBean::getId, queryVO.getIds()).op(FieldOps.InList);
        }
        if (!StringUtils.isEmpty(queryVO.getDealerCode())) {
            whereSqlMapBuilder.field(StatisticsDealerSearchBean::getDealerCode, queryVO.getDealerCode()).op(FieldOps.Equal);
        }
        if (!CollectionUtils.isEmpty(queryVO.getDealerCodeList())) {
            whereSqlMapBuilder.field(StatisticsDealerSearchBean::getDealerCode, queryVO.getDealerCodeList()).op(FieldOps.InList);
        }
        if (!StringUtils.isEmpty(queryVO.getDealerCodeKeyword())) {
            whereSqlMapBuilder.field(StatisticsDealerSearchBean::getDealerCode, queryVO.getDealerCodeKeyword()).op(FieldOps.Contain);
        }
        if (!StringUtils.isEmpty(queryVO.getDealerName())) {
            whereSqlMapBuilder.field(StatisticsDealerSearchBean::getDealerName, queryVO.getDealerName()).op(FieldOps.Contain);
        }
        if (!StringUtils.isEmpty(queryVO.getDealerKeyword())) {
            whereSqlMapBuilder.field(StatisticsDealerSearchBean::getDealerCode, StatisticsDealerSearchBean::getDealerName).sql("$1 like '%?' or $2 like '%?' ", queryVO.getDealerKeyword(), queryVO.getDealerKeyword());

        }
        if (!StringUtils.isEmpty(queryVO.getKeyword())) {
            whereSqlMapBuilder.field(StatisticsDealerSearchBean::getDealerCode, StatisticsDealerSearchBean::getDealerName).sql("$1 like '%?' or $2 like '%?' ", queryVO.getKeyword(), queryVO.getKeyword());

        }
        if (!StringUtils.isEmpty(queryVO.getDealerSerialNo())) {
            whereSqlMapBuilder.field(StatisticsDealerSearchBean::getDealerSerialNo, queryVO.getDealerSerialNo()).op(FieldOps.Contain);
        }
        if (!StringUtils.isEmpty(queryVO.getDealerSerialNo1())) {
            whereSqlMapBuilder.field(StatisticsDealerSearchBean::getDealerSerialNo, queryVO.getDealerSerialNo1()).op(FieldOps.Equal);
        }
        if (!StringUtils.isEmpty(queryVO.getRegion())) {
            whereSqlMapBuilder.field(StatisticsDealerSearchBean::getRegion, queryVO.getRegion()).op(FieldOps.Equal);

        }
        if (!CollectionUtils.isEmpty(queryVO.getRegionList())) {
            whereSqlMapBuilder.field(StatisticsDealerSearchBean::getRegion, queryVO.getRegionList()).op(FieldOps.InList);

        }
        if (!StringUtils.isEmpty(queryVO.getType())) {
            whereSqlMapBuilder.field(StatisticsDealerSearchBean::getType, queryVO.getType()).op(FieldOps.Equal);

        }
        if (!CollectionUtils.isEmpty(queryVO.getTypeList())) {
            whereSqlMapBuilder.field(StatisticsDealerSearchBean::getType, queryVO.getTypeList()).op(FieldOps.InList);

        }
        if (!StringUtils.isEmpty(queryVO.getSalesmanPath())) {
            whereSqlMapBuilder.field(StatisticsDealerSearchBean::getSalesmanPath, queryVO.getSalesmanPath()).op(FieldOps.Equal);

        }
        if (!StringUtils.isEmpty(queryVO.getVehicleType())) {
            whereSqlMapBuilder.field(StatisticsDealerSearchBean::getVehicleType, queryVO.getVehicleType()).op(FieldOps.Equal);

        }
        if (!CollectionUtils.isEmpty(queryVO.getVehicleTypeList())) {
            whereSqlMapBuilder.field(StatisticsDealerSearchBean::getVehicleType, queryVO.getVehicleTypeList()).op(FieldOps.InList);

        }

        if (queryVO.getDocTimeStart() != null && queryVO.getDocTimeEnd() != null) {
            whereSqlMapBuilder.field(StatisticsDealerSearchBean::getDocTime, queryVO.getDocTimeStart(), queryVO.getDocTimeEnd()).op(FieldOps.Between);
        } else {
            if (queryVO.getDocTimeStart() != null) {
                whereSqlMapBuilder.field(StatisticsDealerSearchBean::getDocTime, queryVO.getDocTimeStart()).op(FieldOps.GreaterEqual);
            }
            if (queryVO.getDocTimeEnd() != null) {
                whereSqlMapBuilder.field(StatisticsDealerSearchBean::getDocTime, queryVO.getDocTimeEnd()).op(FieldOps.LessEqual);
            }
        }

        /*if (Objects.nonNull(queryVO.getDocTimeItStart())) {
            whereSqlMapBuilder.field(StatisticsDealerSearchBean::getYearMonthInt, queryVO.getDocTimeItStart()).op(FieldOps.GreaterEqual);
        }
        if (Objects.nonNull(queryVO.getDocTimeItEnd())) {
            whereSqlMapBuilder.field(StatisticsDealerSearchBean::getYearMonthInt, queryVO.getDocTimeItEnd()).op(FieldOps.LessEqual);
        }*/

        if (Objects.nonNull(queryVO.getDocMonth())) {
            whereSqlMapBuilder.field(StatisticsDealerSearchBean::getDocMonth, queryVO.getDocMonth()).op(FieldOps.Equal);
        }

        if (Objects.nonNull(queryVO.getDocTime())) {
            whereSqlMapBuilder.field(StatisticsDealerSearchBean::getDocDate, queryVO.getDocTime().toLocalDate().toString()).op(FieldOps.Equal);
        }


        if (!Objects.isNull(queryVO.getShipQty())) {
            whereSqlMapBuilder.field(StatisticsDealerSearchBean::getShipQty, queryVO.getShipQty()).op(FieldOps.Equal);
        }
        if (!Objects.isNull(queryVO.getOrderQty())) {
            whereSqlMapBuilder.field(StatisticsDealerSearchBean::getOrderQty, queryVO.getOrderQty()).op(FieldOps.Equal);
        }


        if (!StringUtils.isEmpty(queryVO.getCustType())) {
            whereSqlMapBuilder.field(StatisticsDealerSearchBean::getCustType, queryVO.getCustType()).op(FieldOps.Equal);
        }
        if (!CollectionUtils.isEmpty(queryVO.getCustTypes())) {
            whereSqlMapBuilder.field(StatisticsDealerSearchBean::getCustType, queryVO.getCustTypes()).op(FieldOps.InList);
        }
        if (!StringUtils.isEmpty(queryVO.getItemType3())) {
            whereSqlMapBuilder.field(StatisticsDealerSearchBean::getItemType3, queryVO.getItemType3()).op(FieldOps.Equal);
        }
        if (!CollectionUtils.isEmpty(queryVO.getItemType3List())) {
            whereSqlMapBuilder.field(StatisticsDealerSearchBean::getItemType3, queryVO.getItemType3List()).op(FieldOps.InList);
        }

       /* if (!Objects.isNull(queryVO.getUserId())) {
            whereSqlMapBuilder.field(StatisticsDealerSearchBean::getUserId, queryVO.getUserId()).op(FieldOps.Equal);
        }
        if (!StringUtils.isEmpty(queryVO.getLevel())) {
            whereSqlMapBuilder.field(StatisticsDealerSearchBean::getLevel, queryVO.getLevel()).op(FieldOps.Equal);
        }
        if (!StringUtils.isEmpty(queryVO.getAgentEmp())) {
            whereSqlMapBuilder.field(StatisticsDealerSearchBean::getCode, queryVO.getAgentEmp()).op(FieldOps.Equal);
        }
        if (!CollectionUtils.isEmpty(queryVO.getAgentEmpList())) {
            whereSqlMapBuilder.field(StatisticsDealerSearchBean::getCode, queryVO.getAgentEmpList()).op(FieldOps.InList);
        }*/


        return whereSqlMapBuilder;
    }

    private MapBuilder setDtlMapBuilder(SaleStatisticsDealerDtlQueryVO queryVO) {
        var whereSqlMapBuilderDtl = cn.zhxu.bs.util.MapUtils.builder();
        whereSqlMapBuilderDtl.field(StatisticsDealerDtlSearchBean::getDeleteFlag, 0).op(FieldOps.Equal);

        if (!Objects.isNull(queryVO.getUserId())) {
            whereSqlMapBuilderDtl.field(StatisticsDealerDtlSearchBean::getUserId, queryVO.getUserId()).op(FieldOps.Equal);
        }
        if (!StringUtils.isEmpty(queryVO.getLevel())) {
            whereSqlMapBuilderDtl.field(StatisticsDealerDtlSearchBean::getLevel, queryVO.getLevel()).op(FieldOps.Equal);
        }
        if (!CollectionUtils.isEmpty(queryVO.getLevels())) {
            whereSqlMapBuilderDtl.field(StatisticsDealerDtlSearchBean::getLevel, queryVO.getLevels()).op(FieldOps.InList);
        }
        if (!StringUtils.isEmpty(queryVO.getCode())) {
            whereSqlMapBuilderDtl.field(StatisticsDealerDtlSearchBean::getCode, queryVO.getCode()).op(FieldOps.Equal);
        }
        if (!CollectionUtils.isEmpty(queryVO.getCodes())) {
            whereSqlMapBuilderDtl.field(StatisticsDealerDtlSearchBean::getCode, queryVO.getCodes()).op(FieldOps.InList);
        }

        return whereSqlMapBuilderDtl;
    }


    /*********************************************/

    /**
     * 根据统计月份的日期拼装入参里的统计时间起始、统计时间截至
     *
     * @param pageParam 查询入参
     */
    public void assembleDocTime(SaleStatisticsDealerQueryVO pageParam) {
        if (Objects.isNull(pageParam.getDocTimeStart()) || Objects.isNull(pageParam.getDocTimeEnd())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "统计日期为空!");
        }
        if (Objects.nonNull(pageParam.getDocTimeStart())) {
            LocalDate localDateStart = pageParam.getDocTimeStart().toLocalDate();
            LocalDateTime minTime = LocalDateTime.of(localDateStart, LocalTime.MIN);
            pageParam.setDocTimeStart(minTime);
        }
        if (Objects.nonNull(pageParam.getDocTimeEnd())) {
            LocalDate localDateEnd = pageParam.getDocTimeEnd().toLocalDate();
            LocalDateTime maxTime = LocalDateTime.of(localDateEnd, ConstantsSale.LOCAL_TIME_MAX);
            pageParam.setDocTimeEnd(maxTime);
        }
    }

    /**
     * 组装填充经销商销售业绩的相关信息
     *
     * @param respVOList 主表数据信息
     * @return
     */
    private void translateDealer(List<SaleStatisticsDealerRespVO> respVOList) {
        //根据主表ID查询附表信息
        List<Long> idList = respVOList.stream().map(SaleStatisticsDealerRespVO::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<SaleStatisticsDealerDtlRespVO> dtlRespVOList = selectDtlByMasId(idList);
        respVOList.forEach(respVO -> {
            //查询附件信息
            List<SaleStatisticsDealerDtlRespVO> dtlRespVOS = dtlRespVOList.stream().filter(dtlRespVO -> Objects.equals(dtlRespVO.getMasId(), respVO.getId())).collect(Collectors.toList());
            respVO.setDtlRespVOS(dtlRespVOS);
            String docMonth = respVO.getDocTime().format(DateTimeFormatter.ofPattern("yyyy-MM"));
            respVO.setDocMonth(docMonth);
            respVO.setDocDay(respVO.getDocTime().toLocalDate().toString());

            dtlRespVOS.stream().forEach(dtlRespVO -> {
                StringJoiner spliceName = new StringJoiner(" ").add(dtlRespVO.getTypeName()).add(dtlRespVO.getName());
                if (Objects.equals(ConstantsSale.STATISTICS_DEALER_DTL_LEVEL_0, dtlRespVO.getLevel())) {
                    respVO.setAgentEmp(dtlRespVO.getCode());
                    respVO.setAgentEmpName(spliceName.toString());
                } else if (Objects.equals(ConstantsSale.STATISTICS_DEALER_DTL_LEVEL_1, dtlRespVO.getLevel())) {
                    respVO.setLevelOne(spliceName.toString());
                } else if (Objects.equals(ConstantsSale.STATISTICS_DEALER_DTL_LEVEL_2, dtlRespVO.getLevel())) {
                    respVO.setLevelTwo(spliceName.toString());
                } else if (Objects.equals(ConstantsSale.STATISTICS_DEALER_DTL_LEVEL_3, dtlRespVO.getLevel())) {
                    respVO.setLevelThree(spliceName.toString());
                } else if (Objects.equals(ConstantsSale.STATISTICS_DEALER_DTL_LEVEL_4, dtlRespVO.getLevel())) {
                    respVO.setLevelFour(spliceName.toString());
                } else if (Objects.equals(ConstantsSale.STATISTICS_DEALER_DTL_LEVEL_5, dtlRespVO.getLevel())) {
                    respVO.setLevelFive(spliceName.toString());
                }
            });

        });
    }

    private List<SaleStatisticsDealerDtlRespVO> selectDtlByMasId(List<Long> masIds) {
        if (CollectionUtils.isEmpty(masIds)) {
            return Collections.EMPTY_LIST;
        }
        SaleStatisticsDealerDtlQueryVO dtlQueryVO = new SaleStatisticsDealerDtlQueryVO();
        dtlQueryVO.setMasIds(masIds);
        List<SaleStatisticsDealerDtlRespVO> dtlRespVOList = statisticsDealerDtlService.selectByParam(dtlQueryVO);
        if (CollectionUtils.isEmpty(dtlRespVOList)) {
            return Collections.EMPTY_LIST;
        }
        return dtlRespVOList;
    }

    private void appDetailsCheck(SaleStatisticsDealerQueryVO pageParam) {
        if (StringUtils.isBlank(pageParam.getDealerCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "客户编码为空!");
        }
        if (Objects.isNull(pageParam.getDocTimeStart())||Objects.isNull(pageParam.getDocTimeEnd())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "统计时间为空!");
        }
//        if (Objects.isNull(pageParam.getDocMonth())) {
//            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "统计月份为空!");
//        }
//        if (StringUtils.isBlank(pageParam.getRegion())) {
//            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "区域为空!");
//        }
        /*if (StringUtils.isBlank(pageParam.getAgentEmp())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "业务员编码为空!");
        }*/
        /*if (StringUtils.isBlank(pageParam.getVehicleType())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "车型为空!");
        }*/
    }
}
