package com.elitesland.yst.production.sale.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.yst.production.sale.api.service.ComSaleFileInfoService;
import com.elitesland.yst.production.sale.api.vo.resp.com.ComSaleFileComVO;
import com.elitesland.yst.production.sale.convert.ComSaleFileInfoConvert;
import com.elitesland.yst.production.sale.entity.ComSaleFileInfoDO;
import com.elitesland.yst.production.sale.entity.QComSaleFileInfoDO;
import com.elitesland.yst.production.sale.repo.ComSaleFileInfoRepo;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/5/27 13:09
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class ComSaleFileInfoServiceImpl implements ComSaleFileInfoService {

    private final ComSaleFileInfoRepo crmCustFileInfoRepo;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void comSaleFileHardSave(String businessType, String qualifyNo, List<ComSaleFileComVO> params) {
        if (qualifyNo == null) {
            return;
        }
        // 清空数据
        crmCustFileInfoRepo.deleteByBusinessTypeAndQualifyNo(businessType, qualifyNo);
        if (CollectionUtils.isEmpty(params)) {
            return;
        }
        // 数据转换
        List<ComSaleFileInfoDO> crmCustFileInfoDOS = params.stream().map(ComSaleFileInfoConvert.INSTANCE::saveVoToDo).collect(Collectors.toList());
        crmCustFileInfoDOS.forEach(c -> {
            c.setBusinessType(businessType);
        });
        // 保存
        crmCustFileInfoRepo.saveAll(crmCustFileInfoDOS);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void comSaleFileHardSave(String businessType, Long businessId, List<ComSaleFileComVO> params) {
        if (StrUtil.isNotBlank(businessType) && Objects.nonNull(businessId)) {
            // 清空老数据
            crmCustFileInfoRepo.deleteByBusinessTypeAndBusinessId(businessType, businessId);
            if (CollectionUtils.isNotEmpty(params)) {
                // 数据转换
                List<ComSaleFileInfoDO> comSaleFileInfoDOS = params.stream()
                        .map(ComSaleFileInfoConvert.INSTANCE::saveVoToDo).collect(Collectors.toList());
                comSaleFileInfoDOS.forEach(c -> {
                    c.setBusinessId(businessId);
                    c.setBusinessType(businessType);
                });
                crmCustFileInfoRepo.saveAll(comSaleFileInfoDOS);
            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void comSaleFileHardSaveNotDelete(String businessType, Long businessId, List<ComSaleFileComVO> params) {
        if (StrUtil.isNotBlank(businessType) && Objects.nonNull(businessId)) {
            // 清空老数据
//            crmCustFileInfoRepo.deleteByBusinessTypeAndBusinessId(businessType, businessId);
            if (CollectionUtils.isNotEmpty(params)) {
                // 数据转换
                List<ComSaleFileInfoDO> comSaleFileInfoDOS = params.stream()
                        .map(ComSaleFileInfoConvert.INSTANCE::saveVoToDo).collect(Collectors.toList());
                comSaleFileInfoDOS.forEach(c -> {
                    c.setBusinessId(businessId);
                    c.setBusinessType(businessType);
                });
                crmCustFileInfoRepo.saveAll(comSaleFileInfoDOS);
            }
        }
    }
    @Override
    public List<ComSaleFileComVO> findFileByBusinessId(String businessType, Long businessId) {
        if (Objects.isNull(businessId)){
            return null;
        }
        var jpaQuery = jpaQueryFactory.selectFrom(comSaleFileInfoDO)
                .where(comSaleFileInfoDO.businessId.eq(businessId).and(comSaleFileInfoDO.businessType.eq(businessType)));
        List<ComSaleFileInfoDO> comSaleFileComDOS = jpaQuery.fetch();
        if (!CollectionUtils.isEmpty(comSaleFileComDOS)) {
            List<ComSaleFileComVO> comSaleFileComVOS = comSaleFileComDOS.stream().map(ComSaleFileInfoConvert.INSTANCE::doToSaveVo).collect(Collectors.toList());
            return comSaleFileComVOS;
        }
        return new ArrayList<>(0);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Object updateComFile(ComSaleFileComVO param) {
        if (param == null){
            return null;
        }
        this.comSaleFileHardSave(param.getBusinessType(),param.getBusinessId(), Collections.singletonList(param));
        return null;
    }

    private final JPAQueryFactory jpaQueryFactory;

    private final QComSaleFileInfoDO comSaleFileInfoDO = QComSaleFileInfoDO.comSaleFileInfoDO;

    @Override
    public List<ComSaleFileComVO> findFileByQualifyNos(String businessType, List<String> qualifyNos) {

        if (CollectionUtils.isEmpty(qualifyNos)) {
            return null;
        }
        List<ComSaleFileInfoDO> comSaleFileInfoDOS = findData(qualifyNos);
        List<ComSaleFileComVO> comSaleFileComVOS = new ArrayList<>();
        if (!CollectionUtils.isEmpty(comSaleFileInfoDOS)) {
            comSaleFileComVOS = comSaleFileInfoDOS.stream().map(ComSaleFileInfoConvert.INSTANCE::doToSaveVo).collect(Collectors.toList());
        }
        return comSaleFileComVOS;
    }

    private List<ComSaleFileInfoDO> findData(List<String> qualifyNos) {

        return jpaQueryFactory
                .selectFrom(comSaleFileInfoDO)
                .where(
                        comSaleFileInfoDO.qualifyNo.in(qualifyNos)
                                .and(comSaleFileInfoDO.deleteFlag.isNull().or(comSaleFileInfoDO.deleteFlag.eq(0)))
                )
                .fetch();
    }
}