package com.elitesland.yst.production.sale.service;

import cn.hutool.core.date.format.FastDateFormat;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.el.coordinator.core.common.utils.BeanCopyUtil;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.order.param.SalDoDQueryDTO;
import com.elitesland.yst.production.order.param.SalDoDRPCRespDTO;
import com.elitesland.yst.production.order.param.SalSoDetailQueryDTO;
import com.elitesland.yst.production.order.param.SalSoDetailRespDTO;
import com.elitesland.yst.production.sale.api.service.SalInvApplyService;
import com.elitesland.yst.production.sale.api.service.shop.SalReceiptStateService;
import com.elitesland.yst.production.sale.api.vo.param.pri.RmiSalSoDParam;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalInvApplyCheckParam;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalInvApplyPageParam;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalInvApplySaveParam;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalInvApplydSaveParam;
import com.elitesland.yst.production.sale.api.vo.resp.sal.*;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.convert.shop.BipRetationChartConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.*;
import com.elitesland.yst.production.sale.repo.*;
import com.elitesland.yst.production.sale.rmi.ystorder.RmiDoDRpcService;
import com.elitesland.yst.production.sale.rmi.ystorder.RmiOrderSalSoDService;

import com.elitesland.yst.production.sale.rmi.ystorder.RmiOrderSalSoService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiBrandService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiInvAwaitCustService;

import com.elitesland.yst.production.sale.rmi.ystsupport.RmiItemService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;

import com.elitesland.yst.production.support.provider.item.dto.ItmBrandRpcDTO;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmBrandRpcDtoParam;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcDtoParam;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.StringUtils;

import javax.validation.Valid;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

/**
 * @author JinXK
 * @date 2021/6/2 14:00
 */
@Service("salInvApplyService")
@RequiredArgsConstructor
@Slf4j
@Valid
public class SalInvApplySerciceImpl extends BaseServiceImpl implements SalInvApplyService {

    private final SalInvApplyRepo salInvApplyRepo;
    private final SalInvApplydRepo salInvApplydRepo;
    private final SalInvApplyRepoProc salInvApplyRepoProc;
    private final SalInvApplydRepoProc salInvApplydRepoProc;

    private final RmiOrderSalSoDService rmiOrderSalSoDService;

    private final RmiOrderSalSoService rmiOrderSalSoService;
    private final SalSoaRepo salSoaRepo;
    private final RmiDoDRpcService rmiDoDRpcService;
    private final RmiBrandService rmiBrandService;

    private final RmiInvAwaitCustService rmiInvAwaitCustService;
    private final RmiSysNextNumberService rmiSysNextNumberService;
    private final SalReceiptStateService salReceiptStateService;
    private final SalInvSerialRepo salInvSerialRepo;

    private final TransactionTemplate transactionTemplate;

    private final RmiItemService rmiItemService;



    @Autowired(required = false)
    private RedissonClient redissonClient;

    @Override
    @SysCodeProc
    public PagingVO<SalInvApplyRespVO> query(SalInvApplyPageParam pagingParam) {
        var jpaQuery = salInvApplyRepoProc.select(pagingParam);
        long total = jpaQuery.fetchCount();
        if (total == 0) {
            return PagingVO.<SalInvApplyRespVO>builder().build();
        }
        // 添加分页和排序
        PageRequest pageRequest = wrapperPageRequest(pagingParam.getPageRequest(), null);
        appendPageAndSort(jpaQuery, pageRequest, QSalInvApplyDO.salInvApplyDO);
        List<SalInvApplyRespVO> result = jpaQuery.fetch();
        //组装对应详情表信息
//        List<Long> masIds = result.stream().map(SalInvApplyRespVO::getId).collect(Collectors.toList());
//        List<SalInvApplydRespVO> details = salInvApplydRepoProc.findBymasIdIn(masIds).fetch();
//        result.forEach(apply -> {
//            List<SalInvApplydRespVO> salInvApplydRespVOS = new ArrayList<>();
//            details.forEach(applyd -> {
//                if(apply.getId().equals(applyd.getMasId())){
//                    salInvApplydRespVOS.add(applyd);
//                }
//            });
//            apply.setSalInvApplydRespVOS(salInvApplydRespVOS);
//        });
        PagingVO<SalInvApplyRespVO> pageRespVO = PagingVO.<SalInvApplyRespVO>builder()
                .total(total)
                .records(result).build();
        return pageRespVO;
    }

    @Override
    @SysCodeProc
    public PagingVO<RmiSalSoDVO> selectSo(RmiSalSoDParam pagingParamVO) {
        SalSoDetailQueryDTO salSoDetailQueryDTO = getSalSoDetailQueryDTO(pagingParamVO);

        ApiResult<PagingVO<SalSoDetailRespDTO>> apiResult = rmiOrderSalSoService.querySalSoDetail(salSoDetailQueryDTO);
        log.info("销售单查询OMS数据:"+JSON.toJSONString(apiResult));
        if(apiResult.getCode()!=200){
            throw new BusinessException(apiResult.getMsg());
        }

        log.info("销售单查询OMS数据:"+JSON.toJSONString(apiResult));
        if(apiResult.getCode()!=200){
            throw new BusinessException(apiResult.getMsg());
        }
        AtomicReference<Integer> pageNo = new AtomicReference<>(0);
        List<SalSoDetailRespDTO> salSoDetailRespDTOList = apiResult.getData().getRecords();
        List<SalSoDetailRespDTO> data = salSoDetailRespDTOList
                .stream()
                .filter(sal -> !sal.getDocStatus().equals("APPING"))
                .collect(Collectors.toList());
        log.info("过滤完审批中值后得到的数据:{}" , JSON.toJSONString(data));
        //反查及组装出参
        List<ItmBrandRpcDTO> dtoList = new ArrayList<>();
        List<String> brands = data.stream().filter(d->d.getItemBrand()!=null&&!d.getItemBrand().equals("")).map(SalSoDetailRespDTO::getItemBrand).distinct().collect(Collectors.toList());
        if(brands.size()>0) {
            ItmBrandRpcDtoParam brandRpcDtoParam = new ItmBrandRpcDtoParam();
            brandRpcDtoParam.setBrandCodes(brands);
            dtoList = rmiBrandService.findBrandDtoByParam(brandRpcDtoParam);
        }
        //商品信息反查
        List<ItmItemRpcDTO> itemList = new ArrayList<>();
        List<Long> itemIds = data.stream().filter(sod->sod.getItemId()!=null).map(SalSoDetailRespDTO::getItemId).distinct().collect(Collectors.toList());
        if(itemIds.size()>0) {
            ItmItemRpcDtoParam itemRpcDtoParam = new ItmItemRpcDtoParam();
            itemRpcDtoParam.setItemIds(itemIds);
            itemList = rmiItemService.findItemListByParam(itemRpcDtoParam);
        }

        List<ItmBrandRpcDTO> finalDtoList = dtoList;
        List<ItmItemRpcDTO> finalItemList = itemList;
        List<RmiSalSoDVO> list = data.stream().map(l -> {
            RmiSalSoDVO rmiSalSoDVO = new RmiSalSoDVO();
            BeanCopyUtil.beanCopy(l, rmiSalSoDVO);
            if(l.getDocCls()!=null && l.getDocCls().equals("RSO")){
                rmiSalSoDVO.setAmt(rmiSalSoDVO.getAmt()==null?BigDecimal.ZERO:rmiSalSoDVO.getAmt().abs().negate());
                rmiSalSoDVO.setOpenAmt(rmiSalSoDVO.getOpenAmt()==null?BigDecimal.ZERO:rmiSalSoDVO.getOpenAmt().abs().negate());
                rmiSalSoDVO.setApplyAmt(rmiSalSoDVO.getApplyAmt()==null?BigDecimal.ZERO:rmiSalSoDVO.getApplyAmt().abs().negate());
                rmiSalSoDVO.setInvingAmt(rmiSalSoDVO.getInvingAmt()==null?BigDecimal.ZERO:rmiSalSoDVO.getInvingAmt().abs().negate());
                rmiSalSoDVO.setInvedAmt(rmiSalSoDVO.getInvedAmt()==null?BigDecimal.ZERO:rmiSalSoDVO.getInvedAmt().abs().negate());
                rmiSalSoDVO.setNoinvAmt(rmiSalSoDVO.getNoinvAmt()==null?BigDecimal.ZERO:rmiSalSoDVO.getNoinvAmt().abs().negate());
                rmiSalSoDVO.setApAmt(rmiSalSoDVO.getApAmt()==null?BigDecimal.ZERO:rmiSalSoDVO.getApAmt().abs().negate());
                rmiSalSoDVO.setPayedAmt(rmiSalSoDVO.getPayedAmt()==null?BigDecimal.ZERO:rmiSalSoDVO.getPayedAmt().abs().negate());
                rmiSalSoDVO.setPayingAmt(rmiSalSoDVO.getPayingAmt()==null?BigDecimal.ZERO:rmiSalSoDVO.getPayingAmt().abs().negate());
                rmiSalSoDVO.setTaxAmt(rmiSalSoDVO.getTaxAmt()==null?BigDecimal.ZERO:rmiSalSoDVO.getTaxAmt().abs().negate());
                rmiSalSoDVO.setQty(rmiSalSoDVO.getQty()==null?BigDecimal.ZERO:rmiSalSoDVO.getQty().abs().negate());
                rmiSalSoDVO.setApplyQty(rmiSalSoDVO.getApplyQty()==null?BigDecimal.ZERO:rmiSalSoDVO.getApplyQty().abs().negate());
                rmiSalSoDVO.setInvingQty(rmiSalSoDVO.getInvingQty()==null?BigDecimal.ZERO:rmiSalSoDVO.getInvingQty().abs().negate());
                rmiSalSoDVO.setInvedQty(rmiSalSoDVO.getInvedQty()==null?BigDecimal.ZERO:rmiSalSoDVO.getInvedQty().abs().negate());
                rmiSalSoDVO.setNoinvQty(rmiSalSoDVO.getNoinvQty()==null?BigDecimal.ZERO:rmiSalSoDVO.getNoinvQty().abs().negate());
                rmiSalSoDVO.setConfirmQty(rmiSalSoDVO.getConfirmQty()==null?BigDecimal.ZERO:rmiSalSoDVO.getConfirmQty().abs().negate());
                rmiSalSoDVO.setConfirmAmt(rmiSalSoDVO.getConfirmAmt()==null?BigDecimal.ZERO:rmiSalSoDVO.getConfirmAmt().abs().negate());
            }
            rmiSalSoDVO.setApplyAmt(l.getNoinvAmt());
            rmiSalSoDVO.setApplyQty(l.getNoinvQty());
            pageNo.getAndSet(pageNo.get() + 1);
            rmiSalSoDVO.setPageNo(pageNo.get());
            if(finalDtoList.size()>0) {
                finalDtoList.forEach(dto -> {
                    if(rmiSalSoDVO.getItemBrand()!=null && dto.getBrandCode()!=null &&
                            rmiSalSoDVO.getItemBrand().equals(dto.getBrandCode())){
                        rmiSalSoDVO.setItemBrandName(dto.getBrandName());
                    }
                });
            }
            if(finalItemList.size()>0) {
                finalItemList.stream().filter(ite -> rmiSalSoDVO.getItemId() != null && rmiSalSoDVO.getItemId().equals(ite.getId())).forEach(ite -> {
                    rmiSalSoDVO.setTaxClass(ite.getTaxType() == null ? null : ite.getTaxType());
                    rmiSalSoDVO.setThirdCateName(ite.getItemCatePathName().get(2));
                });
            }
            return rmiSalSoDVO;
        }).collect(Collectors.toList());
        PagingVO<RmiSalSoDVO> pageRespVO = PagingVO.<RmiSalSoDVO>builder()
                .total(apiResult.getData().getTotal())
                .records(list).build();
        return pageRespVO;
    }

    /**
     * 组装入参
     */
    private SalSoDetailQueryDTO getSalSoDetailQueryDTO(RmiSalSoDParam pagingParamVO){
        SalSoDetailQueryDTO salSoDetailQueryDTO = new SalSoDetailQueryDTO();
        if(!StringUtils.isEmpty(pagingParamVO.getDocNo())){
            salSoDetailQueryDTO.setDocNo(pagingParamVO.getDocNo());
        }
        if(!StringUtils.isEmpty(pagingParamVO.getContractCode())){
            salSoDetailQueryDTO.setContractCode(pagingParamVO.getContractCode());
        }
        if(!StringUtils.isEmpty(pagingParamVO.getContractName())){
            salSoDetailQueryDTO.setContractName(pagingParamVO.getContractName());
        }
        if(!StringUtils.isEmpty(pagingParamVO.getCustId())){
            salSoDetailQueryDTO.setCustId(pagingParamVO.getCustId());
        }
        if(!StringUtils.isEmpty(pagingParamVO.getDocStatus())){
            salSoDetailQueryDTO.setDocStatus(pagingParamVO.getDocStatus());
        }
        if(Objects.nonNull(pagingParamVO.getOuId())){
            salSoDetailQueryDTO.setOuId(pagingParamVO.getOuId());
        }
        if(!StringUtils.isEmpty(pagingParamVO.getInvStatus())){
            salSoDetailQueryDTO.setInvStatus(pagingParamVO.getInvStatus());
        }
        if(!StringUtils.isEmpty(pagingParamVO.getTaxRate())){
            salSoDetailQueryDTO.setTaxRate(pagingParamVO.getTaxRate());
        }
        if(!StringUtils.isEmpty(pagingParamVO.getType())){
            salSoDetailQueryDTO.setType(pagingParamVO.getType());
            if ("OFF_PRE".equals(pagingParamVO.getType())){
                salSoDetailQueryDTO.setDocType("SOB2");
            }
        }
        if(!StringUtils.isEmpty(pagingParamVO.getSize())){
            salSoDetailQueryDTO.setSize(pagingParamVO.getSize());
        }
        if(!StringUtils.isEmpty(pagingParamVO.getCurrent())){
            salSoDetailQueryDTO.setCurrent(pagingParamVO.getCurrent());
        }
        return salSoDetailQueryDTO;
    }
}
