package com.elitesland.yst.production.sale.service;

import cn.hutool.core.date.format.FastDateFormat;
import cn.hutool.core.util.StrUtil;
import com.el.coordinator.core.common.utils.BeanCopyUtil;
//import com.elitesland.yst.production.order.param.SalDoDQueryDTO;
//import com.elitesland.yst.production.order.param.SalDoDRPCRespDTO;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;
import com.elitesland.yst.production.order.param.SalDoDQueryDTO;
import com.elitesland.yst.production.order.param.SalDoDRPCRespDTO;
import com.elitesland.yst.production.order.param.SalSoDetailQueryDTO;
import com.elitesland.yst.production.order.param.SalSoDetailRespDTO;
import com.elitesland.yst.production.sale.api.service.ComSaleFileInfoService;
import com.elitesland.yst.production.sale.api.service.SalSoaService;
import com.elitesland.yst.production.sale.api.vo.param.pri.RmiDoDParam;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalSoaExportPageParam;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalSoaPageParam;
import com.elitesland.yst.production.sale.api.vo.resp.com.ComSaleFileComVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.*;
import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.*;
import com.elitesland.yst.production.sale.repo.SalSoaDRepo;
import com.elitesland.yst.production.sale.repo.SalSoaDRepoProc;
import com.elitesland.yst.production.sale.repo.SalSoaRepo;
import com.elitesland.yst.production.sale.repo.SalSoaRepoProc;
import com.elitesland.yst.production.sale.rmi.ystorder.RmiDoDRpcService;
import com.elitesland.yst.production.sale.rmi.ystorder.RmiOrderSalSoService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiItemService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiCommonService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcDtoParam;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import javax.validation.Valid;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * @auther JinXK
 * @date 2021/7/7 15:38
 */
@Service
@RequiredArgsConstructor
@Slf4j
@Valid
public class SalSoaServiceImpl extends BaseServiceImpl implements SalSoaService {

    private final SalSoaRepo salSoaRepo;
    private final SalSoaDRepo salSoaDRepo;
    private final SalSoaRepoProc salSoaRepoProc;
    private final SalSoaDRepoProc salSoaDRepoProc;
    private final RmiDoDRpcService rmiDoDRpcService;
    private final RmiCommonService rmiCommonService;
//    private final RmiOrderSalSoService rmiOrderSalSoService;
    private final ComSaleFileInfoService comSaleFileInfoService;
//    private final RmiItemService rmiItemService;
    private final RmiSysNextNumberService rmiSysNextNumberService;

    private final RmiItemService rmiItemService;

    private final RmiOrderSalSoService rmiOrderSalSoService;



    @Autowired(required = false)
    private RedissonClient redissonClient;

    @Override
    @SysCodeProc
    public PagingVO<SalSoaRespVO> query(SalSoaPageParam pagingParam) {
        var jpaQuery = salSoaRepoProc.select(pagingParam);
        long total = jpaQuery.fetchCount();
        if (total == 0) {
            return PagingVO.<SalSoaRespVO>builder().build();
        }
        if(ConstantsSale.SALS0A_EXPORT_MARK.equals(pagingParam.getExportMark())){
            Long total1 = total;
            pagingParam.setSize(total1.intValue());
        }
        // 添加分页和排序
        PageRequest pageRequest = wrapperPageRequest(pagingParam.getPageRequest(), null);
        appendPageAndSort(jpaQuery, pageRequest, QSalSoaDO.salSoaDO);
        List<SalSoaRespVO> result = jpaQuery.fetch();
        //查询订单明细信息
        List<Long> masIds = result.stream().map(SalSoaRespVO::getId).collect(Collectors.toList());
        List<SalSoaDRespVO> soaDs = salSoaDRepoProc.findAllBymasIds(masIds).fetch();
        //反查币种名称
        Set<String> currCodes = result.stream().map(r -> r.getCurrCode()).filter(StrUtil::isNotBlank).collect(Collectors.toSet());

        List<SysCurrencyRespDTO> currRpcResult = rmiCommonService.listByCodes(currCodes);
        //反查销售单信息
        List<Long> sodIds = soaDs.stream().filter(sod->sod.getSoDId()!=null).map(SalSoaDRespVO::getSoDId).distinct().collect(Collectors.toList());

        // 三级品类名称
        List<String> allItemCodes = soaDs.stream().map(SalSoaDRespVO::getItemCode).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        ItmItemRpcDtoParam rpcParam = new ItmItemRpcDtoParam();
        rpcParam.setItemCodes(allItemCodes);
        Map<String, List<String>> itemRpcDTOS = rmiItemService.findItemListByParam(rpcParam).stream().collect(Collectors.toMap(ItmItemRpcDTO::getItemCode, ItmItemRpcDTO::getItemCatePathName, (t1, t2)->t1));

        if(sodIds.size()>0){
            SalSoDetailQueryDTO salSoDetailQueryDTO = new SalSoDetailQueryDTO();
            salSoDetailQueryDTO.setSoDIdList(sodIds);
            salSoDetailQueryDTO.setSize(10000);
            ApiResult<PagingVO<SalSoDetailRespDTO>> apiResult = rmiOrderSalSoService.querySalSoDetail(salSoDetailQueryDTO);
            if(apiResult.getCode()!=200){
                throw new BusinessException(apiResult.getMsg());
            }
            List<SalSoDetailRespDTO> sodList = apiResult.getData().getRecords();
            soaDs.forEach(d -> {
                sodList.stream().filter(sod -> d.getSoDId() != null && d.getSoDId().equals(sod.getSoDId())).forEach(sod -> {
                    d.setApAmt(sod.getApAmt() == null ? BigDecimal.ZERO : sod.getApAmt());
                    d.setPayedAmt(sod.getPayedAmt() == null ? BigDecimal.ZERO : sod.getPayedAmt());
                    d.setPayingAmt(sod.getPayingAmt() == null ? BigDecimal.ZERO : sod.getPayingAmt());
                    d.setOpenAmt(sod.getOpenAmt() == null ? BigDecimal.ZERO : sod.getOpenAmt());
                    d.setInvedAmt(sod.getInvedAmt() == null ? BigDecimal.ZERO : sod.getInvedAmt());
                    d.setInvingAmt(sod.getInvingAmt() == null ? BigDecimal.ZERO : sod.getInvingAmt());
                    d.setNoinvAmt(sod.getNoinvAmt() == null ? BigDecimal.ZERO : sod.getNoinvAmt());
                    d.setInvedQty(sod.getInvedQty() == null ? BigDecimal.ZERO : sod.getInvedQty());
                    d.setInvingQty(sod.getInvingQty() == null ? BigDecimal.ZERO : sod.getInvingQty());
                    d.setNoinvQty(sod.getNoinvQty() == null ? BigDecimal.ZERO : sod.getNoinvQty());
                    List<String> cateList = itemRpcDTOS.get(d.getItemCode());
                    d.setThirdCateName(cateList.get(2));
                });
            });
        }
        //组装出参
        result.forEach(r -> {
            currRpcResult.stream().filter(c -> (StrUtil.isNotBlank(r.getCurrCode()) && r.getCurrCode().equals(c.getCurrCode())))
                    .findFirst().ifPresent(curr -> r.setCurrName(curr.getCurrName()));
            List<SalSoaDRespVO> salSoaDRespVOS = new ArrayList<>();
            soaDs.forEach(soad -> {
                if(r.getId().equals(soad.getMasId())) {
                    salSoaDRespVOS.add(soad);
                }
            });
            r.setSalSoaDRespVOList(salSoaDRespVOS);
        });
        PagingVO<SalSoaRespVO> pageRespVO = PagingVO.<SalSoaRespVO>builder()
                .total(total)
                .records(result).build();
        return pageRespVO;
    }

    @Override
    @SysCodeProc
    public SalSoaRespVO getById(Long id) {
        SalSoaPageParam pagingParam = new SalSoaPageParam();
        pagingParam.setId(id);
        List<SalSoaRespVO> list = salSoaRepoProc.select(pagingParam).fetch();
        SalSoaRespVO salSoaRespVO = new SalSoaRespVO();
        if(list.size()>0){
            salSoaRespVO = list.get(0);
            List<SalSoaDRespVO> details = salSoaDRepoProc.findBymasId(salSoaRespVO.getId()).fetch();
            //反查销售单信息
            List<Long> dodIds = details.stream().map(SalSoaDRespVO::getDodId).distinct().collect(Collectors.toList());
//            List<SalDoDRPCRespDTO> dodList = getDodListByDodId(dodIds);
//            details.forEach(d -> {
//                dodList.forEach(dod -> {
//                    if(d.getDodId().equals(dod.getId())) {
//                        d.setDocCls(dod.getRelateDocType());
//                        d.setSoPrice(dod.getPrice());
//                        d.setSoNetPrice(dod.getNetPrice());
//                    }
//                });
//            });
            salSoaRespVO.setSalSoaDRespVOList(details);
        }else{
            throw new BusinessException("查询Id不存在");
        }
        //塞入附件信息
        List<ComSaleFileComVO> comSFCList = comSaleFileInfoService.findFileByBusinessId("SAL_SOA", salSoaRespVO.getId());
        salSoaRespVO.setAttachFiles(comSFCList);
        return salSoaRespVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Object> save(SalSoaRespVO param) {
        SalSoaDO salSoaDO;
        try {
            salSoaDO = checkParam(param);
        }catch (Exception e) {
            return ApiResult.fail(e.getMessage());
        }
        //利用Redisson解决单据并发问题(key暂定为docNo)
        String docNo;
        if(StringUtils.isEmpty(salSoaDO)){
            docNo = rmiSysNextNumberService.generateCode("yst-sale","SA", new ArrayList<>());
        }else{
            docNo = salSoaDO.getDocNo();
        }
        RLock rLock = redissonClient.getLock(docNo);
        try{
            boolean lock = rLock.tryLock(0, 5, TimeUnit.MINUTES);
            if (!lock){
                throw new BusinessException("订单"+docNo+"正在操作中");
            }
            insertOrUpdate(salSoaDO, param, docNo);
        }catch (Exception e){
            log.error(e.getMessage());
            throw new BusinessException("操作失败:"+e.getMessage());
        }finally {
            if(rLock.isHeldByCurrentThread()) {
                rLock.unlock();
            }
        }
        return ApiResult.ok();
    }

    public ApiResult<Object> insertOrUpdate(SalSoaDO salSoaDO, SalSoaRespVO param, String docNo) {
        boolean isNew = false;
        if(StringUtils.isEmpty(salSoaDO)){
            //为空表示走新增逻辑
            isNew = true;
            salSoaDO = new SalSoaDO();
            BeanCopyUtil.beanCopy(param, salSoaDO);
            salSoaDO.setDocNo(docNo);
            salSoaDO.setApplyDate(LocalDateTime.now());
            salSoaDO.setSoaStatus(UdcEnum.SAL_SOA_STATUS_10.getValueCode());
            salSoaDO.setSoaInvStatus(UdcEnum.SAL_SOA_INV_STATUS_10.getValueCode());
            salSoaDO.setSoaReceiptStatus(UdcEnum.SAL_SOA_RECEIPT_STATUS_10.getValueCode());
        }else {
            //否则走修改逻辑
            BeanCopyUtil.beanCopy(param, salSoaDO);//TODO 赋值操作，细节待修改
            //明细行批量删除
            salSoaDRepo.deleteAllByMasId(salSoaDO.getId());
        }
        //待开票金额赋初始值
        salSoaDO.setInvApplyAmt(salSoaDO.getSoaAmt());
        //获取当前登录人信息
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if(currentUserDTO==null){
            throw new BusinessException("当前登录信息异常");
        }
        salSoaDO.setCreateUserId(currentUserDTO.getDetail().getId());
        salSoaDO.setCreator(currentUserDTO.getDetail().getUsername());
        //数据权限数据赋值
        salSoaDO.setSecOuId(param.getOuId());
        salSoaDO.setSecBuId(param.getBuId());
        salSoaDO.setSecUserId(param.getApplyEmpId());
        salSoaRepo.save(salSoaDO);
        //明细行批量新增
        Long masId = salSoaDO.getId();
        List<SalSoaDDO> detailList = new ArrayList<>();
        List<Long> idList = new ArrayList<>();
        param.getSalSoaDRespVOList().forEach(detail ->{
            SalSoaDDO salSoaDDO = new SalSoaDDO();
            BeanCopyUtil.beanCopy(detail, salSoaDDO);
            salSoaDDO.setMasId(masId);
            //数据权限数据赋值
            salSoaDDO.setSecOuId(param.getOuId());
            salSoaDDO.setSecBuId(param.getBuId());
            salSoaDDO.setSecUserId(param.getApplyEmpId());
            detailList.add(salSoaDDO);
            idList.add(detail.getDodId());
        });
        salSoaDRepo.saveAll(detailList);
        // 保存附件
        if(param.getAttachFiles()!=null&&param.getAttachFiles().size()>0){
            comSaleFileInfoService.comSaleFileHardSave("SAL_SOA", salSoaDO.getId(), param.getAttachFiles());
        }
        if(isNew && idList.size()>0) {
            //对账单新建时修改对应发货单
        //    rmiDoDRpcService.updateSoaStatus(idList, "30");
        }
        return ApiResult.ok();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Object> affirm(Long id) {
        Optional<SalSoaDO> optional = salSoaRepo.findById(id);
        if(optional.isEmpty()){
            throw new BusinessException("单据不存在");
        }
        SalSoaDO salSoaDO = optional.get();
        if(!salSoaDO.getSoaStatus().equals(UdcEnum.SAL_SOA_STATUS_10.getValueCode())) {
            throw new BusinessException("只有新建类型的单据可以确认");
        }
        salSoaDO.setSoaStatus(UdcEnum.SAL_SOA_STATUS_20.getValueCode());
        salSoaRepo.save(salSoaDO);
        return ApiResult.ok();
    }

    @Override
    @SysCodeProc
    public PagingVO<RmiDoDVO> selectDo(RmiDoDParam param) {
        SalDoDQueryDTO salDoDQueryDTO = getSalDoDQueryDTO(param);
        //查询未对账 已签收(发货单) 已收货(退货入库单)状态单据
        salDoDQueryDTO.setSoaStatus("10");
        salDoDQueryDTO.setDocStatus("DONE");
        PagingVO<SalDoDRPCRespDTO> salDoDRPCRespDTOPagingVO = rmiDoDRpcService.queryDodForInvoice(salDoDQueryDTO);

        List<SalDoDRPCRespDTO> data = salDoDRPCRespDTOPagingVO.getRecords();

        //反查币种名称
        Set<String> currCodes = data.stream().map(r -> r.getCurrCode()).filter(StrUtil::isNotBlank).collect(Collectors.toSet());
        List<SysCurrencyRespDTO> currRpcResult = rmiCommonService.listByCodes(currCodes);
        //反查itemId
        List<String> itemCodes = data.stream().map(r -> r.getItemCode()).filter(StrUtil::isNotBlank).distinct().collect(Collectors.toList());
        ItmItemRpcDtoParam itemRpcDtoParam = new ItmItemRpcDtoParam();
        itemRpcDtoParam.setItemCodes(itemCodes);
        List<ItmItemRpcDTO> itemRpcResult = rmiItemService.findItemListByParam(itemRpcDtoParam);

        List<RmiDoDVO> list = data.stream().map(l -> {
            RmiDoDVO rmiDoDVO = new RmiDoDVO();
            BeanCopyUtil.beanCopy(l, rmiDoDVO);
            if(l.getDocCls()!=null && l.getDocCls().equals("RDO")){
                rmiDoDVO.setConfirmAmt(rmiDoDVO.getConfirmAmt()==null?BigDecimal.ZERO:rmiDoDVO.getConfirmAmt().abs().negate());
                rmiDoDVO.setSoAmt(rmiDoDVO.getSoAmt()==null?BigDecimal.ZERO:rmiDoDVO.getSoAmt().abs().negate());
                rmiDoDVO.setConfirmNetAmt(rmiDoDVO.getConfirmNetAmt()==null?BigDecimal.ZERO:rmiDoDVO.getConfirmNetAmt().abs().negate());
                rmiDoDVO.setConfirmTaxAmt(rmiDoDVO.getConfirmTaxAmt()==null?BigDecimal.ZERO:rmiDoDVO.getConfirmTaxAmt().abs().negate());
                rmiDoDVO.setSoNetAmt(rmiDoDVO.getSoNetAmt()==null?BigDecimal.ZERO:rmiDoDVO.getSoNetAmt().abs().negate());
                rmiDoDVO.setSoTaxAmt(rmiDoDVO.getSoTaxAmt()==null?BigDecimal.ZERO:rmiDoDVO.getSoTaxAmt().abs().negate());
                rmiDoDVO.setQty(rmiDoDVO.getQty()==null?BigDecimal.ZERO:rmiDoDVO.getQty().abs().negate());
                rmiDoDVO.setConfirmQty(rmiDoDVO.getConfirmQty()==null?BigDecimal.ZERO:rmiDoDVO.getConfirmQty().abs().negate());
                rmiDoDVO.setSoQty(rmiDoDVO.getSoQty()==null?BigDecimal.ZERO:rmiDoDVO.getSoQty().abs().negate());
            }
            currRpcResult.stream().filter(c -> (StrUtil.isNotBlank(rmiDoDVO.getCurrCode()) && rmiDoDVO.getCurrCode().equals(c.getCurrCode())))
                    .findFirst().ifPresent(curr -> rmiDoDVO.setCurrName(curr.getCurrName()));
            itemRpcResult.stream().filter(c -> (StrUtil.isNotBlank(rmiDoDVO.getItemCode()) && rmiDoDVO.getItemCode().equals(c.getItemCode())))
                    .findFirst().ifPresent(curr -> {
                rmiDoDVO.setItemId(curr.getId());
                rmiDoDVO.setTaxClass(curr.getTaxType());
                rmiDoDVO.setThirdCateName(curr.getItemCatePathName().get(2));
            });
            return rmiDoDVO;
        }).collect(Collectors.toList());
        PagingVO<RmiDoDVO> pageRespVO = PagingVO.<RmiDoDVO>builder()
                .total(salDoDRPCRespDTOPagingVO.getTotal())
                .records(list).build();
        return pageRespVO;
    }

    public SalDoDQueryDTO getSalDoDQueryDTO(RmiDoDParam param){
        SalDoDQueryDTO salDoDQueryDTO = new SalDoDQueryDTO();
        if(!StringUtils.isEmpty(param.getDocNo())){
            salDoDQueryDTO.setDocNo(param.getDocNo());
        }
        if(!StringUtils.isEmpty(param.getCustCode())){
            salDoDQueryDTO.setCustCode(param.getCustCode());
        }
        if(!StringUtils.isEmpty(param.getCustId())){
            salDoDQueryDTO.setCustId(param.getCustId());
        }
        if(!StringUtils.isEmpty(param.getDocTimeStart())){
            salDoDQueryDTO.setDocTimeStart(param.getDocTimeStart());
        }
        if(!StringUtils.isEmpty(param.getDocTimeEnd())){
            salDoDQueryDTO.setDocTimeEnd(param.getDocTimeEnd());
        }
        if(!StringUtils.isEmpty(param.getConfirmTimeStart())){
            salDoDQueryDTO.setConfirmTimeStart(param.getConfirmTimeStart());
        }
        if(!StringUtils.isEmpty(param.getConfirmTimeEnd())){
            salDoDQueryDTO.setConfirmTimeEnd(param.getConfirmTimeEnd());
        }
        if(!StringUtils.isEmpty(param.getDocStatus())){
            salDoDQueryDTO.setDocStatus(param.getDocStatus());
        }
        if(!StringUtils.isEmpty(param.getSoaStatus())){
            salDoDQueryDTO.setSoaStatus(param.getSoaStatus());
        }
        if(!StringUtils.isEmpty(param.getSize())){
            salDoDQueryDTO.setSize(param.getSize());
        }
        if(!StringUtils.isEmpty(param.getCurrent())){
            if(param.getCurrent()>0){
                salDoDQueryDTO.setCurrent(param.getCurrent()-1);
            }else{
                salDoDQueryDTO.setCurrent(param.getCurrent());
            }
        }
        return salDoDQueryDTO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Object> obsolete(Long id) {
        Optional<SalSoaDO> optional = salSoaRepo.findById(id);
        if(optional.isEmpty()){
            throw new BusinessException("单据不存在");
        }
        SalSoaDO salSoaDO = optional.get();
        if(salSoaDO.getSoaStatus().equals(UdcEnum.SAL_SOA_STATUS_20.getValueCode())) {
            throw new BusinessException("客户已确认的单据不能作废");
        }
        salSoaDO.setSoaStatus(UdcEnum.SAL_SOA_STATUS_30.getValueCode());
        salSoaRepo.save(salSoaDO);
        //对账单作废时修改对应发货单为未对账
        List<SalSoaDRespVO> list = salSoaDRepoProc.findBymasId(salSoaDO.getId()).fetch();
        List<Long> idList = list.stream().map(SalSoaDRespVO::getDodId).collect(Collectors.toList());
        if(idList.size()>0){
         //   rmiDoDRpcService.updateSoaStatus(idList, "10");
        }
        return ApiResult.ok();
    }


    @Override
    public PagingVO<SalSoaExportPageVO> searchForSalsoaExport(SalSoaExportPageParam pageParam) {
        LocalDateTime timeS = LocalDateTime.now();
        log.info("对账单导出数据处理......start:{}",timeS);
        List<SalSoaPageParam> salSoaPageParams = new ArrayList<>();
        if(!CollectionUtils.isEmpty(pageParam.getIds())){
            pageParam.getIds().forEach(t->{
                SalSoaPageParam salSoaPageParam = new SalSoaPageParam();
                salExportParm(salSoaPageParam, pageParam);
                salSoaPageParam.setId(t);
                salSoaPageParams.add(salSoaPageParam);
            });
        }else {
            SalSoaPageParam salSoaPageParam = new SalSoaPageParam();
            salExportParm(salSoaPageParam, pageParam);
            salSoaPageParams.add(salSoaPageParam);
        }
        log.info("对账单导出数据处理......查询参数:{}",salSoaPageParams);

        List<SalSoaRespVO> salSoaRespVOS = new ArrayList<>();
        if(!CollectionUtils.isEmpty(salSoaPageParams)){
            salSoaPageParams.forEach(parm->{
                parm.setExportMark(ConstantsSale.SALS0A_EXPORT_MARK);
                PagingVO<SalSoaRespVO> query = query(parm);
                List<SalSoaRespVO> records = query.getRecords();
                records.forEach(r->{
                    salSoaRespVOS.add(r);
                });
            });
        }
        log.info("对账单导出数据处理......查询结果1:{}",salSoaRespVOS);

        long total = salSoaRespVOS.size();
        List<SalSoaExportPageVO> salSoaExportPageVOS = convertSalSoaRespVOForExport(salSoaRespVOS);

        LocalDateTime timeE = LocalDateTime.now();
        log.info("对账单导出数据处理......end:{}",timeE);

        return PagingVO.<SalSoaExportPageVO>builder()
                .total(total)
                .records(salSoaExportPageVOS)
                .build();

//        LocalDateTime timeS = LocalDateTime.now();
//        log.info("对账单导出数据处理......start:{}",timeS);
//        var jpaQuery = salSoaRepoProc.selectExport(pageParam);
//        log.info("对账单导出数据处理......查询SQL:{}",jpaQuery);
//        long total = jpaQuery.fetchCount();
//        // 追加分页和排序，默认按docNo排序
//        PageRequest pageRequest = wrapperPageRequest(pageParam.getPageRequest(), null);
//        appendPageAndSort(jpaQuery, pageRequest, QSalSoaDO.salSoaDO);
//
//        List<SalSoaRespVO> result = jpaQuery.fetch();
//        log.info("对账单导出数据处理......查询结果1:{}",result);
//
//        var respVOList = jpaQuery.fetch();
//        log.info("对账单导出数据处理......查询结果2:{}",result);
//
//        List<SalSoaExportPageVO> salSoaExportPageVOS = convertSalSoaRespVOForExport(respVOList);
//
//        LocalDateTime timeE = LocalDateTime.now();
//        log.info("对账单导出数据处理......end:{}",timeE);
//        return PagingVO.<SalSoaExportPageVO>builder()
//                .total(total)
//                .records(salSoaExportPageVOS)
//                .build();
    }

    private List<SalSoaExportPageVO> convertSalSoaRespVOForExport(List<SalSoaRespVO> pageResult) {
        List<SalSoaExportPageVO> salSoaExportPageVOS = new ArrayList<>();
        log.info("对账单导出数据处理......查询结果3:{}",pageResult);
        //创建导出数据
        pageResult.forEach(page->{
            List<SalSoaDRespVO> salSoaDRespVOList = page.getSalSoaDRespVOList();
            salSoaDRespVOList.forEach(t->{
                SalSoaExportPageVO sal = new SalSoaExportPageVO();
                sal.setDocNo(page.getDocNo());
                sal.setSoaDate(page.getSoaDate());
                sal.setOuName(page.getOuName());
                sal.setCustName(page.getCustName());
                sal.setCustPic(page.getCustPic());
                sal.setCustPicTel(page.getCustPicTel());
                sal.setSoaAmt(page.getSoaAmt());
                sal.setApplyName(page.getApplyName());
                sal.setApplyEmpTel(page.getApplyEmpTel());
                sal.setLineNo(t.getLineNo());
                sal.setDodId(t.getDodId());
                sal.setDocTime(t.getDocTime());
                sal.setConfirmTime(t.getConfirmTime());
                sal.setItemName(t.getItemName());
                sal.setItemSpec(t.getItemSpec());
                sal.setDoQty2(t.getDoQty2());
                sal.setConfirmQty(t.getConfirmQty());
                sal.setConfirmAmt(t.getConfirmAmt());
                sal.setSoUom(t.getSoUom());
                if(t.getConfirmAmt() != null && t.getConfirmQty() != null){
                    BigDecimal doPrice = t.getConfirmQty().compareTo(BigDecimal.ZERO)==0?BigDecimal.ZERO:t.getConfirmAmt().divide(t.getConfirmQty());
                    sal.setDoPrice(doPrice);
                }
                salSoaExportPageVOS.add(sal);
            });
        });
        log.info("对账单导出数据处理......创建导出数据:{}",salSoaExportPageVOS);
        return salSoaExportPageVOS;
    }

    /**
     * 将  对账单导出分页查询入参  赋值给  客户对账单分页查询入参
     * @param page
     * @param export
     */
    public void salExportParm(SalSoaPageParam page,SalSoaExportPageParam export){
        if(!StringUtils.isEmpty(export.getDocNo())){
            page.setDocNo(export.getDocNo());
        }
        if(!StringUtils.isEmpty(export.getSoaDateStart())){
            page.setSoaDateStart(export.getSoaDateStart());
        }
        if(!StringUtils.isEmpty(export.getSoaDateEnd())){
            page.setSoaDateEnd(export.getSoaDateEnd());
        }
        if(!StringUtils.isEmpty(export.getOuId())){
            page.setOuId(export.getOuId());
        }
        if(!StringUtils.isEmpty(export.getOuCode())){
            page.setOuCode(export.getOuCode());
        }
        if(!StringUtils.isEmpty(export.getCustName())){
            page.setCustName(export.getCustName());
        }
        if(!StringUtils.isEmpty(export.getApplyName())){
            page.setApplyName(export.getApplyName());
        }
        if(!StringUtils.isEmpty(export.getSoaStatus())){
            page.setSoaStatus(export.getSoaStatus());
        }
        if(!StringUtils.isEmpty(export.getSoaReceiptStatus())){
            page.setSoaReceiptStatus(export.getSoaReceiptStatus());
        }
        if(!StringUtils.isEmpty(export.getSoaInvStatus())){
            page.setSoaInvStatus(export.getSoaInvStatus());
        }
        if(!StringUtils.isEmpty(export.getDoDocNo())){
            page.setDoDocNo(export.getDoDocNo());
        }
        if(!StringUtils.isEmpty(export.getSoNo())){
            page.setSoNo(export.getSoNo());
        }
        if(!StringUtils.isEmpty(export.getTaxRate())){
            page.setTaxRate(export.getTaxRate());
        }
    }

    /**
     * 入参校验--非空校验
     */
    private SalSoaDO checkParam(SalSoaRespVO param) {
        if(StringUtils.isEmpty(param.getSalSoaDRespVOList())){
            throw new BusinessException("明细不能为空");
        }
        if(StringUtils.isEmpty(param.getOuId())){
            throw new BusinessException("公司id不能为空");
        }
        if(StringUtils.isEmpty(param.getBuId())){
            throw new BusinessException("销售组织id不能为空");
        }
        if(StringUtils.isEmpty(param.getApplyEmpId())){
            throw new BusinessException("申请人id不能为空");
        }
        // 查询销售开票申请单
        if(StringUtils.isEmpty(param.getId())){
            return null;
        }else{
            Optional<SalSoaDO> alterOptional = salSoaRepo.findById(param.getId());
            if(alterOptional.isEmpty()){
                throw new BusinessException("修改失败,查询不到该id数据");
            }
            return alterOptional.get();
        }
    }

    public String getApplyCode(){
        String time ="SA" + FastDateFormat.getInstance("yyMMdd").format(new Date());
        int count = salSoaRepo.countByDocNoLike(time+"%");
        String applyCode =time + String.format("%07d",count);
        return applyCode;
    }

//    public SalDoDQueryDTO getSalDoDQueryDTO(RmiDoDParam param){
//        SalDoDQueryDTO salDoDQueryDTO = new SalDoDQueryDTO();
//        if(!StringUtils.isEmpty(param.getDocNo())){
//            salDoDQueryDTO.setDocNo(param.getDocNo());
//        }
//        if(!StringUtils.isEmpty(param.getCustCode())){
//            salDoDQueryDTO.setCustCode(param.getCustCode());
//        }
//        if(!StringUtils.isEmpty(param.getCustId())){
//            salDoDQueryDTO.setCustId(param.getCustId());
//        }
//        if(!StringUtils.isEmpty(param.getDocTimeStart())){
//            salDoDQueryDTO.setDocTimeStart(param.getDocTimeStart());
//        }
//        if(!StringUtils.isEmpty(param.getDocTimeEnd())){
//            salDoDQueryDTO.setDocTimeEnd(param.getDocTimeEnd());
//        }
//        if(!StringUtils.isEmpty(param.getConfirmTimeStart())){
//            salDoDQueryDTO.setConfirmTimeStart(param.getConfirmTimeStart());
//        }
//        if(!StringUtils.isEmpty(param.getConfirmTimeEnd())){
//            salDoDQueryDTO.setConfirmTimeEnd(param.getConfirmTimeEnd());
//        }
//        if(!StringUtils.isEmpty(param.getDocStatus())){
//            salDoDQueryDTO.setDocStatus(param.getDocStatus());
//        }
//        if(!StringUtils.isEmpty(param.getSoaStatus())){
//            salDoDQueryDTO.setSoaStatus(param.getSoaStatus());
//        }
//        if(!StringUtils.isEmpty(param.getSize())){
//            salDoDQueryDTO.setSize(param.getSize());
//        }
//        if(!StringUtils.isEmpty(param.getCurrent())){
//            if(param.getCurrent()>0){
//                salDoDQueryDTO.setCurrent(param.getCurrent()-1);
//            }else{
//                salDoDQueryDTO.setCurrent(param.getCurrent());
//            }
//        }
//        return salDoDQueryDTO;
//    }

    /**
     * 根据明细id获取销售单明细
     */
//    private List<SalDoDRPCRespDTO> getDodListByDodId(List<Long> dodIds){
//        List<SalDoDRPCRespDTO> dodList = new ArrayList<>();
//        if(dodIds.size()>0){
//            SalDoDQueryDTO salDoDQueryDTO = new SalDoDQueryDTO();
//            salDoDQueryDTO.setIds(dodIds);
//            salDoDQueryDTO.setSize(10000);
//            ApiResult<PagingVO<SalDoDRPCRespDTO>> apiResult = rmiDoDRpcService.queryDodForInvoice(salDoDQueryDTO);
//            if(apiResult.getCode()!=200){
//                throw new BusinessException(apiResult.getMsg());
//            }
//            dodList = apiResult.getData().getRecords();
//        }
//        return dodList;
//    }

}
