package com.elitesland.yst.production.sale.service;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.yst.production.sale.api.service.StatisticsDealerDtlService;
import com.elitesland.yst.production.sale.api.service.StatisticsDealerService;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsDealerDtlQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsDealerDtlRespVO;
import com.elitesland.yst.production.sale.api.vo.save.SaleStatisticsDealerDtlSaveVO;
import com.elitesland.yst.production.sale.convert.StatisticsDealerDtlConvert;
import com.elitesland.yst.production.sale.entity.SaleStatisticsDealerDtlDO;
import com.elitesland.yst.production.sale.repo.SaleStatisticsDealerDtlRepo;
import com.elitesland.yst.production.sale.repo.SaleStatisticsDealerDtlRepoProc;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 功能说明:销售业绩统计-经销商-明细
 * </p>
 *
 * @Author Darren
 * @Date 2023/06/01
 * @Version 1.0
 * @Content:
 */
@Slf4j
@Service
public class StatisticsDealerDtlServiceImpl implements StatisticsDealerDtlService {

    @Autowired
    private SaleStatisticsDealerDtlRepo statisticsDealerDtlRepo;
    @Autowired
    private SaleStatisticsDealerDtlRepoProc statisticsDealerDtlRepoProc;
    @Autowired
    private StatisticsDealerService statisticsDealerService;

    /**
     * 经销商销售业绩明细保存
     *
     * @param saveVOList 入参
     * @return 任务明细ID
     */
    @Override
    @Transactional(rollbackFor = {Exception.class})
    public List<Long> saveStatisticsDealerDtl(List<SaleStatisticsDealerDtlSaveVO> saveVOList) {
        List<SaleStatisticsDealerDtlDO> dtlDOList = saveVOList.stream().map(StatisticsDealerDtlConvert.INSTANCE::saveVoToDo).collect(Collectors.toList());
        return statisticsDealerDtlRepo.saveAll(dtlDOList).stream().map(SaleStatisticsDealerDtlDO::getId).collect(Collectors.toList());
    }

    /**
     * 根据入参查询明细
     *
     * @param queryVO 入参
     * @return 明细出参
     */
    @Override
    @SysCodeProc
    public List<SaleStatisticsDealerDtlRespVO> selectByParam(SaleStatisticsDealerDtlQueryVO queryVO) {
        List<SaleStatisticsDealerDtlRespVO> dtlRespVOList = statisticsDealerDtlRepoProc.selectByQueryVO(queryVO);
        if (CollectionUtils.isEmpty(dtlRespVOList)) {
            return Collections.emptyList();
        }
        return dtlRespVOList;
    }

    /**
     * 根据入参查询主表ID
     *
     * @param queryVO 入参
     * @return 明细出参
     */
    @Override
    @SysCodeProc
    public List<SaleStatisticsDealerDtlRespVO> selectPidByQueryVO(SaleStatisticsDealerDtlQueryVO queryVO) {
        List<SaleStatisticsDealerDtlRespVO> dtlRespVOList = statisticsDealerDtlRepoProc.selectPidByQueryVO(queryVO);
        if (CollectionUtils.isEmpty(dtlRespVOList)) {
            return Collections.emptyList();
        }
        return dtlRespVOList;
    }

}
