//package com.elitesland.yst.production.sale.service.exter;
//
//import cn.hutool.core.lang.Assert;
//import com.alibaba.fastjson.JSON;
//import com.alibaba.fastjson.JSONObject;
//import com.elitescloud.cloudt.support.dto.OrgBuRpcDTO;
//import com.elitesland.yst.production.support.provider.org.dto.OrgEmpRpcDTO;
//import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
//import com.elitesland.yst.production.sale.api.service.CrmCustService;
//import com.elitesland.yst.production.sale.api.service.CrmScustService;
//import com.elitesland.yst.production.sale.api.service.SalContractService;
//import com.elitesland.yst.production.sale.api.service.SalProjService;
//import com.elitesland.yst.production.sale.api.service.exter.NrpSaleExterService;
//import com.elitesland.yst.production.sale.api.vo.param.pro.SalContractDSaveParam;
//import com.elitesland.yst.production.sale.api.vo.param.pro.SalContractSaveParam;
//import com.elitesland.yst.production.sale.api.vo.param.pro.SalProjSaveParam;
//import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustDetailRespVO;
//import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustSimpleVO;
//import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmScustDetailRespVO;
//import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmScustPageRespVO;
//import com.elitesland.yst.production.sale.api.vo.save.CrmCustSaveVO;
//import com.elitesland.yst.production.sale.api.vo.save.CrmScustSaveVO;
//import com.elitesland.yst.production.sale.api.vo.save.exter.CrmCustSaveDTO;
//import com.elitesland.yst.production.sale.api.vo.save.exter.CrmScustSaveDTO;
//import com.elitesland.yst.production.sale.api.vo.save.exter.SalContractSaveDTO;
//import com.elitesland.yst.production.sale.api.vo.save.exter.SaleProjSaveDTO;
//import com.elitesland.yst.production.sale.common.constant.UdcEnum;
//import com.elitesland.yst.production.sale.convert.CrmCustConvert;
//import com.elitesland.yst.production.sale.convert.CrmScustConvert;
////import com.elitesland.yst.production.sale.convert.SalContractConvert;
//import com.elitesland.yst.production.sale.convert.SalProjConvert;
//import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
//import com.elitesland.yst.production.sale.entity.SalContractDO;
//import com.elitesland.yst.production.sale.entity.SalProjDO;
//import com.elitesland.yst.production.sale.repo.*;
//import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgBuService;
//import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgEmpService;
//import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgOuService;
//import com.elitescloud.cloudt.common.base.ApiResult;
//import com.elitescloud.boot.exception.BusinessException;
//import com.elitescloud.cloudt.system.vo.SysUdcComboVO;
//import lombok.RequiredArgsConstructor;
//import lombok.extern.slf4j.Slf4j;
//import org.springframework.http.HttpEntity;
//import org.springframework.http.HttpHeaders;
//import org.springframework.http.MediaType;
//import org.springframework.http.ResponseEntity;
//import org.springframework.stereotype.Service;
//import org.springframework.transaction.annotation.Transactional;
//import org.springframework.util.CollectionUtils;
//import org.springframework.util.LinkedMultiValueMap;
//import org.springframework.util.MultiValueMap;
//import org.springframework.util.ObjectUtils;
//import org.springframework.web.client.RestTemplate;
//
//import java.util.*;
//import java.util.stream.Collectors;
//
///**
// * <p>
// *  对外系统提供接口
// * </p>
// *
// * @author zhao.zhi.hao
// * @since 2021/9/29 10:23
// */
//@Service
//@RequiredArgsConstructor
//@Slf4j
//public class NrpSaleExterServiceImpl extends BaseServiceImpl implements NrpSaleExterService {
//
//    private final CrmCustService crmCustService;
//
//    private final CrmScustService crmScustService;
//
//    private final SalProjService salProjService;
//
//    private final SalContractService salContractService;
//
//    private final RmiOrgBuService rmiOrgBuService;
//
//    private final RmiOrgOuService rmiOrgOuService;
//
//    private final RmiOrgEmpService rmiOrgEmpService;
//
//    private final CrmScustRepoProc crmScustRepoProc;
//
//    private final SalProjRepoProc salProjRepoProc;
//
//    private final CrmCustRepoProc crmCustRepoProc;
//
//    private final SalContractRepo salContractRepo;
//
//    private final SalProjRepo salProjRepo;
//
//    @Override
//    @Transactional(rollbackFor = Exception.class)
//    public ApiResult<CrmCustDetailRespVO> saveCust(CrmCustSaveDTO saveVO) {
//        log.info("外部接口客户保存入参:{}",JSONObject.toJSONString(saveVO));
//        // 数据教研处理
//        checkForCustSave(saveVO);
//        // 数据处理
//        custSaveDataHandle(saveVO);
//        // 转换
//        CrmCustConvert crmCustConvert = CrmCustConvert.INSTANCE;
//        CrmCustSaveVO crmCustSaveVO = crmCustConvert.saveDtoToSaveVO(saveVO);
//        // 数据处理
//        log.info("外部接口客户保存结果:{}",JSONObject.toJSONString(crmCustService.save(crmCustSaveVO)));
//        return crmCustService.save(crmCustSaveVO);
//    }
//
//    private void checkForCustSave(CrmCustSaveDTO saveVO){
//        Assert.notNull(saveVO, "保存信息为空");
//        Assert.isFalse(ObjectUtils.isEmpty(saveVO.getCustType2()), "保存数据客户归类为空");
////        Assert.isFalse(ObjectUtils.isEmpty(saveVO.getCustCode2()), "保存数据外部客户编码为空");
//        Assert.isFalse(ObjectUtils.isEmpty(saveVO.getTaxRegNo()), "保存数据税务登记号为空");
//        Assert.isFalse(ObjectUtils.isEmpty(saveVO.getBuCode()), "保存数据销售组织编码为空");
//        Assert.isFalse(ObjectUtils.isEmpty(saveVO.getCustName()), "保存数据客户名称为空");
//        Assert.isFalse(ObjectUtils.isEmpty(saveVO.getOuCode()), "保存数据销售公司编码为空");
//        Assert.isFalse(ObjectUtils.isEmpty(saveVO.getAgentEmpCode()), "保存数据业务员编号为空");
//
//        Assert.isFalse(ObjectUtils.isEmpty(saveVO.getCustType()), "保存数据客户分类为空");
//        Assert.isFalse(ObjectUtils.isEmpty(saveVO.getCustStatus()), "保存数据客户状态为空");
//        Assert.isFalse(ObjectUtils.isEmpty(saveVO.getFinancialAttribute()), "保存数据财务属性1为空");
//        Assert.isFalse(ObjectUtils.isEmpty(saveVO.getFinancialAttribute2()), "保存数据财务属性2为空");
//    }
//
//    private void custSaveDataHandle(CrmCustSaveDTO saveVO){
//        // 查看数据是否已经存在于正式环境表
//        List<CrmCustSimpleVO> nameAndTaxRegNo = crmCustRepoProc.findIdByNameAndTaxRegNo(saveVO.getCustName(), saveVO.getTaxRegNo());
//        if (!CollectionUtils.isEmpty(nameAndTaxRegNo)){
//            saveVO.setId(nameAndTaxRegNo.get(0).getId());
//            saveVO.setCustCode(nameAndTaxRegNo.get(0).getCustCode());
//            saveVO.setAddrNo(nameAndTaxRegNo.get(0).getAddrNo());
//        }
//        // 查询公司
//        List<String> ouCodes = new ArrayList<>();
//        ouCodes.add(saveVO.getOuCode());
//        List<OrgOuRpcDTO> ouDtoListByCode = rmiOrgOuService.findOuDtoList(null,ouCodes);
//        Assert.isFalse(CollectionUtils.isEmpty(ouDtoListByCode), "该公司在我方数据库未找到,请检查");
//
//        List<String> buCodes = new ArrayList<>();
//        buCodes.add(saveVO.getBuCode());
//        List<OrgBuRpcDTO> buDtoList = rmiOrgBuService.findBuDtoList(null, buCodes);
//        Assert.isFalse(CollectionUtils.isEmpty(buDtoList), "该组织在我方数据库未找到,请检查");
//
//        if (!ObjectUtils.isEmpty(saveVO.getAgentEmpCode())){
//            List<String> agentCodes = new ArrayList<>();
//            agentCodes.add(saveVO.getAgentEmpCode());
//            List<OrgEmpRpcDTO> empDtoList = rmiOrgEmpService.findEmpDtoList(null, agentCodes);
//            Assert.isFalse(CollectionUtils.isEmpty(empDtoList), "该员工在我方数据库未找到,请检查");
//            saveVO.setAgentEmpId(empDtoList.get(0).getId());
//        }
//        saveVO.setBuId(buDtoList.get(0).getId());
//        saveVO.setOuId(ouDtoListByCode.get(0).getId());
//        saveVO.setOuName(ouDtoListByCode.get(0).getOuName());
//        saveVO.setBuName(buDtoList.get(0).getBuName());
//        saveVO.setRegion(ouDtoListByCode.get(0).getRegion());
//    }
//
//    @Override
//    @Transactional(rollbackFor = Exception.class)
//    public ApiResult<CrmScustDetailRespVO> saveScust(CrmScustSaveDTO saveVO) {
//        // 数据校验处理
//        log.info("CRM潜在客户保存入参:{}",JSONObject.toJSONString(saveVO));
//        checkForScustSave(saveVO);
//        // 数据处理
//        sCustSaveDataHandle(saveVO);
//        // 转换
//        CrmScustConvert crmScustConvert = CrmScustConvert.INSTANCE;
//        CrmScustSaveVO crmScustSaveVO = crmScustConvert.saveDtoToVo(saveVO);
//        ApiResult<CrmScustDetailRespVO> respVOApiResult = crmScustService.save(crmScustSaveVO);
//        log.info("CRM潜在客户保存结果:{}",JSONObject.toJSONString(respVOApiResult));
//        return respVOApiResult;
//    }
//
//    private void sCustSaveDataHandle(CrmScustSaveDTO saveVO) {
//        // 查看数据是否已经存在于正式环境表
//        List<CrmCustSimpleVO> nameAndTaxRegNo = crmCustRepoProc.findIdByNameAndTaxRegNo(saveVO.getCustName(), saveVO.getTaxRegNo());
//        if (!CollectionUtils.isEmpty(nameAndTaxRegNo)){
//            throw new BusinessException("该客户已经是NRP正式客户");
//        }
//        // 看数据是否已经存在
//        List<CrmScustPageRespVO> idByNameAndTaxRegNo = crmScustRepoProc.findIdByNameAndTaxRegNo(saveVO.getCustName(), saveVO.getTaxRegNo());
//        if (!CollectionUtils.isEmpty(idByNameAndTaxRegNo)){
//            saveVO.setId(idByNameAndTaxRegNo.get(0).getId());
//            saveVO.setCustCode(idByNameAndTaxRegNo.get(0).getCustCode());
//            saveVO.setAddrNo(idByNameAndTaxRegNo.get(0).getAddrNo());
//        }
//        // 查询公司
//        // 查询已经上线的公司 todo 临时的处理办法
//        List<SysUdcComboVO> onLineOuUdcList = sysUdcService.listCodeCombos("CRM", "ONLINE");
//        List<String> ouOnLineCodes = onLineOuUdcList.stream().map(SysUdcComboVO::getUdcVal).collect(Collectors.toList());
//        List<String> ouNames = new ArrayList<>();
//        ouNames.add(saveVO.getOuName());
//        List<OrgOuRpcDTO> ouDtoListByName = rmiOrgOuService.findOuDtoListByName(ouNames);
//        Assert.isFalse(CollectionUtils.isEmpty(ouDtoListByName), "该公司在我方数据库未找到,请检查");
//        if (!ouOnLineCodes.contains(ouDtoListByName.get(0).getOuCode())){
//            throw new BusinessException("公司名称为"+saveVO.getOuName()+"的公司在NRP系统中尚未上线,请检查");
//        }
//
//        List<String> buCodes = new ArrayList<>();
//        buCodes.add(ouDtoListByName.get(0).getOuCode());
//        List<OrgBuRpcDTO> buDtoList = rmiOrgBuService.findBuDtoList(null, buCodes);
//        Assert.isFalse(CollectionUtils.isEmpty(buDtoList), "该组织在我方数据库未找到,请检查");
//
//        if (!ObjectUtils.isEmpty(saveVO.getAgentEmpCode())){
//            List<String> agentCodes = new ArrayList<>();
//            agentCodes.add(saveVO.getAgentEmpCode());
//            List<OrgEmpRpcDTO> empDtoList = rmiOrgEmpService.findEmpDtoList(null, agentCodes);
//            Assert.isFalse(CollectionUtils.isEmpty(empDtoList), "该员工在我方数据库未找到,请检查");
//            saveVO.setAgentEmpId(empDtoList.get(0).getId());
//        }
//        saveVO.setBuId(buDtoList.get(0).getId());
//        saveVO.setOuId(ouDtoListByName.get(0).getId());
//        saveVO.setOuCode(ouDtoListByName.get(0).getOuCode());
//        saveVO.setBuCode(buDtoList.get(0).getBuCode());
//        saveVO.setBuName(buDtoList.get(0).getBuName());
//        saveVO.setRegion(ouDtoListByName.get(0).getRegion());
//    }
//
//    private void checkForScustSave(CrmScustSaveDTO saveVO){
//        Assert.notNull(saveVO, "保存信息为空");
////        Assert.isFalse(ObjectUtils.isEmpty(saveVO.getCustCode2()), "保存数据CRM客户编码为空");
//        Assert.isFalse(ObjectUtils.isEmpty(saveVO.getTaxRegNo()), "保存数据税务登记号为空");
//        Assert.isFalse(ObjectUtils.isEmpty(saveVO.getCustName()), "保存数据客户名称为空");
////        Assert.isFalse(ObjectUtils.isEmpty(saveVO.getBuCode()), "保存数据销售组织编码为空");
//        Assert.isFalse(ObjectUtils.isEmpty(saveVO.getOuName()), "保存数据公司名称为空");
////        Assert.isFalse(ObjectUtils.isEmpty(saveVO.getRegion()), "保存数据区域为空");
//        Assert.isFalse(ObjectUtils.isEmpty(saveVO.getCustIndustry()), "保存数据客户行业为空");
//        Assert.isFalse(ObjectUtils.isEmpty(saveVO.getCustSource()), "保存数据客户来源为空");
//        Assert.isFalse(ObjectUtils.isEmpty(saveVO.getCustType()), "保存数据客户分类为空");
//    }
//
//    @Override
//    @Transactional(rollbackFor = Exception.class)
//    public ApiResult<String> saveProj(SaleProjSaveDTO saveDTO) {
//        log.info("CRM销售项目保存入参:{}",JSONObject.toJSONString(saveDTO));
//        // 数据处理
//        saveProjDataHandle(saveDTO);
//        // 转换
//        SalProjConvert salProjConvert = SalProjConvert.INSTANCE;
//        SalProjSaveParam salProjSaveParam = salProjConvert.saveDtoToVO(saveDTO);
//        JSONObject save = salProjService.save(salProjSaveParam);
//        log.info("CRM销售项目保存结果:{}",JSONObject.toJSONString(save));
//        return ApiResult.ok(save.get("projNo").toString());
//    }
//
//
//    private void saveProjDataHandle(SaleProjSaveDTO saveDTO) {
//        // 数据校验和处理
//        List<Long> ids = salProjRepoProc.findIdByName(saveDTO.getProjName());
//        if (!CollectionUtils.isEmpty(ids)){
//            saveDTO.setId(ids.get(0));
//        }
//        List<CrmCustSimpleVO> custCodeByName = crmCustRepoProc.getCustByName(saveDTO.getCustName());
//        List<CrmScustPageRespVO> idByNameAndTaxRegNo = crmScustRepoProc.findIdByNameAndTaxRegNo(saveDTO.getCustName(), null);
//        if (!CollectionUtils.isEmpty(custCodeByName)){
//            saveDTO.setCustCode(custCodeByName.get(0).getCustCode());
//            saveDTO.setCustId(custCodeByName.get(0).getId());
//            saveDTO.setCustType2(UdcEnum.SAL_QT_TYPE_B.getValueCode());
//        } else if (!CollectionUtils.isEmpty(idByNameAndTaxRegNo)){
//            saveDTO.setCustCode(idByNameAndTaxRegNo.get(0).getCustCode());
//            saveDTO.setCustId(idByNameAndTaxRegNo.get(0).getId());
//            saveDTO.setCustType2(UdcEnum.SAL_QT_TYPE_A.getValueCode());
//        }else{
//            throw new BusinessException("该客户在NRP方数据库未找到,请检查");
//        }
//
//        List<SysUdcComboVO> onLineOuUdcList = sysUdcService.listCodeCombos("CRM", "ONLINE");
//        List<String> ouOnLineCodes = onLineOuUdcList.stream().map(SysUdcComboVO::getUdcVal).collect(Collectors.toList());
//        List<String> ouNames = new ArrayList<>();
//        ouNames.add(saveDTO.getOuName());
//        List<OrgOuRpcDTO> ouDtoListByName = rmiOrgOuService.findOuDtoListByName(ouNames);
//        Assert.isFalse(CollectionUtils.isEmpty(ouDtoListByName), "该公司在NRP方数据库未找到,请检查");
//        if (!ouOnLineCodes.contains(ouDtoListByName.get(0).getOuCode())){
//            throw new BusinessException("公司名称为"+saveDTO.getOuName()+"的公司在NRP系统中尚未上线,请检查");
//        }
//
//        List<String> buCodes = new ArrayList<>();
//        buCodes.add(ouDtoListByName.get(0).getOuCode());
//        List<OrgBuRpcDTO> buDtoList = rmiOrgBuService.findBuDtoList(null, buCodes);
//        Assert.isFalse(CollectionUtils.isEmpty(buDtoList), "该组织在NRP方数据库未找到,请检查");
//        saveDTO.setOuId(ouDtoListByName.get(0).getId());
//        saveDTO.setBuId(buDtoList.get(0).getId());
//        saveDTO.setOuCode(ouDtoListByName.get(0).getOuCode());
//        saveDTO.setBuCode(ouDtoListByName.get(0).getOuCode());
//        saveDTO.setBuName(buDtoList.get(0).getBuName());
//        saveDTO.setRegion(ouDtoListByName.get(0).getRegion());
//    }
//
//    @Override
//    @Transactional(rollbackFor = Exception.class)
//    public ApiResult<String> saveContract(SalContractSaveDTO saveDTO) {
//        log.info("CRM销售合同保存入参:{}",JSONObject.toJSONString(saveDTO));
//        // 数据校验和处理
////        saveContrationDataHandle(saveDTO);
////        saveDTO.setProjConfirmFlag(null);
////        // 转换
////        SalContractConvert salContractConvert = SalContractConvert.INSTANCE;
////        SalContractSaveParam salContractSaveParam = salContractConvert.saveDtoToVO(saveDTO);
////        // 数据处理
////        List<SalContractDSaveParam> itemDetails = salContractSaveParam.getItemDetails();
////        List<SysUdcComboVO> sysUdcComboVOS = sysUdcService.listCodeCombos("COM", "UOM");
////        itemDetails.forEach(i -> {
////            i.setRemark(i.getItemName());
////            i.setItemName(null);
////            Optional<SysUdcComboVO> sysUdcComboVO = sysUdcComboVOS.stream().filter(udc -> udc.getValDesc().equals(i.getUom()))
////                    .findFirst();
////            if (sysUdcComboVO.isPresent()){
////                i.setUom(sysUdcComboVO.get().getUdcVal());
////            }else{
////                Assert.isFalse(false, i.getItemName()+"商品的单位在NRP方数据库未找到,请检查");
////            }
////        });
////        salContractSaveParam.setCatalogueFlag(0);
////        JSONObject object = salContractService.saveOrSubmit(salContractSaveParam, UdcEnum.SAL_CONTRACT_STATUS_DRAFT.getValueCode());
////        log.info("CRM销售合同保存结果:{}",JSONObject.toJSONString(object));
////        return ApiResult.ok(object.get("contractNo").toString());
//        return null;
//    }
//
//    private void saveContrationDataHandle(SalContractSaveDTO saveDTO) {
//        // 数据校验和处理(为什么写下面代码，因为字段命名不规范导致接不到数据)
//        saveDTO.setBSignOuName(saveDTO.getOuName());
//        saveDTO.setBRegion(saveDTO.getRegion());
//        saveDTO.setBSalesmanCode(saveDTO.getSalesmanCode());
//        saveDTO.setBAddress(saveDTO.getAddress());
//        saveDTO.setBSalesmanTel(saveDTO.getSalesmanTel());
//        SalContractDO salContractDO = salContractRepo.findByContractName(saveDTO.getContractName());
//        if (!ObjectUtils.isEmpty(salContractDO)){
//            if (!UdcEnum.SAL_CONTRACT_STATUS_DRAFT.getValueCode().equals(salContractDO.getContractStatus())){
//                throw new BusinessException("合同已经激活,不可更新,请在NRP复制新版本修改");
//            }else{
//                saveDTO.setId(salContractDO.getId());
//            }
//        }
//        // 查询项目信息补充数据
//        if (!ObjectUtils.isEmpty(saveDTO.getProjName())){
//            SalProjDO byProjName = salProjRepo.findByProjName(saveDTO.getProjName());
//            Assert.isFalse(ObjectUtils.isEmpty(byProjName), "该合同所属项目不存在于NRP系统中,请检查");
//            saveDTO.setProjId(byProjName.getId());
//            saveDTO.setProjCode(byProjName.getProjNo());
//        }
//        // 通过公司名称反查公司和组织信息
//        List<SysUdcComboVO> onLineOuUdcList = sysUdcService.listCodeCombos("CRM", "ONLINE");
//        List<String> ouOnLineCodes = onLineOuUdcList.stream().map(SysUdcComboVO::getUdcVal).collect(Collectors.toList());
//        List<String> ouNames = new ArrayList<>();
//        ouNames.add(saveDTO.getBSignOuName());
//        List<OrgOuRpcDTO> ouDtoList = rmiOrgOuService.findOuDtoListByName(ouNames);
//        Assert.isFalse(CollectionUtils.isEmpty(ouDtoList), "该公司在我方数据库未找到,请检查");
//        if (!ouOnLineCodes.contains(ouDtoList.get(0).getOuCode())){
//            throw new BusinessException("公司名称为"+saveDTO.getOuName()+"的公司在NRP系统中尚未上线,请检查");
//        }
//        saveDTO.setBSignOu(ouDtoList.get(0).getId().toString());
//        saveDTO.setBSignOuCode(ouDtoList.get(0).getOuCode());
//        // 客户名称反查客户编码
//        List<CrmCustSimpleVO> custCodeByName = crmCustRepoProc.getCustByName(saveDTO.getCustName());
//        List<CrmScustPageRespVO> sCustByName = crmScustRepoProc.findIdByNameAndTaxRegNo(saveDTO.getCustName(), null);
//        if (!CollectionUtils.isEmpty(custCodeByName)){
//          saveDTO.setCustCode(custCodeByName.get(0).getCustCode());
//          saveDTO.setCustId(custCodeByName.get(0).getId());
//        }else if (!CollectionUtils.isEmpty(sCustByName)){
//            throw new BusinessException("此客户为潜在客户，请在NRP转为正式客户后再创建合同.");
//        }else{
//            throw new BusinessException("此客户信息不存在，请在NRP创建正式客户后再创建合同.");
//        }
//
//        List<String> buCodes = new ArrayList<>();
//        buCodes.add(ouDtoList.get(0).getOuCode());
//        List<OrgBuRpcDTO> buDtoList = rmiOrgBuService.findBuDtoList(null, buCodes);
//        Assert.isFalse(CollectionUtils.isEmpty(buDtoList), "该组织在我方数据库未找到,请检查");
//
//        saveDTO.setBSignDept(buDtoList.get(0).getId().toString());
//        saveDTO.setBSignDeptCode(buDtoList.get(0).getBuCode());
//        saveDTO.setBSignDeptName(buDtoList.get(0).getBuName());
//        saveDTO.setBRegion(ouDtoList.get(0).getRegion());
//
//        if (!ObjectUtils.isEmpty(saveDTO.getBSalesmanCode())){
//            List<String> agentCodes = new ArrayList<>();
//            agentCodes.add(saveDTO.getBSalesmanCode());
//            List<OrgEmpRpcDTO> empDtoList = rmiOrgEmpService.findEmpDtoList(null, agentCodes);
//            Assert.isFalse(CollectionUtils.isEmpty(empDtoList), "该员工在我方数据库未找到,请检查");
//            saveDTO.setBSalesman(empDtoList.get(0).getId().toString());
//        }
//    }
//}
