package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Validator;
import cn.hutool.core.util.StrUtil;
import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitesland.yst.production.sale.Application;
import com.elitesland.yst.production.sale.api.service.shop.BipCompanyManageService;
import com.elitesland.yst.production.sale.api.service.shop.MktDiscountOffsetService;
import com.elitesland.yst.production.sale.api.vo.param.shop.MktDiscountOffsetDSaveVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.MktDiscountOffsetQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.MktDiscountOffsetSaveVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCompanyManageRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.MktDiscountOffsetRespDVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.MktDiscountOffsetRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.MktDiscountOffsetVO;
import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.convert.shop.MktDiscountOffsetConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.dto.PriSalePriceDTO;
import com.elitesland.yst.production.sale.dto.PriSalePriceSimpleDTO;
import com.elitesland.yst.production.sale.dto.query.PriSaleItemReqDTO;
import com.elitesland.yst.production.sale.dto.query.PriSalePriceReqDTO;
import com.elitesland.yst.production.sale.entity.*;
import com.elitesland.yst.production.sale.repo.shop.*;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiItemService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import com.elitesland.yst.production.sale.service.PriSalePriceRpcService;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.dto.OrgUserEmpInfoRpcDTO;
import com.elitesland.yst.production.support.provider.org.service.OrgEmpRpcService;
import com.google.common.collect.Lists;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.dsl.BooleanExpression;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 满减折扣服务
 * </p>
 *
 * @author ssy
 * @since 2021/8/18
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class MktDiscountOffsetServiceImpl extends BaseServiceImpl implements MktDiscountOffsetService {

    /**
     * service
     */
    private final OrgEmpRpcService orgEmpRpcService;
    private final RmiSysNextNumberService rmiSysNextNumberService;
    private final BipCompanyManageService bipCompanyManageService;
    private final PriSalePriceRpcService priSalePriceRpcService;
    /**
     * repo
     */
    private final MktDiscountOffsetRepo mktDiscountOffsetRepo;
    private final MktDiscountOffsetDRepo mktDiscountOffsetDRepo;
    private final BipItemSkuRepo bipItemSkuRepo;
    /**
     * proc
     */
    private final MktDiscountOffsetRepoProc mktDiscountOffsetRepoProc;
    private final MktDiscountGiftRepoProc mktDiscountGiftRepoProc;
    private final BipCustUserBindRepoProc bipCustUserBindRepoProc;
    private final BipCustUserBindRepo bipCustUserBindRepo;
    private final RmiItemService rmiItemService;

//    private final RmiItemService rmiItemService;

    @Autowired
    private UdcProvider udcProvider;


    @Override
    public PagingVO<MktDiscountOffsetRespVO> search(MktDiscountOffsetQueryVO queryParam) {

        List<Long> ids = mktDiscountOffsetRepoProc.findMasIdByItemCode(queryParam.getItemCode());

        queryParam.setIds(ids!=null && ids.size()>0 ? ids : new ArrayList<>());

        QMktDiscountOffsetDO qmktDiscountOffsetDO = QMktDiscountOffsetDO.mktDiscountOffsetDO;
        var jpaQuery = mktDiscountOffsetRepoProc.select(queryParam);
        long total = jpaQuery.fetchCount();
        if (total == 0) {
            return PagingVO.<MktDiscountOffsetRespVO>builder().build();
        }
        var pageRequest = wrapperPageRequest(queryParam.getPageRequest(), null);
        appendPageAndSort(jpaQuery, pageRequest, qmktDiscountOffsetDO);
        List<MktDiscountOffsetRespVO> pageResult = jpaQuery.fetch();
        // udc 翻译
        transUdc(pageResult);
        return PagingVO.<MktDiscountOffsetRespVO>builder().total(total).records(pageResult).build();
    }

    
    @Override
    public Optional<MktDiscountOffsetRespVO> findCodeOne(String code) {
        QMktDiscountOffsetDO qmktDiscountOffsetDO = QMktDiscountOffsetDO.mktDiscountOffsetDO;
        MktDiscountOffsetRespVO mktDiscountOffsetRespVO = mktDiscountOffsetRepoProc.select(null).where(qmktDiscountOffsetDO.code.eq(code)).fetchOne();
        if (mktDiscountOffsetRespVO == null) {
            return Optional.empty();
        }
        setDetails(mktDiscountOffsetRespVO);
        // udc 翻译
        transUdc(Collections.singletonList(mktDiscountOffsetRespVO));
        return Optional.of(mktDiscountOffsetRespVO);
    }

    @Override
    public Optional<MktDiscountOffsetRespVO> findIdOne(Long id) {
        QMktDiscountOffsetDO qmktDiscountOffsetDO = QMktDiscountOffsetDO.mktDiscountOffsetDO;
        MktDiscountOffsetRespVO mktDiscountOffsetRespVO = mktDiscountOffsetRepoProc.select(null).where(qmktDiscountOffsetDO.id.eq(id)).fetchOne();
        if (mktDiscountOffsetRespVO == null) {
            return Optional.empty();
        }
        setDetails(mktDiscountOffsetRespVO);
        // udc 翻译
        transUdc(Collections.singletonList(mktDiscountOffsetRespVO));
        return Optional.of(mktDiscountOffsetRespVO);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<Long> createBatch(List<MktDiscountOffsetSaveVO> list) {
        //新增数据
        if (!CollectionUtil.isEmpty(list)) {
            // 1.数据校验
            OrgUserEmpInfoRpcDTO userEmpInfo = getCurrentEmpInfo();
            List<BipCompanyManageRespVO> manageByOuIds = bipCompanyManageService.findCompanyManageByOuIds(Arrays.asList(userEmpInfo.getOuId()));
            if (CollectionUtils.isEmpty(manageByOuIds)) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "当前用户公司信息为空");
            }
            paramCheck(list, true);
            //  paramDbCheck(list, true, userEmpInfo.getOuId());
            // 业务处理
            // 2.数据新增
            List<Long> result = list.stream().map(i -> {
                // 保存主表
                MktDiscountOffsetConvert mktDiscountOffsetConvert = MktDiscountOffsetConvert.INSTANCE;
                MktDiscountOffsetDO mktDiscountOffsetDO = mktDiscountOffsetConvert.saveVoToDo(i);
                mktDiscountOffsetDO.setSecOuId(userEmpInfo.getOuId());
                mktDiscountOffsetDO.setSecUserId(userEmpInfo.getUserId());
                mktDiscountOffsetDO.setSecBuId(manageByOuIds.get(0).getBuId());
                mktDiscountOffsetDO.setId(null);  // ID 置为null

                String code = rmiSysNextNumberService.generateCode(Application.NAME,"CX", null);
                mktDiscountOffsetDO.setCode(code);
                // 填充当前登录人的ou、bu信息
                mktDiscountOffsetDO.setOuId(userEmpInfo.getOuId());
                mktDiscountOffsetDO.setOuCode(userEmpInfo.getOuCode());
                mktDiscountOffsetDO.setOuName(userEmpInfo.getOuName());
                mktDiscountOffsetDO.setBuId(userEmpInfo.getBuId());
                mktDiscountOffsetDO.setBuCode(userEmpInfo.getBuCode());
                mktDiscountOffsetDO.setBuName(userEmpInfo.getBuName());
                mktDiscountOffsetDO.setDeleteFlag(ConstantsSale.COMMON_DELETE_NO);
                Long masId = mktDiscountOffsetRepo.save(mktDiscountOffsetDO).getId();
                // 保存明细
                List<MktDiscountOffsetDDO> details = i.getDetails().stream().map(d -> {

                    // 件数
                    if ("0".equals(i.getType())) {
                        BigDecimal targetAmt = d.getBasePrice().multiply(BigDecimal.valueOf(d.getLimitNum()));
                        Assert.isTrue(targetAmt.compareTo(d.getFreeAmt())>0,"商品【"+d.getItemName()+"】的基础价格乘以促销条件数量必须大于减免金额！");
                    } else { // 按金额
                        Assert.isTrue(d.getLimitAmt().compareTo(d.getFreeAmt())>0,"商品【"+d.getItemName()+"】的促销条件金额必须大于减免金额！");
                    }

                    MktDiscountOffsetDDO mktDiscountOffsetDDO = mktDiscountOffsetConvert.dsaveVoToDo(d);
                    String skuCode = mktDiscountOffsetDDO.getItemCode();
                    if(StringUtils.isNotBlank(skuCode)){
                        //查询skuId进行补偿
                        QBipItemSkuDO qBipItemSkuDO = QBipItemSkuDO.bipItemSkuDO;
                        BooleanExpression exp = qBipItemSkuDO.skuCode.eq(skuCode).and(qBipItemSkuDO.deleteFlag.eq(0));
                        Iterable<BipItemSkuDO> iterables = bipItemSkuRepo.findAll(exp);
                        if(!IterUtil.isEmpty(iterables)){
                            List<BipItemSkuDO> listSkus = Lists.newArrayList(iterables);
                            mktDiscountOffsetDDO.setItemId(listSkus.get(0).getId());
                        }
                    }


                    mktDiscountOffsetDDO.setSecOuId(userEmpInfo.getOuId());
                    mktDiscountOffsetDDO.setSecUserId(userEmpInfo.getUserId());
                    mktDiscountOffsetDDO.setSecBuId(manageByOuIds.get(0).getBuId());
                    mktDiscountOffsetDDO.setId(null);
                    mktDiscountOffsetDDO.setMktDiscountOffsetId(masId);
                    mktDiscountOffsetDDO.setDeleteFlag(ConstantsSale.COMMON_DELETE_NO);

                    ItmItemRpcDtoParam codeparam = new ItmItemRpcDtoParam();
                    List<String> skuCodes = new ArrayList<>();
                    skuCodes.add(mktDiscountOffsetDDO.getItemCode());
                    codeparam.setItemCodes(skuCodes);

                    List<ItmItemRpcDTO> dtos = new ArrayList<>(rmiItemService.findItemListByParam(codeparam));
                    if(null != dtos && !dtos.isEmpty()){
                        mktDiscountOffsetDDO.setUom(dtos.get(0).getUom());
                    }


                    MktDiscountOffsetVO mktDiscountOffsetVO = new MktDiscountOffsetVO();
                    mktDiscountOffsetVO.setFreeAmt(mktDiscountOffsetDDO.getFreeAmt());
                    mktDiscountOffsetVO.setBasePrice(mktDiscountOffsetDDO.getBasePrice());
                    mktDiscountOffsetVO.setType(mktDiscountOffsetDO.getType());
                    mktDiscountOffsetVO.setLimitAmt(mktDiscountOffsetDDO.getLimitAmt());
                    mktDiscountOffsetVO.setLimitNum(mktDiscountOffsetDDO.getLimitNum());
                    mktDiscountOffsetVO.setOuId(mktDiscountOffsetDO.getOuId());
                    mktDiscountOffsetVO.setUom(mktDiscountOffsetDDO.getUom());
                    if(null != dtos && !dtos.isEmpty() && null != dtos.get(0).getId()){
                        mktDiscountOffsetVO.setItemId(dtos.get(0).getId());
                    }else {
                        mktDiscountOffsetVO.setItemId(mktDiscountOffsetDDO.getItemId());
                    }
                    if(!disRule(mktDiscountOffsetVO)){
                        throw new BusinessException("请检查数据！");
                    }
                    return mktDiscountOffsetDDO;
                }).collect(Collectors.toList());
                mktDiscountOffsetDRepo.saveAll(details);
                return mktDiscountOffsetDO.getId();
            }).collect(Collectors.toList());
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(MktDiscountOffsetSaveVO updateParam) {
//        OrgUserEmpInfoRpcDTO userEmpInfo = getCurrentEmpInfo();
//        List<BipCompanyManageRespVO> manageByOuIds = bipCompanyManageService.findCompanyManageByOuIds(Collections.singletonList(userEmpInfo.getOuId()));
//        if (CollectionUtils.isEmpty(manageByOuIds)) {
//            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "当前用户公司信息为空");
//        }
//        // 1.数据校验
//        paramCheck(Collections.singletonList(updateParam), false);
//        // 原数据
//        MktDiscountOffsetDO oldDO = mktDiscountOffsetRepo.findById(updateParam.getId()).get();
//        Assert.isFalse(Validator.isNull(oldDO), "[满减促销]操作数据不存在");
//  //      paramDbCheck(Collections.singletonList(updateParam), false, oldDO.getOuId());
//        // 2.业务处理
//        MktDiscountOffsetConvert mktDiscountOffsetConvert = MktDiscountOffsetConvert.INSTANCE;
//        MktDiscountOffsetDO mktDiscountOffsetDO = mktDiscountOffsetConvert.saveVoToDo(updateParam);
//        mktDiscountOffsetDO.setSecOuId(userEmpInfo.getOuId());
//        mktDiscountOffsetDO.setSecUserId(userEmpInfo.getUserId());
//        mktDiscountOffsetDO.setSecBuId(manageByOuIds.get(0).getBuId());
//        mktDiscountOffsetDO.setOuId(oldDO.getOuId());
//        mktDiscountOffsetDO.setOuCode(oldDO.getOuCode());
//        mktDiscountOffsetDO.setOuName(oldDO.getOuName());
//        mktDiscountOffsetDO.setBuId(oldDO.getBuId());
//        mktDiscountOffsetDO.setBuCode(oldDO.getBuCode());
//        mktDiscountOffsetDO.setBuName(oldDO.getBuName());
//        if (mktDiscountOffsetDO.getDeleteFlag() == null) {
//            mktDiscountOffsetDO.setDeleteFlag(ConstantsSale.COMMON_DELETE_NO);
//        }
//
//        List<MktDiscountOffsetDDO> details = updateParam.getDetails().stream().map(d -> {
//
//            // 件数
//            if ("0".equals(updateParam.getType())) {
//                BigDecimal targetAmt = d.getBasePrice().multiply(BigDecimal.valueOf(d.getLimitNum()));
//                Assert.isTrue(targetAmt.compareTo(d.getFreeAmt())>0,"商品【"+d.getItemName()+"】的基础价格乘以促销条件数量必须大于减免金额！");
//            } else { // 按金额
//                Assert.isTrue(d.getLimitAmt().compareTo(d.getFreeAmt())>0,"商品【"+d.getItemName()+"】的促销条件金额必须大于减免金额！");
//            }
//
//            MktDiscountOffsetDDO mktDiscountOffsetDDO = mktDiscountOffsetConvert.dsaveVoToDo(d);
//            String skuCode = mktDiscountOffsetDDO.getItemCode();
//            if(StringUtils.isNotBlank(skuCode)){
//                //查询skuId进行补偿
//                QBipItemSkuDO qBipItemSkuDO = QBipItemSkuDO.bipItemSkuDO;
//                BooleanExpression exp = qBipItemSkuDO.skuCode.eq(skuCode).and(qBipItemSkuDO.deleteFlag.eq(0));
//                Iterable<BipItemSkuDO> iterables = bipItemSkuRepo.findAll(exp);
//                if(!IterUtil.isEmpty(iterables)){
//                    List<BipItemSkuDO> list = Lists.newArrayList(iterables);
//                    mktDiscountOffsetDDO.setItemId(list.get(0).getId());
//                }
//            }
//            mktDiscountOffsetDDO.setSecOuId(userEmpInfo.getOuId());
//            mktDiscountOffsetDDO.setSecUserId(userEmpInfo.getUserId());
//            mktDiscountOffsetDDO.setSecBuId(manageByOuIds.get(0).getBuId());
//            mktDiscountOffsetDDO.setMktDiscountOffsetId(oldDO.getId());
//            if (mktDiscountOffsetDDO.getDeleteFlag() == null) {
//                mktDiscountOffsetDDO.setDeleteFlag(ConstantsSale.COMMON_DELETE_NO);
//            }
//
//            ItmItemRpcDtoParam codeparam = new ItmItemRpcDtoParam();
//            List<String> skuCodes = new ArrayList<>();
//            skuCodes.add(mktDiscountOffsetDDO.getItemCode());
//            codeparam.setItemCodes(skuCodes);
//
//            List<ItmItemRpcDTO> dtos = new ArrayList<>(rmiItemService.findItemListByParam(codeparam));
//            if(null != dtos && !dtos.isEmpty()){
//                mktDiscountOffsetDDO.setUom(dtos.get(0).getUom());
//            }
//
//            MktDiscountOffsetVO mktDiscountOffsetVO = new MktDiscountOffsetVO();
//            mktDiscountOffsetVO.setFreeAmt(mktDiscountOffsetDDO.getFreeAmt());
//            mktDiscountOffsetVO.setBasePrice(mktDiscountOffsetDDO.getBasePrice());
//            mktDiscountOffsetVO.setType(mktDiscountOffsetDO.getType());
//            mktDiscountOffsetVO.setLimitAmt(mktDiscountOffsetDDO.getLimitAmt());
//            mktDiscountOffsetVO.setLimitNum(mktDiscountOffsetDDO.getLimitNum());
//            mktDiscountOffsetVO.setOuId(mktDiscountOffsetDO.getOuId());
//            mktDiscountOffsetVO.setUom(mktDiscountOffsetDDO.getUom());
//            if(null != dtos && !dtos.isEmpty() && null != dtos.get(0).getId()){
//                mktDiscountOffsetVO.setItemId(dtos.get(0).getId());
//            }else {
//                mktDiscountOffsetVO.setItemId(mktDiscountOffsetDDO.getItemId());
//            }
//
//
//            if(!disRule(mktDiscountOffsetVO)){
//                throw new BusinessException("请检查数据！");
//            }
//            return mktDiscountOffsetDDO;
//        }).collect(Collectors.toList());
//        mktDiscountOffsetRepo.save(mktDiscountOffsetDO);
//        mktDiscountOffsetDRepo.saveAll(details);
    }



    public Boolean disRule(MktDiscountOffsetVO mktDiscountOffsetVO){
        //折扣金额/满足条件的金额，这个比例必须小于（基础价格-最低销售价格）/基础价格
        //减免金额
        BigDecimal freeAmt = mktDiscountOffsetVO.getFreeAmt();
        //基础价
        BigDecimal basePrice = mktDiscountOffsetVO.getBasePrice();
        //按照金额
        if(mktDiscountOffsetVO.getType().equals("1")){
            //达标金额
            BigDecimal limitAmt = mktDiscountOffsetVO.getLimitAmt();
            BigDecimal disScale = freeAmt.divide(limitAmt,4, RoundingMode.HALF_UP);
            //获取底价
            BigDecimal floorPrice = getMinPrice(mktDiscountOffsetVO);
            if(null == floorPrice){
                floorPrice = BigDecimal.ZERO;
            }
            if(floorPrice.compareTo(BigDecimal.ZERO)==0){
                return true;
            }
            if(floorPrice.compareTo(BigDecimal.ZERO) > 0){
                BigDecimal floorScale = (basePrice.subtract(floorPrice)).divide(basePrice,4,RoundingMode.HALF_UP);
                if (disScale.compareTo(floorScale) < 0){
                    return true;
                }
            }
        }
        //按照数量
        if(mktDiscountOffsetVO.getType().equals("0")){
            BigDecimal amt = new BigDecimal(mktDiscountOffsetVO.getLimitNum()).multiply(basePrice);
            BigDecimal disScale = freeAmt.divide(amt,4, RoundingMode.HALF_UP);
            //获取底价
            BigDecimal floorPrice = getMinPrice(mktDiscountOffsetVO);
            if(null == floorPrice){
                floorPrice = BigDecimal.ZERO;
            }
            if(floorPrice.compareTo(BigDecimal.ZERO)==0){
                return true;
            }
            BigDecimal floorScale = (basePrice.subtract(floorPrice)).divide(basePrice,4,RoundingMode.HALF_UP);
            if (disScale.compareTo(floorScale) < 0){
                return true;
            }
        }
        return false;
    }

    public BigDecimal getMinPrice(MktDiscountOffsetVO mktDiscountOffsetVO){
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        QBipCustUserBindDO qBipCustUserBindDO = QBipCustUserBindDO.bipCustUserBindDO;
        BooleanExpression expression = qBipCustUserBindDO.agentEmpId.eq(currentUserDTO.getUserId()).and(qBipCustUserBindDO.deleteFlag.eq(0)).and(qBipCustUserBindDO.ouId.eq(mktDiscountOffsetVO.getOuId()));
        Iterable<BipCustUserBindDO> iterables = bipCustUserBindRepo.findAll(expression);
        BipCustUserBindDO bipCustUserBindDO = new BipCustUserBindDO();
        if(!IterUtil.isEmpty(iterables)){
            bipCustUserBindDO = Lists.newArrayList(iterables).get(0);
        }
        if(null == bipCustUserBindDO || null == bipCustUserBindDO.getCustId()){
            return BigDecimal.ZERO;
        }
        PriSalePriceReqDTO priSalePriceReqDTO = new PriSalePriceReqDTO();
        priSalePriceReqDTO.setOuId(mktDiscountOffsetVO.getOuId());
        priSalePriceReqDTO.setCustId(bipCustUserBindDO.getCustId());
        priSalePriceReqDTO.setCustCode(bipCustUserBindDO.getCustCode());
        List<PriSaleItemReqDTO> list = new ArrayList<>();
        PriSaleItemReqDTO priSaleItemReqDTO = new PriSaleItemReqDTO();
        priSaleItemReqDTO.setItemId(mktDiscountOffsetVO.getItemId());
        priSaleItemReqDTO.setUom(mktDiscountOffsetVO.getUom());
        list.add(priSaleItemReqDTO);
        priSalePriceReqDTO.setItems(list);
        ApiResult<PriSalePriceDTO> res = priSalePriceRpcService.findSalePriceDto(priSalePriceReqDTO);
        if(res.getCode() == 200 && null != res.getData() && null != res.getData().getPriceList() && !res.getData().getPriceList().isEmpty()){
            PriSalePriceSimpleDTO priSalePriceSimpleDTO = res.getData().getPriceList().get(0);
            return priSalePriceSimpleDTO.getFloorPrice();
        }
        return BigDecimal.ZERO;
    }







    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<Long> idList) {
        if (CollectionUtil.isEmpty(idList)) {
            return;
        }
        mktDiscountOffsetRepoProc.deleteIdBatch(idList);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateDeleteFlag(Long id) {
        this.updateDeleteFlagBatch(Collections.singletonList(id));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateDeleteFlagBatch(List<Long> ids) {
        Assert.isFalse(CollectionUtil.isEmpty(ids), "[满减促销]操作数据为空");
        mktDiscountOffsetRepoProc.updateDeleteFlagBatch(ids, ConstantsSale.COMMON_DELETE_YSE);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void appr(List<Long> ids, String status) {
        Map<String, String> statusUdcMap = udcProvider.getValueMapByUdcCode("yst-sale", "DISCOUNT_OFFSET_STATUS");
        Assert.isFalse(CollectionUtil.isEmpty(ids), "[满减促销]操作数据为空");
        Assert.isTrue(checkUdcValueExit(statusUdcMap, status), "促销状态异常");
        if(status.equals("ENABLE")){
            //查询详情商品  同一商品不能同时满减和满赠
            boolean flag = getGiftSkuIds(ids);
            if(!flag){
                throw new BusinessException("一个商品只能是满减或买赠");
            }

            if(!isExistsType(ids)){
                throw new BusinessException("满减同一商品类型只能按商品或数量");
            }


            // 判断满减促销金额是否大于商品单价
            for (Long id : ids) {
                Optional<MktDiscountOffsetRespVO> offsetOPT = findIdOne(id);
                if (offsetOPT.isPresent()) {
                    MktDiscountOffsetRespVO offset = offsetOPT.get();
                    List<MktDiscountOffsetRespDVO> details = offset.getDetails();

                    // 件数
                    if ("0".equals(offset.getType())) {
                        for (MktDiscountOffsetRespDVO detail : details) {
                            BigDecimal targetAmt = detail.getBasePrice().multiply(BigDecimal.valueOf(detail.getLimitNum()));
                            Assert.isTrue(targetAmt.compareTo(detail.getFreeAmt())>0,"商品【"+detail.getItemName()+"】的基础价格乘以促销条件数量必须大于减免金额！");
                        }
                    } else { // 按金额
                        for (MktDiscountOffsetRespDVO detail : details) {
                            Assert.isTrue(detail.getLimitAmt().compareTo(detail.getFreeAmt())>0,"商品【"+detail.getItemName()+"】的促销条件金额必须大于减免金额！");
                        }
                    }
                }
            }
        }
        mktDiscountOffsetRepoProc.updateStatusBatch(ids, status);
    }

    public Boolean isExistsType(List<Long> ids){
        log.info("ids:-------------"+ JSON.toJSONString(ids));
        QMktDiscountOffsetDO qMktDiscountOffsetDO = QMktDiscountOffsetDO.mktDiscountOffsetDO;
        QMktDiscountOffsetDDO qMktDiscountOffsetDDO = QMktDiscountOffsetDDO.mktDiscountOffsetDDO;
        for(Long id : ids){
            MktDiscountOffsetDO mktDiscountOffsetDO  = mktDiscountOffsetRepo.findById(id).get();
            String type = mktDiscountOffsetDO.getType();
            log.info("type:-------------"+ type);
            BooleanExpression expression = qMktDiscountOffsetDDO.mktDiscountOffsetId.eq(mktDiscountOffsetDO.getId()).and(qMktDiscountOffsetDDO.deleteFlag.eq(0));
            Iterable<MktDiscountOffsetDDO> iterables = mktDiscountOffsetDRepo.findAll(expression);
            if(!IterUtil.isEmpty(iterables)){
                List<MktDiscountOffsetDDO> list = Lists.newArrayList(iterables);
                List<String> items = list.stream().map(MktDiscountOffsetDDO :: getItemCode).distinct().collect(Collectors.toList());
                log.info("items:-------------"+ JSON.toJSONString(items));
                //查询DO
                String typeRec = "";
                if(type.equals("0")){
                    typeRec = "1";
                }else {
                    typeRec = "0";
                }
                BooleanExpression e = qMktDiscountOffsetDO.deleteFlag.eq(0).and(qMktDiscountOffsetDO.status.eq("ENABLE")).and(qMktDiscountOffsetDO.ouId.eq(mktDiscountOffsetDO.getOuId())).and(qMktDiscountOffsetDO.type.eq(typeRec)).and(qMktDiscountOffsetDO.code.notEqualsIgnoreCase(mktDiscountOffsetDO.getCode()));
                Iterable<MktDiscountOffsetDO> iterableDos = mktDiscountOffsetRepo.findAll(e);
                if(!IterUtil.isEmpty(iterableDos)){
                    List<MktDiscountOffsetDO> dos = Lists.newArrayList(iterableDos);
                    List<Long> doIds = dos.stream().map(MktDiscountOffsetDO :: getId).distinct().collect(Collectors.toList());
                    log.info("doIds:-------------"+ JSON.toJSONString(doIds));
                    BooleanExpression ddoExpr = qMktDiscountOffsetDDO.mktDiscountOffsetId.in(doIds).and(qMktDiscountOffsetDDO.deleteFlag.eq(0));
                    Iterable<MktDiscountOffsetDDO> ddosIterables = mktDiscountOffsetDRepo.findAll(ddoExpr);
                    if(!IterUtil.isEmpty(ddosIterables)){
                        List<MktDiscountOffsetDDO> ddosList = Lists.newArrayList(ddosIterables);
                        List<String> ddoItemIds = ddosList.stream().map(MktDiscountOffsetDDO :: getItemCode).distinct().collect(Collectors.toList());
                        log.info("ddoItemIds:-------------"+ JSON.toJSONString(ddoItemIds));
                        //交集  如果不为空的话就说明有重复
                        List<String> intersection = items.stream().filter(item -> ddoItemIds.contains(item)).collect(Collectors.toList());
                        log.info("intersection:-------------"+ JSON.toJSONString(intersection));
                        if(null != intersection && !intersection.isEmpty() ){
                            return false;
                        }
                    }

                }

            }

        }
        return true;
    }


    public boolean getGiftSkuIds(List<Long> ids){
        for(Long id : ids){
            //满减ID
            List<String> offsetItemCodes = mktDiscountOffsetRepoProc.getOffsetSkuCode(id);
            if(null != null && !offsetItemCodes.isEmpty()){
                offsetItemCodes = offsetItemCodes.stream().distinct().collect(Collectors.toList());
            }
            Long ouId = mktDiscountOffsetRepoProc.getOuIdById(id).get(0);
            //查询是否存在满赠
            List<Long> giftIds = mktDiscountGiftRepoProc.getGiftId(ouId);
            if(null != giftIds && !giftIds.isEmpty()){
                //查询买赠详情skuId
                List<String> giftSkuCodes = mktDiscountGiftRepoProc.getGiftDetailCode(giftIds);
                if(!giftSkuCodes.isEmpty() && !offsetItemCodes.isEmpty()){
                    //交集s
                    giftSkuCodes.retainAll(offsetItemCodes);
                    if(!giftSkuCodes.isEmpty()){
                        return false;
                    }
                }
            }
        }
        return true;
    }

    @Override
    public List<MktDiscountOffsetVO> findMktDiscountOffsetByParam(Long ouId, String customLevel, List<Long> itemIds) {
        Assert.isFalse(CollectionUtil.isEmpty(itemIds), "商品数据为空");
        Assert.isFalse(Validator.isNull(ouId), "公司数据为空");
        List<MktDiscountOffsetVO> mktDiscountOffsetVOS =
                mktDiscountOffsetRepoProc.findMktDisCountOffset(ouId, customLevel, LocalDateTime.now(), itemIds).fetch();
        if (CollectionUtil.isNotEmpty(mktDiscountOffsetVOS)) {
            Map<String, String> custGroupUdcMap = udcProvider.getValueMapByUdcCode("yst-sale", "CUST_GROUP");
            Map<String, String> statusUdcMap = udcProvider.getValueMapByUdcCode("yst-sale", "DISCOUNT_OFFSET_STATUS");
            Map<String, String> typeUdcMap = udcProvider.getValueMapByUdcCode("yst-sale", "DISCOUNT_OFFSET_TYPE");
            Map<String, String> uomUdcMap = udcProvider.getValueMapByUdcCode("yst-supp", "UOM");

            mktDiscountOffsetVOS.forEach(i -> {
                // 表头
                if (StringUtils.isNotBlank(i.getCustomLevel()) && !MapUtils.isEmpty(custGroupUdcMap)) {
                    i.setCustomLevelName(custGroupUdcMap.get(i.getCustomLevel()));
                }
                if (StringUtils.isNotBlank(i.getType()) && !MapUtils.isEmpty(typeUdcMap)) {
                    i.setTypeName(typeUdcMap.get(i.getType()));
                }
                if (StringUtils.isNotBlank(i.getStatus()) && !MapUtils.isEmpty(statusUdcMap)) {
                    i.setStatusName(statusUdcMap.get(i.getStatus()));
                }
                if (StringUtils.isNotBlank(i.getUom()) && !MapUtils.isEmpty(uomUdcMap)) {
                    i.setUomName(uomUdcMap.get(i.getUom()));
                }

            });
        }
        return mktDiscountOffsetVOS;
    }


    public List<MktDiscountOffsetVO> findMktDiscountOffsetByParamCode(Long ouId, String customLevel, List<String> itemCodes) {
        Assert.isFalse(CollectionUtil.isEmpty(itemCodes), "商品数据为空");
        Assert.isFalse(Validator.isNull(ouId), "公司数据为空");
        List<MktDiscountOffsetVO> mktDiscountOffsetVOS =
                mktDiscountOffsetRepoProc.findMktDisCountOffsetCode(ouId, customLevel, LocalDateTime.now(), itemCodes).fetch();
        if (CollectionUtil.isNotEmpty(mktDiscountOffsetVOS)) {
            Map<String, String> custGroupUdcMap = udcProvider.getValueMapByUdcCode("yst-sale", "CUST_GROUP");
            Map<String, String> statusUdcMap = udcProvider.getValueMapByUdcCode("yst-sale", "DISCOUNT_OFFSET_STATUS");
            Map<String, String> typeUdcMap = udcProvider.getValueMapByUdcCode("yst-sale", "DISCOUNT_OFFSET_TYPE");
            Map<String, String> uomUdcMap = udcProvider.getValueMapByUdcCode("yst-supp", "UOM");

            mktDiscountOffsetVOS.forEach(i -> {
                // 表头
                if (StringUtils.isNotBlank(i.getCustomLevel()) && !MapUtils.isEmpty(custGroupUdcMap)) {
                    i.setCustomLevelName(custGroupUdcMap.get(i.getCustomLevel()));
                }
                if (StringUtils.isNotBlank(i.getType()) && !MapUtils.isEmpty(typeUdcMap)) {
                    i.setTypeName(typeUdcMap.get(i.getType()));
                }
                if (StringUtils.isNotBlank(i.getStatus()) && !MapUtils.isEmpty(statusUdcMap)) {
                    i.setStatusName(statusUdcMap.get(i.getStatus()));
                }
                if (StringUtils.isNotBlank(i.getUom()) && !MapUtils.isEmpty(uomUdcMap)) {
                    i.setUomName(uomUdcMap.get(i.getUom()));
                }

            });
        }
        return mktDiscountOffsetVOS;
    }


    /**
     * 根据主表ID 获取明细，并赋值
     *
     * @param mktDiscountOffsetRespVO
     */
    private void setDetails(MktDiscountOffsetRespVO mktDiscountOffsetRespVO) {
        if (mktDiscountOffsetRespVO == null) {
            return;
        }
        List<MktDiscountOffsetRespDVO> details = mktDiscountOffsetRepoProc.selectDetailsByMasId(mktDiscountOffsetRespVO.getId()).fetch();
        mktDiscountOffsetRespVO.setDetails(details);
    }

    /**
     * 获取当前登录人信息
     *
     * @return
     */
    private OrgUserEmpInfoRpcDTO getCurrentEmpInfo() {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "当前用户已失效,请重登录重试");
        }
        OrgUserEmpInfoRpcDTO userEmpInfo = orgEmpRpcService.findUserEmpInfo(currentUser.getUserId());
        if (userEmpInfo == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "无法获取当前用户信息");
        }
        return userEmpInfo;
    }

    /**
     * 数据校验，部分字段附默认值
     *
     * @param source
     * @param isNew  是否新增
     * @return
     */
    private void paramCheck(List<MktDiscountOffsetSaveVO> source, boolean isNew) {

        Map<String, String> custGroupUdcMap = udcProvider.getValueMapByUdcCode("yst-sale", "CUST_GROUP");
        Map<String, String> statusUdcMap = udcProvider.getValueMapByUdcCode("yst-sale", "DISCOUNT_OFFSET_STATUS");
        Map<String, String> typeUdcMap = udcProvider.getValueMapByUdcCode("yst-sale", "DISCOUNT_OFFSET_TYPE");
        Map<String, String> uomUdcMap = udcProvider.getValueMapByUdcCode("yst-supp", "UOM");

        source.forEach(i -> {
            Assert.isFalse(Validator.isNull(i), "[满减促销]操作数据为空");
            if (!isNew) {
                Assert.isFalse(Validator.isNull(i.getId()), "更新主键缺失");
                Assert.isFalse(Validator.isEmpty(i.getCode()), "促销编码为空");
            }
            Assert.isFalse(Validator.isEmpty(i.getName()), "促销名称为空");
            Assert.isFalse(Validator.isEmpty(i.getCurrCode()), "币种为空");
            Assert.isFalse(Validator.isNull(i.getValidStime()), "促销生效时间为空");
            Assert.isFalse(Validator.isNull(i.getValidEtime()), "促销失效时间为空");
            Assert.isFalse(Validator.isEmpty(i.getType()), "促销条件为空");
            Assert.isFalse(CollectionUtil.isEmpty(i.getDetails()), "促销明细为空");
            Assert.isTrue(checkUdcValueExit(typeUdcMap, i.getType()), "促销类型异常");
            Assert.isTrue(checkUdcValueExit(statusUdcMap, i.getStatus()), "促销状态异常");

            if (!StringUtils.isEmpty(i.getCustomLevel())) {
                Assert.isTrue(checkUdcValueExit(custGroupUdcMap, i.getCustomLevel()), "客户等级数据异常");
            }
            List<String> itemIds = i.getDetails().stream().map(MktDiscountOffsetDSaveVO::getItemCode).distinct().collect(Collectors.toList());
       //     Assert.isFalse(itemIds.size() != i.getDetails().size(), "明细中存在相同的商品");
            i.getDetails().forEach(d -> {
//                Assert.notNull(d.getItemId(),"商品【"+d.getItemName()+"】的ID不能为空");
                Assert.isTrue(checkUdcValueExit(uomUdcMap, d.getUom()), "明细商品单位异常");
                if (UdcEnum.MKT_DISCOUNT_OFFSET_TYPE_0.getValueCode().equals(i.getType())) {
                    Assert.isFalse(Validator.isNull(d.getLimitNum()), "【促销条件】为【按数量】，促销条件数量为空");
                    d.setLimitAmt(null);
                } else if (UdcEnum.MKT_DISCOUNT_OFFSET_TYPE_1.getValueCode().equals(i.getType())) {
                    Assert.isFalse(Validator.isNull(d.getLimitAmt()), "【促销条件】为【按金额】，促销条件金额为空");
                    d.setLimitNum(null);
                }
            });
        });
    }

    /**
     * 数据库唯一性校验
     *
     * @param source 入参
     * @param isNew  是否新建
     * @param ouId   公司ID
     */
    private void paramDbCheck(List<MktDiscountOffsetSaveVO> source, boolean isNew, Long ouId) {
        source.forEach(i -> {
            // 未失效的数据 进行校验
            if (i.getValidEtime().isAfter(LocalDateTime.now())) {
                List<Long> itemIds = i.getDetails().stream().map(MktDiscountOffsetDSaveVO::getItemId).distinct().collect(Collectors.toList());
                List<Tuple> itemCodes =
                        mktDiscountOffsetRepoProc.checkItemExitsInValidDate(isNew ? null : i.getId(), ouId, i.getCustomLevel(), i.getValidStime(), i.getValidEtime(), itemIds);
                Assert.isFalse(itemCodes.size() > 0, "数据库已存在符合生效规则的[满减活动]商品明细：{}",
                        String.join(StrUtil.COMMA, itemCodes.stream().map(t ->
                                StrUtil.format("[促销编码为：{}，商品编号为:{}]", t.get(0, String.class), t.get(1, String.class))).collect(Collectors.toList())));
                itemCodes =
                        mktDiscountGiftRepoProc.checkItemExitsInValidDate(isNew ? null : i.getId(), ouId, i.getCustomLevel(), i.getValidStime(), i.getValidEtime(), itemIds);
                Assert.isFalse(itemCodes.size() > 0, "数据库已存在符合生效规则的[买赠活动]商品明细：{}",
                        String.join(StrUtil.COMMA, itemCodes.stream().map(t ->
                                StrUtil.format("[促销编码为：{}，商品编号为:{}]", t.get(0, String.class), t.get(1, String.class))).collect(Collectors.toList())));
            }
        });
    }

    /**
     * udc 翻译
     *
     * @param source
     */
    private void transUdc(List<MktDiscountOffsetRespVO> source) {
        Map<String, String> custGroupUdcMap = udcProvider.getValueMapByUdcCode("yst-sale", "CUST_GROUP");
        Map<String, String> statusUdcMap = udcProvider.getValueMapByUdcCode("yst-sale", "DISCOUNT_OFFSET_STATUS");
        Map<String, String> typeUdcMap = udcProvider.getValueMapByUdcCode("yst-sale", "DISCOUNT_OFFSET_TYPE");
        Map<String, String> uomUdcMap = udcProvider.getValueMapByUdcCode("yst-supp", "UOM");

        source.forEach(i -> {
            // 表头
            if (StringUtils.isNotBlank(i.getCustomLevel()) && !MapUtils.isEmpty(custGroupUdcMap)) {
                i.setCustomLevelName(custGroupUdcMap.get(i.getCustomLevel()));
            }
            if (StringUtils.isNotBlank(i.getType()) && !MapUtils.isEmpty(typeUdcMap)) {
                i.setTypeName(typeUdcMap.get(i.getType()));
            }
            if (StringUtils.isNotBlank(i.getStatus()) && !MapUtils.isEmpty(statusUdcMap)) {
                i.setStatusName(statusUdcMap.get(i.getStatus()));
            }
            // 表明细
            if (!CollectionUtil.isEmpty(i.getDetails())) {
                i.getDetails().forEach(d -> {
                    if (StringUtils.isNotBlank(d.getUom()) && !MapUtils.isEmpty(uomUdcMap)) {
                        d.setUomName(uomUdcMap.get(d.getUom()));
                    }
                });
            }
        });
    }
}
