/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.controller.item;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.vo.resp.itm.ItmItemBusionessPagingDTO;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiItemService;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemBusinessRpcPagingDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemBusinessRpcPagingParam;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/item/opera"}, produces={"application/json"})
@Api(tags={"\u5546\u54c1\u7ecf\u8425\u76ee\u5f55"})
public class ItemOperaCatalogueController {
    private static final Logger log = LoggerFactory.getLogger(ItemOperaCatalogueController.class);
    @Autowired
    private RmiItemService rmiItemService;

    @PostMapping(value={"/query"})
    @ApiOperation(value="\u67e5\u8be2\u5546\u54c1\u7ecf\u8425\u76ee\u5f55\u4fe1\u606f")
    @ApiOperationSupport(order=1)
    public ApiResult<PagingVO<ItmItemBusionessPagingDTO>> query(@RequestBody ItmItemBusinessRpcPagingParam itmItemBusinessRpcPagingParam) {
        PagingVO<ItmItemBusinessRpcPagingDTO> itemBusinessRpcDtoByParam = this.rmiItemService.findItemBusinessRpcDtoByParam(itmItemBusinessRpcPagingParam);
        AtomicLong id = new AtomicLong(1L);
        List records = itemBusinessRpcDtoByParam.getRecords();
        List itemBusionessDTOList = records.stream().map(i -> {
            ItmItemBusionessPagingDTO itmItemBusionessPagingDTO = new ItmItemBusionessPagingDTO();
            BeanUtils.copyProperties((Object)i, (Object)itmItemBusionessPagingDTO);
            itmItemBusionessPagingDTO.setId(Long.valueOf(id.getAndAdd(1L)));
            String lifeStatus = i.getItemLifeStatus();
            itmItemBusionessPagingDTO.setFreeze(false);
            if (!StringUtils.isEmpty((Object)lifeStatus) && lifeStatus.contains("SALE_FREEZE")) {
                itmItemBusionessPagingDTO.setFreeze(true);
            }
            return itmItemBusionessPagingDTO;
        }).collect(Collectors.toList());
        return ApiResult.ok((Object)new PagingVO(itemBusinessRpcDtoByParam.getTotal(), itemBusionessDTOList));
    }
}

