/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.core.service;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.common.model.UserDTO;
import com.elitesland.yst.production.sale.core.convert.UserConvert;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserService {
    private static final Logger log = LoggerFactory.getLogger(UserService.class);
    @Autowired
    private SysUserRpcService sysUserService;
    private static final UserConvert USER_CONVERT = UserConvert.INSTANCE;

    public static CurrentUserDTO currentUser() {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (userDetails == null) {
            return null;
        }
        CurrentUserDTO user = USER_CONVERT.convert(userDetails);
        user.setDetail(USER_CONVERT.convert(userDetails.getUser()));
        user.setUserId(userDetails.getUser().getId());
        return user;
    }

    public UserDTO getUser(Long sysUserId) {
        Assert.notNull((Object)sysUserId, (String)"\u7528\u6237ID\u4e3a\u7a7a", (Object[])new Object[0]);
        SysUserDTO sysUserDTO = this.sysUserService.getById(sysUserId);
        if (sysUserDTO == null) {
            log.error("\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f\uff1a{}", (Object)sysUserId);
            return null;
        }
        return USER_CONVERT.convert(sysUserDTO);
    }

    public List<SysUserVO> getUsers(List<Long> ids) {
        Assert.notNull(ids, (String)"\u7528\u6237ID\u4e3a\u7a7a", (Object[])new Object[0]);
        List sysUserDTOS = this.sysUserService.getByIds(ids);
        if (sysUserDTOS == null || sysUserDTOS.size() < 1) {
            log.error("\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f\uff1a{}", ids);
            return null;
        }
        return sysUserDTOS;
    }

    public UserDTO getUser(String username) {
        Assert.notBlank((CharSequence)username, (String)"\u7528\u6237\u540d\u4e3a\u7a7a", (Object[])new Object[0]);
        ApiResult sysUserDTO = this.sysUserService.getUserByUsername(username);
        if (sysUserDTO == null) {
            log.error("\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f\uff1a{}", (Object)username);
            return null;
        }
        return USER_CONVERT.convert((SysUserDTO)sysUserDTO.getData());
    }
}

