/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.ExecutRecordQueryParam;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.ExecutRecordExportVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.ExecutRecordRespVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.entity.QExecutRecordDO;
import com.elitesland.yst.production.sale.entity.QExecutRecordDtlDO;
import com.elitesland.yst.production.sale.entity.QSalesmanInfoDO;
import com.elitesland.yst.production.sale.entity.QSalesmanRegionDO;
import com.elitesland.yst.production.sale.entity.QTaskInfoDO;
import com.elitesland.yst.production.sale.entity.QTaskInfoDtlDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExecutRecordRepoProc {
    private final QExecutRecordDO qExecutRecordDO = QExecutRecordDO.executRecordDO;
    private final QExecutRecordDtlDO qExecutRecordDtlDO = QExecutRecordDtlDO.executRecordDtlDO;
    private static final QTaskInfoDO qTaskInfoDO = QTaskInfoDO.taskInfoDO;
    private static final QTaskInfoDtlDO qTaskInfoDtlDO = QTaskInfoDtlDO.taskInfoDtlDO;
    @Autowired
    private JPAQueryFactory jpaQueryFactory;

    public PagingVO<ExecutRecordRespVO> page(ExecutRecordQueryParam executRecordPageParam) {
        JPAQuery query = (JPAQuery)this.selectInnerJoinTaskDtl().where(this.bulidPredicate(executRecordPageParam, true));
        executRecordPageParam.setPaging(query);
        executRecordPageParam.fillOrders(query, (EntityPathBase)this.qExecutRecordDO);
        if (StringUtils.isNotBlank((CharSequence)executRecordPageParam.getTaskCodeNameLike())) {
            query.where((Predicate)this.qExecutRecordDO.taskCode.like("%" + executRecordPageParam.getTaskCodeNameLike() + "%").or((Predicate)ExecutRecordRepoProc.qTaskInfoDO.name.like("%" + executRecordPageParam.getTaskCodeNameLike() + "%")));
        }
        if (StringUtils.isNotEmpty((CharSequence)executRecordPageParam.getJurisdiction())) {
            QSalesmanRegionDO qSalesmanRegionDO = QSalesmanRegionDO.salesmanRegionDO;
            QSalesmanInfoDO qSalesmanInfoDO = QSalesmanInfoDO.salesmanInfoDO;
            BooleanExpression booleanExpression = ((JPQLQuery)((JPQLQuery)JPAExpressions.select((Expression)Expressions.ONE).from(new EntityPath[]{qSalesmanRegionDO}).innerJoin((EntityPath)qSalesmanInfoDO).on(new Predicate[]{qSalesmanRegionDO.masId.eq(qSalesmanInfoDO.id)}).where(new Predicate[]{qSalesmanInfoDO.salesmanNo.eq((Expression)this.qExecutRecordDO.executUserCode)})).where(new Predicate[]{qSalesmanRegionDO.regionCode.eq((Object)executRecordPageParam.getJurisdiction())})).exists();
            query.where((Predicate)booleanExpression);
        }
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    public Long del(List<Long> ids) {
        Long res = this.jpaQueryFactory.update((EntityPath)this.qExecutRecordDO).set(this.qExecutRecordDO.deleteFlag, (Object)1).where(new Predicate[]{this.qExecutRecordDO.id.in(ids)}).execute();
        return res;
    }

    public ExecutRecordRespVO get(Long id) {
        ExecutRecordRespVO executRecordVO = (ExecutRecordRespVO)((JPAQuery)this.selectInnerJoinTaskDtl().where((Predicate)this.qExecutRecordDO.id.eq((Object)id))).fetchOne();
        return executRecordVO;
    }

    public List<ExecutRecordRespVO> getList(ExecutRecordQueryParam executRecordPageParam) {
        List res = ((JPAQuery)this.select(ExecutRecordRespVO.class).where(this.bulidPredicate(executRecordPageParam, false))).fetch();
        return res;
    }

    private JPAQuery<ExecutRecordRespVO> selectInnerJoinTaskDtl() {
        return (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ExecutRecordRespVO.class, (Expression[])new Expression[]{this.qExecutRecordDO.code, this.qExecutRecordDO.taskCode, this.qExecutRecordDO.taskDtlId, this.qExecutRecordDO.taskType, this.qExecutRecordDO.publishUser, this.qExecutRecordDO.publishUserId, this.qExecutRecordDO.publishUserCode, this.qExecutRecordDO.state, this.qExecutRecordDO.executUser, this.qExecutRecordDO.businessType, this.qExecutRecordDO.businessId, this.qExecutRecordDO.businessCode, this.qExecutRecordDO.businessName, this.qExecutRecordDO.startTime, this.qExecutRecordDO.endTime, this.qExecutRecordDO.auditDesc, this.qExecutRecordDO.id, this.qExecutRecordDO.createTime, this.qExecutRecordDO.creator, this.qExecutRecordDO.updater, this.qExecutRecordDO.modifyTime, this.qExecutRecordDO.remark, ExecutRecordRepoProc.qTaskInfoDtlDO.delayFlag, ExecutRecordRepoProc.qTaskInfoDO.id.as("taskId"), ExecutRecordRepoProc.qTaskInfoDO.name.as("taskName"), ExecutRecordRepoProc.qTaskInfoDtlDO.executUserId, ExecutRecordRepoProc.qTaskInfoDtlDO.executUserCode})).from((EntityPath)this.qExecutRecordDO)).innerJoin((EntityPath)qTaskInfoDO)).on((Predicate)ExecutRecordRepoProc.qTaskInfoDO.code.eq((Expression)this.qExecutRecordDO.taskCode))).innerJoin((EntityPath)qTaskInfoDtlDO)).on((Predicate)ExecutRecordRepoProc.qTaskInfoDtlDO.id.eq(this.qExecutRecordDO.taskDtlId));
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qExecutRecordDO.code, this.qExecutRecordDO.taskCode, this.qExecutRecordDO.taskId, this.qExecutRecordDO.taskDtlId, this.qExecutRecordDO.taskName, this.qExecutRecordDO.taskType, this.qExecutRecordDO.publishUser, this.qExecutRecordDO.publishUserId, this.qExecutRecordDO.publishUserCode, this.qExecutRecordDO.state, this.qExecutRecordDO.executUser, this.qExecutRecordDO.executUserId, this.qExecutRecordDO.executUserCode, this.qExecutRecordDO.businessType, this.qExecutRecordDO.businessId, this.qExecutRecordDO.businessCode, this.qExecutRecordDO.businessName, this.qExecutRecordDO.startTime, this.qExecutRecordDO.endTime, this.qExecutRecordDO.auditDesc, this.qExecutRecordDO.id, this.qExecutRecordDO.createTime, this.qExecutRecordDO.creator, this.qExecutRecordDO.updater, this.qExecutRecordDO.modifyTime, this.qExecutRecordDO.remark})).from((EntityPath)this.qExecutRecordDO);
    }

    private Predicate bulidPredicate(ExecutRecordQueryParam executRecordPageParam, boolean innerJoinTaskDtlFlag) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andLike(StringUtils.isNotBlank((CharSequence)executRecordPageParam.getCode()), (StringExpression)this.qExecutRecordDO.code, executRecordPageParam.getCode()).andLike(StringUtils.isNotBlank((CharSequence)executRecordPageParam.getTaskCode()), (StringExpression)this.qExecutRecordDO.taskCode, executRecordPageParam.getTaskCode()).andEq(null != executRecordPageParam.getTaskId(), this.qExecutRecordDO.taskId, (Object)executRecordPageParam.getTaskId()).andEq(StringUtils.isNotBlank((CharSequence)executRecordPageParam.getTaskName()), (SimpleExpression)this.qExecutRecordDO.taskName, (Object)executRecordPageParam.getTaskName()).andEq(StringUtils.isNotBlank((CharSequence)executRecordPageParam.getTaskType()), (SimpleExpression)this.qExecutRecordDO.taskType, (Object)executRecordPageParam.getTaskType()).andEq(StringUtils.isNotBlank((CharSequence)executRecordPageParam.getPublishUser()), (SimpleExpression)this.qExecutRecordDO.publishUser, (Object)executRecordPageParam.getPublishUser()).andEq(null != executRecordPageParam.getPublishUserId(), this.qExecutRecordDO.publishUserId, (Object)executRecordPageParam.getPublishUserId()).andEq(StringUtils.isNotBlank((CharSequence)executRecordPageParam.getPublishUserCode()), (SimpleExpression)this.qExecutRecordDO.publishUserCode, (Object)executRecordPageParam.getPublishUserCode()).andEq(StringUtils.isNotBlank((CharSequence)executRecordPageParam.getState()), (SimpleExpression)this.qExecutRecordDO.state, (Object)executRecordPageParam.getState()).andEq(StringUtils.isNotBlank((CharSequence)executRecordPageParam.getExecutUser()), (SimpleExpression)this.qExecutRecordDO.executUser, (Object)executRecordPageParam.getExecutUser()).andEq(null != executRecordPageParam.getExecutUserId(), this.qExecutRecordDO.executUserId, (Object)executRecordPageParam.getExecutUserId()).andEq(StringUtils.isNotBlank((CharSequence)executRecordPageParam.getExecutUserCode()), (SimpleExpression)this.qExecutRecordDO.executUserCode, (Object)executRecordPageParam.getExecutUserCode()).andEq(StringUtils.isNotBlank((CharSequence)executRecordPageParam.getBusinessType()), (SimpleExpression)this.qExecutRecordDO.businessType, (Object)executRecordPageParam.getBusinessType()).andEq(null != executRecordPageParam.getBusinessId(), this.qExecutRecordDO.businessId, (Object)executRecordPageParam.getBusinessId()).andEq(StringUtils.isNotBlank((CharSequence)executRecordPageParam.getBusinessCode()), (SimpleExpression)this.qExecutRecordDO.businessCode, (Object)executRecordPageParam.getBusinessCode()).andLike(StringUtils.isNotBlank((CharSequence)executRecordPageParam.getBusinessName()), (StringExpression)this.qExecutRecordDO.businessName, executRecordPageParam.getBusinessName()).andGoe(null != executRecordPageParam.getStartTime(), this.qExecutRecordDO.startTime, (Comparable)executRecordPageParam.getStartTime()).andLoe(null != executRecordPageParam.getEndTime(), this.qExecutRecordDO.endTime, (Comparable)executRecordPageParam.getEndTime()).andGoe(null != executRecordPageParam.getCreateTimeStart(), this.qExecutRecordDO.createTime, (Comparable)executRecordPageParam.getCreateTimeStart()).andLoe(null != executRecordPageParam.getCreateTimeEnd(), this.qExecutRecordDO.createTime, (Comparable)executRecordPageParam.getCreateTimeEnd()).andEq(StringUtils.isNotBlank((CharSequence)executRecordPageParam.getAuditDesc()), (SimpleExpression)this.qExecutRecordDO.auditDesc, (Object)executRecordPageParam.getAuditDesc()).andIn(!CollectionUtils.isEmpty((Collection)executRecordPageParam.getIds()), this.qExecutRecordDO.id, (Collection)executRecordPageParam.getIds()).build();
        if (innerJoinTaskDtlFlag && StringUtils.isNotEmpty((CharSequence)executRecordPageParam.getDelayFlag())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)ExecutRecordRepoProc.qTaskInfoDtlDO.delayFlag.eq((Object)executRecordPageParam.getDelayFlag()));
        }
        return predicate;
    }

    public List<ExecutRecordRespVO> queryBylast(String taskType, String businessCode) {
        List fetch = ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.select(ExecutRecordRespVO.class).where((Predicate)this.qExecutRecordDO.taskType.eq((Object)taskType))).where((Predicate)this.qExecutRecordDO.businessCode.eq((Object)businessCode))).where((Predicate)this.qExecutRecordDO.state.eq((Object)UdcEnum.EXECT_RECORD_STATUS_CPD.getValueCode()))).where((Predicate)this.qExecutRecordDO.deleteFlag.eq((Object)0).or((Predicate)this.qExecutRecordDO.deleteFlag.isNull()))).orderBy(this.qExecutRecordDO.createTime.desc())).fetch();
        return fetch;
    }

    public List<ExecutRecordRespVO> queryByCodes(List<String> codes) {
        List fetch = ((JPAQuery)((JPAQuery)this.select(ExecutRecordRespVO.class).where((Predicate)this.qExecutRecordDO.code.in(codes))).where((Predicate)this.qExecutRecordDO.deleteFlag.eq((Object)0).or((Predicate)this.qExecutRecordDO.deleteFlag.isNull()))).fetch();
        return fetch;
    }

    public Long updateByCode(List<String> code, String status) {
        Long res = this.jpaQueryFactory.update((EntityPath)this.qExecutRecordDO).set((Path)this.qExecutRecordDO.state, (Object)status).where(new Predicate[]{this.qExecutRecordDO.code.in(code)}).execute();
        return res;
    }

    public Long updateById(Long id, String status) {
        Long res = this.jpaQueryFactory.update((EntityPath)this.qExecutRecordDO).set((Path)this.qExecutRecordDO.state, (Object)status).where(new Predicate[]{this.qExecutRecordDO.id.eq((Object)id)}).execute();
        return res;
    }

    public PagingVO<ExecutRecordExportVO> pageExport(ExecutRecordQueryParam executRecordPageParam) {
        JPAQuery query = (JPAQuery)this.selectExport().where(this.bulidPredicate(executRecordPageParam, true));
        executRecordPageParam.setPaging(query);
        executRecordPageParam.fillOrders(query, (EntityPathBase)this.qExecutRecordDO);
        if (StringUtils.isNotBlank((CharSequence)executRecordPageParam.getTaskCodeNameLike())) {
            query.where((Predicate)this.qExecutRecordDO.taskCode.like("%" + executRecordPageParam.getTaskCodeNameLike() + "%").or((Predicate)ExecutRecordRepoProc.qTaskInfoDO.name.like("%" + executRecordPageParam.getTaskCodeNameLike() + "%")));
        }
        if (StringUtils.isNotEmpty((CharSequence)executRecordPageParam.getJurisdiction())) {
            QSalesmanRegionDO qSalesmanRegionDO = QSalesmanRegionDO.salesmanRegionDO;
            QSalesmanInfoDO qSalesmanInfoDO = QSalesmanInfoDO.salesmanInfoDO;
            BooleanExpression booleanExpression = ((JPQLQuery)((JPQLQuery)JPAExpressions.select((Expression)Expressions.ONE).from(new EntityPath[]{qSalesmanRegionDO}).innerJoin((EntityPath)qSalesmanInfoDO).on(new Predicate[]{qSalesmanRegionDO.masId.eq(qSalesmanInfoDO.id)}).where(new Predicate[]{qSalesmanInfoDO.salesmanNo.eq((Expression)this.qExecutRecordDO.executUserCode)})).where(new Predicate[]{qSalesmanRegionDO.regionCode.eq((Object)executRecordPageParam.getJurisdiction())})).exists();
            query.where((Predicate)booleanExpression);
        }
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    private JPAQuery<ExecutRecordExportVO> selectExport() {
        return (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(ExecutRecordExportVO.class, (Expression[])new Expression[]{this.qExecutRecordDO.id, this.qExecutRecordDO.code, this.qExecutRecordDO.taskCode, this.qExecutRecordDO.taskDtlId, this.qExecutRecordDO.taskType, this.qExecutRecordDO.publishUser, this.qExecutRecordDO.publishUserId, this.qExecutRecordDO.publishUserCode, this.qExecutRecordDO.state, this.qExecutRecordDO.executUser, this.qExecutRecordDO.businessType, this.qExecutRecordDO.businessId, this.qExecutRecordDO.businessCode, this.qExecutRecordDO.businessName, this.qExecutRecordDO.startTime, this.qExecutRecordDO.endTime, this.qExecutRecordDO.auditDesc, this.qExecutRecordDO.id, this.qExecutRecordDO.createTime, this.qExecutRecordDO.creator, this.qExecutRecordDO.updater, this.qExecutRecordDO.modifyTime, this.qExecutRecordDO.remark, ExecutRecordRepoProc.qTaskInfoDtlDO.delayFlag, this.qExecutRecordDtlDO.masId, this.qExecutRecordDtlDO.entryTime, this.qExecutRecordDtlDO.leaveTime, this.qExecutRecordDtlDO.signInPosition, this.qExecutRecordDtlDO.signInPositionCode, this.qExecutRecordDtlDO.signOutPosition, this.qExecutRecordDtlDO.signOutPositionCode, this.qExecutRecordDtlDO.signDesc, this.qExecutRecordDtlDO.id, this.qExecutRecordDtlDO.createTime, this.qExecutRecordDtlDO.remark, this.qExecutRecordDtlDO.creator, this.qExecutRecordDtlDO.updater, this.qExecutRecordDtlDO.modifyTime, ExecutRecordRepoProc.qTaskInfoDO.id.as("taskId"), ExecutRecordRepoProc.qTaskInfoDO.name.as("taskName"), ExecutRecordRepoProc.qTaskInfoDtlDO.executUserId, ExecutRecordRepoProc.qTaskInfoDtlDO.executUserCode})).from((EntityPath)this.qExecutRecordDO)).innerJoin((EntityPath)qTaskInfoDO)).on((Predicate)ExecutRecordRepoProc.qTaskInfoDO.code.eq((Expression)this.qExecutRecordDO.taskCode))).innerJoin((EntityPath)qTaskInfoDtlDO)).on((Predicate)ExecutRecordRepoProc.qTaskInfoDtlDO.id.eq(this.qExecutRecordDO.taskDtlId))).innerJoin((EntityPath)this.qExecutRecordDtlDO)).on((Predicate)this.qExecutRecordDtlDO.masId.eq(this.qExecutRecordDO.id));
    }
}

