/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.rmi.ystsystem;

import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.SysEmployeeDetailDTO;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeeUpsertDTO;
import com.elitescloud.cloudt.system.dto.req.UserCreateDTO;
import com.elitescloud.cloudt.system.dto.req.UserQueryDTO;
import com.elitescloud.cloudt.system.param.SysOrgQueryDTO;
import com.elitescloud.cloudt.system.provider.org.EmployeeRpcService;
import com.elitescloud.cloudt.system.provider.org.OrgRpcService;
import com.elitescloud.cloudt.system.provider.org.UserRpcService;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RmiSysOrgService {
    private static final Logger log = LoggerFactory.getLogger(RmiSysOrgService.class);
    private final EmployeeRpcService employeeRpcService;
    private final UserRpcService userRpcService;
    private final OrgRpcService orgRpcService;

    public List<SysEmployeeDetailDTO> findEmpByCode(List<String> codes) {
        Function<Set, List> function = queryParam -> {
            ApiResult apiResult = this.employeeRpcService.getDetailListByCode(queryParam);
            return (List)this.getData(apiResult);
        };
        return this.execute(function, new HashSet<String>(codes), "\u5458\u5de5\u67e5\u8be2\u63a5\u53e3");
    }

    public SysEmployeeDetailDTO findEmpByCode(String code) {
        Function<String, SysEmployeeDetailDTO> function = queryParam -> {
            ApiResult apiResult = this.employeeRpcService.getDetailByCode(queryParam);
            return (SysEmployeeDetailDTO)this.getData(apiResult);
        };
        return this.execute(function, code, "\u5458\u5de5\u67e5\u8be2\u63a5\u53e3");
    }

    public String saveEmp(EmployeeUpsertDTO param) {
        Function<EmployeeUpsertDTO, String> function = queryParam -> {
            ApiResult apiResult = this.employeeRpcService.upsert(queryParam);
            return (String)this.getData(apiResult);
        };
        return this.execute(function, param, "\u5458\u5de5\u4fdd\u5b58\u63a5\u53e3");
    }

    public SysUserBasicDTO findUserById(Long userId) {
        Function<Long, SysUserBasicDTO> function = queryParam -> {
            ApiResult apiResult = this.userRpcService.getById(queryParam);
            return (SysUserBasicDTO)this.getData(apiResult);
        };
        return this.execute(function, userId, "\u7528\u6237\u67e5\u8be2\u63a5\u53e3");
    }

    public List<SysUserBasicDTO> findUserByUsername(List<String> usenames) {
        UserQueryDTO param = new UserQueryDTO();
        param.setUsernames(new HashSet<String>(usenames));
        return this.findUserByParam(param);
    }

    public List<SysUserBasicDTO> findUserByParam(UserQueryDTO param) {
        Function<UserQueryDTO, List> function = queryParam -> {
            ApiResult apiResult = this.userRpcService.queryUser(queryParam);
            return (List)this.getData(apiResult);
        };
        return this.execute(function, param, "\u7528\u6237\u67e5\u8be2\u63a5\u53e3");
    }

    public Long saveUser(UserCreateDTO param) {
        Function<UserCreateDTO, Long> function = queryParam -> {
            ApiResult apiResult = this.userRpcService.upsert(queryParam);
            return (Long)this.getData(apiResult);
        };
        return this.execute(function, param, "\u7528\u6237\u4fdd\u5b58\u63a5\u53e3");
    }

    public List<SysOrgBasicDTO> findOrgByCodes(List<String> orgCodes) {
        SysOrgQueryDTO param = new SysOrgQueryDTO();
        param.setCodes(new HashSet<String>(orgCodes));
        return this.findOrgByParam(param);
    }

    public List<SysOrgBasicDTO> findOrgByParam(SysOrgQueryDTO param) {
        Function<SysOrgQueryDTO, List> function = queryParam -> {
            ApiResult apiResult = this.orgRpcService.queryList(queryParam);
            return (List)this.getData(apiResult);
        };
        return this.execute(function, param, "\u7ec4\u7ec7\u67e5\u8be2\u63a5\u53e3");
    }

    public Map<String, SysOrgBasicDTO> selectOrgParentByCodes(Set<String> codes) {
        if (CollectionUtil.isEmpty(codes)) {
            return null;
        }
        Function<Set, Map> function = queryParam -> {
            ApiResult apiResult = this.orgRpcService.getParentByCode(queryParam, "COMPANY");
            return (Map)this.getData(apiResult);
        };
        return this.execute(function, new HashSet<String>(codes), "\u6839\u636e\u7f16\u7801\u83b7\u53d6\u4e0a\u7ea7\u7ec4\u7ec7\u4fe1\u606f\u63a5\u53e3");
    }

    private <T> T getData(ApiResult<T> apiResult) {
        if (apiResult.isSuccess()) {
            return (T)apiResult.getData();
        }
        log.error("\u8c03\u7528\u7cfb\u7edf\u57df\u63a5\u53e3\u5931\u8d25:{}", (Object)apiResult.getErrorMsg());
        throw new BusinessException(apiResult.getErrorMsg());
    }

    private <T, R> R execute(Function<T, R> function, T param, String interfaceName) {
        try {
            return function.apply(param);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u7cfb\u7edf\u57df" + interfaceName + "\u5931\u8d25", (Throwable)e);
            throw new BusinessException("\u8c03\u7528\u7cfb\u7edf\u57df" + interfaceName + "\u5931\u8d25:" + e.getMessage());
        }
    }

    public RmiSysOrgService(EmployeeRpcService employeeRpcService, UserRpcService userRpcService, OrgRpcService orgRpcService) {
        this.employeeRpcService = employeeRpcService;
        this.userRpcService = userRpcService;
        this.orgRpcService = orgRpcService;
    }
}

