/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.common.param.ComSearchParam;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysEmployeeDetailDTO;
import com.elitescloud.cloudt.system.dto.resp.SysAreaRespDTO;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;
import com.elitescloud.cloudt.system.provider.extend.SysAreaRpcService;
import com.elitescloud.cloudt.system.provider.org.EmployeeRpcService;
import com.elitescloud.cloudt.system.vo.SysUdcComboVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.sale.api.service.ComSaleFileInfoService;
import com.elitesland.yst.production.sale.api.service.CrmCustOuService;
import com.elitesland.yst.production.sale.api.service.CrmCustService;
import com.elitesland.yst.production.sale.api.service.CustBelongOuService;
import com.elitesland.yst.production.sale.api.service.SalesmanInfoService;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmCustAddrParamVO;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmCustBaseParamVO;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmCustCheckParamVO;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmCustFixPhoneParamVO;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmCustOuParamVO;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmCustPlugInParamVO;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmCustQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmCustSimpleParam;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmEmpAssignParamVO;
import com.elitesland.yst.production.sale.api.vo.param.crm.CustAddrFindParam;
import com.elitesland.yst.production.sale.api.vo.param.crm.CustPredictionParamVO;
import com.elitesland.yst.production.sale.api.vo.param.crm.CustSwitchStatusParamVO;
import com.elitesland.yst.production.sale.api.vo.param.crm.OrgAddrAddressSaveParam;
import com.elitesland.yst.production.sale.api.vo.param.crm.SevenCustDto;
import com.elitesland.yst.production.sale.api.vo.param.crm.SevenCustVo;
import com.elitesland.yst.production.sale.api.vo.resp.com.ComSaleFileComVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustAddrRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustBasePageVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustBaseRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustDetailRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustPageRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustPlugInRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustQualifyRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustSimpleVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustAccountVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustBelongOuVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustCorOuResVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustImportEmpDTO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustPrentInfoDTO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CustSalePredictionVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.LmCrmCustSaveVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.LmSaveCustRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.mdmSync.CrmCustMasterDataRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.mdmSync.CrmCustMdmSyncRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.mdmSync.CrmCustResponseDataRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.RmiOuDetailVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.RmiOuInfoByAddr;
import com.elitesland.yst.production.sale.api.vo.save.CrmAddrImplSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.CrmCustAddrSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.CrmCustImportSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.CrmCustOuSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.CrmCustQualifySaveVO;
import com.elitesland.yst.production.sale.api.vo.save.CrmCustSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.OrgAddrBankAccSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.mdmSync.CrmCustMdmRequstSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.mdmSync.CrmCustMdmSyncDataSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.mdmSync.CrmCustMdmSyncSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.mdmSync.CustSyncBaseDataLine;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.convert.CrmCustConvert;
import com.elitesland.yst.production.sale.convert.CrmCustMdmSyncConvert;
import com.elitesland.yst.production.sale.convert.RmiOuInfoByAddrConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.dto.SalesmanInfoDTO;
import com.elitesland.yst.production.sale.dto.query.SalesmanQueryDTO;
import com.elitesland.yst.production.sale.entity.BipCustUserBindDO;
import com.elitesland.yst.production.sale.entity.CrmCustDO;
import com.elitesland.yst.production.sale.entity.CrmCustExtendDO;
import com.elitesland.yst.production.sale.entity.CustAccountDO;
import com.elitesland.yst.production.sale.entity.QBipCustUserBindDO;
import com.elitesland.yst.production.sale.entity.QCrmCustDO;
import com.elitesland.yst.production.sale.entity.QCrmCustExtendDO;
import com.elitesland.yst.production.sale.entity.QCustAccountDO;
import com.elitesland.yst.production.sale.entity.SalesmanInfoDO;
import com.elitesland.yst.production.sale.repo.CrmCustExtendRepo;
import com.elitesland.yst.production.sale.repo.CrmCustOuRepoProc;
import com.elitesland.yst.production.sale.repo.CrmCustRepo;
import com.elitesland.yst.production.sale.repo.CrmCustRepoProc;
import com.elitesland.yst.production.sale.repo.CustAccountRepo;
import com.elitesland.yst.production.sale.repo.CustAccountRepoProc;
import com.elitesland.yst.production.sale.repo.SalesmanInfoRepo;
import com.elitesland.yst.production.sale.repo.shop.BipCustUserBindRepo;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiCityCodeService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgAddrService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgBuService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgEmpService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgOuService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiCommonService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysUserRpcService;
import com.elitesland.yst.production.support.provider.org.dto.OrgAddrAddressRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgAddrBankAccRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgAddrDetailsRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgAddrQualifyRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgAddressRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgBuRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgEmpRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgUserEmpInfoRpcDTO;
import com.elitesland.yst.production.support.provider.org.param.OrgAddrAddressRpcSaveParam;
import com.elitesland.yst.production.support.provider.org.param.OrgAddrQualifyRpcSaveParam;
import com.elitesland.yst.production.support.provider.org.param.OrgAddrRpcSaveParam;
import com.elitesland.yst.production.support.provider.org.param.OrgAddressRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.param.OrgBuRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.param.OrgEmpRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.param.OrgOuRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.param.OrgOuRpcSaveParam;
import com.elitesland.yst.production.support.provider.org.service.OrgOuRpcService;
import com.google.common.collect.Lists;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class CrmCustServiceImpl
extends BaseServiceImpl
implements CrmCustService {
    private static final Logger log = LoggerFactory.getLogger(CrmCustServiceImpl.class);
    private static final QCrmCustDO qCrmCustDO = QCrmCustDO.crmCustDO;
    private final CrmCustRepo crmCustRepo;
    private final CrmCustRepoProc crmCustRepoProc;
    private final CrmCustOuRepoProc crmCustOuRepoProc;
    private final ComSaleFileInfoService comSaleFileInfoService;
    private final RmiCityCodeService rmiCityCodeService;
    private final RmiOrgAddrService rmiOrgAddrService;
    private final RmiOrgEmpService rmiOrgEmpService;
    private final RmiOrgOuService rmiOrgOuService;
    private final RmiOrgBuService rmiOrgBuService;
    private final RmiSysNextNumberService rmiSysNextNumberService;
    private final RmiCommonService rmiCommonService;
    private final CrmCustOuService crmCustOuService;
    private final BipCustUserBindRepo bipCustUserBindRepo;
    private final CustAccountRepoProc custAccountRepoproc;
    private final CustAccountRepo custAccountRepo;
    @Autowired
    private SalesmanInfoService salesmanInfoService;
    private final SalesmanInfoRepo salesmanInfoRepo;
    private final OrgOuRpcService orgOuRpcService;
    private final CustBelongOuService custBelongOuService;
    private final SysAreaRpcService sysAreaRpcService;
    private final CrmCustExtendRepo crmCustExtendRepo;
    @Qualifier(value="cloudt_taskExecutor")
    private final TaskExecutor taskExecutor;
    private final RmiSysUserRpcService rmiSysUserRpcService;
    private final RmiSysService rmiSysService;
    @Autowired
    private UdcProvider udcProvider;
    @Autowired
    private EmployeeRpcService employeeRpcService;
    private static final String DATEFORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String DATEFORMAT2 = "yyyyMMddHHmmss";
    private static final String IFACECODE_UP_DATA = "KHZSJ_DR";
    private static final String IFACECODE_FIND = "KHZSJ";
    private static String DISTRIBUTIONMDMURL;
    private static String IMPORTMDMURL;
    @Autowired
    public RedissonClient redissonClient;
    public static final Integer EXPIRE_TIME;

    public CustPrentInfoDTO getPrentCustByCode(String custCode) {
        return this.crmCustRepoProc.getPrentCust(custCode);
    }

    public ApiResult<PagingVO<CrmCustSimpleVO>> query(ComSearchParam searchParam) {
        if (searchParam == null) {
            return ApiResult.fail((String)"\u641c\u7d22\u53c2\u6570\u4e3a\u7a7a");
        }
        PagingVO<CrmCustSimpleVO> pagingVO = this.querying(searchParam);
        return ApiResult.ok(pagingVO);
    }

    @SysCodeProc
    public CrmCustDetailRespVO get(Long id) {
        if (id == null) {
            return null;
        }
        CrmCustDO crmCustDO = this.crmCustRepo.findById(id).orElse(null);
        if (crmCustDO == null) {
            return null;
        }
        CrmCustDetailRespVO respVO = CrmCustConvert.INSTANCE.doToDetailRespVO(crmCustDO);
        this.translateDetail(respVO);
        CustAccountVO custAccountVO = this.getAccountByCustCode(crmCustDO.getCustCode());
        if (!ObjectUtils.isEmpty((Object)custAccountVO)) {
            respVO.setCustAccountVO(custAccountVO);
        }
        return respVO;
    }

    public List<CrmCustBaseRespVO> getByAgentEmpId(Long agentEmpId) {
        List<CrmCustBaseRespVO> list = this.crmCustRepoProc.getCustByEmpId(agentEmpId);
        list.forEach(l -> {
            l.setAddress(this.findDefaultAddr(l.getAddrNo()));
            ApiResult<SalesmanInfoDTO> res = this.getSaleManInfo(agentEmpId);
            if (res.isSuccess() && !ObjectUtils.isEmpty(res) && !ObjectUtils.isEmpty((Object)res.getData())) {
                l.setAgentEmpName(((SalesmanInfoDTO)res.getData()).getFullName());
            }
        });
        return list;
    }

    public ApiResult<SalesmanInfoDTO> getSaleManInfo(Long agentEmpId) {
        SalesmanQueryDTO salesmanQueryDTO = new SalesmanQueryDTO();
        salesmanQueryDTO.setSalesmanId(agentEmpId);
        return this.salesmanInfoService.querySalesmanInfo(salesmanQueryDTO);
    }

    public String findDefaultAddr(Long addrNo) {
        ApiResult<OrgAddrDetailsRpcDTO> rpcDtoByAddrNo = this.rmiOrgAddrService.findAddrByAddrNo(addrNo);
        Assert.isFalse((!rpcDtoByAddrNo.isSuccess() ? 1 : 0) != 0, (String)rpcDtoByAddrNo.getMsg(), (Object[])new Object[0]);
        OrgAddrDetailsRpcDTO orgAddr = (OrgAddrDetailsRpcDTO)rpcDtoByAddrNo.getData();
        if (!ObjectUtils.isEmpty((Object)orgAddr) && !CollectionUtils.isEmpty((Collection)orgAddr.getOrgAddrAddressVos())) {
            List addrs = orgAddr.getOrgAddrAddressVos().stream().filter(o -> o.getDefaultFlag()).map(OrgAddrAddressRpcDTO::getDetailAddr).collect(Collectors.toList());
            return (String)addrs.get(0);
        }
        return null;
    }

    public CustAccountVO getAccountByCustCode(String custCode) {
        return this.custAccountRepoproc.getAccountByCustCode(custCode);
    }

    private PagingVO<CrmCustSimpleVO> querying(ComSearchParam searchParam) {
        BooleanExpression predicate;
        if (StrUtil.isBlank((CharSequence)searchParam.getKeyword())) {
            predicate = qCrmCustDO.isNotNull();
        } else {
            String keyword = "%" + searchParam.getKeyword() + "%";
            predicate = CrmCustServiceImpl.qCrmCustDO.custCode.like(keyword).or((Predicate)CrmCustServiceImpl.qCrmCustDO.custName.like(keyword));
        }
        predicate = this.appendCommon((Predicate)predicate);
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{CrmCustServiceImpl.qCrmCustDO.id, CrmCustServiceImpl.qCrmCustDO.custCode, CrmCustServiceImpl.qCrmCustDO.custName, CrmCustServiceImpl.qCrmCustDO.custAbbr}).from((EntityPath)qCrmCustDO)).where((Predicate)predicate);
        long total = jpaQuery.fetchCount();
        if (total == 0L) {
            return PagingVO.builder().build();
        }
        PageRequest pageRequest = this.wrapperPageRequest(searchParam.getPageRequest(), Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{CrmCustServiceImpl.qCrmCustDO.createTime.getMetadata().getName()}));
        this.appendPageAndSort(jpaQuery, pageRequest, qCrmCustDO);
        List voList = jpaQuery.fetch().stream().map(tuple -> {
            CrmCustSimpleVO vo = new CrmCustSimpleVO();
            vo.setId((Long)tuple.get(CrmCustServiceImpl.qCrmCustDO.id));
            vo.setCustCode((String)tuple.get((Expression)CrmCustServiceImpl.qCrmCustDO.custCode));
            vo.setCustName((String)tuple.get((Expression)CrmCustServiceImpl.qCrmCustDO.custName));
            vo.setCustAbbr((String)tuple.get((Expression)CrmCustServiceImpl.qCrmCustDO.custAbbr));
            return vo;
        }).collect(Collectors.toList());
        return PagingVO.builder().total(total).records(voList).build();
    }

    private Predicate appendCommon(Predicate predicate) {
        return ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.deleteFlag.eq((Object)0));
    }

    @SysCodeProc
    public PagingVO<CrmCustPageRespVO> search(CrmCustQueryParamVO queryParamVO) {
        if (queryParamVO == null) {
            return null;
        }
        Page<CrmCustDO> pagingDo = this.searching(queryParamVO);
        long total = pagingDo.getTotalElements();
        List crmCustDOList = pagingDo.getContent();
        if (CollUtil.isEmpty((Collection)crmCustDOList)) {
            return new PagingVO(total, Collections.emptyList());
        }
        CrmCustConvert convert = CrmCustConvert.INSTANCE;
        List<CrmCustPageRespVO> respVOList = crmCustDOList.stream().map(convert::doToPageRespVO).collect(Collectors.toList());
        this.translatePage(respVOList);
        return new PagingVO(total, respVOList);
    }

    public ApiResult<PagingVO<CrmCustPlugInRespVO>> queryCustPlugIn(CrmCustPlugInParamVO searchParam) {
        if (searchParam == null) {
            return ApiResult.fail((String)"\u67e5\u8be2\u53c2\u6570\u4e3a\u7a7a");
        }
        Page<CrmCustDO> pagingDo = this.searchPlugIn(searchParam);
        long total = pagingDo.getTotalElements();
        List crmCustDOList = pagingDo.getContent();
        if (CollUtil.isEmpty((Collection)crmCustDOList)) {
            return ApiResult.ok((Object)new PagingVO(total, Collections.emptyList()));
        }
        CrmCustConvert convert = CrmCustConvert.INSTANCE;
        List<CrmCustPlugInRespVO> respVOList = crmCustDOList.stream().map(t -> {
            CrmCustPlugInRespVO respVO = convert.doToPlugInRespVO((CrmCustDO)t);
            respVO.setCustId(t.getId());
            return respVO;
        }).collect(Collectors.toList());
        this.translateCustPlugIn(respVOList);
        this.udcTranslate(respVOList);
        return ApiResult.ok((Object)new PagingVO(total, respVOList));
    }

    public PagingVO<CustSalePredictionVO> queryCustSalePrediction(CustPredictionParamVO param) {
        PagingVO<CustSalePredictionVO> pagingVO = this.crmCustRepoProc.queryCustSalePrediction(param);
        if (pagingVO.isNotEmpty() && !pagingVO.getRecords().isEmpty()) {
            List list = pagingVO.getRecords();
            Map regionMap = this.udcProvider.getValueMapByUdcCode("yst-supp", "REGION");
            Map custTypeUdc = this.udcProvider.getValueMapByUdcCode("yst-sale", "CUST_TYPE");
            list.forEach(l -> {
                if (!MapUtils.isEmpty((Map)regionMap) && StringUtil.isNotBlank((CharSequence)l.getRegion())) {
                    l.setRegionName((String)regionMap.get(l.getRegion()));
                }
                if (!MapUtils.isEmpty((Map)custTypeUdc) && StringUtil.isNotBlank((CharSequence)l.getCustType())) {
                    l.setCustTypeName((String)custTypeUdc.get(l.getCustType()));
                }
            });
            pagingVO.setRecords(list);
        }
        return pagingVO;
    }

    private void translateCustPlugIn(List<CrmCustPlugInRespVO> respVOList) {
        List agentEmpIds = respVOList.stream().map(CrmCustPlugInRespVO::getAgentEmpId).distinct().collect(Collectors.toList());
        OrgEmpRpcDtoParam orgEmpRpcDtoParam = new OrgEmpRpcDtoParam();
        List<Object> empDtoByParam = new ArrayList();
        if (!CollectionUtils.isEmpty(agentEmpIds)) {
            orgEmpRpcDtoParam.setEmpIds(agentEmpIds);
            empDtoByParam = this.rmiOrgEmpService.findEmpListByParam(orgEmpRpcDtoParam);
        }
        List<Object> addressRpcDto = new ArrayList();
        OrgAddressRpcDtoParam orgAddressRpcDtoParam = new OrgAddressRpcDtoParam();
        List addrNos = respVOList.stream().map(CrmCustPlugInRespVO::getRecvAddrNo).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(addrNos)) {
            orgAddressRpcDtoParam.setAddrNos(addrNos);
            addressRpcDto = this.rmiOrgAddrService.findAddrAddressListByParam(orgAddressRpcDtoParam);
        }
        ArrayList finalAddressRpcDto = addressRpcDto;
        List<Object> finalEmpDtoByParam = empDtoByParam;
        for (CrmCustPlugInRespVO respVo : respVOList) {
            List orgAddressRpcDTOS;
            if (!org.springframework.util.StringUtils.isEmpty((Object)respVo.getRecvAddrNo()) && !CollectionUtils.isEmpty(orgAddressRpcDTOS = finalAddressRpcDto.stream().filter(addr -> addr.getAddrNo().equals(respVo.getRecvAddrNo())).sorted(Comparator.comparing(OrgAddressRpcDTO::getId)).collect(Collectors.toList()))) {
                OrgAddressRpcDTO orgAddressRpcDTO;
                ArrayList<String> recvRegion = new ArrayList<String>();
                List orgAddressRpcDTOS1 = orgAddressRpcDTOS.stream().filter(orgAddr -> UdcEnum.ORG_ADDRESS_TYPE_RECEIVE.getValueCode().equals(orgAddr.getAddressType())).sorted(Comparator.comparing(OrgAddressRpcDTO::getId)).collect(Collectors.toList());
                List orgAddressRpcDTOS2 = orgAddressRpcDTOS.stream().filter(orgAddr -> UdcEnum.ORG_ADDRESS_TYPE_DEFAULT.getValueCode().equals(orgAddr.getAddressType())).sorted(Comparator.comparing(OrgAddressRpcDTO::getId)).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(orgAddressRpcDTOS1)) {
                    orgAddressRpcDTOOptional = orgAddressRpcDTOS1.stream().filter(addr -> addr.getDefaultFlag().equals(true)).findFirst();
                    orgAddressRpcDTO = orgAddressRpcDTOOptional.orElseGet(() -> (OrgAddressRpcDTO)orgAddressRpcDTOS1.get(0));
                } else if (!CollectionUtils.isEmpty(orgAddressRpcDTOS2)) {
                    orgAddressRpcDTOOptional = orgAddressRpcDTOS2.stream().filter(addr -> addr.getDefaultFlag().equals(true)).findFirst();
                    orgAddressRpcDTO = orgAddressRpcDTOOptional.orElseGet(() -> (OrgAddressRpcDTO)orgAddressRpcDTOS2.get(0));
                } else {
                    orgAddressRpcDTO = (OrgAddressRpcDTO)orgAddressRpcDTOS.get(0);
                }
                respVo.setCustContactName(orgAddressRpcDTO.getContPerson());
                respVo.setCustContactEmail(orgAddressRpcDTO.getEmail());
                respVo.setCustContactTel(orgAddressRpcDTO.getMobile());
                respVo.setCustContactEmail(orgAddressRpcDTO.getEmail());
                respVo.setRecvCountry(orgAddressRpcDTO.getCountry());
                respVo.setRecvCity(orgAddressRpcDTO.getCity());
                respVo.setRecvCityName(orgAddressRpcDTO.getCityName());
                respVo.setRecvCounty(orgAddressRpcDTO.getCounty());
                respVo.setRecvCountyName(orgAddressRpcDTO.getCountyName());
                respVo.setReceiveStreet(orgAddressRpcDTO.getStreet());
                respVo.setRecvProvince(orgAddressRpcDTO.getProvince());
                respVo.setRecvProvinceName(orgAddressRpcDTO.getProvinceName());
                respVo.setAddrDetail(orgAddressRpcDTO.getDetailAddr());
                recvRegion.add(orgAddressRpcDTO.getProvince());
                recvRegion.add(orgAddressRpcDTO.getCity());
                recvRegion.add(orgAddressRpcDTO.getCounty());
                respVo.setRecvRegion(recvRegion);
                respVo.setAddrId(orgAddressRpcDTO.getId());
            }
            if (org.springframework.util.StringUtils.isEmpty((Object)respVo.getAgentEmpId())) continue;
            finalEmpDtoByParam.stream().filter(emp -> emp.getId().equals(respVo.getAgentEmpId())).findFirst().ifPresent(agentEmp -> respVo.setAgentEmpName(agentEmp.getEmpName()));
        }
    }

    private void udcTranslate(List<CrmCustPlugInRespVO> respVOList) {
    }

    private Page<CrmCustDO> searchPlugIn(CrmCustPlugInParamVO searchParam) {
        List custCodes;
        List custOuSaveVOS;
        CrmCustOuParamVO crmCustOuParamVO;
        BooleanExpression predicate = qCrmCustDO.isNotNull();
        if (!org.springframework.util.StringUtils.isEmpty((Object)searchParam.getCustData())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.custCode.like("%" + searchParam.getCustData() + "%").or((Predicate)CrmCustServiceImpl.qCrmCustDO.custName.like("%" + searchParam.getCustData() + "%")));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)searchParam.getCustType())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.custType.eq((Object)searchParam.getCustType()));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)searchParam.getInnerFlag())) {
            if (searchParam.getInnerFlag().equals(Boolean.TRUE)) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.custType2.eq((Object)UdcEnum.CRM_CUST_TYPE2_C.getValueCode()));
                predicate = ExpressionUtils.or((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.custType2.eq((Object)UdcEnum.CRM_CUST_TYPE2_D.getValueCode()));
            } else {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.custType2.ne((Object)UdcEnum.CRM_CUST_TYPE2_C.getValueCode()));
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.custType2.ne((Object)UdcEnum.CRM_CUST_TYPE2_D.getValueCode()));
            }
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)searchParam.getAgentEmpId())) {
            crmCustOuParamVO = new CrmCustOuParamVO();
            crmCustOuParamVO.setAgentEmpId(searchParam.getAgentEmpId());
            crmCustOuParamVO.setIfTrans(Boolean.valueOf(false));
            custOuSaveVOS = this.crmCustOuService.search(crmCustOuParamVO);
            predicate = !CollectionUtils.isEmpty((Collection)custOuSaveVOS) ? (!CollectionUtils.isEmpty(custCodes = custOuSaveVOS.stream().map(CrmCustOuSaveVO::getCustCode).distinct().collect(Collectors.toList())) ? ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.custCode.in(custCodes).or((Predicate)CrmCustServiceImpl.qCrmCustDO.agentEmpId.eq((Object)searchParam.getAgentEmpId()))) : ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.agentEmpId.eq((Object)searchParam.getAgentEmpId()))) : ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.agentEmpId.eq((Object)searchParam.getAgentEmpId()));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)searchParam.getOuId())) {
            crmCustOuParamVO = new CrmCustOuParamVO();
            crmCustOuParamVO.setOuId(searchParam.getOuId());
            crmCustOuParamVO.setIfTrans(Boolean.valueOf(false));
            custOuSaveVOS = this.crmCustOuService.search(crmCustOuParamVO);
            predicate = !CollectionUtils.isEmpty((Collection)custOuSaveVOS) ? (!CollectionUtils.isEmpty(custCodes = custOuSaveVOS.stream().map(CrmCustOuSaveVO::getCustCode).distinct().collect(Collectors.toList())) ? ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.custCode.in(custCodes).or((Predicate)CrmCustServiceImpl.qCrmCustDO.ouId.eq((Object)searchParam.getOuId()))) : ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.ouId.eq((Object)searchParam.getOuId()))) : ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.ouId.eq((Object)searchParam.getOuId()));
        }
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.custStatus.ne((Object)UdcEnum.CRM_CUST_STATUS_CLOSED.getValueCode()));
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.deleteFlag.ne((Object)1));
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)DataAuthJpaUtil.dataAuthJpaPredicate((PathMetadata)qCrmCustDO.getMetadata()));
        return this.crmCustRepo.findAll((Predicate)predicate, (Pageable)this.wrapperPageRequest(searchParam.getPageRequest(), null));
    }

    @SysCodeProc
    public List<CrmCustPageRespVO> searchList(CrmCustQueryParamVO queryParamVO) {
        if (queryParamVO == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        List<CrmCustDO> crmCustDOList = this.searching1(queryParamVO);
        CrmCustConvert convert = CrmCustConvert.INSTANCE;
        List<CrmCustPageRespVO> respVOList = crmCustDOList.stream().map(t -> {
            CrmCustPageRespVO crmCustPageRespVO = convert.doToPageRespVO((CrmCustDO)t);
            return crmCustPageRespVO;
        }).collect(Collectors.toList());
        if (!org.springframework.util.StringUtils.isEmpty((Object)queryParamVO.getTransFlag()) && queryParamVO.getTransFlag().equals(Boolean.TRUE)) {
            this.translatePage(respVOList);
        }
        return respVOList;
    }

    private void translatePage(List<CrmCustPageRespVO> respVOList) {
        List agentEmpIds = respVOList.stream().map(CrmCustPageRespVO::getAgentEmpId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        OrgEmpRpcDtoParam orgEmpRpcDtoParam = new OrgEmpRpcDtoParam();
        List<Object> empDtoByParam = new ArrayList();
        if (!CollectionUtils.isEmpty(agentEmpIds)) {
            orgEmpRpcDtoParam.setEmpIds(agentEmpIds);
            empDtoByParam = this.rmiOrgEmpService.findEmpListByParam(orgEmpRpcDtoParam);
        }
        OrgBuRpcDtoParam orgBuRpcDtoParam = new OrgBuRpcDtoParam();
        List buCodes = respVOList.stream().map(CrmCustPageRespVO::getBuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Object> buDtoByParam = new ArrayList();
        if (!CollectionUtils.isEmpty(buCodes)) {
            orgBuRpcDtoParam.setBuCodes(buCodes);
            buDtoByParam = this.rmiOrgBuService.findBuDtoByParam(orgBuRpcDtoParam);
        }
        List addrNos = respVOList.stream().map(CrmCustPageRespVO::getAddrNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        OrgAddressRpcDtoParam orgAddressRpcDtoParam = new OrgAddressRpcDtoParam();
        List<Object> addressRpcDto = new ArrayList();
        if (!CollectionUtils.isEmpty(addrNos)) {
            orgAddressRpcDtoParam.setAddrNos(addrNos);
            addressRpcDto = this.rmiOrgAddrService.findAddrAddressListByParam(orgAddressRpcDtoParam);
        }
        List<Object> finalEmpDtoByParam = empDtoByParam;
        ArrayList finalAddressRpcDto = addressRpcDto;
        List<Object> finalBuDtoByParam = buDtoByParam;
        respVOList.forEach(respVo -> {
            List orgAddressRpcDTOS;
            if (!org.springframework.util.StringUtils.isEmpty((Object)respVo.getAddrNo()) && !CollectionUtils.isEmpty(orgAddressRpcDTOS = finalAddressRpcDto.stream().filter(addr -> addr.getAddrNo().equals(respVo.getAddrNo())).sorted(Comparator.comparing(OrgAddressRpcDTO::getId)).collect(Collectors.toList()))) {
                OrgAddressRpcDTO orgAddressRpcDTO;
                List orgAddressRpcDTOS1 = orgAddressRpcDTOS.stream().filter(orgAddr -> UdcEnum.ORG_ADDRESS_TYPE_RECEIVE.getValueCode().equals(orgAddr.getAddressType())).sorted(Comparator.comparing(OrgAddressRpcDTO::getId)).collect(Collectors.toList());
                List orgAddressRpcDTOS2 = orgAddressRpcDTOS.stream().filter(orgAddr -> UdcEnum.ORG_ADDRESS_TYPE_DEFAULT.getValueCode().equals(orgAddr.getAddressType())).sorted(Comparator.comparing(OrgAddressRpcDTO::getId)).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(orgAddressRpcDTOS2)) {
                    orgAddressRpcDTOOptional = orgAddressRpcDTOS2.stream().filter(addr -> addr.getDefaultFlag().equals(true)).findFirst();
                    orgAddressRpcDTO = orgAddressRpcDTOOptional.orElseGet(() -> (OrgAddressRpcDTO)orgAddressRpcDTOS2.get(0));
                } else if (!CollectionUtils.isEmpty(orgAddressRpcDTOS1)) {
                    orgAddressRpcDTOOptional = orgAddressRpcDTOS1.stream().filter(addr -> addr.getDefaultFlag().equals(true)).findFirst();
                    orgAddressRpcDTO = orgAddressRpcDTOOptional.orElseGet(() -> (OrgAddressRpcDTO)orgAddressRpcDTOS1.get(0));
                } else {
                    orgAddressRpcDTO = (OrgAddressRpcDTO)orgAddressRpcDTOS.get(0);
                }
                respVo.setContPerson(orgAddressRpcDTO.getContPerson());
                respVo.setContPersonEmail(orgAddressRpcDTO.getEmail());
                respVo.setContPersonTel(orgAddressRpcDTO.getTel());
                respVo.setContPersonMobile(orgAddressRpcDTO.getMobile());
                respVo.setContPersonEmail(orgAddressRpcDTO.getEmail());
                respVo.setStreet(orgAddressRpcDTO.getStreet());
                respVo.setCountry(orgAddressRpcDTO.getCountry());
                respVo.setContPersonFax(orgAddressRpcDTO.getFax());
                ArrayList<String> contractCity = new ArrayList<String>();
                contractCity.add(orgAddressRpcDTO.getProvince());
                contractCity.add(orgAddressRpcDTO.getCity());
                contractCity.add(orgAddressRpcDTO.getCounty());
                respVo.setContractCity(contractCity);
                respVo.setContractCityName((String)(orgAddressRpcDTO.getProvinceName() == null ? "/" : orgAddressRpcDTO.getProvinceName() + "/") + (String)(orgAddressRpcDTO.getCityName() == null ? "/" : orgAddressRpcDTO.getCityName() + "/") + (orgAddressRpcDTO.getCounty() == null ? "" : orgAddressRpcDTO.getCountyName()));
                respVo.setAddrDetail(orgAddressRpcDTO.getDetailAddr());
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)respVo.getAgentEmpId())) {
                finalEmpDtoByParam.stream().filter(emp -> emp.getId().equals(respVo.getAgentEmpId())).findFirst().ifPresent(agentEmp -> respVo.setAgentEmpName(agentEmp.getEmpName()));
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)respVo.getBuCode())) {
                finalBuDtoByParam.stream().filter(bu -> bu.getBuCode().equals(respVo.getBuCode())).findFirst().ifPresent(buDto -> buDto.setBuName(buDto.getBuName()));
            }
        });
    }

    private void translateDetail(CrmCustDetailRespVO respVO) {
        ApiResult<SalesmanInfoDTO> res;
        if (!org.springframework.util.StringUtils.isEmpty((Object)respVO.getPid())) {
            String pidName = this.crmCustRepoProc.getCustNameByPidCode(respVO.getPid());
            respVO.setPidName(pidName);
        }
        CrmCustConvert crmCustConvert = CrmCustConvert.INSTANCE;
        if (!ObjectUtils.isEmpty((Object)respVO.getAgentEmpId()) && (res = this.getSaleManInfo(respVO.getAgentEmpId())).isSuccess() && !ObjectUtils.isEmpty(res) && !ObjectUtils.isEmpty((Object)res.getData())) {
            respVO.setAgentEmpName(((SalesmanInfoDTO)res.getData()).getFullName());
        }
        if (!ObjectUtils.isEmpty((Object)respVO.getAgentEmpId2()) && (res = this.getSaleManInfo(respVO.getAgentEmpId2())).isSuccess() && !ObjectUtils.isEmpty(res) && !ObjectUtils.isEmpty((Object)res.getData())) {
            respVO.setAgentEmpName2(((SalesmanInfoDTO)res.getData()).getFullName());
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)respVO.getAddrNo())) {
            ApiResult<OrgAddrDetailsRpcDTO> rpcDtoByAddrNo = this.rmiOrgAddrService.findAddrByAddrNo(respVO.getAddrNo());
            Assert.isFalse((!rpcDtoByAddrNo.isSuccess() ? 1 : 0) != 0, (String)rpcDtoByAddrNo.getMsg(), (Object[])new Object[0]);
            OrgAddrDetailsRpcDTO orgAddr = (OrgAddrDetailsRpcDTO)rpcDtoByAddrNo.getData();
            if (!ObjectUtils.isEmpty((Object)orgAddr) && !CollectionUtils.isEmpty((Collection)orgAddr.getOrgAddrAddressVos())) {
                respVO.setAddrId(orgAddr.getId());
                List crmCustAddrRespVOS = orgAddr.getOrgAddrAddressVos().stream().map(addr -> {
                    CrmCustAddrRespVO crmCustAddrRespVO = crmCustConvert.addrRpcToAddrVo((OrgAddrAddressRpcDTO)addr);
                    crmCustAddrRespVO.setContEmail(addr.getEmail());
                    crmCustAddrRespVO.setContFax(addr.getFax());
                    crmCustAddrRespVO.setContMobile(addr.getMobile());
                    crmCustAddrRespVO.setCountry(addr.getCountry());
                    crmCustAddrRespVO.setCountryName(addr.getCountryName());
                    crmCustAddrRespVO.setContTel(addr.getTel());
                    crmCustAddrRespVO.setDetailaddr(addr.getDetailAddr());
                    crmCustAddrRespVO.setUpdater(addr.getUpdater());
                    crmCustAddrRespVO.setCreator(addr.getCreator());
                    crmCustAddrRespVO.setModifyTime(addr.getModifyTime());
                    crmCustAddrRespVO.setCreateTime(addr.getCreateTime());
                    return crmCustAddrRespVO;
                }).collect(Collectors.toList());
                respVO.setAddrList(crmCustAddrRespVOS);
            }
            if (!ObjectUtils.isEmpty((Object)orgAddr) && !CollectionUtils.isEmpty((Collection)orgAddr.getOrgAddrBankAccVos())) {
                respVO.setAddrId(orgAddr.getId());
                List orgAddrBankAccRespVOS = orgAddr.getOrgAddrBankAccVos().stream().map(bank -> {
                    if (StringUtil.isBlank((CharSequence)bank.getCreator())) {
                        bank.setCreator(bank.getUpdater());
                    }
                    return crmCustConvert.bankRpcToAddrVo((OrgAddrBankAccRpcDTO)bank);
                }).collect(Collectors.toList());
                respVO.setOrgAddrBankAccList(orgAddrBankAccRespVOS);
            }
            if (!ObjectUtils.isEmpty((Object)orgAddr) && !CollectionUtils.isEmpty((Collection)orgAddr.getOrgAddrQualifyVos())) {
                respVO.setAddrId(orgAddr.getId());
                List qualifyFileNos = orgAddr.getOrgAddrQualifyVos().stream().map(OrgAddrQualifyRpcDTO::getQualifyNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List comSaleFileComVOS = this.comSaleFileInfoService.findFileByBusinessId("CUST", respVO.getId());
                List custQualifyRespVOS = orgAddr.getOrgAddrQualifyVos().stream().map(qualify -> {
                    CrmCustQualifyRespVO crmCustQualifyRespVO = crmCustConvert.qualifyRpcToAddrVo((OrgAddrQualifyRpcDTO)qualify);
                    if (!CollectionUtils.isEmpty((Collection)qualifyFileNos)) {
                        comSaleFileComVOS.stream().filter(cust -> cust.getQualifyNo().equals(qualify.getQualifyNo())).findFirst().ifPresent(arg_0 -> ((CrmCustQualifyRespVO)crmCustQualifyRespVO).setEnclosure(arg_0));
                    }
                    return crmCustQualifyRespVO;
                }).collect(Collectors.toList());
                respVO.setQualifyList(custQualifyRespVOS);
            }
        }
    }

    private void addInterCustName(CrmCustDetailRespVO respVO) {
        if (UdcEnum.CRM_CUST_TYPE2_D.getValueCode().equals(respVO.getCustType2())) {
            OrgEmpRpcDtoParam orgEmpRpcDtoParam = new OrgEmpRpcDtoParam();
            ArrayList<String> empCodes = new ArrayList<String>();
            empCodes.add(respVO.getCustCode());
            orgEmpRpcDtoParam.setEmpCodes(empCodes);
            List<OrgEmpRpcDTO> empDtoByParam = this.rmiOrgEmpService.findEmpListByParam(orgEmpRpcDtoParam);
            empDtoByParam.stream().filter(emp -> emp.getEmpCode().equals(respVO.getCustCode())).findFirst().ifPresent(empD -> respVO.setCustCodePopupName(empD.getEmpName()));
        }
        if (UdcEnum.CRM_CUST_TYPE2_C.getValueCode().equals(respVO.getCustType2())) {
            OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
            ArrayList<String> ouCodes = new ArrayList<String>();
            ouCodes.add(respVO.getCustCode());
            orgOuRpcDtoParam.setOuCodes(ouCodes);
            List<OrgOuRpcDTO> ouDtoByParam = this.rmiOrgOuService.findOuDtoListByParam(orgOuRpcDtoParam);
            ouDtoByParam.stream().filter(ou -> ou.getOuCode().equals(respVO.getCustCode())).findFirst().ifPresent(ouD -> respVO.setCustCodePopupName(ouD.getOuName()));
        }
    }

    public String getRandom() {
        String BASIC = "123456789qwertyuiopasdfghjklzxcvbnm";
        char[] basicArray = BASIC.toCharArray();
        Random random = new Random();
        char[] result = new char[6];
        for (int i = 0; i < result.length; ++i) {
            int index = random.nextInt(100) % basicArray.length;
            result[i] = basicArray[index];
        }
        return new String(result);
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<CrmCustDetailRespVO> save(CrmCustSaveVO saveVO) {
        if (org.springframework.util.StringUtils.isEmpty((Object)saveVO.getCustCode())) {
            String custCode = this.rmiSysNextNumberService.generateCode("yst-sale", "C", new ArrayList<String>());
            saveVO.setCustCode(custCode);
        }
        this.checkForSave(saveVO);
        ArrayList<ComSaleFileComVO> comSaleFileComVOS = new ArrayList<ComSaleFileComVO>();
        OrgAddrRpcSaveParam param = this.addrHandle(saveVO, comSaleFileComVOS);
        saveVO.setSecBuId(saveVO.getBuId());
        saveVO.setSecOuId(saveVO.getOuId());
        saveVO.setSecUserId(saveVO.getAgentEmpId());
        CrmCustDO crmCustDO = this.saveVoDo(saveVO);
        ApiResult<Long> addrNo1 = this.rmiOrgAddrService.orgAddrSaveOrUpdateReturnAddrNo(param);
        Assert.isFalse((!addrNo1.isSuccess() ? 1 : 0) != 0, (String)addrNo1.getMsg(), (Object[])new Object[0]);
        Long addrNo = (Long)addrNo1.getData();
        crmCustDO.setAddrNo(addrNo);
        saveVO.setAddrNo(addrNo);
        CrmCustDO custDO = (CrmCustDO)this.crmCustRepo.save(crmCustDO);
        comSaleFileComVOS.forEach(k -> k.setBusinessId(custDO.getId()));
        this.comSaleFileInfoService.comSaleFileHardSave("CUST", custDO.getId(), comSaleFileComVOS);
        this.saveCustAccount(custDO.getCustCode(), saveVO.getCustAccountVO(), saveVO.getBusinessTypeCust());
        return ApiResult.ok((Object)CrmCustConvert.INSTANCE.doToDetailRespVO(custDO));
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<CrmCustDetailRespVO> bcSave(CrmCustSaveVO saveVO) {
        Long addrNo;
        if (org.springframework.util.StringUtils.isEmpty((Object)saveVO.getCustCode())) {
            String custCode = this.rmiSysNextNumberService.generateCode("yst-sale", "C", null);
            saveVO.setCustCode(custCode);
        }
        this.checkForSave(saveVO);
        ArrayList<ComSaleFileComVO> comSaleFileComVOS = new ArrayList<ComSaleFileComVO>();
        OrgAddrRpcSaveParam param = this.addrHandle(saveVO, comSaleFileComVOS);
        if (org.springframework.util.StringUtils.isEmpty((Object)saveVO.getCreatedBy())) {
            saveVO.setCreatedBy(Integer.valueOf(0));
        }
        saveVO.setIntfStatus("N");
        saveVO.setSecBuId(saveVO.getBuId());
        saveVO.setSecOuId(saveVO.getOuId());
        saveVO.setSecUserId(saveVO.getAgentEmpId());
        CrmCustDO crmCustDO = this.saveVoDo(saveVO);
        if (!"C".equals(saveVO.getCustType2())) {
            ApiResult<Long> addrNo1 = this.rmiOrgAddrService.orgAddrSaveOrUpdate(param);
            Assert.isFalse((!addrNo1.isSuccess() ? 1 : 0) != 0, (String)addrNo1.getMsg(), (Object[])new Object[0]);
            addrNo = (Long)addrNo1.getData();
        } else {
            addrNo = saveVO.getAddrNo();
        }
        crmCustDO.setAddrNo(addrNo);
        saveVO.setAddrNo(addrNo);
        CrmCustDO custDO = (CrmCustDO)this.crmCustRepo.save(crmCustDO);
        comSaleFileComVOS.forEach(k -> k.setBusinessId(custDO.getId()));
        this.comSaleFileInfoService.comSaleFileHardSave("CUST", custDO.getId(), comSaleFileComVOS);
        QBipCustUserBindDO qBipCustUserBindDO = QBipCustUserBindDO.bipCustUserBindDO;
        BooleanExpression e = qBipCustUserBindDO.deleteFlag.eq((Object)0).and((Predicate)qBipCustUserBindDO.custCode.eq((Object)saveVO.getCustCode()));
        Optional optional = this.bipCustUserBindRepo.findOne((Predicate)e);
        if (!optional.isEmpty()) {
            BipCustUserBindDO bipCustUserBindDO = (BipCustUserBindDO)optional.get();
            bipCustUserBindDO.setOuId(saveVO.getOuId());
            bipCustUserBindDO.setAgentEmpId(saveVO.getAgentEmpId());
            this.bipCustUserBindRepo.save(bipCustUserBindDO);
        }
        return ApiResult.ok((Object)CrmCustConvert.INSTANCE.doToDetailRespVO(custDO));
    }

    public ApiResult<Object> updateAgentEmpId(List<CustImportEmpDTO> datas) {
        ArrayList<CrmCustDO> res = new ArrayList<CrmCustDO>();
        List empCodes = datas.stream().map(CustImportEmpDTO::getEmpCode).collect(Collectors.toList());
        empCodes.removeAll(Collections.singletonList(null));
        if (!CollectionUtils.isEmpty(empCodes)) {
            for (int i = 0; i < datas.size(); ++i) {
                CrmCustDO cust;
                int row = i + 1;
                CustImportEmpDTO d = datas.get(i);
                ApiResult<SalesmanInfoDTO> saleMan = this.getSaleManInfoByEmpCode(d.getEmpCode());
                if (saleMan.isSuccess() && !ObjectUtils.isEmpty((Object)saleMan.getData())) {
                    cust = this.crmCustRepoProc.getCustInfoByCode(d.getCustCode());
                    if (ObjectUtils.isEmpty((Object)cust)) {
                        return ApiResult.fail((String)("\u7b2c" + row + "\u884c,\u5ba2\u6237\u7f16\u53f7\u4e3a" + d.getCustCode() + "\u7684\u5ba2\u6237\u4e0d\u5b58\u5728"));
                    }
                    cust.setAgentEmpId(((SalesmanInfoDTO)saleMan.getData()).getId());
                    Long agentEmpId2 = this.excuteAgentEmpId2(((SalesmanInfoDTO)saleMan.getData()).getId(), d.getCustCode());
                    if (null != agentEmpId2) {
                        cust.setAgentEmpId2(agentEmpId2);
                    }
                } else {
                    return ApiResult.fail((String)("\u7f16\u53f7\u4e3a\uff1a" + d.getEmpCode() + "\u7684\u5458\u5de5\u4e0d\u5b58\u5728"));
                }
                res.add(cust);
            }
        }
        this.crmCustRepo.saveAll(res);
        return ApiResult.ok();
    }

    public ApiResult<SalesmanInfoDTO> getSaleManInfoByEmpCode(String agentEmpCode) {
        SalesmanQueryDTO salesmanQueryDTO = new SalesmanQueryDTO();
        salesmanQueryDTO.setSalesmanCode(agentEmpCode);
        return this.salesmanInfoService.querySalesmanInfo(salesmanQueryDTO);
    }

    public void saveCustAccount(String custCode, CustAccountVO custAccountVO, String bussinessTypeCust) {
        CustAccountVO custAccount = this.custAccountRepoproc.getAccountByCustCode(custCode);
        if (ObjectUtils.isEmpty((Object)custAccount)) {
            this.custAccountRepoproc.saveAccountCust(custCode, custAccountVO);
        }
        if (!ObjectUtils.isEmpty((Object)custAccount) && custAccount.getIsOpenAccount().equals(Boolean.FALSE)) {
            custAccountVO.setId(custAccount.getId());
            this.custAccountRepoproc.saveAccountCust(custCode, custAccountVO);
        }
    }

    private void innerUpdateSyncDate(HttpHeaders headers, CrmCustMdmSyncRespVO crmCustMdmSyncRespVO, CrmCustSaveVO crmCustSaveVO) {
        CrmCustConvert crmCustConvert = CrmCustConvert.INSTANCE;
        if (!ObjectUtils.isEmpty((Object)crmCustMdmSyncRespVO) && crmCustMdmSyncRespVO.getCode().equals("0")) {
            String queryResponse = crmCustMdmSyncRespVO.getData();
            String str1 = Base64.decodeStr((CharSequence)queryResponse);
            CrmCustResponseDataRespVO parseObject = (CrmCustResponseDataRespVO)JSON.parseObject((String)str1, CrmCustResponseDataRespVO.class);
            List custMasterDataIntfList = parseObject.getCustMasterDataIntfList();
            Optional<CrmCustMasterDataRespVO> masterDataRespVO = custMasterDataIntfList.stream().filter(cust -> crmCustSaveVO.getTaxRegNo().equals(cust.getLicenseNo2())).findFirst();
            if (masterDataRespVO.isPresent()) {
                // empty if block
            }
        } else {
            throw new BusinessException("\u5185\u90e8\u5ba2\u6237Mdm\u540c\u6b65\u5f02\u5e38");
        }
        CrmCustDO crmCustDO = new CrmCustDO();
        crmCustConvert.copyVoToDo(crmCustSaveVO, crmCustDO);
        this.crmCustRepo.save(crmCustDO);
    }

    private void addAndUpdateSyncDate(HttpHeaders headers, CrmCustMdmSyncRespVO crmCustMdmSyncRespVO, CrmCustSaveVO crmCustSaveVO) {
        String userName;
        AtomicReference<Boolean> ifExtis = new AtomicReference<Boolean>(false);
        CrmCustConvert crmCustConvert = CrmCustConvert.INSTANCE;
        CrmCustMdmSyncConvert crmCustMdmSyncConvert = CrmCustMdmSyncConvert.INSTANCE;
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        String string = userName = Objects.isNull(currentUserDTO) || Objects.isNull(currentUserDTO.getUserName()) ? "admin" : currentUserDTO.getUserName();
        if (!ObjectUtils.isEmpty((Object)crmCustMdmSyncRespVO) && crmCustMdmSyncRespVO.getCode().equals("0")) {
            String queryResponse = crmCustMdmSyncRespVO.getData();
            String str1 = Base64.decodeStr((CharSequence)queryResponse);
            CrmCustResponseDataRespVO parseObject = (CrmCustResponseDataRespVO)JSON.parseObject((String)str1, CrmCustResponseDataRespVO.class);
            List custMasterDataIntfList = parseObject.getCustMasterDataIntfList();
            Optional<CrmCustMasterDataRespVO> masterDataRespVO = custMasterDataIntfList.stream().filter(cust -> crmCustSaveVO.getTaxRegNo().equals(cust.getLicenseNo2())).findFirst();
            if (masterDataRespVO.isPresent()) {
                CrmCustDO crmCustDO = new CrmCustDO();
                crmCustConvert.copyVoToDo(crmCustSaveVO, crmCustDO);
                this.crmCustRepo.save(crmCustDO);
            }
        } else {
            log.info("\u540c\u6b65\u5931\u8d25\u6570\u636e2{}", (Object)JSON.toJSONString((Object)crmCustMdmSyncRespVO));
            throw new BusinessException("\u540c\u6b65\u5931\u8d252" + JSON.toJSONString((Object)crmCustMdmSyncRespVO));
        }
    }

    private void updateNRPSyncDate(HttpHeaders headers, CrmCustMdmSyncRespVO crmCustMdmSyncRespVO, CrmCustSaveVO crmCustSaveVO) {
        String queryResponse;
        String str1;
        CrmCustResponseDataRespVO parseObject;
        List custMasterDataIntfList;
        Optional<CrmCustMasterDataRespVO> masterDataRespVO;
        String userName;
        AtomicReference<Boolean> ifExtis = new AtomicReference<Boolean>(false);
        CrmCustConvert crmCustConvert = CrmCustConvert.INSTANCE;
        CrmCustMdmSyncConvert crmCustMdmSyncConvert = CrmCustMdmSyncConvert.INSTANCE;
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        String string = userName = Objects.isNull(currentUserDTO) || Objects.isNull(currentUserDTO.getUserName()) ? "admin" : currentUserDTO.getUserName();
        if (!ObjectUtils.isEmpty((Object)crmCustMdmSyncRespVO) && crmCustMdmSyncRespVO.getCode().equals("0") && (masterDataRespVO = (custMasterDataIntfList = (parseObject = (CrmCustResponseDataRespVO)JSON.parseObject((String)(str1 = Base64.decodeStr((CharSequence)(queryResponse = crmCustMdmSyncRespVO.getData()))), CrmCustResponseDataRespVO.class)).getCustMasterDataIntfList()).stream().filter(cust -> crmCustSaveVO.getTaxRegNo().equals(cust.getLicenseNo2())).findFirst()).isPresent() && crmCustSaveVO.getCustCode().equals(masterDataRespVO.get().getOrgnCustNo())) {
            CrmCustMasterDataRespVO crmCustMasterDataRespVO = masterDataRespVO.get();
            SimpleDateFormat sdfSave = new SimpleDateFormat(DATEFORMAT2);
            CrmCustMdmSyncSaveVO crmCustMdmSyncSaveVO = new CrmCustMdmSyncSaveVO();
            crmCustMdmSyncSaveVO.setBatch("");
            crmCustMdmSyncSaveVO.setIfaceCode(IFACECODE_UP_DATA);
            String requestSaveID = sdfSave.format(new Date());
            crmCustMdmSyncSaveVO.setRequestID(requestSaveID);
            CrmCustMdmRequstSaveVO crmCustMdmRequstSaveVO = new CrmCustMdmRequstSaveVO();
            crmCustMdmRequstSaveVO.setIfaceCode(IFACECODE_UP_DATA);
            crmCustMdmRequstSaveVO.setVersion("");
            ArrayList<CrmCustMdmSyncDataSaveVO> dataSaveVOS = new ArrayList<CrmCustMdmSyncDataSaveVO>();
            CrmCustMdmSyncDataSaveVO custMdmSyncDataSaveVO = crmCustMdmSyncConvert.responseToSaveVo(crmCustMasterDataRespVO);
            custMdmSyncDataSaveVO.setCustName(crmCustSaveVO.getCustName());
            if (UdcEnum.CRM_CUST_STATUS_ACTIVE.getValueCode().equals(crmCustSaveVO.getCustStatus())) {
                custMdmSyncDataSaveVO.setCustStat("Y");
            } else {
                custMdmSyncDataSaveVO.setCustStat("N");
            }
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern(DATEFORMAT);
            custMdmSyncDataSaveVO.setUpdateTime(LocalDateTime.now().format(dtf));
            if (!org.springframework.util.StringUtils.isEmpty((Object)crmCustSaveVO.getCreateTime())) {
                custMdmSyncDataSaveVO.setCrtDate(crmCustSaveVO.getCreateTime().format(dtf));
            } else {
                custMdmSyncDataSaveVO.setCrtDate(LocalDateTime.now().format(dtf));
            }
            if (!org.springframework.util.StringUtils.isEmpty((Object)crmCustSaveVO.getCreator())) {
                custMdmSyncDataSaveVO.setCrtName(crmCustSaveVO.getCreator());
            } else {
                custMdmSyncDataSaveVO.setCrtName(userName);
            }
            custMdmSyncDataSaveVO.setLstupdtName(userName);
            custMdmSyncDataSaveVO.setLstupdtDate(LocalDateTime.now().format(dtf));
            custMdmSyncDataSaveVO.setDataType("\u66f4\u65b0");
            ArrayList<CustSyncBaseDataLine> custSyncBaseDataLines = new ArrayList<CustSyncBaseDataLine>();
            CustSyncBaseDataLine custSyncBaseDataLine = new CustSyncBaseDataLine();
            custSyncBaseDataLine.setLineType("LXR");
            custSyncBaseDataLine.setLicenseNo2(crmCustSaveVO.getTaxRegNo());
            CustSyncBaseDataLine custSyncBaseDataLine2 = new CustSyncBaseDataLine();
            custSyncBaseDataLine2.setLineType("YH");
            custSyncBaseDataLine2.setLicenseNo2(crmCustSaveVO.getTaxRegNo());
            CustSyncBaseDataLine custSyncBaseDataLine3 = new CustSyncBaseDataLine();
            custSyncBaseDataLine3.setLineType("DZ");
            custSyncBaseDataLine3.setLicenseNo2(crmCustSaveVO.getTaxRegNo());
            custSyncBaseDataLines.add(custSyncBaseDataLine);
            custSyncBaseDataLines.add(custSyncBaseDataLine2);
            custSyncBaseDataLines.add(custSyncBaseDataLine3);
            custMdmSyncDataSaveVO.setCustMasterDataLineImpTemp(custSyncBaseDataLines);
            dataSaveVOS.add(custMdmSyncDataSaveVO);
            crmCustMdmRequstSaveVO.setCustMasterDataList(dataSaveVOS);
            String saveQueryJson = JSON.toJSONString((Object)crmCustMdmRequstSaveVO);
            String requestSaveData = Base64.encode((CharSequence)saveQueryJson);
            crmCustMdmSyncSaveVO.setRequestData(requestSaveData);
            Object custMdmSyncRespVO = null;
            if (!ObjectUtils.isEmpty(custMdmSyncRespVO) && custMdmSyncRespVO.getCode().equals("0")) {
                CrmCustDO crmCustDO = new CrmCustDO();
                crmCustConvert.copyVoToDo(crmCustSaveVO, crmCustDO);
                this.crmCustRepo.save(crmCustDO);
            }
            ifExtis.set(true);
        }
    }

    private void updateERPSyncDate(HttpHeaders headers, CrmCustMdmSyncRespVO crmCustMdmSyncRespVO, CrmCustSaveVO crmCustSaveVO) {
        String queryResponse;
        String str1;
        CrmCustResponseDataRespVO parseObject;
        List custMasterDataIntfList;
        Optional<CrmCustMasterDataRespVO> masterDataRespVO;
        CrmCustConvert crmCustConvert = CrmCustConvert.INSTANCE;
        if (!ObjectUtils.isEmpty((Object)crmCustMdmSyncRespVO) && crmCustMdmSyncRespVO.getCode().equals("0") && (masterDataRespVO = (custMasterDataIntfList = (parseObject = (CrmCustResponseDataRespVO)JSON.parseObject((String)(str1 = Base64.decodeStr((CharSequence)(queryResponse = crmCustMdmSyncRespVO.getData()))), CrmCustResponseDataRespVO.class)).getCustMasterDataIntfList()).stream().filter(cust -> crmCustSaveVO.getTaxRegNo().equals(cust.getLicenseNo2())).findFirst()).isPresent() && !crmCustSaveVO.getCustCode().equals(masterDataRespVO.get().getOrgnCustNo())) {
            CrmCustMasterDataRespVO crmCustMasterDataRespVO = masterDataRespVO.get();
            CrmCustDO crmCustDO = new CrmCustDO();
            crmCustConvert.copyVoToDo(crmCustSaveVO, crmCustDO);
            this.crmCustRepo.save(crmCustDO);
        }
    }

    private OrgAddrRpcSaveParam addrHandle(CrmCustSaveVO saveVO, List<ComSaleFileComVO> comSaleFileComVOS) {
        OrgAddrRpcSaveParam param = new OrgAddrRpcSaveParam();
        CrmCustConvert crmCustConvert = CrmCustConvert.INSTANCE;
        param.setId(saveVO.getAddrId());
        param.setAddrNo(saveVO.getAddrNo());
        param.setAddrName(saveVO.getCustName());
        param.setAddrType(UdcEnum.ORG_ADDR_TYPE_CUST.getValueCode());
        param.setDataSources(Collections.singletonList(UdcEnum.ORG_ADDR_TYPE_CUST.getValueCode()));
        if (!CollectionUtils.isEmpty((Collection)saveVO.getAddrList())) {
            List custAddrSaveVOS = saveVO.getAddrList();
            List addrAddressRpcSaveParams = custAddrSaveVOS.stream().map(add -> {
                OrgAddrAddressRpcSaveParam orgAddrAddress = crmCustConvert.saveVoToAddrRpc((CrmCustAddrSaveVO)add);
                if (StringUtil.isBlank((CharSequence)add.getAddressType())) {
                    orgAddrAddress.setAddressType(UdcEnum.ORG_ADDRESS_TYPE_DEFAULT.getValueCode());
                }
                orgAddrAddress.setId(add.getId());
                orgAddrAddress.setMobile(add.getContMobile());
                orgAddrAddress.setTel(add.getContTel());
                orgAddrAddress.setFax(add.getContFax());
                orgAddrAddress.setEmail(add.getContEmail());
                orgAddrAddress.setDetailAddr(add.getDetailaddr());
                orgAddrAddress.setDataSource(UdcEnum.ORG_ADDR_TYPE_CUST.getValueCode());
                return orgAddrAddress;
            }).collect(Collectors.toList());
            param.setOrgAddrAddressSaveParams(addrAddressRpcSaveParams);
        }
        if (!CollectionUtils.isEmpty((Collection)saveVO.getOrgAddrBankAccList())) {
            List bankAccSaveVOS = saveVO.getOrgAddrBankAccList();
            List bankAccRpcSaveParams = bankAccSaveVOS.stream().map(add -> {
                add.setDataSource(UdcEnum.ORG_ADDR_TYPE_CUST.getValueCode());
                return crmCustConvert.saveVoToBankRpc((OrgAddrBankAccSaveVO)add);
            }).collect(Collectors.toList());
            param.setOrgAddrBankAccSaveParams(bankAccRpcSaveParams);
        }
        if (!CollectionUtils.isEmpty((Collection)saveVO.getQualifyList())) {
            List crmCustQualifySaveVOS = saveVO.getQualifyList();
            List addrQualifyRpcSaveParams = crmCustQualifySaveVOS.stream().map(qualify -> {
                OrgAddrQualifyRpcSaveParam orgAddrQualify = crmCustConvert.saveVoToQualifyRpc((CrmCustQualifySaveVO)qualify);
                orgAddrQualify.setDataSource(UdcEnum.ORG_ADDR_TYPE_CUST.getValueCode());
                ComSaleFileComVO comSaleFileComVO = new ComSaleFileComVO();
                orgAddrQualify.setQualifyFileId(qualify.getQualifyOuId());
                if (!ObjectUtils.isEmpty((Object)qualify.getEnclosure())) {
                    comSaleFileComVO.setQualifyNo(qualify.getQualifyNo());
                    comSaleFileComVO.setFileCode(qualify.getEnclosure().getFileCode());
                    comSaleFileComVO.setOriginalName(qualify.getEnclosure().getOriginalName());
                    comSaleFileComVOS.add(comSaleFileComVO);
                }
                this.comSaleFileInfoService.comSaleFileHardSave("CUST", qualify.getQualifyNo(), List.of(comSaleFileComVO));
                return orgAddrQualify;
            }).collect(Collectors.toList());
            param.setOrgAddrQualifySaveParams(addrQualifyRpcSaveParams);
        }
        return param;
    }

    @Transactional(rollbackFor={Exception.class})
    public void switchStatusByIds(CustSwitchStatusParamVO paramVO) {
        if (ObjectUtils.isEmpty((Object)paramVO) && CollectionUtils.isEmpty((Collection)paramVO.getCustIds())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u672a\u9009\u62e9\u5ba2\u6237");
        }
        List<CrmCustDetailRespVO> custDetailRespVOS = this.findIdBatch(paramVO.getCustIds());
        custDetailRespVOS.forEach(cust -> cust.setCustStatus(paramVO.getCustStatus()));
        List crmCustDOS = custDetailRespVOS.stream().map(CrmCustConvert.INSTANCE::detailVoToDo).collect(Collectors.toList());
        this.crmCustRepo.saveAll(crmCustDOS);
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<List<CrmCustImportSaveVO>> custImportData(List<CrmCustImportSaveVO> parseData) {
        return ApiResult.fail();
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<List<CrmAddrImplSaveVO>> custaddrImportData(List<CrmAddrImplSaveVO> parseData) {
        CrmCustConvert crmCustConvert = CrmCustConvert.INSTANCE;
        ApiResult<List<CrmAddrImplSaveVO>> crmCustImportData = this.checkAndHandleAddrImportData(parseData);
        List custImportDataData = (List)crmCustImportData.getData();
        List custCodes = custImportDataData.stream().map(CrmAddrImplSaveVO::getCustCode).distinct().collect(Collectors.toList());
        CrmCustQueryParamVO crmCustQueryParamVO = new CrmCustQueryParamVO();
        crmCustQueryParamVO.setCustCodes(custCodes);
        crmCustQueryParamVO.setTransFlag(Boolean.valueOf(false));
        List crmCustSaveVOS = this.searching1(crmCustQueryParamVO).stream().map(CrmCustConvert.INSTANCE::doToSaveVO).collect(Collectors.toList());
        Map<String, List<CrmAddrImplSaveVO>> importListMap = parseData.stream().collect(Collectors.groupingBy(CrmAddrImplSaveVO::getCustCode));
        ArrayList<CrmCustDO> crmCustDOS = new ArrayList<CrmCustDO>();
        for (String key : importListMap.keySet()) {
            CrmCustSaveVO crmCustSaveVO = crmCustSaveVOS.stream().filter(resp -> resp.getCustCode().equals(key)).findFirst().orElseThrow(new BusinessException("\u5ba2\u6237\u7f16\u7801\u4e3a\u3010" + key + "\u3011\u7684\u6570\u636e\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5"));
            OrgAddrRpcSaveParam param = new OrgAddrRpcSaveParam();
            param.setId(null);
            param.setAddrNo(crmCustSaveVO.getAddrNo());
            param.setAddrName(crmCustSaveVO.getCustName());
            param.setAddrType(UdcEnum.ORG_ADDR_TYPE_CUST.getValueCode());
            ArrayList<OrgAddrAddressRpcSaveParam> orgAddrAddressRpcSaveParams = new ArrayList<OrgAddrAddressRpcSaveParam>();
            for (CrmAddrImplSaveVO crmAddrImplSaveVO : importListMap.get(key)) {
                OrgAddrAddressRpcSaveParam orgAddrAddressRpcSaveParam = CrmCustConvert.INSTANCE.addrImportVoToDo(crmAddrImplSaveVO);
                orgAddrAddressRpcSaveParams.add(orgAddrAddressRpcSaveParam);
            }
            param.setOrgAddrAddressSaveParams(orgAddrAddressRpcSaveParams);
            ApiResult<Long> addrNo = this.rmiOrgAddrService.orgAddrSaveOrUpdate(param);
            Assert.isFalse((!addrNo.isSuccess() ? 1 : 0) != 0, (String)addrNo.getMsg(), (Object[])new Object[0]);
            crmCustSaveVO.setAddrNo((Long)addrNo.getData());
            CrmCustDO crmCustDO = new CrmCustDO();
            crmCustConvert.copyVoToDo(crmCustSaveVO, crmCustDO);
            crmCustDOS.add(crmCustDO);
        }
        this.crmCustRepo.saveAll(crmCustDOS);
        return ApiResult.ok(parseData);
    }

    @Transactional(rollbackFor={Exception.class})
    public void empAssign(CrmEmpAssignParamVO crmEmpAssignParamVO) {
        Assert.notNull((Object)crmEmpAssignParamVO, (String)"\u66f4\u65b0\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
        this.crmCustRepo.updateCustAgentEmp(crmEmpAssignParamVO.getAgentEmpId(), crmEmpAssignParamVO.getCustIds());
    }

    public List<CrmCustAddrRespVO> findAddrsByParam(CrmCustAddrParamVO crmCustAddrParamVO) {
        if (org.springframework.util.StringUtils.isEmpty((Object)crmCustAddrParamVO.getAddrNo())) {
            return new ArrayList<CrmCustAddrRespVO>();
        }
        List orgAddrAddressRpcDTOS = new ArrayList();
        ApiResult<OrgAddrDetailsRpcDTO> addrByAddrNo = this.rmiOrgAddrService.findAddrByAddrNo(crmCustAddrParamVO.getAddrNo());
        if (addrByAddrNo.isSuccess() && !ObjectUtils.isEmpty((Object)addrByAddrNo.getData())) {
            orgAddrAddressRpcDTOS = ((OrgAddrDetailsRpcDTO)addrByAddrNo.getData()).getOrgAddrAddressVos();
        }
        List<Object> custAddrRespVOS = new ArrayList<CrmCustAddrRespVO>();
        if (!CollectionUtils.isEmpty(orgAddrAddressRpcDTOS)) {
            custAddrRespVOS = orgAddrAddressRpcDTOS.stream().map(CrmCustConvert.INSTANCE::addrRpcToAddrVo).collect(Collectors.toList());
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)crmCustAddrParamVO.getContPerson())) {
            custAddrRespVOS = custAddrRespVOS.stream().filter(cust -> cust.getContPerson().contains(crmCustAddrParamVO.getContPerson())).collect(Collectors.toList());
        }
        return custAddrRespVOS;
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<CrmCustDetailRespVO> saveLm(CrmCustSaveVO saveVO) {
        String firstCustCode = saveVO.getCustCode();
        if (org.springframework.util.StringUtils.isEmpty((Object)saveVO.getCustCode())) {
            Boolean isExistsUserName;
            if (StringUtil.isNotBlank((CharSequence)saveVO.getContactPhone()) && (isExistsUserName = this.isExistsMobile(saveVO.getContactPhone(), saveVO.getBusinessTypeCust())).booleanValue()) {
                return ApiResult.fail((String)"\u624b\u673a\u53f7\u5df2\u5b58\u5728\u8bf7\u4fee\u6539\u624b\u673a\u53f7");
            }
            String custCode = this.rmiSysNextNumberService.generateCode("yst-sale", "C", new ArrayList<String>());
            saveVO.setCustCode(custCode);
        } else {
            Long agentEmpId2 = this.excuteAgentEmpId2(saveVO.getAgentEmpId(), saveVO.getCustCode());
            if (null != agentEmpId2) {
                saveVO.setAgentEmpId2(agentEmpId2);
            }
        }
        this.checkForSave(saveVO);
        ArrayList<ComSaleFileComVO> comSaleFileComVOS = new ArrayList<ComSaleFileComVO>();
        OrgAddrRpcSaveParam param = this.addrHandle(saveVO, comSaleFileComVOS);
        saveVO.setSecBuId(saveVO.getBuId());
        saveVO.setSecOuId(saveVO.getOuId());
        CrmCustDO crmCustDO = this.saveVoDo(saveVO);
        ApiResult<Long> addrNo1 = this.rmiOrgAddrService.orgAddrSaveOrUpdateReturnAddrNo(param);
        Assert.isFalse((!addrNo1.isSuccess() ? 1 : 0) != 0, (String)addrNo1.getMsg(), (Object[])new Object[0]);
        Long addrNo = (Long)addrNo1.getData();
        crmCustDO.setAddrNo(addrNo);
        saveVO.setAddrNo(addrNo);
        CrmCustDO custDO = (CrmCustDO)this.crmCustRepo.save(crmCustDO);
        comSaleFileComVOS.forEach(k -> k.setBusinessId(custDO.getId()));
        this.comSaleFileInfoService.comSaleFileHardSave("CUST", custDO.getId(), comSaleFileComVOS);
        return ApiResult.ok((Object)CrmCustConvert.INSTANCE.doToDetailRespVO(custDO));
    }

    public List<LmSaveCustRespVO> getCustInfoByRegion(List<String> region) {
        return this.crmCustRepoProc.getCustInfoByRegion(region);
    }

    public Boolean isExistsUserName(String userName) {
        QCustAccountDO qCustAccountDO = QCustAccountDO.custAccountDO;
        BooleanExpression e = qCustAccountDO.userName.eq((Object)userName).and((Predicate)qCustAccountDO.deleteFlag.eq((Object)0));
        Long count = this.custAccountRepo.count((Predicate)e);
        if (count == 0L) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Boolean isExistsMobile(String mobile, String businessTypeCust) {
        QCustAccountDO qCustAccountDO = QCustAccountDO.custAccountDO;
        BooleanExpression e = qCustAccountDO.mobile.eq((Object)mobile).and((Predicate)qCustAccountDO.deleteFlag.eq((Object)0)).and((Predicate)qCustAccountDO.dealerType.in((Object[])new String[]{"ONE", "TWO"})).and((Predicate)qCustAccountDO.businessTypeCust.eq((Object)businessTypeCust));
        Long count = this.custAccountRepo.count((Predicate)e);
        if (count == 0L) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Long excuteAgentEmpId2(Long agentEmpId, String custCode) {
        Long oldAgentEmpId;
        if (null != agentEmpId && null != (oldAgentEmpId = this.crmCustRepoProc.getAgentEmpId(custCode)) && !agentEmpId.equals(oldAgentEmpId)) {
            return oldAgentEmpId;
        }
        return null;
    }

    public void custMdmSync(Long id) {
    }

    public Boolean findCustByCode(String custCode) {
        return this.crmCustRepoProc.existsCode(custCode, null);
    }

    public List<CrmCustAddrRespVO> findAddrsByCustCode(String custCode) {
        Long addrNo = this.crmCustRepoProc.getaddrNoByCode(custCode);
        CrmCustAddrParamVO crmCustAddrParamVO = new CrmCustAddrParamVO();
        crmCustAddrParamVO.setAddrNo(addrNo);
        return this.findAddrsByParam(crmCustAddrParamVO);
    }

    public PagingVO<CrmCustSimpleVO> checkQuery(CrmCustCheckParamVO paramVO) {
        BooleanExpression predicate = qCrmCustDO.isNotNull();
        predicate = this.appendCommon((Predicate)predicate);
        if (null != paramVO.getOuId()) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.ouId.eq((Object)paramVO.getOuId()));
        }
        Page res = this.crmCustRepo.findAll((Predicate)predicate, (Pageable)this.wrapperPageRequest(paramVO.getPageRequest(), null));
        Long total = res.getTotalElements();
        List crmCustDOList = res.getContent();
        CrmCustConvert crmCustConvert = CrmCustConvert.INSTANCE;
        List respVOList = crmCustDOList.stream().map(t -> {
            CrmCustSimpleVO respVO = crmCustConvert.do2SimpleVo((CrmCustDO)t);
            return respVO;
        }).collect(Collectors.toList());
        return new PagingVO(total.longValue(), respVOList);
    }

    public RmiOuInfoByAddr getOuByAddr(Long addrNo) {
        Assert.notNull((Object)addrNo, (String)"\u5730\u5740\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ApiResult<OrgAddrDetailsRpcDTO> result = this.rmiOrgAddrService.findAddrByAddrNo(addrNo);
        OrgAddrDetailsRpcDTO data = (OrgAddrDetailsRpcDTO)result.getData();
        RmiOuInfoByAddr addr = new RmiOuInfoByAddr();
        if (data == null) {
            return addr;
        }
        List orgAddrAddressVos = data.getOrgAddrAddressVos();
        List orgAddrBankAccVos = data.getOrgAddrBankAccVos();
        List orgAddrQualifyVos = data.getOrgAddrQualifyVos();
        RmiOuInfoByAddrConvert convert = RmiOuInfoByAddrConvert.INSTANCE;
        if (!CollUtil.isEmpty((Collection)orgAddrAddressVos)) {
            addr.setOrgAddrAddressVos(convert.addrDTO2VOS(orgAddrAddressVos));
        }
        if (!CollUtil.isEmpty((Collection)orgAddrBankAccVos)) {
            addr.setOrgAddrBankAccVos(convert.bankDTO2VOS(orgAddrBankAccVos));
        }
        if (!CollUtil.isEmpty((Collection)orgAddrQualifyVos)) {
            addr.setOrgAddrQualifyVos(convert.qualifyDTO2VOS(orgAddrQualifyVos));
        }
        return addr;
    }

    public RmiOuDetailVO getOuByCode(String ouCode) {
        Assert.notNull((Object)ouCode, (String)"\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        OrgOuRpcDtoParam param = new OrgOuRpcDtoParam();
        param.setOuCodes(Collections.singletonList(ouCode));
        List<OrgOuRpcDTO> ouDtoListByParam = this.rmiOrgOuService.findOuDtoListByParam(param);
        if (ouDtoListByParam == null || ouDtoListByParam.size() == 0) {
            return null;
        }
        OrgOuRpcDTO ouRpcDTO = ouDtoListByParam.get(0);
        RmiOuInfoByAddrConvert convert = RmiOuInfoByAddrConvert.INSTANCE;
        return convert.ouDTO2VO(ouRpcDTO);
    }

    public Object updateContactPhone(CrmCustFixPhoneParamVO crmCustFixPhoneParamVO) {
        Optional crmCust;
        BipCustUserBindDO bind;
        Long custId;
        QBipCustUserBindDO qBipCustUserBindDO = QBipCustUserBindDO.bipCustUserBindDO;
        BooleanExpression expression = qBipCustUserBindDO.userId.eq((Object)crmCustFixPhoneParamVO.getUserId()).and((Predicate)qBipCustUserBindDO.deleteFlag.eq((Object)0));
        Optional optional = this.bipCustUserBindRepo.findOne((Predicate)expression);
        if (!(optional.isEmpty() || org.springframework.util.StringUtils.isEmpty((Object)(custId = (bind = (BipCustUserBindDO)optional.get()).getCustId())) || (crmCust = this.crmCustRepo.findById(custId)).isEmpty())) {
            CrmCustDO crmCustDO = (CrmCustDO)crmCust.get();
            crmCustDO.setContactPhone(crmCustFixPhoneParamVO.getNewMobile());
            this.crmCustRepo.save(crmCustDO);
        }
        return null;
    }

    public SevenCustVo select(SevenCustDto custDto, String token, String tokenId) {
        if (custDto == null && token == null && tokenId == null) {
            return null;
        }
        SevenCustVo sevenCustVo = new SevenCustVo();
        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        orgOuRpcDtoParam.setOuIds(Collections.singletonList(custDto.getOuId()));
        List<OrgOuRpcDTO> ouDtoListByParam = this.rmiOrgOuService.findOuDtoListByParam(orgOuRpcDtoParam);
        if (ouDtoListByParam == null || ouDtoListByParam.size() == 0) {
            return null;
        }
        for (OrgOuRpcDTO dto : ouDtoListByParam) {
            sevenCustVo.setOuName(dto.getOuName());
        }
        CrmCustQueryParamVO crmCustQueryParamVO = new CrmCustQueryParamVO();
        crmCustQueryParamVO.setCustCodes(Collections.singletonList(custDto.getCustCode()));
        crmCustQueryParamVO.setTransFlag(Boolean.valueOf(false));
        List crmCustSaveVOS = this.searching1(crmCustQueryParamVO).stream().map(CrmCustConvert.INSTANCE::doToSaveVO).collect(Collectors.toList());
        for (CrmCustSaveVO custSaveVO : crmCustSaveVOS) {
            sevenCustVo.setCustName(custSaveVO.getCustName());
            sevenCustVo.setTaxRegNo(custSaveVO.getTaxRegNo());
            sevenCustVo.setCustType(custSaveVO.getCustType());
            sevenCustVo.setContactName(custSaveVO.getContactName());
            sevenCustVo.setContactPhone(custSaveVO.getContactPhone());
        }
        return sevenCustVo;
    }

    public List<CrmCustAddrRespVO> queryCustAddr() {
        Long addrNo = this.getAddrNo();
        ApiResult<OrgAddrDetailsRpcDTO> rpcDtoByAddrNo = this.rmiOrgAddrService.findAddrByAddrNo(addrNo);
        Assert.isFalse((!rpcDtoByAddrNo.isSuccess() ? 1 : 0) != 0, (String)rpcDtoByAddrNo.getMsg(), (Object[])new Object[0]);
        OrgAddrDetailsRpcDTO orgAddr = (OrgAddrDetailsRpcDTO)rpcDtoByAddrNo.getData();
        if (!ObjectUtils.isEmpty((Object)orgAddr) && !CollectionUtils.isEmpty((Collection)orgAddr.getOrgAddrAddressVos())) {
            CrmCustConvert crmCustConvert = CrmCustConvert.INSTANCE;
            List<CrmCustAddrRespVO> crmCustAddrRespVOS = orgAddr.getOrgAddrAddressVos().stream().map(addr -> {
                CrmCustAddrRespVO crmCustAddrRespVO = crmCustConvert.addrRpcToAddrVo((OrgAddrAddressRpcDTO)addr);
                crmCustAddrRespVO.setContEmail(addr.getEmail());
                crmCustAddrRespVO.setContFax(addr.getFax());
                crmCustAddrRespVO.setContMobile(addr.getMobile());
                crmCustAddrRespVO.setContTel(addr.getTel());
                crmCustAddrRespVO.setDetailaddr(addr.getDetailAddr());
                return crmCustAddrRespVO;
            }).collect(Collectors.toList());
            return crmCustAddrRespVOS;
        }
        return new ArrayList<CrmCustAddrRespVO>();
    }

    public Long getAddrNo() {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (Objects.isNull(userDetails) || Objects.isNull(userDetails.getUser())) {
            throw new BusinessException("\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        SysUserDTO sysUser = userDetails.getUser();
        String userName = sysUser.getUsername();
        CustAccountVO custAccount = this.custAccountRepoproc.getAccountByUserName(userName);
        Long addrNo = this.crmCustRepoProc.getAddrNo(custAccount.getCustCode());
        return addrNo;
    }

    public Long saveCustAddr(OrgAddrAddressSaveParam param) {
        GeneralUserDetails userDetails = SecurityContextUtil.currentUser();
        if (Objects.isNull(userDetails) || Objects.isNull(userDetails.getUser())) {
            throw new BusinessException("\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        SysUserDTO sysUser = userDetails.getUser();
        if (Objects.isNull(sysUser)) {
            throw new BusinessException("\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        String userName = sysUser.getUsername();
        CustAccountVO custAccount = this.custAccountRepoproc.getAccountByUserName(userName);
        Long addrNo = this.crmCustRepoProc.getAddrNo(custAccount.getCustCode());
        OrgAddrAddressRpcSaveParam rpcSave = new OrgAddrAddressRpcSaveParam();
        BeanUtils.copyProperties((Object)param, (Object)rpcSave);
        rpcSave.setDetailAddr(param.getDetailaddr());
        rpcSave.setAddrNo(addrNo);
        rpcSave.setDataSource("CUST");
        rpcSave.setMobile(param.getContMobile());
        ApiResult<Long> addrId = this.rmiOrgAddrService.orgAddrAddressSaveOrUpdate(rpcSave);
        if (addrId.isSuccess()) {
            return (Long)addrId.getData();
        }
        throw new BusinessException("\u4fee\u6539/\u65b0\u589e\u5730\u5740\u4fe1\u606f\u5931\u8d25");
    }

    public void delCustAddr(Long id) {
        this.rmiOrgAddrService.orgAddrAddressDelete(id);
    }

    public CrmCustDetailRespVO getByUserName(String userName) {
        if (StringUtil.isBlank((CharSequence)userName)) {
            throw new BusinessException("\u7528\u6237\u540d\u4e3a\u7a7a");
        }
        CustAccountDO custAccountDO = this.custAccountRepoproc.getByUserName(userName);
        if (custAccountDO == null || StringUtil.isBlank((CharSequence)custAccountDO.getCustCode())) {
            return null;
        }
        CrmCustDO crmCustDO = this.crmCustRepoProc.getCustInfoByCode(custAccountDO.getCustCode());
        if (crmCustDO == null) {
            return null;
        }
        CrmCustDetailRespVO respVO = CrmCustConvert.INSTANCE.doToDetailRespVO(crmCustDO);
        this.translateDetail(respVO);
        return respVO;
    }

    public CrmCustDetailRespVO getByUserId(Long userId) {
        if (ObjectUtils.isEmpty((Object)userId)) {
            throw new BusinessException("\u7528\u6237\u540d\u4e3a\u7a7a");
        }
        CustAccountDO custAccountDO = this.custAccountRepoproc.getByUserId(userId);
        if (custAccountDO == null || StringUtil.isBlank((CharSequence)custAccountDO.getCustCode())) {
            return null;
        }
        CrmCustDO crmCustDO = this.crmCustRepoProc.getCustInfoByCode(custAccountDO.getCustCode());
        if (crmCustDO == null) {
            return null;
        }
        CrmCustDetailRespVO respVO = CrmCustConvert.INSTANCE.doToDetailRespVO(crmCustDO);
        this.translateDetail(respVO);
        return respVO;
    }

    public String getRegionByCustCode(String custCode) {
        return this.crmCustRepoProc.getCustRegion(custCode);
    }

    public String getcustStatusByCode(String custCode) {
        return this.crmCustRepoProc.getCustStatusByCode(custCode);
    }

    public LmSaveCustRespVO getCustInfoByCustCode(String custCode) {
        return this.crmCustRepoProc.getCustInfoByCustCode(custCode);
    }

    public List<LmSaveCustRespVO> getCustInfoByPid(String custCode) {
        return this.crmCustRepoProc.getCustInfoByPid(custCode);
    }

    public List<LmSaveCustRespVO> getCustInfoByCustCodes(List<String> custCode) {
        return this.crmCustRepoProc.getCustInfoByCustCodes(custCode);
    }

    public List<LmSaveCustRespVO> getCustInfoByCustCode2s(List<String> custCode2s) {
        return this.crmCustRepoProc.getCustInfoByCustCode2s(custCode2s);
    }

    public List<LmSaveCustRespVO> getCustSimpleByParam(CrmCustSimpleParam param) {
        return this.crmCustRepoProc.getCustInfoByCustCodes(param);
    }

    public PagingVO<CrmCustBasePageVO> getCustBasePage(CrmCustBaseParamVO crmCustBaseParamVO) {
        PagingVO<CrmCustBasePageVO> page = this.crmCustRepoProc.getCustBasePage(crmCustBaseParamVO);
        if (!(page.isEmpty() || ObjectUtils.isEmpty((Object)page.getRecords()) || CollectionUtils.isEmpty((Collection)page.getRecords()))) {
            Map regionMap = this.udcProvider.getValueMapByUdcCode("yst-supp", "REGION");
            Map<String, String> custTypeUdc = this.rmiSysUserRpcService.sysUdcGetCodeMap("yst-sale", "CUST_TYPE");
            List agentEmpIds = page.getRecords().stream().filter(a -> !ObjectUtils.isEmpty((Object)a.getAgentEmpId())).map(CrmCustBasePageVO::getAgentEmpId).collect(Collectors.toList());
            List salesmanInfos = this.salesmanInfoRepo.findAllById(agentEmpIds);
            Map<Object, Object> salesmanMap = new HashMap();
            Map<Object, Object> empMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)salesmanInfos)) {
                salesmanMap = salesmanInfos.stream().collect(Collectors.toMap(BaseModel::getId, t -> t, (t1, t2) -> t1));
                List empCodes = salesmanInfos.stream().filter(a -> StringUtil.isNotBlank((CharSequence)a.getSalesmanNo())).map(SalesmanInfoDO::getSalesmanNo).collect(Collectors.toList());
                HashSet set = new HashSet(empCodes);
                ApiResult apiResult = this.employeeRpcService.getDetailListByCode(set);
                if (apiResult.isSuccess() && !ObjectUtils.isEmpty((Object)apiResult.getData()) && !CollectionUtils.isEmpty((Collection)((Collection)apiResult.getData()))) {
                    empMap = ((List)apiResult.getData()).stream().collect(Collectors.toMap(SysEmployeeDetailDTO::getCode, t -> t, (t1, t2) -> t1));
                }
            }
            HashMap finalSalesmanMap = salesmanMap;
            HashMap finalEmpMap = empMap;
            List<Long> addrNos = page.getRecords().stream().filter(a -> !ObjectUtils.isEmpty((Object)a.getAddrNo())).map(CrmCustBasePageVO::getAddrNo).collect(Collectors.toList());
            Map<Long, List<OrgAddressRpcDTO>> addrsMap = this.getAddrs(addrNos);
            page.getRecords().forEach(p -> {
                List addrs;
                OrgAddressRpcDTO addr;
                SalesmanInfoDO salesmanInfo;
                if (MapUtils.isNotEmpty((Map)regionMap) && StringUtil.isNotBlank((CharSequence)p.getRegion())) {
                    p.setRegionName((String)regionMap.get(p.getRegion()));
                }
                if (MapUtils.isNotEmpty((Map)custTypeUdc) && StringUtil.isNotBlank((CharSequence)p.getCustType())) {
                    p.setCustTypeName((String)custTypeUdc.get(p.getCustType()));
                }
                if (!ObjectUtils.isEmpty((Object)p.getCancelCustFlag())) {
                    p.setCancelCustFlagName(p.getCancelCustFlag() != false ? "\u662f" : "\u5426");
                }
                if (!ObjectUtils.isEmpty((Object)p.getAgentEmpId()) && MapUtils.isNotEmpty((Map)finalSalesmanMap) && !ObjectUtils.isEmpty(finalSalesmanMap.get(p.getAgentEmpId())) && !ObjectUtils.isEmpty((Object)(salesmanInfo = (SalesmanInfoDO)((Object)((Object)finalSalesmanMap.get(p.getAgentEmpId())))).getSalesmanNo()) && MapUtils.isNotEmpty((Map)finalEmpMap) && !ObjectUtils.isEmpty(finalEmpMap.get(salesmanInfo.getSalesmanNo()))) {
                    SysEmployeeDetailDTO emp = (SysEmployeeDetailDTO)finalEmpMap.get(salesmanInfo.getSalesmanNo());
                    p.setAgentEmpCode(emp.getCode());
                    p.setAgentEmpName(emp.getFullName());
                }
                if (!ObjectUtils.isEmpty((Object)p.getAddrNo()) && MapUtils.isNotEmpty((Map)addrsMap) && !CollectionUtils.isEmpty((Collection)((Collection)addrsMap.get(p.getAddrNo()))) && !ObjectUtils.isEmpty((Object)(addr = this.getDefaultOrgAddr(addrs = (List)addrsMap.get(p.getAddrNo()))))) {
                    p.setProvince(addr.getProvince());
                    p.setProvinceName(addr.getProvinceName());
                    p.setCity(addr.getCity());
                    p.setCityName(addr.getCityName());
                    p.setCounty(addr.getCounty());
                    p.setCountyName(addr.getCountyName());
                    p.setDetailAddr(addr.getDetailAddr());
                }
            });
        }
        return page;
    }

    public ApiResult<Object> syncSyncToOu(List<Long> ids) {
        ArrayList custTypes = Lists.newArrayList((Object[])new String[]{"ONE", "TWO"});
        CompletableFuture<Void> future1 = CompletableFuture.supplyAsync(() -> {
            ids.forEach(i -> {
                CrmCustDetailRespVO respVO = this.getCustDetail((Long)i);
                if (StringUtils.isNotBlank((CharSequence)respVO.getCustCode())) {
                    OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
                    orgOuRpcDtoParam.setOuCodes(Collections.singletonList(respVO.getCustCode()));
                    List ouDtoByParam = this.orgOuRpcService.findOuDtoByParam(orgOuRpcDtoParam);
                    if (!CollectionUtils.isEmpty((Collection)ouDtoByParam)) {
                        this.updateIsCreateOu(respVO.getCustCode(), 0, "\u5ba2\u6237\u5bf9\u5e94\u7684\u516c\u53f8\u7684\u5ba2\u6237\u7f16\u7801\u5df2\u5b58\u5728\uff01");
                        return;
                    }
                    if ("TWO".equals(respVO.getCustType())) {
                        String orderSignx = respVO.getOrderSignx();
                        String pid = respVO.getPid();
                        if (StringUtils.isNotBlank((CharSequence)orderSignx) && "0".equals(orderSignx)) {
                            if (!StringUtils.isBlank((CharSequence)pid)) {
                                List<OrgOuRpcDTO> ouList;
                                CustCorOuResVO corOu = this.crmCustRepoProc.getCustCorOu(pid);
                                if (ObjectUtils.isEmpty((Object)corOu) || StringUtils.isBlank((CharSequence)corOu.getCorOu())) {
                                    this.updateIsCreateOu(respVO.getCustCode(), 0, "\u4e0a\u7ea7\u5bf9\u5e94\u516c\u53f8\u4e3a\u7a7a");
                                }
                                if (CollectionUtils.isEmpty(ouList = this.getOuInfo(null, Collections.singletonList(corOu.getCorOu())))) {
                                    this.updateIsCreateOu(respVO.getCustCode(), 0, "\u67e5\u8be2\u516c\u53f8\u4e3a\u7a7a\uff0c\u7f16\u7801\u4e3a\uff1a" + corOu.getCorOu());
                                }
                                OrgOuRpcDTO ou = ouList.get(0);
                                OrgOuRpcSaveParam ouParam = this.excuteSaveOuParam(respVO, ou);
                                String ouId = this.orgOuRpcService.createOu(ouParam);
                                this.updateIsCreateOu(ouParam.getOuCode(), 1, "\u540c\u6b65\u6210\u529f");
                            } else {
                                this.updateIsCreateOu(respVO.getCustCode(), 0, "\u4e8c\u7f51\u7ecf\u9500\u5546\u5bf9\u5e94\u4e0a\u7ea7\u7ecf\u9500\u5546\u4e0d\u5b58\u5728");
                            }
                        } else if ("1".equals(orderSignx)) {
                            this.excuteCreateOu(respVO, custTypes);
                        }
                    } else {
                        this.excuteCreateOu(respVO, custTypes);
                    }
                }
            });
            return null;
        }, (Executor)this.taskExecutor);
        return ApiResult.ok();
    }

    public void excuteCreateOu(CrmCustDetailRespVO respVO, List<String> custTypes) {
        List belongOus = this.custBelongOuService.getByCustCode(respVO.getCustCode());
        if (!CollectionUtils.isEmpty((Collection)belongOus)) {
            respVO.setBelongOus(belongOus);
            if (!ObjectUtils.isEmpty((Object)respVO) && !StringUtils.isEmpty((CharSequence)respVO.getCustType()) && custTypes.contains(respVO.getCustType())) {
                List<Long> ouIds = belongOus.stream().map(CustBelongOuVO::getOuId).collect(Collectors.toList());
                List<OrgOuRpcDTO> ouList = this.getOuInfo(ouIds, null);
                OrgOuRpcDTO ou = this.filterOuType(ouList);
                log.info("\u5ba2\u6237\u751f\u6210\u516c\u53f8\u67e5\u8be2\u6240\u5c5e\u516c\u53f8\u7684ou\u4fe1\u606f----" + JSON.toJSONString((Object)ou));
                if (!ObjectUtils.isEmpty((Object)ou) && !ObjectUtils.isEmpty((Object)ou.getBuId())) {
                    OrgOuRpcSaveParam ouParam = this.excuteSaveOuParam(respVO, ou);
                    try {
                        String ouId = this.orgOuRpcService.createOu(ouParam);
                        if (StringUtils.isBlank((CharSequence)ouId)) {
                            this.updateIsCreateOu(respVO.getCustCode(), 0, "\u8c03\u7528\u57fa\u7840\u57df\u521b\u5efa\u516c\u53f8\u5931\u8d25");
                        }
                        this.updateIsCreateOu(ouParam.getOuCode(), 1, "\u540c\u6b65\u6210\u529f");
                    }
                    catch (Exception e) {
                        this.updateIsCreateOu(respVO.getCustCode(), 0, "\u8c03\u7528\u57fa\u7840\u57df\u521b\u5efa\u516c\u53f8\u5931\u8d25");
                    }
                } else {
                    this.updateIsCreateOu(respVO.getCustCode(), 0, "\u5f52\u5c5e\u516c\u53f8\u6240\u5c5e\u7ec4\u7ec7\u4e3a\u7a7a");
                }
            } else {
                this.updateIsCreateOu(respVO.getCustCode(), 0, "\u5ba2\u6237\u7c7b\u578b\u4e3a\u4e00\u7f51\u3001\u4e8c\u7f51\u7ecf\u9500\u5546\u624d\u80fd\u751f\u6210\u516c\u53f8");
            }
        } else {
            this.updateIsCreateOu(respVO.getCustCode(), 0, "\u6240\u5c5e\u516c\u53f8\u4e3a\u7a7a");
        }
    }

    public OrgOuRpcSaveParam excuteSaveOuParam(CrmCustDetailRespVO respVO, OrgOuRpcDTO ou) {
        OrgOuRpcSaveParam ouParam = new OrgOuRpcSaveParam();
        ouParam.setOuCode(respVO.getCustCode());
        ouParam.setOuName(respVO.getCustName());
        ouParam.setOuType2("OUTER");
        if (respVO.getCustType().equals("ONE")) {
            ouParam.setOuType("1-NET");
        } else {
            ouParam.setOuType("2-NET");
        }
        if (!StringUtils.isEmpty((CharSequence)respVO.getCertNo())) {
            ouParam.setIcRegisterNo(respVO.getCertNo());
        } else {
            ouParam.setIcRegisterNo(respVO.getCustCode());
        }
        ouParam.setAddrNo(respVO.getAddrNo());
        ouParam.setPid(ou.getBuId());
        ouParam.setOuStatus("ACTIVE");
        ouParam.setInvType(respVO.getInvType());
        ouParam.setInvAddress(respVO.getInvAddress());
        ouParam.setInvBankAcc(respVO.getInvBankAcc());
        ouParam.setInvBankName(respVO.getInvBankName());
        ouParam.setInvTel(respVO.getInvTel());
        ouParam.setInvPicPhone(respVO.getInvPicPhone());
        ouParam.setInvPicName(respVO.getInvPicName());
        ouParam.setOuCurr("CNY");
        ouParam.setSelectedCreateOu(Boolean.TRUE.booleanValue());
        return ouParam;
    }

    public OrgOuRpcDTO filterOuType(List<OrgOuRpcDTO> list) {
        List ous;
        if (!CollectionUtils.isEmpty(list) && !CollectionUtils.isEmpty(ous = list.stream().filter(l -> l.getOuType().equals("TRADE") || l.getOuType().equals("TRADE_A")).collect(Collectors.toList()))) {
            return (OrgOuRpcDTO)ous.get(0);
        }
        return new OrgOuRpcDTO();
    }

    public void updateIsCreateOu(String custCode, Integer isCreateOu, String msg) {
        QCrmCustDO qCrmCustDO = QCrmCustDO.crmCustDO;
        BooleanExpression e = qCrmCustDO.deleteFlag.eq((Object)0).and((Predicate)qCrmCustDO.custCode.eq((Object)custCode));
        Optional optional = this.crmCustRepo.findOne((Predicate)e);
        if (!optional.isEmpty()) {
            CrmCustDO crmCustDO = (CrmCustDO)optional.get();
            crmCustDO.setIsCreateOu(isCreateOu);
            crmCustDO.setCorOu(crmCustDO.getCustCode());
            crmCustDO.setEs1(msg);
            this.crmCustRepo.save(crmCustDO);
        }
    }

    public List<OrgOuRpcDTO> getOuInfo(List<Long> ouIds, List<String> ouCodes) {
        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        orgOuRpcDtoParam.setOuIds(ouIds);
        orgOuRpcDtoParam.setOuCodes(ouCodes);
        return this.orgOuRpcService.findOuDtoByParam(orgOuRpcDtoParam);
    }

    public CrmCustDetailRespVO getCustDetail(Long id) {
        Optional<CrmCustExtendDO> optional;
        LmSaveCustRespVO lmSaveCustRespVO;
        ApiResult listByAreaCodes;
        CrmCustDetailRespVO crmCustDetailRespVO = this.get(id);
        CrmCustDetailRespVO resp = crmCustDetailRespVO;
        if (!ObjectUtils.isEmpty((Object)resp) && StringUtils.isNotBlank((CharSequence)resp.getProvinceCode()) && (listByAreaCodes = this.sysAreaRpcService.listByAreaCodes((Set)SetUtils.hashSet((Object[])new String[]{resp.getProvinceCode()}))).isSuccess() && !CollectionUtils.isEmpty((Collection)((Collection)listByAreaCodes.getData()))) {
            resp.setProvinceName(((SysAreaRespDTO)((List)listByAreaCodes.getData()).get(0)).getShortName());
        }
        if (StringUtils.isNotBlank((CharSequence)crmCustDetailRespVO.getPid()) && !ObjectUtils.isEmpty((Object)(lmSaveCustRespVO = this.getCustInfoByCustCode(crmCustDetailRespVO.getPid())))) {
            resp.setPid2(lmSaveCustRespVO.getCustCode2());
            resp.setPid2Abbr(lmSaveCustRespVO.getCustAbbr());
        }
        if ((optional = this.findCustByCustCode(crmCustDetailRespVO.getCustCode())).isPresent()) {
            List<String> invCustCodes;
            List<LmSaveCustRespVO> list;
            resp.setInvCustCode(optional.get().getInvCustCode());
            if (StringUtils.isNotBlank((CharSequence)optional.get().getInvCustCode()) && !CollectionUtils.isEmpty(list = this.getCustInfoByCustCodes(invCustCodes = List.of(optional.get().getInvCustCode().split(";"))))) {
                List custCode2 = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getCustCode2())).map(LmSaveCustRespVO::getCustCode2).collect(Collectors.toList());
                resp.setInvCustCode2(String.join((CharSequence)";", custCode2));
            }
            resp.setOrderSignx(optional.get().getOrderSignx());
            resp.setAdjustSignx(optional.get().getAdjustSignx());
        }
        this.translateCustDetail(resp);
        return resp;
    }

    public ApiResult<LmSaveCustRespVO> saveCustLm(LmCrmCustSaveVO save) {
        CrmCustConvert crmCustConvert = CrmCustConvert.INSTANCE;
        CrmCustSaveVO custSaveVO = crmCustConvert.saveLmToVo(save);
        ApiResult<CrmCustDetailRespVO> crmCustDetailResp = this.saveLm(custSaveVO);
        if (crmCustDetailResp.isSuccess() && !Objects.isNull(crmCustDetailResp)) {
            CrmCustDetailRespVO crmCustDetailRespVO = (CrmCustDetailRespVO)crmCustDetailResp.getData();
            LmSaveCustRespVO res = new LmSaveCustRespVO();
            res.setId(crmCustDetailRespVO.getId());
            res.setCustCode(crmCustDetailRespVO.getCustCode());
            res.setCustName(crmCustDetailRespVO.getCustName());
            return ApiResult.ok((Object)res);
        }
        return ApiResult.fail((String)crmCustDetailResp.getMsg());
    }

    public void translateCustDetail(CrmCustDetailRespVO resp) {
        ApiResult listByAreaCodes;
        Map<String, String> map;
        if (!StringUtils.isEmpty((CharSequence)resp.getCustCurr()) && !MapUtils.isEmpty(map = this.getCurr(SetUtils.hashSet((Object[])new String[]{resp.getCustCurr()})))) {
            resp.setCustCurrName(map.get(resp.getCustCurr()));
        }
        if (StringUtils.isNotBlank((CharSequence)resp.getProvinceCode()) && (listByAreaCodes = this.sysAreaRpcService.listByAreaCodes((Set)SetUtils.hashSet((Object[])new String[]{resp.getProvinceCode()}))).isSuccess() && !CollectionUtils.isEmpty((Collection)((Collection)listByAreaCodes.getData()))) {
            resp.setProvinceName(((SysAreaRespDTO)((List)listByAreaCodes.getData()).get(0)).getShortName());
        }
        if (StringUtils.isNotBlank((CharSequence)resp.getCountry()) && (listByAreaCodes = this.sysAreaRpcService.listByAreaCodes((Set)SetUtils.hashSet((Object[])new String[]{resp.getCountry()}))).isSuccess() && !CollectionUtils.isEmpty((Collection)((Collection)listByAreaCodes.getData()))) {
            resp.setCountryName(((SysAreaRespDTO)((List)listByAreaCodes.getData()).get(0)).getAreaName());
        }
        Map<String, String> custType2Udc = this.rmiSysUserRpcService.sysUdcGetCodeMap("yst-sale", "CUST_TYPE2");
        Map<String, String> custTypeUdc = this.rmiSysUserRpcService.sysUdcGetCodeMap("yst-sale", "CUST_TYPE");
        Map<String, String> custGroupUdc = this.rmiSysUserRpcService.sysUdcGetCodeMap("yst-sale", "CUST_GROUP");
        Map<String, String> custStatusUdc = this.rmiSysUserRpcService.sysUdcGetCodeMap("yst-sale", "CUST_STATUS");
        Map<String, String> custLevelUdc = this.rmiSysUserRpcService.sysUdcGetCodeMap("yst-sale", "CUST_LEVEL");
        Map<String, String> custRegion2Udc = this.rmiSysUserRpcService.sysUdcGetCodeMap("yst-supp", "REGION");
        Map<String, String> taxpayerTypeUdc = this.rmiSysUserRpcService.sysUdcGetCodeMap("yst-sale", "TAXPAYER_TYPE");
        Map<String, String> invTypeUdc = this.rmiSysUserRpcService.sysUdcGetCodeMap("yst-sale", "INV_TYPE");
        Map<String, String> paymentTermUdc = this.rmiSysUserRpcService.sysUdcGetCodeMap("yst-sale", "PAYMENT_TERM");
        if (!MapUtils.isEmpty(custType2Udc) && StringUtils.isNotBlank((CharSequence)resp.getCustType2())) {
            resp.setCustType2Name(custType2Udc.get(resp.getCustType2()));
        }
        if (!MapUtils.isEmpty(custTypeUdc) && StringUtils.isNotBlank((CharSequence)resp.getCustType())) {
            resp.setCustTypeName(custTypeUdc.get(resp.getCustType()));
        }
        if (!MapUtils.isEmpty(custGroupUdc) && StringUtils.isNotBlank((CharSequence)resp.getCustGroup())) {
            resp.setCustGroupName(custGroupUdc.get(resp.getCustGroup()));
        }
        if (!MapUtils.isEmpty(custStatusUdc) && StringUtils.isNotBlank((CharSequence)resp.getCustStatus())) {
            resp.setCustStatusName(custStatusUdc.get(resp.getCustStatus()));
        }
        if (!MapUtils.isEmpty(custLevelUdc) && StringUtils.isNotBlank((CharSequence)resp.getCustLevel())) {
            resp.setCustLevelName(custLevelUdc.get(resp.getCustLevel()));
        }
        if (!MapUtils.isEmpty(custRegion2Udc) && StringUtils.isNotBlank((CharSequence)resp.getRegion())) {
            resp.setRegionName(custRegion2Udc.get(resp.getRegion()));
        }
        if (!MapUtils.isEmpty(taxpayerTypeUdc) && StringUtils.isNotBlank((CharSequence)resp.getTaxpayerType())) {
            resp.setTaxpayerTypeName(taxpayerTypeUdc.get(resp.getTaxpayerType()));
        }
        if (!MapUtils.isEmpty(invTypeUdc) && StringUtils.isNotBlank((CharSequence)resp.getInvType())) {
            resp.setInvTypeName(invTypeUdc.get(resp.getInvType()));
        }
        if (!MapUtils.isEmpty(paymentTermUdc) && StringUtils.isNotBlank((CharSequence)resp.getPaymentTerm())) {
            resp.setPaymentTermName(paymentTermUdc.get(resp.getPaymentTerm()));
        }
    }

    public Map<String, String> getCurr(Set<String> list) {
        ApiResult<List<SysCurrencyRespDTO>> res;
        list.removeAll(Collections.singleton(null));
        if (!CollectionUtils.isEmpty(list) && !Objects.isNull(res = this.rmiSysService.listByCodes(list)) && res.isSuccess() && !CollectionUtils.isEmpty((Collection)((Collection)res.getData()))) {
            List resp = (List)res.getData();
            return resp.stream().collect(Collectors.toMap(SysCurrencyRespDTO::getCurrCode, SysCurrencyRespDTO::getCurrName));
        }
        return new HashMap<String, String>();
    }

    public Optional<CrmCustExtendDO> findCustByCustCode(String custCode) {
        QCrmCustExtendDO qCrmCustExtendDO = QCrmCustExtendDO.crmCustExtendDO;
        BooleanExpression e = qCrmCustExtendDO.custCode.eq((Object)custCode).and((Predicate)qCrmCustExtendDO.deleteFlag.eq((Object)0));
        return this.crmCustExtendRepo.findOne((Predicate)e);
    }

    public OrgAddressRpcDTO getDefaultOrgAddr(List<OrgAddressRpcDTO> addrs) {
        ArrayList list = new ArrayList();
        list.addAll(addrs.stream().filter(a -> StringUtil.isNotBlank((CharSequence)a.getAddressType()) && !ObjectUtils.isEmpty((Object)a.getDefaultFlag()) && a.getDefaultFlag().equals(Boolean.TRUE) && a.getAddressType().equals("DEFAULT")).collect(Collectors.toList()));
        if (!CollectionUtils.isEmpty(list)) {
            return (OrgAddressRpcDTO)list.get(0);
        }
        return null;
    }

    public Map<Long, List<OrgAddressRpcDTO>> getAddrs(List<Long> addrNos) {
        if (!CollectionUtils.isEmpty(addrNos)) {
            OrgAddressRpcDtoParam orgAddressRpcDtoParam = new OrgAddressRpcDtoParam();
            orgAddressRpcDtoParam.setAddrNos(addrNos);
            List<OrgAddressRpcDTO> addrs = this.rmiOrgAddrService.findAddrAddressListByParam(orgAddressRpcDtoParam);
            if (!CollectionUtils.isEmpty(addrs)) {
                return addrs.stream().collect(Collectors.groupingBy(OrgAddressRpcDTO::getAddrNo));
            }
        }
        return new HashMap<Long, List<OrgAddressRpcDTO>>();
    }

    public Map<String, SysEmployeeDetailDTO> getEmpMap(List<String> empCodes) {
        Map<String, SysEmployeeDetailDTO> empMap = new HashMap<String, SysEmployeeDetailDTO>();
        HashSet<String> set = new HashSet<String>(empCodes);
        ApiResult apiResult = this.employeeRpcService.getDetailListByCode(set);
        if (apiResult.isSuccess() && !ObjectUtils.isEmpty((Object)apiResult.getData()) && !CollectionUtils.isEmpty((Collection)((Collection)apiResult.getData()))) {
            empMap = ((List)apiResult.getData()).stream().collect(Collectors.toMap(SysEmployeeDetailDTO::getCode, t -> t, (t1, t2) -> t1));
        }
        return empMap;
    }

    public Map<Long, SalesmanInfoDO> getSalesmanMap(List<Long> agentEmpIds) {
        Map<Long, SalesmanInfoDO> salesmanMap = new HashMap<Long, SalesmanInfoDO>();
        List salesmanInfos = this.salesmanInfoRepo.findAllById(agentEmpIds);
        if (!CollectionUtils.isEmpty((Collection)salesmanInfos)) {
            salesmanMap = salesmanInfos.stream().collect(Collectors.toMap(BaseModel::getId, t -> t, (t1, t2) -> t1));
        }
        return salesmanMap;
    }

    public List<LmSaveCustRespVO> getCustInfoByParam(CustAddrFindParam param) {
        return this.crmCustRepoProc.getCustInfoByParam(param);
    }

    public CrmCustSimpleVO getCustSimple(String userName) {
        CustAccountVO custAccount = this.custAccountRepoproc.getAccountByUserName(userName);
        if (!ObjectUtils.isEmpty((Object)custAccount) && !StringUtil.isBlank((CharSequence)custAccount.getCustCode())) {
            CrmCustDO cust = this.crmCustRepoProc.getDoByCustCode(custAccount.getCustCode());
            CrmCustSimpleVO respVO = CrmCustConvert.INSTANCE.do2SimpleVo(cust);
            return respVO;
        }
        return null;
    }

    public CrmCustSimpleVO getCustSimpleByUserId(Long userId) {
        CustAccountVO custAccount = this.custAccountRepoproc.getAccountByUserId(userId);
        if (!ObjectUtils.isEmpty((Object)custAccount) && !StringUtil.isBlank((CharSequence)custAccount.getCustCode())) {
            CrmCustDO cust = this.crmCustRepoProc.getDoByCustCode(custAccount.getCustCode());
            CrmCustSimpleVO respVO = CrmCustConvert.INSTANCE.do2SimpleVo(cust);
            return respVO;
        }
        return null;
    }

    private ApiResult<List<CrmCustImportSaveVO>> checkAndHandleImportData(List<CrmCustImportSaveVO> parseData) {
        List<CrmCustImportSaveVO> crmCustImportSaveVOS;
        if (CollectionUtils.isEmpty(parseData)) {
            return ApiResult.ok();
        }
        List custImportSaveVOS = parseData.stream().filter(data -> !ObjectUtils.isEmpty((Object)data.getCustCode()) && !ObjectUtils.isEmpty((Object)data.getCustName()) && !ObjectUtils.isEmpty((Object)data.getTaxRegNo())).collect(Collectors.toList());
        Map<String, List<CrmCustImportSaveVO>> custCodeMaps = custImportSaveVOS.stream().collect(Collectors.groupingBy(CrmCustImportSaveVO::getCustCode));
        Map<String, List<CrmCustImportSaveVO>> custNameMaps = custImportSaveVOS.stream().collect(Collectors.groupingBy(CrmCustImportSaveVO::getCustName));
        Map<String, List<CrmCustImportSaveVO>> taxRegNoMaps = custImportSaveVOS.stream().collect(Collectors.groupingBy(CrmCustImportSaveVO::getTaxRegNo));
        StringBuilder custCodeMsg = new StringBuilder();
        StringBuilder custNameMsg = new StringBuilder();
        StringBuilder taxRegNoMag = new StringBuilder();
        for (String custCode : custCodeMaps.keySet()) {
            crmCustImportSaveVOS = custCodeMaps.get(custCode);
            if (crmCustImportSaveVOS.size() <= 1) continue;
            custCodeMsg.append("\u3010" + custCode + "\u3011,");
        }
        for (String custName : custNameMaps.keySet()) {
            crmCustImportSaveVOS = custNameMaps.get(custName);
            if (crmCustImportSaveVOS.size() <= 1) continue;
            custNameMsg.append("\u3010" + custName + "\u3011,");
        }
        for (String taxRateNo : taxRegNoMaps.keySet()) {
            crmCustImportSaveVOS = taxRegNoMaps.get(taxRateNo);
            if (crmCustImportSaveVOS.size() <= 1) continue;
            taxRegNoMag.append("\u3010" + taxRateNo + "\u3011,");
        }
        if (custCodeMsg.length() > 0) {
            throw new BusinessException("\u5bfc\u5165\u7684\u591a\u6761\u6570\u636e,\u5ba2\u6237\u7f16\u7801\u4e3a:" + custCodeMsg + "\u6570\u636e\u91cd\u590d");
        }
        if (custNameMsg.length() > 0) {
            throw new BusinessException("\u5bfc\u5165\u7684\u591a\u6761\u6570\u636e,\u5ba2\u6237\u540d\u79f0\u4e3a:" + custNameMsg + "\u6570\u636e\u91cd\u590d");
        }
        if (taxRegNoMag.length() > 0) {
            throw new BusinessException("\u5bfc\u5165\u7684\u591a\u6761\u6570\u636e,\u7a0e\u52a1\u767b\u8bb0\u53f7\u4e3a:" + taxRegNoMag + "\u6570\u636e\u91cd\u590d");
        }
        this.udcHandle(parseData);
        List buCodes = parseData.stream().map(CrmCustImportSaveVO::getBuCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List ouNames = parseData.stream().map(CrmCustImportSaveVO::getOuName).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List ouCustNames = parseData.stream().filter(crm -> UdcEnum.CRM_CUST_TYPE2_C.getValueCode().equals(crm.getCustType2())).map(CrmCustImportSaveVO::getCustName).distinct().collect(Collectors.toList());
        List agentEmpCodes = parseData.stream().map(CrmCustImportSaveVO::getAgentEmpCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        ouNames.addAll(ouCustNames);
        ouNames = ouNames.stream().distinct().collect(Collectors.toList());
        OrgBuRpcDtoParam orgBuRpcDtoParam = new OrgBuRpcDtoParam();
        List<Object> buDtoByParam = new ArrayList();
        if (!CollectionUtils.isEmpty(buCodes)) {
            orgBuRpcDtoParam.setBuCodes(buCodes);
            buDtoByParam = this.rmiOrgBuService.findBuDtoByParam(orgBuRpcDtoParam);
        }
        OrgEmpRpcDtoParam orgEmpRpcDtoParam = new OrgEmpRpcDtoParam();
        List<Object> orgEmpRpcDTOS = new ArrayList();
        if (!CollectionUtils.isEmpty(agentEmpCodes)) {
            orgEmpRpcDtoParam.setEmpCodes(agentEmpCodes);
            orgEmpRpcDTOS = this.rmiOrgEmpService.findEmpListByParam(orgEmpRpcDtoParam);
        }
        OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        List<Object> ouDtoByParam = new ArrayList();
        if (!CollectionUtils.isEmpty(ouNames)) {
            orgOuRpcDtoParam.setOuNames(ouNames);
            ouDtoByParam = this.rmiOrgOuService.findOuDtoListByParam(orgOuRpcDtoParam);
        }
        List<Object> finalBuDtoByParam = buDtoByParam;
        ArrayList finalOuDtoByParam = ouDtoByParam;
        List<Object> finalOrgEmpRpcDtoS = orgEmpRpcDTOS;
        for (CrmCustImportSaveVO importVo : parseData) {
            Assert.isFalse((boolean)org.springframework.util.StringUtils.isEmpty((Object)importVo.getCustName()), (String)"excel\u4e2d\u5b58\u5728\u6570\u636e\u5ba2\u6237\u540d\u79f0\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.isFalse((boolean)org.springframework.util.StringUtils.isEmpty((Object)importVo.getBuCode()), (String)("\u5ba2\u6237\u540d\u79f0\u4e3a" + importVo.getCustName() + "\u7684\u6570\u636e\u9500\u552e\u7ec4\u7ec7\u4e3a\u7a7a"), (Object[])new Object[0]);
            Assert.isFalse((boolean)org.springframework.util.StringUtils.isEmpty((Object)importVo.getOuName()), (String)("\u5ba2\u6237\u540d\u79f0\u4e3a" + importVo.getCustName() + "\u7684\u6570\u636e\u516c\u53f8\u540d\u79f0\u4e3a\u7a7a"), (Object[])new Object[0]);
            Assert.isFalse((boolean)org.springframework.util.StringUtils.isEmpty((Object)importVo.getOuCode()), (String)("\u5ba2\u6237\u540d\u79f0\u4e3a" + importVo.getCustName() + "\u7684\u6570\u636e\u516c\u53f8\u4e3a\u7a7a"), (Object[])new Object[0]);
            Assert.isFalse((boolean)org.springframework.util.StringUtils.isEmpty((Object)importVo.getRegion()), (String)("\u5ba2\u6237\u540d\u79f0\u4e3a" + importVo.getCustName() + "\u7684\u6570\u636e\u533a\u57df\u4e3a\u7a7a"), (Object[])new Object[0]);
            Assert.isFalse((boolean)org.springframework.util.StringUtils.isEmpty((Object)importVo.getAgentEmpCode()), (String)("\u5ba2\u6237\u540d\u79f0\u4e3a" + importVo.getCustName() + "\u7684\u6570\u636e\u4e1a\u52a1\u5458\u7f16\u7801\u4e3a\u7a7a"), (Object[])new Object[0]);
            Assert.isFalse((boolean)org.springframework.util.StringUtils.isEmpty((Object)importVo.getAgentEmpName()), (String)("\u5ba2\u6237\u540d\u79f0\u4e3a" + importVo.getCustName() + "\u7684\u6570\u636e\u4e1a\u52a1\u5458\u540d\u79f0\u4e3a\u7a7a"), (Object[])new Object[0]);
            Assert.isFalse((boolean)org.springframework.util.StringUtils.isEmpty((Object)importVo.getCustType()), (String)("\u5ba2\u6237\u540d\u79f0\u4e3a" + importVo.getCustName() + "\u7684\u6570\u636e\u5ba2\u6237\u5206\u7c7b\u4e3a\u7a7a"), (Object[])new Object[0]);
            Assert.isFalse((boolean)org.springframework.util.StringUtils.isEmpty((Object)importVo.getCustStatus()), (String)("\u5ba2\u6237\u540d\u79f0\u4e3a" + importVo.getCustName() + "\u7684\u6570\u636e\u5ba2\u6237\u72b6\u6001\u4e3a\u7a7a"), (Object[])new Object[0]);
            Assert.isFalse((boolean)org.springframework.util.StringUtils.isEmpty((Object)importVo.getCustType2()), (String)("\u5ba2\u6237\u540d\u79f0\u4e3a" + importVo.getCustName() + "\u7684\u6570\u636e\u5ba2\u6237\u5f52\u7c7b\u4e3a\u7a7a"), (Object[])new Object[0]);
            Assert.isFalse((boolean)org.springframework.util.StringUtils.isEmpty((Object)importVo.getTaxRegNo()), (String)("\u5ba2\u6237\u540d\u79f0\u4e3a" + importVo.getCustName() + "\u7684\u6570\u636e\u7a0e\u52a1\u767b\u8bb0\u7801\u4e3a\u7a7a"), (Object[])new Object[0]);
            Assert.isFalse((boolean)org.springframework.util.StringUtils.isEmpty((Object)importVo.getInvType()), (String)("\u5ba2\u6237\u540d\u79f0\u4e3a" + importVo.getCustName() + "\u7684\u6570\u636e\u5f00\u7968\u7c7b\u578b\u4e3a\u7a7a"), (Object[])new Object[0]);
            Assert.isFalse((boolean)org.springframework.util.StringUtils.isEmpty((Object)importVo.getCustGroup2()), (String)("\u5ba2\u6237\u540d\u79f0\u4e3a" + importVo.getCustName() + "\u7684\u6570\u636e\u5927B/\u5c0fB\u4e3a\u7a7a"), (Object[])new Object[0]);
            Assert.isFalse((boolean)org.springframework.util.StringUtils.isEmpty((Object)importVo.getFinancialAttribute()), (String)"\u5bfc\u5165\u6570\u636e\u8d22\u52a1\u5c5e\u60271\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.isFalse((!UdcEnum.CRM_FINANCIAL_ATTRIBUTE_50.getValueCode().equals(importVo.getFinancialAttribute()) && !UdcEnum.CRM_FINANCIAL_ATTRIBUTE_60.getValueCode().equals(importVo.getFinancialAttribute()) && org.springframework.util.StringUtils.isEmpty((Object)importVo.getFinancialAttribute2()) ? 1 : 0) != 0, (String)" \u5f53\u8d22\u52a1\u5c5e\u60271\u4e0d\u4e3a\uff0850\u8f66\u8239\u6237,60\u6279\u53d1\u6237\u65f6\uff09\u8d22\u52a1\u5c5e\u60272\u5fc5\u586b", (Object[])new Object[0]);
            Assert.isFalse(((UdcEnum.CRM_FINANCIAL_ATTRIBUTE_20.getValueCode().equals(importVo.getFinancialAttribute()) || UdcEnum.CRM_FINANCIAL_ATTRIBUTE_30.getValueCode().equals(importVo.getFinancialAttribute()) || UdcEnum.CRM_FINANCIAL_ATTRIBUTE_40.getValueCode().equals(importVo.getFinancialAttribute()) || UdcEnum.CRM_FINANCIAL_ATTRIBUTE_50.getValueCode().equals(importVo.getFinancialAttribute())) && org.springframework.util.StringUtils.isEmpty((Object)importVo.getFinancialAttribute3()) ? 1 : 0) != 0, (String)" \u5f53\u8d22\u52a1\u5c5e\u60271\u4e3a\uff0820\u8f66\u8239\u6237,30\u6279\u53d1\u6237,40\u516c\u798f\u6237\u65f6,50\u8f66\u8239\u6237\uff09\u8d22\u52a1\u5c5e\u60273\u5fc5\u586b", (Object[])new Object[0]);
            Assert.isFalse(((UdcEnum.CRM_FINANCIAL_ATTRIBUTE_20.getValueCode().equals(importVo.getFinancialAttribute()) || UdcEnum.CRM_FINANCIAL_ATTRIBUTE_30.getValueCode().equals(importVo.getFinancialAttribute()) || UdcEnum.CRM_FINANCIAL_ATTRIBUTE_40.getValueCode().equals(importVo.getFinancialAttribute())) && org.springframework.util.StringUtils.isEmpty((Object)importVo.getFinancialAttribute4()) ? 1 : 0) != 0, (String)" \u5f53\u8d22\u52a1\u5c5e\u60271\u4e3a\uff0820\u8f66\u8239\u6237,30\u6279\u53d1\u6237,40\u516c\u670d\u6237\u65f6\uff09\u8d22\u52a1\u5c5e\u60274\u5fc5\u586b", (Object[])new Object[0]);
            Assert.isFalse((UdcEnum.COM_INV_TYPE_VANA.getValueCode().equals(importVo.getInvType()) && (org.springframework.util.StringUtils.isEmpty((Object)importVo.getInvTitle()) || org.springframework.util.StringUtils.isEmpty((Object)importVo.getTaxerNo())) ? 1 : 0) != 0, (String)"\u5f53\u5f00\u7968\u7c7b\u578b\u4e3a\u589e\u503c\u7a0e\u666e\u7968\u65f6,\u5f00\u7968\u62ac\u5934\u548c\u7a0e\u53f7\u5fc5\u586b", (Object[])new Object[0]);
            Assert.isFalse((UdcEnum.COM_INV_TYPE_VATS.getValueCode().equals(importVo.getInvType()) && (org.springframework.util.StringUtils.isEmpty((Object)importVo.getInvTitle()) || org.springframework.util.StringUtils.isEmpty((Object)importVo.getTaxerNo()) || org.springframework.util.StringUtils.isEmpty((Object)importVo.getInvAddress()) || org.springframework.util.StringUtils.isEmpty((Object)importVo.getInvTel()) || org.springframework.util.StringUtils.isEmpty((Object)importVo.getInvBankName()) || org.springframework.util.StringUtils.isEmpty((Object)importVo.getInvBankAcc()) || org.springframework.util.StringUtils.isEmpty((Object)importVo.getInvPicName()) || org.springframework.util.StringUtils.isEmpty((Object)importVo.getInvPicPhone())) ? 1 : 0) != 0, (String)"\u5f53\u5f00\u7968\u7c7b\u578b\u4e3a\u589e\u503c\u7a0e\u4e13\u7968\u65f6,\u5f00\u7968\u62ac\u5934\u3001\u7a0e\u53f7\u3001\u5f00\u7968\u5730\u5740\u3001\u5f00\u7968\u7535\u8bdd\u3001\u5f00\u6237\u94f6\u884c\u3001\u94f6\u884c\u8d26\u6237\u3001\u8054\u7cfb\u4eba\u3001\u8054\u7cfb\u4eba\u7535\u8bdd\u5fc5\u586b", (Object[])new Object[0]);
            if (UdcEnum.CRM_CUST_TYPE2_C.getValueCode().equals(importVo.getCustType2())) {
                String ouCode = finalOuDtoByParam.stream().filter(ou -> ou.getOuName().equals(importVo.getCustName())).findFirst().orElseThrow(new BusinessException("\u5ba2\u6237\u540d\u79f0\u4e3a\u3010" + importVo.getCustName() + "\u3011\u7684\u6570\u636e,\u4e3a\u5185\u90e8\u516c\u53f8\u5ba2\u6237,\u5ba2\u6237\u540d\u79f0\u4e0d\u5b58\u5728")).getOuCode();
                if (org.springframework.util.StringUtils.isEmpty((Object)importVo.getCustCode())) {
                    importVo.setCustCode(ouCode);
                } else if (!ouCode.equals(importVo.getCustCode())) {
                    throw new BusinessException("\u5ba2\u6237\u540d\u79f0\u4e3a\u3010" + importVo.getCustName() + "\u3011\u7684\u6570\u636e,\u4e3a\u5185\u90e8\u516c\u53f8\u5ba2\u6237,\u5ba2\u6237\u540d\u79f0\u548c\u5ba2\u6237\u7f16\u7801\u4e0d\u4e00\u81f4");
                }
            }
            if (org.springframework.util.StringUtils.isEmpty((Object)importVo.getCustCode())) {
                String custCode = this.rmiSysNextNumberService.generateCode("yst-sale", "C", new ArrayList<String>());
                importVo.setCustCode(custCode);
            }
            Boolean exists = this.crmCustRepoProc.exists(importVo.getCustName(), null);
            Assert.isFalse((boolean)exists, (String)("\u5ba2\u6237\u540d\u79f0\u4e3a\u3010" + importVo.getCustName() + "\u3011\u7684\u6570\u636e\u5ba2\u6237\u540d\u79f0\u5df2\u5b58\u5728"), (Object[])new Object[0]);
            if (!org.springframework.util.StringUtils.isEmpty((Object)importVo.getTaxRegNo())) {
                Boolean existsTaxRegNo = this.crmCustRepoProc.existsTaxRegNo(importVo.getTaxRegNo(), null, null);
                Assert.isFalse((boolean)existsTaxRegNo, (String)("\u5ba2\u6237\u540d\u79f0\u4e3a\u3010" + importVo.getCustName() + "\u3011\u7684\u6570\u636e\u7a0e\u52a1\u767b\u8bb0\u53f7\u5df2\u5b58\u5728"), (Object[])new Object[0]);
            }
            if (UdcEnum.CRM_CUST_TYPE2_A.getValueCode().equals(importVo.getCustType2())) {
                Assert.isTrue((boolean)importVo.getCustCode().matches("C\\d{10}"), (String)("\u5ba2\u6237\u540d\u79f0\u4e3a\u3010" + importVo.getCustName() + "\u3011\u7684\u6570\u636e\uff0c\u5ba2\u6237\u7f16\u7801\u5fc5\u987b\u662f\u5b57\u6bcdC\u52a010\u4f4d\u6570\u5b57\uff01"), (Object[])new Object[0]);
            }
            OrgBuRpcDTO orgBuRpcDTO = finalBuDtoByParam.stream().filter(bu -> bu.getBuCode().equals(importVo.getBuCode())).findFirst().orElseThrow(new BusinessException("\u5ba2\u6237\u540d\u79f0\u4e3a\u3010" + importVo.getCustName() + "\u3011\u7684\u6570\u636e,\u9500\u552e\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5"));
            importVo.setBuId(orgBuRpcDTO.getId());
            importVo.setBuName(orgBuRpcDTO.getBuName());
            Long ouId = finalOuDtoByParam.stream().filter(ou -> ou.getOuCode().equals(importVo.getOuCode())).findFirst().orElseThrow(new BusinessException("\u5ba2\u6237\u540d\u79f0\u4e3a\u3010" + importVo.getCustName() + "\u3011\u7684\u6570\u636e,\u516c\u53f8\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5")).getId();
            importVo.setOuId(ouId);
            Long id = finalOrgEmpRpcDtoS.stream().filter(emp -> emp.getEmpCode().equals(importVo.getAgentEmpCode()) && emp.getEmpName().equals(importVo.getAgentEmpName())).findFirst().orElseThrow(new BusinessException("\u5ba2\u6237\u540d\u79f0\u4e3a\u3010" + importVo.getCustName() + "\u3011\u7684\u6570\u636e,\u4e1a\u52a1\u5458\u7f16\u7801\u6216\u8005\u4e1a\u52a1\u5458\u540d\u79f0\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5")).getId();
            importVo.setAgentEmpId(id);
        }
        return ApiResult.ok(parseData);
    }

    private void udcHandle(List<CrmCustImportSaveVO> parseData) {
    }

    private String udcHandleCom(List<SysUdcComboVO> udcComboVOList, String udcDesc, String handleDate, String custName) {
        return udcComboVOList.stream().filter(udc -> udc.getValDesc().equals(udcDesc)).findFirst().orElseThrow(new BusinessException("\u5ba2\u6237\u540d\u79f0\u4e3a\u3010" + custName + "\u3011\u7684\u6570\u636e," + handleDate + "\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5")).getUdcVal();
    }

    private String udcRelatedHandleCom(List<SysUdcComboVO> udcComboVOList, String udcDesc, String handleDate1, String handleDate2, String handleDate3, String custName) {
        return udcComboVOList.stream().filter(udc -> udc.getValDesc().equals(udcDesc)).findFirst().orElseThrow(new BusinessException("\u5ba2\u6237\u540d\u79f0\u4e3a\u3010" + custName + "\u3011\u7684\u6570\u636e,\u5f53\u8d22\u52a1\u5c5e\u60271\u4e3a" + handleDate1 + "\u65f6," + handleDate2 + "\u5e94\u8be5\u53d6" + handleDate3 + ",\u6240\u586b\u5199" + handleDate2 + "\u4e0d\u5b58\u5728")).getUdcVal();
    }

    private ApiResult<List<CrmAddrImplSaveVO>> checkAndHandleAddrImportData(List<CrmAddrImplSaveVO> parseData) {
        Assert.notNull(parseData, (String)"\u4fdd\u5b58\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
        return ApiResult.ok(parseData);
    }

    private List<String> switchProvince(List<String> provinces) {
        ArrayList<String> newProvince = new ArrayList<String>();
        provinces.forEach(pro -> {
            if (pro.contains("\u65b0\u7586")) {
                newProvince.add("\u65b0\u7586");
            } else if (pro.contains("\u5e7f\u897f")) {
                newProvince.add("\u5e7f\u897f");
            } else if (pro.contains("\u5b81\u590f")) {
                newProvince.add("\u5b81\u590f");
            } else if (pro.contains("\u897f\u85cf")) {
                newProvince.add("\u897f\u85cf");
            } else if (pro.contains("\u5185\u8499\u53e4")) {
                newProvince.add("\u5185\u8499\u53e4");
            } else {
                newProvince.add((String)pro);
            }
        });
        return newProvince;
    }

    private List<CrmCustDetailRespVO> findIdBatch(List<Long> ids) {
        List<CrmCustDetailRespVO> custDetailRespVOS = this.crmCustRepo.findAllById(ids).stream().map(CrmCustConvert.INSTANCE::doToDetailRespVO).collect(Collectors.toList());
        custDetailRespVOS.forEach(this::translateDetail);
        return custDetailRespVOS;
    }

    private void checkForSave(CrmCustSaveVO saveVO) {
        Assert.notNull((Object)saveVO, (String)"\u4fdd\u5b58\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.isFalse((boolean)org.springframework.util.StringUtils.isEmpty((Object)saveVO.getCustName()), (String)"\u4fdd\u5b58\u6570\u636e\u5ba2\u6237\u540d\u79f0\u4e3a\u7a7a", (Object[])new Object[0]);
        if (!org.springframework.util.StringUtils.isEmpty((Object)saveVO.getCustCode2())) {
            Boolean exists = this.crmCustRepoProc.existsCustCode2(saveVO.getCustCode2(), saveVO.getId());
            Assert.isFalse((boolean)exists, (String)"\u5ba2\u6237\u53f7\u5df2\u7ecf\u5b58\u5728,\u8bf7\u5728\u67e5\u8be2\u9875\u9762\u67e5\u770b", (Object[])new Object[0]);
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)saveVO.getCustCode())) {
            Boolean exists1 = this.crmCustRepoProc.existsCode(saveVO.getCustCode(), saveVO.getId());
            Assert.isFalse((boolean)exists1, (String)"\u5ba2\u6237\u7f16\u7801\u5df2\u5b58\u5728,\u8bf7\u5728\u67e5\u8be2\u754c\u9762\u67e5\u8be2\u6b64\u5ba2\u6237", (Object[])new Object[0]);
        }
    }

    private CrmCustDO saveVoDo(CrmCustSaveVO saveVO) {
        CrmCustDO crmCustDO = saveVO.getId() == null ? new CrmCustDO() : (CrmCustDO)this.crmCustRepo.findById(saveVO.getId()).orElseThrow();
        CrmCustConvert.INSTANCE.copyVoToDo(saveVO, crmCustDO);
        return crmCustDO;
    }

    private Page<CrmCustDO> searching(CrmCustQueryParamVO queryParamVO) {
        OrgUserEmpInfoRpcDTO userEmpInfo;
        BooleanExpression predicate = qCrmCustDO.isNotNull();
        if (!org.springframework.util.StringUtils.isEmpty((Object)queryParamVO.getCustCode())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.custCode.like("%" + queryParamVO.getCustCode() + "%"));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)queryParamVO.getCustStatus())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.custStatus.eq((Object)queryParamVO.getCustStatus()));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)queryParamVO.getCustType())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.custType.eq((Object)queryParamVO.getCustType()));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)queryParamVO.getCustType2())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.custType2.eq((Object)queryParamVO.getCustType2()));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)queryParamVO.getCustLevel())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.custLevel.eq((Object)queryParamVO.getCustLevel()));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)queryParamVO.getTaxRegNo())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.taxRegNo.like("%" + queryParamVO.getTaxRegNo() + "%"));
        }
        if (!CollectionUtils.isEmpty((Collection)queryParamVO.getCustCodes())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.custCode.in((Collection)queryParamVO.getCustCodes()));
        }
        if (!CollectionUtils.isEmpty((Collection)queryParamVO.getCustIds())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.id.in((Collection)queryParamVO.getCustIds()));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)queryParamVO.getAgentEmpId())) {
            List custCodes;
            CrmCustOuParamVO crmCustOuParamVO = new CrmCustOuParamVO();
            crmCustOuParamVO.setAgentEmpId(queryParamVO.getAgentEmpId());
            crmCustOuParamVO.setIfTrans(Boolean.valueOf(false));
            List custOuSaveVOS = this.crmCustOuService.search(crmCustOuParamVO);
            predicate = !CollectionUtils.isEmpty((Collection)custOuSaveVOS) ? (!CollectionUtils.isEmpty(custCodes = custOuSaveVOS.stream().map(CrmCustOuSaveVO::getCustCode).distinct().collect(Collectors.toList())) ? ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.custCode.in(custCodes).or((Predicate)CrmCustServiceImpl.qCrmCustDO.agentEmpId.eq((Object)queryParamVO.getAgentEmpId()))) : ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.agentEmpId.eq((Object)queryParamVO.getAgentEmpId()))) : ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.agentEmpId.eq((Object)queryParamVO.getAgentEmpId()));
        }
        List<Object> custCodes = new ArrayList();
        if (!org.springframework.util.StringUtils.isEmpty((Object)queryParamVO.getOuId())) {
            CrmCustOuParamVO crmCustOuParamVO = new CrmCustOuParamVO();
            crmCustOuParamVO.setOuId(queryParamVO.getOuId());
            crmCustOuParamVO.setIfTrans(Boolean.valueOf(false));
            List custOuSaveVOS = this.crmCustOuService.search(crmCustOuParamVO);
            predicate = !CollectionUtils.isEmpty((Collection)custOuSaveVOS) ? (!CollectionUtils.isEmpty(custCodes = custOuSaveVOS.stream().map(CrmCustOuSaveVO::getCustCode).distinct().collect(Collectors.toList())) ? ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.custCode.in(custCodes).or((Predicate)CrmCustServiceImpl.qCrmCustDO.ouId.eq((Object)queryParamVO.getOuId()))) : ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.ouId.eq((Object)queryParamVO.getOuId()))) : ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.ouId.eq((Object)queryParamVO.getOuId()));
        }
        List<Object> custCodes2 = new ArrayList();
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        if (!(ObjectUtils.isEmpty((Object)currentUserDTO) || ObjectUtils.isEmpty((Object)(userEmpInfo = this.rmiOrgEmpService.findUserEmpInfo(currentUserDTO.getUserId()))) || ObjectUtils.isEmpty((Object)userEmpInfo.getOuId()))) {
            CrmCustOuParamVO crmCustOuParamVO = new CrmCustOuParamVO();
            crmCustOuParamVO.setOuId(userEmpInfo.getOuId());
            crmCustOuParamVO.setIfTrans(Boolean.valueOf(false));
            List custOuSaveVOS = this.crmCustOuService.search(crmCustOuParamVO);
            if (!CollectionUtils.isEmpty((Collection)custOuSaveVOS) && (ObjectUtils.isEmpty((Object)queryParamVO.getOuId()) || queryParamVO.getOuId().equals(userEmpInfo.getOuId()))) {
                custCodes2 = custOuSaveVOS.stream().map(CrmCustOuSaveVO::getCustCode).distinct().collect(Collectors.toList());
            }
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)queryParamVO.getBuId())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.buId.eq((Object)queryParamVO.getBuId()));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)queryParamVO.getCustName())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.custName.like("%" + queryParamVO.getCustName() + "%"));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)queryParamVO.getCustAbbr())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.custAbbr.like("%" + queryParamVO.getCustAbbr() + "%"));
        }
        if (!CollectionUtils.isEmpty((Collection)queryParamVO.getAddrNos())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.addrNo.in((Collection)queryParamVO.getAddrNos()));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)queryParamVO.getInnerFlag())) {
            if (queryParamVO.getInnerFlag().equals(Boolean.TRUE)) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.custType2.eq((Object)UdcEnum.CRM_CUST_TYPE2_C.getValueCode()));
                predicate = ExpressionUtils.or((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.custType2.eq((Object)UdcEnum.CRM_CUST_TYPE2_D.getValueCode()));
            } else {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.custType2.ne((Object)UdcEnum.CRM_CUST_TYPE2_C.getValueCode()));
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.custType2.ne((Object)UdcEnum.CRM_CUST_TYPE2_D.getValueCode()));
            }
        }
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.deleteFlag.ne((Object)1));
        custCodes.addAll(custCodes2);
        List custList = custCodes.stream().distinct().collect(Collectors.toList());
        BooleanExpression predicate2 = qCrmCustDO.isNotNull();
        if (!CollectionUtils.isEmpty(custList)) {
            predicate2 = ExpressionUtils.and((Predicate)predicate2, (Predicate)CrmCustServiceImpl.qCrmCustDO.custCode.in(custCodes).or(DataAuthJpaUtil.dataAuthJpaPredicate((PathMetadata)qCrmCustDO.getMetadata())));
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)predicate2);
        } else {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)DataAuthJpaUtil.dataAuthJpaPredicate((PathMetadata)qCrmCustDO.getMetadata()));
        }
        return this.crmCustRepo.findAll((Predicate)predicate, (Pageable)this.wrapperPageRequest(queryParamVO.getPageRequest(), null));
    }

    private List<CrmCustDO> searching1(CrmCustQueryParamVO queryParamVO) {
        BooleanExpression predicate = qCrmCustDO.isNotNull();
        if (!org.springframework.util.StringUtils.isEmpty((Object)queryParamVO.getCustCode())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.custCode.like("%" + queryParamVO.getCustCode() + "%"));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)queryParamVO.getCustStatus())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.custStatus.eq((Object)queryParamVO.getCustStatus()));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)queryParamVO.getCustType())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.custType.eq((Object)queryParamVO.getCustType()));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)queryParamVO.getCustType2())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.custType2.eq((Object)queryParamVO.getCustType2()));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)queryParamVO.getCustLevel())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.custLevel.eq((Object)queryParamVO.getCustLevel()));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)queryParamVO.getTaxRegNo())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.taxRegNo.like("%" + queryParamVO.getTaxRegNo() + "%"));
        }
        if (!CollectionUtils.isEmpty((Collection)queryParamVO.getCustCodes())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.custCode.in((Collection)queryParamVO.getCustCodes()));
        }
        if (!CollectionUtils.isEmpty((Collection)queryParamVO.getCustIds())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.id.in((Collection)queryParamVO.getCustIds()));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)queryParamVO.getAgentEmpId())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.agentEmpId.eq((Object)queryParamVO.getAgentEmpId()));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)queryParamVO.getOuId())) {
            List custCodes;
            CrmCustOuParamVO crmCustOuParamVO = new CrmCustOuParamVO();
            crmCustOuParamVO.setOuId(queryParamVO.getOuId());
            crmCustOuParamVO.setIfTrans(Boolean.valueOf(false));
            List custOuSaveVOS = this.crmCustOuService.search(crmCustOuParamVO);
            predicate = !CollectionUtils.isEmpty((Collection)custOuSaveVOS) ? (!CollectionUtils.isEmpty(custCodes = custOuSaveVOS.stream().map(CrmCustOuSaveVO::getCustCode).distinct().collect(Collectors.toList())) ? ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.custCode.in(custCodes).or((Predicate)CrmCustServiceImpl.qCrmCustDO.ouId.eq((Object)queryParamVO.getOuId()))) : ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.ouId.eq((Object)queryParamVO.getOuId()))) : ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.ouId.eq((Object)queryParamVO.getOuId()));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)queryParamVO.getBuId())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.buId.eq((Object)queryParamVO.getBuId()));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)queryParamVO.getCustName())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.custName.like("%" + queryParamVO.getCustName() + "%"));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)queryParamVO.getCustAbbr())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.custAbbr.like("%" + queryParamVO.getCustAbbr() + "%"));
        }
        if (!CollectionUtils.isEmpty((Collection)queryParamVO.getAddrNos())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.addrNo.in((Collection)queryParamVO.getAddrNos()));
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)queryParamVO.getInnerFlag())) {
            if (queryParamVO.getInnerFlag().equals(Boolean.TRUE)) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.custType2.eq((Object)UdcEnum.CRM_CUST_TYPE2_C.getValueCode()));
                predicate = ExpressionUtils.or((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.custType2.eq((Object)UdcEnum.CRM_CUST_TYPE2_D.getValueCode()));
            } else {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.custType2.ne((Object)UdcEnum.CRM_CUST_TYPE2_C.getValueCode()));
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.custType2.ne((Object)UdcEnum.CRM_CUST_TYPE2_D.getValueCode()));
            }
        }
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)CrmCustServiceImpl.qCrmCustDO.deleteFlag.ne((Object)1));
        Iterable crmCustRepoAll = this.crmCustRepo.findAll((Predicate)predicate);
        ArrayList<CrmCustDO> crmCustDOS = new ArrayList<CrmCustDO>();
        crmCustRepoAll.forEach(crmCustDOS::add);
        return crmCustDOS;
    }

    public CrmCustServiceImpl(CrmCustRepo crmCustRepo, CrmCustRepoProc crmCustRepoProc, CrmCustOuRepoProc crmCustOuRepoProc, ComSaleFileInfoService comSaleFileInfoService, RmiCityCodeService rmiCityCodeService, RmiOrgAddrService rmiOrgAddrService, RmiOrgEmpService rmiOrgEmpService, RmiOrgOuService rmiOrgOuService, RmiOrgBuService rmiOrgBuService, RmiSysNextNumberService rmiSysNextNumberService, RmiCommonService rmiCommonService, CrmCustOuService crmCustOuService, BipCustUserBindRepo bipCustUserBindRepo, CustAccountRepoProc custAccountRepoproc, CustAccountRepo custAccountRepo, SalesmanInfoRepo salesmanInfoRepo, OrgOuRpcService orgOuRpcService, CustBelongOuService custBelongOuService, SysAreaRpcService sysAreaRpcService, CrmCustExtendRepo crmCustExtendRepo, TaskExecutor taskExecutor, RmiSysUserRpcService rmiSysUserRpcService, RmiSysService rmiSysService) {
        this.crmCustRepo = crmCustRepo;
        this.crmCustRepoProc = crmCustRepoProc;
        this.crmCustOuRepoProc = crmCustOuRepoProc;
        this.comSaleFileInfoService = comSaleFileInfoService;
        this.rmiCityCodeService = rmiCityCodeService;
        this.rmiOrgAddrService = rmiOrgAddrService;
        this.rmiOrgEmpService = rmiOrgEmpService;
        this.rmiOrgOuService = rmiOrgOuService;
        this.rmiOrgBuService = rmiOrgBuService;
        this.rmiSysNextNumberService = rmiSysNextNumberService;
        this.rmiCommonService = rmiCommonService;
        this.crmCustOuService = crmCustOuService;
        this.bipCustUserBindRepo = bipCustUserBindRepo;
        this.custAccountRepoproc = custAccountRepoproc;
        this.custAccountRepo = custAccountRepo;
        this.salesmanInfoRepo = salesmanInfoRepo;
        this.orgOuRpcService = orgOuRpcService;
        this.custBelongOuService = custBelongOuService;
        this.sysAreaRpcService = sysAreaRpcService;
        this.crmCustExtendRepo = crmCustExtendRepo;
        this.taskExecutor = taskExecutor;
        this.rmiSysUserRpcService = rmiSysUserRpcService;
        this.rmiSysService = rmiSysService;
    }

    static {
        EXPIRE_TIME = 5;
    }
}

