/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.elitescloud.cloudt.system.provider.extend.SysCurrencyRpcService;
import com.elitesland.yst.production.sale.api.service.ComSaleFileInfoService;
import com.elitesland.yst.production.sale.api.service.CrmCustService;
import com.elitesland.yst.production.sale.api.service.PriSalePriceService;
import com.elitesland.yst.production.sale.api.service.SalContractService;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmCustQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.param.pro.SalContractPagingParam;
import com.elitesland.yst.production.sale.api.vo.param.pro.SalContractSaveParam;
import com.elitesland.yst.production.sale.api.vo.resp.crm.CrmCustPageRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.pro.SalContractPageRespVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.convert.SalContractConvert;
import com.elitesland.yst.production.sale.convert.SalContractDConvert;
import com.elitesland.yst.production.sale.convert.SalContractRecvConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.entity.QSalContractDO;
import com.elitesland.yst.production.sale.entity.SalContractDDO;
import com.elitesland.yst.production.sale.entity.SalContractDO;
import com.elitesland.yst.production.sale.entity.SalContractRecvDO;
import com.elitesland.yst.production.sale.repo.CrmCustRepoProc;
import com.elitesland.yst.production.sale.repo.SalContractDRepo;
import com.elitesland.yst.production.sale.repo.SalContractRecvRepo;
import com.elitesland.yst.production.sale.repo.SalContractRepo;
import com.elitesland.yst.production.sale.repo.SalContractRepoProc;
import com.elitesland.yst.production.sale.repo.SalInvApplydRepo;
import com.elitesland.yst.production.sale.repo.SalProjRepo;
import com.elitesland.yst.production.sale.repo.SalProjRepoProc;
import com.elitesland.yst.production.sale.repo.SalReceiptdRepo;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiCityCodeService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiItemService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgBuService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgEmpService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgOuService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemBusinessRpcPagingDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemBusinessRpcPagingParam;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.yst.production.support.provider.org.param.OrgEmpRpcDtoParam;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service(value="salContractService")
public class SalContractServiceImpl
extends BaseServiceImpl
implements SalContractService {
    private static final Logger log = LoggerFactory.getLogger(SalContractServiceImpl.class);
    private final QSalContractDO qSalContractDO = QSalContractDO.salContractDO;
    private final SalContractRepo salContractRepo;
    private final SalContractDRepo salContractDRepo;
    private final SalContractRecvRepo salContractRecvRepo;
    private final ComSaleFileInfoService comSaleFileInfoService;
    private final CrmCustService crmCustService;
    private final RmiSysNextNumberService nextNumberService;
    private final SysCurrencyRpcService sysCurrencyRpcService;
    public static final String ATTACH_BUSINESS_TYPE = "SAL_CONTRACT";
    private final PriSalePriceService priSalePriceService;
    private final RmiOrgEmpService rmiOrgEmpService;
    private final RmiOrgOuService rmiOrgOuService;
    private final RmiOrgBuService rmiOrgBuService;
    private final SalProjRepoProc salProjRepoProc;
    private final CrmCustRepoProc crmCustRepoProc;
    private final SalProjRepo salProjRepo;
    private final SalReceiptdRepo salReceiptdRepo;
    private final SalInvApplydRepo salInvApplydRepo;
    private final SalContractRepoProc salContractRepoProc;
    private final RmiCityCodeService rmiCityCodeService;
    private final RmiItemService rmiItemService;
    private static final String CONTRACT_S_DRAFT = UdcEnum.SAL_CONTRACT_STATUS_DRAFT.getValueCode();
    private static final String CONTRACT_S_APPROVING = UdcEnum.SAL_CONTRACT_STATUS_APPROVING.getValueCode();
    private static final String CONTRACT_S_APPROVED = UdcEnum.SAL_CONTRACT_STATUS_APPROVED.getValueCode();
    private static final String CONTRACT_S_REJECTED = UdcEnum.SAL_CONTRACT_STATUS_REJECTED.getValueCode();
    private static final String CONTRACT_S_CLOSED = UdcEnum.SAL_CONTRACT_STATUS_CLOSED.getValueCode();

    @SysCodeProc
    public PagingVO<SalContractPageRespVO> query(SalContractPagingParam pageParam) {
        if (StrUtil.isNotBlank((CharSequence)pageParam.getCustType())) {
            CrmCustQueryParamVO custQueryParam = new CrmCustQueryParamVO();
            custQueryParam.setCustType(pageParam.getCustType());
            List crmCustResult = this.crmCustService.searchList(custQueryParam);
            List custIds = crmCustResult.stream().map(CrmCustPageRespVO::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            pageParam.setCustIds(custIds);
        }
        Predicate predicate = this.buildPageSearchCondition(pageParam);
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.selectFrom((EntityPath)this.qSalContractDO).where(predicate);
        long total = jpaQuery.fetchCount();
        if (total == 0L) {
            return PagingVO.builder().build();
        }
        PageRequest pageRequest = this.wrapperPageRequest(pageParam.getPageRequest(), null);
        this.appendPageAndSort(jpaQuery, pageRequest, this.qSalContractDO);
        List queryResult = jpaQuery.fetch();
        List<SalContractPageRespVO> pageResult = queryResult.stream().map(SalContractConvert.INSTANCE::doToPageRespVo).collect(Collectors.toList());
        this.translationPageSalContract(pageResult);
        return PagingVO.builder().total(total).records(pageResult).build();
    }

    private Predicate buildPageSearchCondition(SalContractPagingParam pageParam) {
        BooleanExpression predicate = this.qSalContractDO.isNotNull();
        if (Objects.nonNull(pageParam)) {
            if (StrUtil.isNotBlank((CharSequence)pageParam.getContractNo())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalContractDO.contractNo.like("%" + pageParam.getContractNo().trim() + "%"));
            }
            if (StrUtil.isNotBlank((CharSequence)pageParam.getContractName())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalContractDO.contractName.like("%" + pageParam.getContractName().trim() + "%"));
            }
            if (StrUtil.isNotBlank((CharSequence)pageParam.getContractType())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalContractDO.contractType.eq((Object)pageParam.getContractType()));
            }
            if (Objects.nonNull(pageParam.getSignDate())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalContractDO.signDate.eq((Object)pageParam.getSignDate()));
            }
            if (StrUtil.isNotBlank((CharSequence)pageParam.getProjName())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalContractDO.projName.like("%" + pageParam.getProjName().trim() + "%"));
            }
            if (StrUtil.isNotBlank((CharSequence)pageParam.getContractStatus())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalContractDO.contractStatus.eq((Object)pageParam.getContractStatus()));
            }
            if (Objects.nonNull(pageParam.getCustId())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalContractDO.custId.eq((Object)pageParam.getCustId()));
            }
            if (CollUtil.isNotEmpty((Collection)pageParam.getCustIds())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalContractDO.custId.in((Collection)pageParam.getCustIds()));
            }
            if (StrUtil.isNotBlank((CharSequence)pageParam.getCustCode())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalContractDO.custCode.like("%" + pageParam.getCustCode().trim() + "%"));
            }
            if (StrUtil.isNotBlank((CharSequence)pageParam.getCustName())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalContractDO.custName.like("%" + pageParam.getCustName().trim() + "%"));
            }
            if (StrUtil.isNotBlank((CharSequence)pageParam.getSignOu())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalContractDO.bSignOu.eq((Object)pageParam.getSignOu()));
            }
            if (StrUtil.isNotBlank((CharSequence)pageParam.getSalesMan())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalContractDO.bSalesman.eq((Object)pageParam.getSalesMan()));
            }
            if (StrUtil.isNotBlank((CharSequence)pageParam.getRegion())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalContractDO.bRegion.eq((Object)pageParam.getRegion()));
            }
            if (StrUtil.isNotBlank((CharSequence)pageParam.getFindCloseOrderFlag()) && pageParam.getFindCloseOrderFlag().equals("false")) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qSalContractDO.contractStatus.eq((Object)UdcEnum.SAL_CONTRACT_STATUS_APPROVED.getValueCode()));
            }
        }
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)DataAuthJpaUtil.dataAuthJpaPredicate((PathMetadata)this.qSalContractDO.getMetadata()));
        return predicate;
    }

    private void translationPageSalContract(List<SalContractPageRespVO> pageResult) {
        Set currCodes = pageResult.stream().map(SalContractPageRespVO::getCurrCode).filter(CharSequenceUtil::isNotBlank).distinct().collect(Collectors.toSet());
        ApiResult sysCurrencyRespDTOListApiResult = this.sysCurrencyRpcService.listByCodes(currCodes);
        Assert.notNull((Object)sysCurrencyRespDTOListApiResult, (String)"\u6839\u636e\u7f16\u7801\u67e5\u8be2\u5e01\u79cd\u5931\u8d25", (Object[])new Object[0]);
        Assert.isTrue((boolean)sysCurrencyRespDTOListApiResult.isSuccess(), (String)"\u6839\u636e\u7f16\u7801\u67e5\u8be2\u5e01\u79cd\u5931\u8d25", (Object[])new Object[0]);
        List currRpcResult = (List)this.sysCurrencyRpcService.listByCodes(currCodes).getData();
        List salesmans = pageResult.stream().map(SalContractPageRespVO::getBSalesman).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        List salesmansL = salesmans.stream().map(Long::parseLong).collect(Collectors.toList());
        List signDepts = pageResult.stream().map(SalContractPageRespVO::getBSignDept).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        List<Long> signDeptsL = signDepts.stream().map(Long::parseLong).collect(Collectors.toList());
        List signOus = pageResult.stream().map(SalContractPageRespVO::getBSignOu).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        List<Long> signOusL = signOus.stream().map(Long::parseLong).collect(Collectors.toList());
        OrgEmpRpcDtoParam orgEmpRpcDtoParam = new OrgEmpRpcDtoParam();
        List<Object> empListByParam = new ArrayList();
        if (!CollectionUtils.isEmpty(salesmansL)) {
            orgEmpRpcDtoParam.setEmpIds(salesmansL);
            empListByParam = this.rmiOrgEmpService.findEmpListByParam(orgEmpRpcDtoParam);
        }
        List<Object> ouDtoList = new ArrayList();
        if (!CollectionUtils.isEmpty(signOusL)) {
            ouDtoList = this.rmiOrgOuService.findOuDtoList(signOusL, null);
        }
        List<Object> buDtoList = new ArrayList();
        if (!CollectionUtils.isEmpty(signDeptsL)) {
            buDtoList = this.rmiOrgBuService.findBuDtoList(signDeptsL, null);
        }
        List<Object> finalEmpListByParam = empListByParam;
        List<Object> finalOuDtoList = ouDtoList;
        ArrayList finalBuDtoList = buDtoList;
        pageResult.forEach(r -> {
            currRpcResult.stream().filter(curr -> StrUtil.isNotBlank((CharSequence)r.getCurrCode()) && curr.getCurrCode().equals(r.getCurrCode())).findFirst().ifPresent(c -> r.setCurrName(c.getCurrName()));
            finalEmpListByParam.stream().filter(emp -> emp.getId().equals(Long.parseLong(r.getBSalesman() == null ? "0" : r.getBSalesman()))).findFirst().ifPresent(e -> r.setBSalesmanName(e.getEmpName()));
            finalOuDtoList.stream().filter(ou -> ou.getId().equals(Long.parseLong(r.getBSignOu() == null ? "0" : r.getBSignOu()))).findFirst().ifPresent(o -> r.setBSignOuName(o.getOuName()));
            finalBuDtoList.stream().filter(bu -> bu.getId().equals(Long.parseLong(r.getBSignDept() == null ? "0" : r.getBSignDept()))).findFirst().ifPresent(b -> r.setBSignDeptName(b.getBuName()));
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public JSONObject saveOrSubmit(SalContractSaveParam param, String operate) {
        log.info("\u5408\u540c\u4fdd\u5b58\u6216\u63d0\u4ea4\uff1a{}", (Object)JSON.toJSONString((Object)param));
        if (Objects.isNull(param.getId())) {
            String contractNo = this.nextNumberService.generateCode("yst-sale", "SAL_CONTR_NO", null);
            param.setContractNo(contractNo);
        }
        if (!StringUtils.isEmpty((Object)param.getProjName())) {
            Boolean exists = this.salProjRepoProc.exists(param.getProjName(), param.getCustCode());
            Boolean exists1 = this.salProjRepoProc.exists1(param.getProjName(), param.getBSignOu());
            if (!exists.booleanValue()) {
                throw new BusinessException("\u8be5\u5ba2\u6237\u4e0d\u5c5e\u4e8e\u8be5\u9879\u76ee,\u8bf7\u68c0\u67e5");
            }
            if (!exists1.booleanValue()) {
                throw new BusinessException("\u8be5\u7b7e\u7ea6\u516c\u53f8\u4e0d\u5c5e\u4e8e\u8be5\u9879\u76ee,\u8bf7\u68c0\u67e5");
            }
        }
        SalContractDO salContractDO = null;
        if (Objects.nonNull(param.getId())) {
            Optional contractOptional = this.salContractRepo.findById(param.getId());
            if (contractOptional.isPresent()) {
                salContractDO = (SalContractDO)contractOptional.get();
                if (CONTRACT_S_APPROVING.equals(operate) && !CONTRACT_S_DRAFT.equals(salContractDO.getContractStatus()) && !CONTRACT_S_REJECTED.equals(salContractDO.getContractStatus())) {
                    throw new BusinessException("\u5f53\u524d\u9500\u552e\u5408\u540c\u975e\u5f85\u63d0\u4ea4\u6216\u5df2\u62d2\u7edd\u72b6\u6001\u4e0d\u80fd\u6267\u884c\u8be5\u64cd\u4f5c");
                }
                param.setContractNo(salContractDO.getContractNo());
            } else {
                throw new BusinessException("\u5f53\u524d\u9500\u552e\u5408\u540c\u4e0d\u5b58\u5728");
            }
        }
        salContractDO = SalContractConvert.INSTANCE.paramToDo(param);
        salContractDO.setDeleteFlag(0);
        salContractDO.setContractVersion(Objects.isNull(param.getContractVersion()) ? 1 : param.getContractVersion());
        salContractDO.setContractStatus(operate);
        salContractDO.setSecBuId(Long.parseLong(param.getBSignDept()));
        salContractDO.setSecOuId(Long.parseLong(param.getBSignOu()));
        if (!ObjectUtils.isEmpty((Object)param.getBSalesman())) {
            salContractDO.setSecUserId(Long.parseLong(param.getBSalesman()));
        }
        this.salContractRepo.save(salContractDO);
        Long masId = salContractDO.getId();
        String contractNo = salContractDO.getContractNo();
        this.salContractDRepo.deleteAllByMasId(masId);
        this.salContractRecvRepo.deleteAllByContractNo(contractNo);
        List itemDetails = param.getItemDetails();
        List<SalContractDDO> itemDetailDOList = itemDetails.stream().map(SalContractDConvert.INSTANCE::paramToDo).collect(Collectors.toList());
        ArrayList<Long> ouIds = new ArrayList<Long>();
        ouIds.add(Long.parseLong(param.getBSignOu()));
        List<OrgOuRpcDTO> ouDtoList = this.rmiOrgOuService.findOuDtoList(ouIds, null);
        itemDetailDOList.forEach(i -> {
            i.setMasId(masId);
            if (param.getCatalogueFlag() == 1) {
                ItmItemBusinessRpcPagingParam pagingParam = new ItmItemBusinessRpcPagingParam();
                ArrayList<String> itemCodes = new ArrayList<String>();
                itemCodes.add(i.getItemCode());
                ArrayList<String> ouCodes = new ArrayList<String>();
                if (!CollectionUtils.isEmpty((Collection)ouDtoList)) {
                    String ouCode = ouDtoList.stream().filter(ou -> ou.getId().equals(Long.parseLong(param.getBSignOu()))).findFirst().orElseThrow(new BusinessException("\u8be5\u7b7e\u7ea6\u516c\u53f8\u4e0d\u5b58\u5728")).getOuCode();
                    ouCodes.add(ouCode);
                }
                pagingParam.setItemCodes(itemCodes);
                pagingParam.setBuCodes(ouCodes);
                PagingVO<ItmItemBusinessRpcPagingDTO> itemBusinessRpcDtoByParam = this.rmiItemService.findItemBusinessRpcDtoByParam(pagingParam);
                if (ObjectUtils.isEmpty((Object)itemBusinessRpcDtoByParam.getRecords())) {
                    throw new BusinessException("\u5546\u54c1\u7f16\u7801\u4e3a" + i.getItemCode() + "\u7684\u5546\u54c1\u5728\u7ecf\u8425\u76ee\u5f55\u4e0a\u6ca1\u6709\u7ef4\u62a4,\u8bf7\u68c0\u67e5");
                }
            }
        });
        this.salContractDRepo.saveAll(itemDetailDOList);
        List contractRecvs = param.getContractRecvs();
        if (!CollectionUtils.isEmpty((Collection)contractRecvs)) {
            List<SalContractRecvDO> contractRecvDOList = contractRecvs.stream().map(SalContractRecvConvert.INSTANCE::paramToDo).collect(Collectors.toList());
            contractRecvDOList.forEach(c -> {
                c.setMasId(masId);
                c.setSecBuId(Long.parseLong(param.getBSignDept()));
                c.setSecOuId(Long.parseLong(param.getBSignOu()));
                c.setSecUserId(Long.parseLong(param.getBSalesman()));
                c.setCurrCode(param.getCurrCode());
                c.setContractNo(param.getContractNo());
            });
            this.salContractRecvRepo.saveAll(contractRecvDOList);
        }
        List attachFiles = param.getAttachFiles();
        this.comSaleFileInfoService.comSaleFileHardSave(ATTACH_BUSINESS_TYPE, masId, attachFiles);
        JSONObject result = new JSONObject();
        result.put("id", (Object)masId);
        result.put("contractNo", (Object)contractNo);
        return result;
    }

    public SalContractServiceImpl(SalContractRepo salContractRepo, SalContractDRepo salContractDRepo, SalContractRecvRepo salContractRecvRepo, ComSaleFileInfoService comSaleFileInfoService, CrmCustService crmCustService, RmiSysNextNumberService nextNumberService, SysCurrencyRpcService sysCurrencyRpcService, PriSalePriceService priSalePriceService, RmiOrgEmpService rmiOrgEmpService, RmiOrgOuService rmiOrgOuService, RmiOrgBuService rmiOrgBuService, SalProjRepoProc salProjRepoProc, CrmCustRepoProc crmCustRepoProc, SalProjRepo salProjRepo, SalReceiptdRepo salReceiptdRepo, SalInvApplydRepo salInvApplydRepo, SalContractRepoProc salContractRepoProc, RmiCityCodeService rmiCityCodeService, RmiItemService rmiItemService) {
        this.salContractRepo = salContractRepo;
        this.salContractDRepo = salContractDRepo;
        this.salContractRecvRepo = salContractRecvRepo;
        this.comSaleFileInfoService = comSaleFileInfoService;
        this.crmCustService = crmCustService;
        this.nextNumberService = nextNumberService;
        this.sysCurrencyRpcService = sysCurrencyRpcService;
        this.priSalePriceService = priSalePriceService;
        this.rmiOrgEmpService = rmiOrgEmpService;
        this.rmiOrgOuService = rmiOrgOuService;
        this.rmiOrgBuService = rmiOrgBuService;
        this.salProjRepoProc = salProjRepoProc;
        this.crmCustRepoProc = crmCustRepoProc;
        this.salProjRepo = salProjRepo;
        this.salReceiptdRepo = salReceiptdRepo;
        this.salInvApplydRepo = salInvApplydRepo;
        this.salContractRepoProc = salContractRepoProc;
        this.rmiCityCodeService = rmiCityCodeService;
        this.rmiItemService = rmiItemService;
    }
}

