/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.elitesland.yst.production.sale.api.service.SalPayDepositService;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalPayDepositApproveParamVO;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalPayDepositParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.pro.SalContractSimpleRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalPayDepositRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalPayDepositReturnRespVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.convert.SalReceiptConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.entity.QSalReceiptDO;
import com.elitesland.yst.production.sale.entity.SalReceiptDO;
import com.elitesland.yst.production.sale.repo.SalReceiptRepo;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SalPayDepositServiceImpl
extends BaseServiceImpl
implements SalPayDepositService {
    private static final Logger log = LoggerFactory.getLogger(SalPayDepositServiceImpl.class);
    private static final QSalReceiptDO qSalReceiptDO = QSalReceiptDO.salReceiptDO;
    private final RmiSysNextNumberService rmiSysNextNumberService;
    private final SalReceiptRepo salReceiptRepo;
    private static final String DOC_TYPE_01 = "10";
    private static final String DOC_TYPE_02 = "20";
    private static final String QUERYRANGE_ALL = "all";
    private static final String QUERYRANGE_DEPOSIT_REFUNDED = "depositRefunded";
    private static final String QUERYRANGE_UN_DEPOSIT = "unreturnedDeposit";

    @SysCodeProc
    public PagingVO<SalPayDepositRespVO> search(SalPayDepositParamVO searchParam) {
        JPAQuery<SalPayDepositRespVO> jpaQuery;
        long total;
        if (StrUtil.isNotBlank((CharSequence)searchParam.getContractNo()) || StrUtil.isNotBlank((CharSequence)searchParam.getContractName()) || Objects.nonNull(searchParam.getCustId())) {
            // empty if block
        }
        if ((total = (jpaQuery = this.select(searchParam)).fetchCount()) == 0L) {
            return PagingVO.builder().build();
        }
        PageRequest pageRequest = this.wrapperPageRequest(searchParam.getPageRequest(), null);
        this.appendPageAndSort(jpaQuery, pageRequest, qSalReceiptDO);
        List respVOS = jpaQuery.fetch();
        this.translatePage(respVOS);
        return PagingVO.builder().total(total).records(respVOS).build();
    }

    private void translatePage(List<SalPayDepositRespVO> respVOS) {
        List contractNos = respVOS.stream().map(SalPayDepositRespVO::getCustCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        ArrayList contractResult = new ArrayList();
        if (!CollectionUtils.isEmpty(contractNos)) {
            // empty if block
        }
        ArrayList finalContractResult = contractResult;
        respVOS.forEach(deposit -> {
            Optional<SalContractSimpleRespVO> contractSimpleRespVO = finalContractResult.stream().filter(con -> con.getContractNo().equals(deposit.getContractCode())).findFirst();
            if (contractSimpleRespVO.isPresent()) {
                SalContractSimpleRespVO simpleRespVO = contractSimpleRespVO.get();
                deposit.setCustName(simpleRespVO.getCustName());
                deposit.setContractName(simpleRespVO.getContractName());
                deposit.setCustContactTel(simpleRespVO.getCustPicTel());
                deposit.setCustContactName(simpleRespVO.getCustPic());
            }
        });
    }

    @SysCodeProc
    public SalPayDepositRespVO findSalPayDepositById(Long id) {
        List salPayDepositRespVoS = this.select2(id).fetch();
        if (!CollectionUtils.isEmpty((Collection)salPayDepositRespVoS)) {
            this.translatePage(salPayDepositRespVoS);
            return (SalPayDepositRespVO)salPayDepositRespVoS.get(0);
        }
        throw new BusinessException("\u8be5\u652f\u4ed8\u62bc\u91d1\u5355\u4e0d\u5b58\u5728,\u8bf7\u68c0\u67e5");
    }

    @Transactional(rollbackFor={Exception.class})
    public Long createSalPayDeposit(SalPayDepositRespVO salPayDepositRespVO) {
        SalReceiptConvert salReceiptConvert = SalReceiptConvert.INSTANCE;
        if (StringUtils.isEmpty((Object)salPayDepositRespVO.getDocNo())) {
            String salQuoDocNo = this.rmiSysNextNumberService.generateCode("yst-sale", "PD", null);
            salPayDepositRespVO.setDocNo(salQuoDocNo);
        }
        if (StringUtils.isEmpty((Object)salPayDepositRespVO.getDocStatus())) {
            salPayDepositRespVO.setDocStatus(UdcEnum.SAL_QUOTATION_STATUS_DRAFT.getValueCode());
        }
        if (!salPayDepositRespVO.getDocStatus().equals(UdcEnum.SAL_QUOTATION_STATUS_APPROVING.getValueCode())) {
            salPayDepositRespVO.setDocStatus(UdcEnum.SAL_QUOTATION_STATUS_DRAFT.getValueCode());
        }
        salPayDepositRespVO.setDocType(DOC_TYPE_01);
        SalReceiptDO salReceiptDO = salReceiptConvert.detailRespVOToDo(salPayDepositRespVO);
        salReceiptDO.setOpenAmt(salPayDepositRespVO.getAmt());
        salReceiptDO.setReturningAmt(new BigDecimal(0));
        salReceiptDO.setReturnAmt(new BigDecimal(0));
        salReceiptDO.setAuditDataVersion(0);
        salReceiptDO.setSecBuId(salPayDepositRespVO.getBuId());
        SalReceiptDO save = (SalReceiptDO)this.salReceiptRepo.save(salReceiptDO);
        return save.getId();
    }

    private void checkForSave(SalPayDepositRespVO salPayDepositRespVO) {
        Optional byId = this.salReceiptRepo.findById(salPayDepositRespVO.getId());
        if (byId.isPresent()) {
            // empty if block
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public Long approveSalPayDeposit(SalPayDepositApproveParamVO param) {
        this.salReceiptRepo.approveSalPayDeposit(param.getId(), param.getDocStatus(), param.getApprComment(), LocalDateTime.now(), param.getApprUserId(), param.getApprUserName());
        return param.getId();
    }

    @Transactional(rollbackFor={Exception.class})
    public Long submitSalPayDeposit(SalPayDepositRespVO salPayDepositRespVO) {
        String contractCode = salPayDepositRespVO.getContractCode();
        JPAQuery<SalPayDepositRespVO> jpaQuery = this.select5(contractCode);
        List fetch = jpaQuery.fetch();
        if (CollectionUtil.isEmpty((Collection)fetch) || StringUtils.isEmpty((Object)salPayDepositRespVO.getContractCode())) {
            if (StringUtils.isEmpty((Object)salPayDepositRespVO.getDocStatus())) {
                salPayDepositRespVO.setDocStatus(UdcEnum.SAL_QUOTATION_STATUS_APPROVING.getValueCode());
                return this.createSalPayDeposit(salPayDepositRespVO);
            }
            salPayDepositRespVO.setDocStatus(UdcEnum.SAL_QUOTATION_STATUS_APPROVING.getValueCode());
            return this.createSalPayDeposit(salPayDepositRespVO);
        }
        throw new BusinessException("\u6b64\u5408\u540c\u5df2\u652f\u4ed8\u62bc\u91d1\uff0c\u8bf7\u52ff\u91cd\u590d\u7533\u8bf7");
    }

    @Transactional(rollbackFor={Exception.class})
    public Long deleteSalPayDeposit(Long id) {
        Optional byId = this.salReceiptRepo.findById(id);
        if (byId.isPresent()) {
            SalReceiptDO salReceiptDO = (SalReceiptDO)byId.get();
            if (salReceiptDO.getDocStatus().equals(UdcEnum.SAL_QUOTATION_STATUS_DRAFT.getValueCode())) {
                this.salReceiptRepo.deleteSalPayDeposit(id, "1");
                return id;
            }
            throw new BusinessException("\u53ea\u80fd\u5220\u9664\u5f85\u63d0\u4ea4\u72b6\u6001\u8ba2\u5355");
        }
        throw new BusinessException("\u6ca1\u6709\u67e5\u51fa\u8ba2\u5355");
    }

    @Transactional(rollbackFor={Exception.class})
    public Long refundSalQuotationSubmit(SalPayDepositReturnRespVO param) {
        String relateDocNo;
        SalReceiptDO salReceiptRelateDO;
        if (StringUtils.isEmpty((Object)param.getBuName())) {
            throw new BusinessException("\u7ec4\u7ec7\u540d\u79f0\u4e3a\u7a7a");
        }
        if (param.getId() != null) {
            Optional result = this.salReceiptRepo.findById(param.getId());
            if (result.isPresent()) {
                if (UdcEnum.SAL_QUOTATION_STATUS_APPROVING.getValueCode().equals(((SalReceiptDO)result.get()).getDocStatus())) {
                    throw new BusinessException("\u5355\u636e\u72b6\u6001\u5df2\u7ecf\u4e3a\u5f85\u5ba1\u6279\u7684\u4e0d\u80fd\u518d\u6b21\u63d0\u4ea4");
                }
            } else {
                throw new BusinessException("\u5355\u636e\u72b6\u6001\u4e0d\u5b58\u5728");
            }
        }
        if ((salReceiptRelateDO = this.salReceiptRepo.findByDocNo(relateDocNo = param.getRelateDocNo())).getDocStatus().equals(UdcEnum.SAL_QUOTATION_STATUS_APPROVED.getValueCode()) && salReceiptRelateDO.getDocType().equals(DOC_TYPE_01)) {
            Integer auditDataVersion = salReceiptRelateDO.getAuditDataVersion();
            BigDecimal returnAmt = param.getReturnAmt();
            if (returnAmt.compareTo(salReceiptRelateDO.getOpenAmt()) > 0) {
                throw new BusinessException("\u9000\u62bc\u91d1\u91d1\u989d\u5927\u4e8e\u62bc\u91d1\u4f59\u989d");
            }
            BigDecimal returningAmt = salReceiptRelateDO.getReturningAmt().add(param.getReturnAmt());
            BigDecimal openAmt = salReceiptRelateDO.getOpenAmt().subtract(param.getReturnAmt());
            if (openAmt.compareTo(new BigDecimal(0)) < 0) {
                throw new BusinessException("\u62bc\u91d1\u4f59\u989d\u4e0d\u80fd\u4e3a\u8d1f\u6570");
            }
            int num = this.salReceiptRepo.updateByDocNoAndVersion(openAmt, returningAmt, relateDocNo, auditDataVersion, auditDataVersion + 1);
            if (num == 0) {
                throw new BusinessException("\u8bf7\u52ff\u540c\u65f6\u64cd\u4f5c");
            }
            SalReceiptConvert salReceiptConvert = SalReceiptConvert.INSTANCE;
            SalReceiptDO salReceiptDO = salReceiptConvert.detailReturnRespVOToDo(param);
            if (!StrUtil.isNotBlank((CharSequence)param.getDocNo())) {
                String salQuoDocNo = this.rmiSysNextNumberService.generateCode("yst-sale", "PD", new ArrayList<String>());
                salReceiptDO.setDocNo(salQuoDocNo);
            }
            salReceiptDO.setSecBuId(param.getBuId());
            salReceiptDO.setAmt(returnAmt);
            salReceiptDO.setDocStatus(UdcEnum.SAL_QUOTATION_STATUS_APPROVING.getValueCode());
            return ((SalReceiptDO)this.salReceiptRepo.save(salReceiptDO)).getId();
        }
        throw new BusinessException("\u4ec5\u7c7b\u578b\u4e3a\u652f\u4ed8\u62bc\u91d1\u7684\u53ef\u7533\u8bf7\uff0c\u4e14\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u5ba1\u6279");
    }

    @Transactional(rollbackFor={Exception.class})
    public Long refundSalQuotationSave(SalPayDepositReturnRespVO param) {
        SalPayDepositReturnRespVO salPayDepositReturnRespVO;
        if (StringUtils.isEmpty((Object)param.getBuName())) {
            throw new BusinessException("\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (param.getId() != null && (salPayDepositReturnRespVO = this.refundSalQuotationQueryById(param.getId())).getDocStatus().equals(DOC_TYPE_01)) {
            throw new BusinessException("\u62bc\u91d1\u7c7b\u578b\u53ea\u80fd\u4e3a\u9000\u62bc\u91d1\u7c7b\u578b");
        }
        SalReceiptDO salReceiptRelateDO = this.salReceiptRepo.findByDocNo(param.getRelateDocNo());
        if (salReceiptRelateDO.getDocStatus().equals(UdcEnum.SAL_QUOTATION_STATUS_APPROVED.getValueCode()) && salReceiptRelateDO.getDocType().equals(DOC_TYPE_01)) {
            BigDecimal returnAmt = param.getReturnAmt();
            if (returnAmt.compareTo(salReceiptRelateDO.getOpenAmt()) >= 1) {
                throw new BusinessException("\u9000\u62bc\u91d1\u91d1\u989d\u5927\u4e8e\u62bc\u91d1\u4f59\u989d");
            }
            SalReceiptConvert salReceiptConvert = SalReceiptConvert.INSTANCE;
            SalReceiptDO salReceiptDO = salReceiptConvert.detailReturnRespVOToDo(param);
            if (!StrUtil.isNotBlank((CharSequence)param.getDocNo())) {
                String salQuoDocNo = this.rmiSysNextNumberService.generateCode("yst-sale", "PD", new ArrayList<String>());
                salReceiptDO.setDocNo(salQuoDocNo);
            }
            salReceiptDO.setDocType(DOC_TYPE_02);
            salReceiptDO.setAmt(returnAmt);
            salReceiptDO.setRelateDocNo(param.getRelateDocNo());
            salReceiptDO.setDocStatus(UdcEnum.SAL_QUOTATION_STATUS_DRAFT.getValueCode());
            salReceiptDO.setSecBuId(param.getBuId());
            return ((SalReceiptDO)this.salReceiptRepo.save(salReceiptDO)).getId();
        }
        throw new BusinessException("\u4ec5\u7c7b\u578b\u4e3a\u652f\u4ed8\u62bc\u91d1\u7684\u53ef\u7533\u8bf7\uff0c\u4e14\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u5ba1\u6279");
    }

    @SysCodeProc
    public PagingVO<SalPayDepositReturnRespVO> findRefundByPayDepositDocNo(String docNo) {
        JPAQuery<SalPayDepositReturnRespVO> jpaQuery = this.select3(docNo);
        long total = jpaQuery.fetchCount();
        if (total < 1L) {
            return PagingVO.builder().build();
        }
        List result = jpaQuery.fetch();
        return PagingVO.builder().total(total).records(result).build();
    }

    @Transactional(rollbackFor={Exception.class})
    public Long refundSalQuotationRefuse(SalPayDepositApproveParamVO param) {
        Optional result = this.salReceiptRepo.findById(param.getId());
        if (result.isEmpty()) {
            throw new BusinessException("\u6ca1\u6709\u627e\u5230\u6b64\u5355\u636e");
        }
        if (!UdcEnum.SAL_QUOTATION_STATUS_APPROVING.getValueCode().equals(((SalReceiptDO)result.get()).getDocStatus())) {
            throw new BusinessException("\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5f85\u5ba1\u6279\u7684\u624d\u80fd\u5ba1\u6279");
        }
        SalReceiptDO salReceiptDO = this.salReceiptRepo.findByDocNo(((SalReceiptDO)result.get()).getRelateDocNo());
        BigDecimal returningAmt = salReceiptDO.getReturningAmt();
        returningAmt = returningAmt.subtract(((SalReceiptDO)result.get()).getReturnAmt());
        BigDecimal openAmt = salReceiptDO.getOpenAmt().add(((SalReceiptDO)result.get()).getReturnAmt());
        int total = this.salReceiptRepo.updateReturningAmtByIdAndVersion(returningAmt, salReceiptDO.getId(), salReceiptDO.getAuditDataVersion(), salReceiptDO.getAuditDataVersion() + 1, openAmt);
        if (total < 1) {
            throw new BusinessException("\u8bf7\u52ff\u540c\u65f6\u64cd\u4f5c");
        }
        this.salReceiptRepo.approveSalPayDeposit(param.getId(), UdcEnum.SAL_QUOTATION_STATUS_REJECTED.getValueCode(), param.getApprComment(), LocalDateTime.now(), param.getApprUserId(), param.getApprUserName());
        return param.getId();
    }

    @Transactional(rollbackFor={Exception.class})
    public Long refundSalQuotationApprove(SalPayDepositApproveParamVO param) {
        Optional result = this.salReceiptRepo.findById(param.getId());
        if (result.isEmpty()) {
            throw new BusinessException("\u6ca1\u6709\u627e\u5230\u6b64\u5355\u636e");
        }
        if (!UdcEnum.SAL_QUOTATION_STATUS_APPROVING.getValueCode().equals(((SalReceiptDO)result.get()).getDocStatus())) {
            throw new BusinessException("\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5f85\u5ba1\u6279\u7684\u624d\u80fd\u5ba1\u6279");
        }
        SalReceiptDO salReceiptDO = this.salReceiptRepo.findByDocNo(((SalReceiptDO)result.get()).getRelateDocNo());
        Integer auditDataVersion = salReceiptDO.getAuditDataVersion();
        BigDecimal openAmt = salReceiptDO.getOpenAmt();
        BigDecimal returningAmt = salReceiptDO.getReturningAmt();
        int total = this.salReceiptRepo.updateOpenAmtByIdAndVersion(returningAmt = returningAmt.subtract(((SalReceiptDO)result.get()).getReturnAmt()), salReceiptDO.getId(), auditDataVersion, auditDataVersion + 1);
        if (total < 1) {
            throw new BusinessException("\u8bf7\u52ff\u540c\u65f6\u64cd\u4f5c");
        }
        this.salReceiptRepo.approveSalPayDeposit(param.getId(), UdcEnum.SAL_QUOTATION_STATUS_APPROVED.getValueCode(), param.getApprComment(), LocalDateTime.now(), param.getApprUserId(), param.getApprUserName());
        return param.getId();
    }

    @SysCodeProc
    public SalPayDepositReturnRespVO refundSalQuotationQueryById(Long id) {
        JPAQuery<SalPayDepositReturnRespVO> jpaQuery = this.select4(id);
        List result = jpaQuery.fetch();
        return (SalPayDepositReturnRespVO)result.get(0);
    }

    public JPAQuery<SalPayDepositRespVO> select(SalPayDepositParamVO searchParam) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SalPayDepositRespVO.class, (Expression[])new Expression[]{SalPayDepositServiceImpl.qSalReceiptDO.id, SalPayDepositServiceImpl.qSalReceiptDO.docNo, SalPayDepositServiceImpl.qSalReceiptDO.custId, SalPayDepositServiceImpl.qSalReceiptDO.custName, SalPayDepositServiceImpl.qSalReceiptDO.custCode, SalPayDepositServiceImpl.qSalReceiptDO.contractCode, SalPayDepositServiceImpl.qSalReceiptDO.contractName, SalPayDepositServiceImpl.qSalReceiptDO.amt, SalPayDepositServiceImpl.qSalReceiptDO.applyDate, SalPayDepositServiceImpl.qSalReceiptDO.demandPaymentDate, SalPayDepositServiceImpl.qSalReceiptDO.planReturnDate, SalPayDepositServiceImpl.qSalReceiptDO.returnDate, SalPayDepositServiceImpl.qSalReceiptDO.bankId, SalPayDepositServiceImpl.qSalReceiptDO.bankCode, SalPayDepositServiceImpl.qSalReceiptDO.bankName, SalPayDepositServiceImpl.qSalReceiptDO.bankAcc, SalPayDepositServiceImpl.qSalReceiptDO.custContactName, SalPayDepositServiceImpl.qSalReceiptDO.custContactTel, SalPayDepositServiceImpl.qSalReceiptDO.applyEmpId, SalPayDepositServiceImpl.qSalReceiptDO.applyName, SalPayDepositServiceImpl.qSalReceiptDO.docStatus, SalPayDepositServiceImpl.qSalReceiptDO.apprUserId, SalPayDepositServiceImpl.qSalReceiptDO.apprUserName, SalPayDepositServiceImpl.qSalReceiptDO.remark, SalPayDepositServiceImpl.qSalReceiptDO.apprComment, SalPayDepositServiceImpl.qSalReceiptDO.soNo, SalPayDepositServiceImpl.qSalReceiptDO.depositDescription, SalPayDepositServiceImpl.qSalReceiptDO.ouName, SalPayDepositServiceImpl.qSalReceiptDO.payMethod, SalPayDepositServiceImpl.qSalReceiptDO.relateDocNo, SalPayDepositServiceImpl.qSalReceiptDO.docType, SalPayDepositServiceImpl.qSalReceiptDO.saleRegion, SalPayDepositServiceImpl.qSalReceiptDO.buName, SalPayDepositServiceImpl.qSalReceiptDO.buId})).from((EntityPath)qSalReceiptDO);
        if (searchParam != null) {
            jpaQuery.where(this.where(searchParam));
        }
        return jpaQuery;
    }

    public JPAQuery<SalPayDepositRespVO> select2(Long id) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SalPayDepositRespVO.class, (Expression[])new Expression[]{SalPayDepositServiceImpl.qSalReceiptDO.id, SalPayDepositServiceImpl.qSalReceiptDO.docNo, SalPayDepositServiceImpl.qSalReceiptDO.custId, SalPayDepositServiceImpl.qSalReceiptDO.custName, SalPayDepositServiceImpl.qSalReceiptDO.custCode, SalPayDepositServiceImpl.qSalReceiptDO.contractCode, SalPayDepositServiceImpl.qSalReceiptDO.contractName, SalPayDepositServiceImpl.qSalReceiptDO.amt, SalPayDepositServiceImpl.qSalReceiptDO.applyDate, SalPayDepositServiceImpl.qSalReceiptDO.demandPaymentDate, SalPayDepositServiceImpl.qSalReceiptDO.planReturnDate, SalPayDepositServiceImpl.qSalReceiptDO.returnDate, SalPayDepositServiceImpl.qSalReceiptDO.bankId, SalPayDepositServiceImpl.qSalReceiptDO.bankCode, SalPayDepositServiceImpl.qSalReceiptDO.bankName, SalPayDepositServiceImpl.qSalReceiptDO.bankAcc, SalPayDepositServiceImpl.qSalReceiptDO.custContactName, SalPayDepositServiceImpl.qSalReceiptDO.custContactTel, SalPayDepositServiceImpl.qSalReceiptDO.applyEmpId, SalPayDepositServiceImpl.qSalReceiptDO.applyName, SalPayDepositServiceImpl.qSalReceiptDO.docStatus, SalPayDepositServiceImpl.qSalReceiptDO.apprUserId, SalPayDepositServiceImpl.qSalReceiptDO.apprUserName, SalPayDepositServiceImpl.qSalReceiptDO.remark, SalPayDepositServiceImpl.qSalReceiptDO.apprComment, SalPayDepositServiceImpl.qSalReceiptDO.soNo, SalPayDepositServiceImpl.qSalReceiptDO.depositDescription, SalPayDepositServiceImpl.qSalReceiptDO.ouName, SalPayDepositServiceImpl.qSalReceiptDO.ouId, SalPayDepositServiceImpl.qSalReceiptDO.payMethod, SalPayDepositServiceImpl.qSalReceiptDO.relateDocNo, SalPayDepositServiceImpl.qSalReceiptDO.docType, SalPayDepositServiceImpl.qSalReceiptDO.saleRegion, SalPayDepositServiceImpl.qSalReceiptDO.buName, SalPayDepositServiceImpl.qSalReceiptDO.openAmt, SalPayDepositServiceImpl.qSalReceiptDO.buId})).from((EntityPath)qSalReceiptDO);
        if (id != null) {
            jpaQuery.where((Predicate)SalPayDepositServiceImpl.qSalReceiptDO.id.eq((Object)id));
        }
        return jpaQuery;
    }

    public JPAQuery<SalPayDepositRespVO> select5(String contractCode) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SalPayDepositRespVO.class, (Expression[])new Expression[]{SalPayDepositServiceImpl.qSalReceiptDO.id})).from((EntityPath)qSalReceiptDO);
        if (!StringUtils.isEmpty((Object)contractCode)) {
            jpaQuery.where((Predicate)SalPayDepositServiceImpl.qSalReceiptDO.contractCode.eq((Object)contractCode).and((Predicate)SalPayDepositServiceImpl.qSalReceiptDO.docStatus.in((Object[])new String[]{"APPROVING", "APPROVED"})));
        }
        return jpaQuery;
    }

    public JPAQuery<SalPayDepositReturnRespVO> select3(String docNo) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SalPayDepositReturnRespVO.class, (Expression[])new Expression[]{SalPayDepositServiceImpl.qSalReceiptDO.id, SalPayDepositServiceImpl.qSalReceiptDO.docNo, SalPayDepositServiceImpl.qSalReceiptDO.custId, SalPayDepositServiceImpl.qSalReceiptDO.custName, SalPayDepositServiceImpl.qSalReceiptDO.custCode, SalPayDepositServiceImpl.qSalReceiptDO.soNo, SalPayDepositServiceImpl.qSalReceiptDO.contractCode, SalPayDepositServiceImpl.qSalReceiptDO.contractName, SalPayDepositServiceImpl.qSalReceiptDO.applyDate, SalPayDepositServiceImpl.qSalReceiptDO.demandPaymentDate, SalPayDepositServiceImpl.qSalReceiptDO.returnDate, SalPayDepositServiceImpl.qSalReceiptDO.bankId, SalPayDepositServiceImpl.qSalReceiptDO.bankCode, SalPayDepositServiceImpl.qSalReceiptDO.bankName, SalPayDepositServiceImpl.qSalReceiptDO.bankAcc, SalPayDepositServiceImpl.qSalReceiptDO.custContactName, SalPayDepositServiceImpl.qSalReceiptDO.custContactTel, SalPayDepositServiceImpl.qSalReceiptDO.applyEmpId, SalPayDepositServiceImpl.qSalReceiptDO.applyName, SalPayDepositServiceImpl.qSalReceiptDO.docStatus, SalPayDepositServiceImpl.qSalReceiptDO.apprUserId, SalPayDepositServiceImpl.qSalReceiptDO.apprUserName, SalPayDepositServiceImpl.qSalReceiptDO.depositDescription, SalPayDepositServiceImpl.qSalReceiptDO.ouName, SalPayDepositServiceImpl.qSalReceiptDO.remark, SalPayDepositServiceImpl.qSalReceiptDO.apprComment, SalPayDepositServiceImpl.qSalReceiptDO.payMethod, SalPayDepositServiceImpl.qSalReceiptDO.relateDocNo, SalPayDepositServiceImpl.qSalReceiptDO.docType, SalPayDepositServiceImpl.qSalReceiptDO.saleRegion, SalPayDepositServiceImpl.qSalReceiptDO.returnAmt, SalPayDepositServiceImpl.qSalReceiptDO.openAmt, SalPayDepositServiceImpl.qSalReceiptDO.buName, SalPayDepositServiceImpl.qSalReceiptDO.buId})).from((EntityPath)qSalReceiptDO);
        if (!StringUtils.isEmpty((Object)docNo)) {
            jpaQuery.where((Predicate)SalPayDepositServiceImpl.qSalReceiptDO.relateDocNo.eq((Object)docNo).and((Predicate)SalPayDepositServiceImpl.qSalReceiptDO.docType.eq((Object)DOC_TYPE_02)));
        }
        return jpaQuery;
    }

    public JPAQuery<SalPayDepositReturnRespVO> select4(Long id) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SalPayDepositReturnRespVO.class, (Expression[])new Expression[]{SalPayDepositServiceImpl.qSalReceiptDO.id, SalPayDepositServiceImpl.qSalReceiptDO.docNo, SalPayDepositServiceImpl.qSalReceiptDO.docType, SalPayDepositServiceImpl.qSalReceiptDO.custId, SalPayDepositServiceImpl.qSalReceiptDO.custName, SalPayDepositServiceImpl.qSalReceiptDO.custCode, SalPayDepositServiceImpl.qSalReceiptDO.soNo, SalPayDepositServiceImpl.qSalReceiptDO.contractCode, SalPayDepositServiceImpl.qSalReceiptDO.contractName, SalPayDepositServiceImpl.qSalReceiptDO.amt, SalPayDepositServiceImpl.qSalReceiptDO.applyDate, SalPayDepositServiceImpl.qSalReceiptDO.demandPaymentDate, SalPayDepositServiceImpl.qSalReceiptDO.planReturnDate, SalPayDepositServiceImpl.qSalReceiptDO.returnDate, SalPayDepositServiceImpl.qSalReceiptDO.bankId, SalPayDepositServiceImpl.qSalReceiptDO.bankCode, SalPayDepositServiceImpl.qSalReceiptDO.bankAcc, SalPayDepositServiceImpl.qSalReceiptDO.bankName, SalPayDepositServiceImpl.qSalReceiptDO.custContactName, SalPayDepositServiceImpl.qSalReceiptDO.custContactTel, SalPayDepositServiceImpl.qSalReceiptDO.applyEmpId, SalPayDepositServiceImpl.qSalReceiptDO.applyName, SalPayDepositServiceImpl.qSalReceiptDO.docStatus, SalPayDepositServiceImpl.qSalReceiptDO.apprUserId, SalPayDepositServiceImpl.qSalReceiptDO.apprUserName, SalPayDepositServiceImpl.qSalReceiptDO.depositDescription, SalPayDepositServiceImpl.qSalReceiptDO.remark, SalPayDepositServiceImpl.qSalReceiptDO.apprComment, SalPayDepositServiceImpl.qSalReceiptDO.ouName, SalPayDepositServiceImpl.qSalReceiptDO.ouId, SalPayDepositServiceImpl.qSalReceiptDO.payMethod, SalPayDepositServiceImpl.qSalReceiptDO.relateDocNo, SalPayDepositServiceImpl.qSalReceiptDO.saleRegion, SalPayDepositServiceImpl.qSalReceiptDO.returnAmt, SalPayDepositServiceImpl.qSalReceiptDO.openAmt, SalPayDepositServiceImpl.qSalReceiptDO.buName, SalPayDepositServiceImpl.qSalReceiptDO.buId})).from((EntityPath)qSalReceiptDO);
        if (!StringUtils.isEmpty((Object)id)) {
            jpaQuery.where((Predicate)SalPayDepositServiceImpl.qSalReceiptDO.id.eq((Object)id).and((Predicate)SalPayDepositServiceImpl.qSalReceiptDO.docType.eq((Object)DOC_TYPE_02)));
        }
        return jpaQuery;
    }

    public Predicate where(SalPayDepositParamVO searchParam) {
        BooleanExpression predicate = qSalReceiptDO.isNotNull();
        if (!StringUtils.isEmpty((Object)searchParam.getDocNo())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalPayDepositServiceImpl.qSalReceiptDO.docNo.like("%" + searchParam.getDocNo() + "%"));
        }
        if (!StringUtils.isEmpty((Object)searchParam.getCustCode())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalPayDepositServiceImpl.qSalReceiptDO.custCode.like("%" + searchParam.getCustCode() + "%"));
        }
        if (!StringUtils.isEmpty((Object)searchParam.getCustName())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalPayDepositServiceImpl.qSalReceiptDO.custName.like("%" + searchParam.getCustName() + "%"));
        }
        if (!StringUtils.isEmpty((Object)searchParam.getApplyEmpId())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalPayDepositServiceImpl.qSalReceiptDO.applyEmpId.eq((Object)searchParam.getApplyEmpId()));
        }
        if (!StringUtils.isEmpty((Object)searchParam.getApplyDateBegin())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalPayDepositServiceImpl.qSalReceiptDO.applyDate.eq((Object)searchParam.getApplyDateBegin()).or((Predicate)SalPayDepositServiceImpl.qSalReceiptDO.applyDate.after((Comparable)searchParam.getApplyDateBegin())));
        }
        if (!StringUtils.isEmpty((Object)searchParam.getApplyDateEnd())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalPayDepositServiceImpl.qSalReceiptDO.applyDate.eq((Object)searchParam.getApplyDateEnd()).or((Predicate)SalPayDepositServiceImpl.qSalReceiptDO.applyDate.before((Comparable)searchParam.getApplyDateEnd())));
        }
        if (!StringUtils.isEmpty((Object)searchParam.getContractNo())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalPayDepositServiceImpl.qSalReceiptDO.contractCode.like("%" + searchParam.getContractNo() + "%"));
        }
        if (!StringUtils.isEmpty((Object)searchParam.getContractName())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalPayDepositServiceImpl.qSalReceiptDO.contractName.like("%" + searchParam.getContractName() + "%"));
        }
        if (!StringUtils.isEmpty((Object)searchParam.getOuId())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalPayDepositServiceImpl.qSalReceiptDO.ouId.eq((Object)searchParam.getOuId()));
        }
        predicate = !StringUtils.isEmpty((Object)searchParam.getDocType()) ? ExpressionUtils.and((Predicate)predicate, (Predicate)SalPayDepositServiceImpl.qSalReceiptDO.docType.eq((Object)searchParam.getDocType())) : ExpressionUtils.and((Predicate)predicate, (Predicate)SalPayDepositServiceImpl.qSalReceiptDO.docType.in((Object[])new String[]{DOC_TYPE_01, DOC_TYPE_02}));
        if (!StringUtils.isEmpty((Object)searchParam.getQueryRange()) && QUERYRANGE_DEPOSIT_REFUNDED.equals(searchParam.getQueryRange())) {
            if (StringUtils.isEmpty((Object)searchParam.getDocType())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalPayDepositServiceImpl.qSalReceiptDO.docType.eq((Object)DOC_TYPE_01));
            }
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalPayDepositServiceImpl.qSalReceiptDO.openAmt.eq((Object)new BigDecimal("0.0000")));
        }
        if (!StringUtils.isEmpty((Object)searchParam.getQueryRange()) && QUERYRANGE_UN_DEPOSIT.equals(searchParam.getQueryRange())) {
            if (StringUtils.isEmpty((Object)searchParam.getDocType())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalPayDepositServiceImpl.qSalReceiptDO.docType.eq((Object)DOC_TYPE_01));
            }
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)SalPayDepositServiceImpl.qSalReceiptDO.openAmt.ne((Object)new BigDecimal("0.0000")));
        }
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)DataAuthJpaUtil.dataAuthJpaPredicate((PathMetadata)qSalReceiptDO.getMetadata()));
        return predicate;
    }

    public SalPayDepositServiceImpl(RmiSysNextNumberService rmiSysNextNumberService, SalReceiptRepo salReceiptRepo) {
        this.rmiSysNextNumberService = rmiSysNextNumberService;
        this.salReceiptRepo = salReceiptRepo;
    }
}

