/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.el.coordinator.file.utils.UUIDUtil;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.order.param.SalSoDetailRespDTO;
import com.elitesland.yst.production.sale.api.service.shop.SalReceiptStateService;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalReceiptRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalReceiptdRespVO;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.dto.SalReceiptDetailStatementDTO;
import com.elitesland.yst.production.sale.dto.SalReceiptStatementDTO;
import com.elitesland.yst.production.sale.entity.SalReceiptSettleDO;
import com.elitesland.yst.production.sale.entity.SalReceiptSettleddDO;
import com.elitesland.yst.production.sale.entity.SalReceiptSettleitemDO;
import com.elitesland.yst.production.sale.repo.CrmCustRepo;
import com.elitesland.yst.production.sale.repo.SalReceiptSettleRepo;
import com.elitesland.yst.production.sale.repo.SalReceiptSettleddRepo;
import com.elitesland.yst.production.sale.repo.SalReceiptSettleitemRepo;
import com.elitesland.yst.production.sale.rmi.ystfin.RmiSettleDocTypeService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgOuService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiSysSettingService;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SalReceiptStateServiceImpl
extends BaseServiceImpl
implements SalReceiptStateService {
    private static final Logger log = LoggerFactory.getLogger(SalReceiptStateServiceImpl.class);
    private final RmiSysSettingService rmiSysSettingService;
    private final SalReceiptSettleddRepo salReceiptSettleddRepo;
    private final CrmCustRepo crmCustRepo;
    private final RmiSettleDocTypeService rmiSettleDocTypeService;
    private final SalReceiptSettleRepo salReceiptSettleRepo;
    private final SalReceiptSettleitemRepo salReceiptSettleitemRepo;
    private final RmiOrgOuService rmiOrgOuService;
    @Autowired
    private UdcProvider udcProvider;

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Object> createStatement(SalReceiptRespVO receiptDO, List<SalReceiptdRespVO> ddos, String receiptSerial) {
        SalReceiptStatementDTO statementDTO = this.getSalReceiptStatementDTO(receiptDO, ddos, receiptSerial);
        this.setSettledd(statementDTO);
        Message<SalReceiptStatementDTO> message = this.sendMessage(statementDTO);
        LocalDateTime now = LocalDateTime.now();
        log.info("\u6536\u6b3e\u7ed3\u7b97\u5355" + now + "\u8f93\u51fa:" + statementDTO);
        return ApiResult.ok(message);
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Object> createStatement(String soType, SalReceiptRespVO receiptDO, List<SalReceiptdRespVO> ddos, String receiptSerial) {
        SalReceiptStatementDTO statementDTO = this.getSalReceiptStatementDTO(receiptDO, ddos, receiptSerial);
        this.setSettledd(soType, statementDTO);
        Message<SalReceiptStatementDTO> message = this.sendMessage(statementDTO);
        LocalDateTime now = LocalDateTime.now();
        log.info("\u6536\u6b3e\u7ed3\u7b97\u5355" + now + "\u8f93\u51fa:" + JSONUtil.toJsonStr((Object)statementDTO));
        return ApiResult.ok(message);
    }

    private void setSettledd(String soType, SalReceiptStatementDTO statementDTO) {
        SalReceiptSettleDO settleDO = new SalReceiptSettleDO();
        this.salReceiptSettleRepo.save(settleDO);
        statementDTO.setSourceId(settleDO.getId());
        AtomicReference<BigDecimal> settleAmt = new AtomicReference<BigDecimal>(new BigDecimal(0));
        AtomicReference<BigDecimal> settleTax = new AtomicReference<BigDecimal>(new BigDecimal(0));
        if (statementDTO.getDetails() != null && statementDTO.getDetails().size() > 0) {
            statementDTO.getDetails().forEach(detail -> {
                SalReceiptSettleitemDO settleitemDO = new SalReceiptSettleitemDO();
                settleitemDO.setMasId(settleDO.getId());
                settleitemDO.setLineNo(detail.getSoLineNo());
                settleitemDO.setItemCat(detail.getItemClass());
                settleitemDO.setFinCat(detail.getFinanceClass());
                settleitemDO.setTaxRate(detail.getTaxRate());
                settleitemDO.setReceiptAmt(detail.getAmt());
                settleitemDO.setReceiptTax(detail.getTax());
                settleitemDO.setApAmt(detail.getTotalAmount());
                settleitemDO.setCardAmt(BigDecimal.ZERO);
                settleitemDO.setCouponAmt(BigDecimal.ZERO);
                settleitemDO.setGiftAmt(BigDecimal.ZERO);
                settleitemDO.setUsepointAmt(BigDecimal.ZERO);
                settleitemDO.setLineNo(detail.getSoLineNo());
                settleitemDO.setItemCat(detail.getItemClass());
                this.salReceiptSettleitemRepo.save(settleitemDO);
                SalReceiptSettleddDO settleddDO = new SalReceiptSettleddDO();
                settleddDO.setSettleitemId(settleitemDO.getId());
                if (statementDTO.getDetails() != null && statementDTO.getDetails().size() > 0) {
                    settleddDO.setDocNo(((SalReceiptDetailStatementDTO)statementDTO.getDetails().get(0)).getSoNo());
                }
                settleddDO.setCreateUserId(statementDTO.getCreateUserId());
                settleddDO.setCurrCode(statementDTO.getCurrency());
                settleddDO.setAgentEmpId(statementDTO.getApplyEmpId());
                settleddDO.setAgentName(statementDTO.getApplyName());
                settleddDO.setSoSource(statementDTO.getOrderChannel());
                settleddDO.setReceiptType(statementDTO.getBusinessType2());
                settleddDO.setReceiptDate(statementDTO.getProcessTime());
                settleddDO.setDocTime(statementDTO.getProcessTime());
                settleddDO.setPno(statementDTO.getDocNo());
                settleddDO.setOuId(statementDTO.getOuId());
                settleddDO.setOuCode(statementDTO.getOuCode());
                settleddDO.setOuName(statementDTO.getOuName());
                settleddDO.setBuId(statementDTO.getBuId());
                settleddDO.setBuCode(statementDTO.getBuCode());
                settleddDO.setBuName(statementDTO.getBuName());
                settleddDO.setCustId(statementDTO.getCustId());
                settleddDO.setCustCode(statementDTO.getCustCode());
                settleddDO.setCustName(statementDTO.getCustName());
                settleddDO.setDocType(soType);
                settleddDO.setDocType2("B");
                settleddDO.setCardAmt(BigDecimal.ZERO);
                settleddDO.setGiftAmt(BigDecimal.ZERO);
                settleddDO.setCouponAmt(BigDecimal.ZERO);
                settleddDO.setUsepointAmt(BigDecimal.ZERO);
                settleddDO.setDocDId(detail.getSoDId());
                settleddDO.setItemCat(detail.getItemClass());
                settleddDO.setFinCat(detail.getFinanceClass());
                settleddDO.setItemCode(detail.getItemCode());
                settleddDO.setItemId(detail.getItemId());
                settleddDO.setItemName(detail.getItemName());
                settleddDO.setUom(detail.getUom());
                settleddDO.setTaxRate(detail.getTaxRate());
                settleddDO.setOriginAmt(detail.getAmt());
                settleddDO.setReceiptAmt(detail.getAmt());
                settleAmt.set(((BigDecimal)settleAmt.get()).add(detail.getAmt()));
                settleddDO.setReceiptTax(detail.getTax());
                settleTax.set(((BigDecimal)settleTax.get()).add(detail.getTax()));
                settleddDO.setRemark(detail.getRemark());
                settleddDO.setLineNo(detail.getSoLineNo());
                settleddDO.setApAmt(detail.getTotalAmount());
                this.salReceiptSettleddRepo.save(settleddDO);
            });
        }
        settleDO.setDocType(soType);
        settleDO.setDocType2("B");
        settleDO.setSettleDate(statementDTO.getProcessTime());
        settleDO.setSoSource(statementDTO.getOrderChannel());
        settleDO.setBuId(statementDTO.getBuId());
        settleDO.setBuCode(statementDTO.getBuCode());
        settleDO.setBuName(statementDTO.getBuName());
        settleDO.setCurrCode(statementDTO.getCurrency());
        settleDO.setOuId(statementDTO.getOuId());
        settleDO.setOuCode(statementDTO.getOuCode());
        settleDO.setOuName(statementDTO.getOuName());
        settleDO.setCustId(statementDTO.getCustId());
        settleDO.setCustCode(statementDTO.getCustCode());
        settleDO.setCustName(statementDTO.getCustName());
        settleDO.setAgentEmpId(statementDTO.getApplyEmpId());
        settleDO.setAgentName(statementDTO.getApplyName());
        settleDO.setCreateUserId(statementDTO.getCreateUserId());
        settleDO.setSettleAmt(settleAmt.get());
        settleDO.setSettleTax(settleTax.get());
        settleDO.setReceiptOuId(statementDTO.getOuId());
        settleDO.setReceiptOuCode(statementDTO.getOuCode());
        settleDO.setReceiptOuName(statementDTO.getOuName());
        this.salReceiptSettleRepo.save(settleDO);
    }

    private SalReceiptStatementDTO getSalReceiptStatementDTO(SalReceiptRespVO receiptDO, List<SalReceiptdRespVO> ddos, String receiptSerial) {
        return null;
    }

    private void setSettledd(SalReceiptStatementDTO statementDTO) {
        SalReceiptSettleDO settleDO = new SalReceiptSettleDO();
        this.salReceiptSettleRepo.save(settleDO);
        SalReceiptSettleitemDO settleitemDO = new SalReceiptSettleitemDO();
        settleitemDO.setMasId(settleDO.getId());
        this.salReceiptSettleitemRepo.save(settleitemDO);
        statementDTO.setSourceId(settleDO.getId());
        SalReceiptSettleddDO settleddDO = new SalReceiptSettleddDO();
        settleddDO.setSettleitemId(settleitemDO.getId());
        if (statementDTO.getDetails() != null && statementDTO.getDetails().size() > 0) {
            settleddDO.setDocNo(((SalReceiptDetailStatementDTO)statementDTO.getDetails().get(0)).getSoNo());
        }
        settleddDO.setDocId(statementDTO.getReceiptId());
        settleddDO.setDocTime(statementDTO.getProcessTime());
        settleddDO.setPno(statementDTO.getDocNo());
        settleddDO.setOuId(statementDTO.getOuId());
        settleddDO.setOuCode(statementDTO.getOuCode());
        settleddDO.setOuName(statementDTO.getOuName());
        settleddDO.setBuId(statementDTO.getBuId());
        settleddDO.setBuCode(statementDTO.getBuCode());
        settleddDO.setBuName(statementDTO.getBuName());
        settleddDO.setCustId(statementDTO.getCustId());
        settleddDO.setCustCode(statementDTO.getCustCode());
        settleddDO.setCustName(statementDTO.getCustName());
        settleddDO.setDocType(statementDTO.getSettleType());
        settleddDO.setDocType2("B");
        settleddDO.setCardAmt(BigDecimal.ZERO);
        settleddDO.setGiftAmt(BigDecimal.ZERO);
        settleddDO.setCouponAmt(BigDecimal.ZERO);
        settleddDO.setUsepointAmt(BigDecimal.ZERO);
        if (statementDTO.getDetails() != null && statementDTO.getDetails().size() > 0) {
            statementDTO.getDetails().forEach(detail -> {
                settleddDO.setDocDId(detail.getReceiptDId());
                settleddDO.setItemCat(detail.getItemClass());
                settleddDO.setFinCat(detail.getFinanceClass());
                settleddDO.setItemCode(detail.getItemCode());
                settleddDO.setItemId(detail.getItemId());
                settleddDO.setItemName(detail.getItemName());
                settleddDO.setUom(detail.getUom());
                settleddDO.setTaxRate(detail.getTaxRate());
                settleddDO.setOriginAmt(detail.getAmt());
                settleddDO.setReceiptAmt(detail.getAmt());
                settleddDO.setReceiptTax(detail.getTax());
                settleddDO.setRemark(detail.getRemark());
                this.salReceiptSettleddRepo.save(settleddDO);
            });
        } else {
            this.salReceiptSettleddRepo.save(settleddDO);
        }
    }

    private List<SalSoDetailRespDTO> getSodListBySodId(List<Long> sodIds) {
        ArrayList<SalSoDetailRespDTO> sodList = new ArrayList<SalSoDetailRespDTO>();
        return sodList;
    }

    private Message<SalReceiptStatementDTO> sendMessage(SalReceiptStatementDTO statementDTO) {
        Message springMessage = MessageBuilder.withPayload((Object)statementDTO).setHeader("KEYS", (Object)UUIDUtil.getUUID()).setHeader("sale-fin", (Object)"sale-fin-sale").build();
        log.info("[sendMessage]\u6536\u6b3e\u7ed3\u7b97\u5355\u53d1\u9001\u6d88\u606f\u961f\u5217, messageId:{}; message payload:{}", springMessage.getHeaders().get((Object)"KEYS"), (Object)JSON.toJSONString((Object)springMessage.getPayload()));
        return springMessage;
    }

    public SalReceiptStateServiceImpl(RmiSysSettingService rmiSysSettingService, SalReceiptSettleddRepo salReceiptSettleddRepo, CrmCustRepo crmCustRepo, RmiSettleDocTypeService rmiSettleDocTypeService, SalReceiptSettleRepo salReceiptSettleRepo, SalReceiptSettleitemRepo salReceiptSettleitemRepo, RmiOrgOuService rmiOrgOuService) {
        this.rmiSysSettingService = rmiSysSettingService;
        this.salReceiptSettleddRepo = salReceiptSettleddRepo;
        this.crmCustRepo = crmCustRepo;
        this.rmiSettleDocTypeService = rmiSettleDocTypeService;
        this.salReceiptSettleRepo = salReceiptSettleRepo;
        this.salReceiptSettleitemRepo = salReceiptSettleitemRepo;
        this.rmiOrgOuService = rmiOrgOuService;
    }
}

