/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import cn.hutool.core.collection.CollUtil;
import cn.zhxu.bs.FieldOp;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.SysEmployeeDetailDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeeUpsertDTO;
import com.elitescloud.cloudt.system.dto.resp.EmployeeUnderlingDTO;
import com.elitescloud.cloudt.system.provider.org.EmployeeRpcService;
import com.elitesland.yst.production.sale.api.service.CrmCustService;
import com.elitesland.yst.production.sale.api.service.SaleStatisticsService;
import com.elitesland.yst.production.sale.api.service.SalesmanInfoService;
import com.elitesland.yst.production.sale.api.service.StatisticsDealerService;
import com.elitesland.yst.production.sale.api.vo.param.crm.CrmCustSimpleParam;
import com.elitesland.yst.production.sale.api.vo.param.salesman.SalesmanInfoSimpleQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.salesman.SalesmanRegionVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsDealerQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsStoreQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.crm.LmSaveCustRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.salesman.SalesmanInfoSimpleRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsTeamRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.StatisticsDealerAppSumRespVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.convert.CrmCustConvert;
import com.elitesland.yst.production.sale.convert.SalesmanInfoConvert;
import com.elitesland.yst.production.sale.dto.SalemanCustDTO;
import com.elitesland.yst.production.sale.dto.SalesmanInfoDTO;
import com.elitesland.yst.production.sale.dto.SalesmanLevelInfoDTO;
import com.elitesland.yst.production.sale.dto.query.SalesmanAPPQueryDTO;
import com.elitesland.yst.production.sale.dto.query.SalesmanInfoAPPRespDTO;
import com.elitesland.yst.production.sale.dto.query.SalesmanQueryDTO;
import com.elitesland.yst.production.sale.dto.save.SalesmanUpdateDTO;
import com.elitesland.yst.production.sale.entity.SalesmanInfoDO;
import com.elitesland.yst.production.sale.repo.SalesmanInfoRepo;
import com.elitesland.yst.production.sale.repo.SalesmanInfoRepoProc;
import com.elitesland.yst.production.sale.search.bean.SalesmanInfoSearchBean;
import com.elitesland.yst.production.sale.search.service.SearchBeanService;
import com.elitesland.yst.production.sale.service.RmiSysUDCService;
import com.elitesland.yst.production.sale.service.SalesmanInfoServiceImpl;
import com.elitesland.yst.production.sale.service.SalesmanRpcService;
import com.elitesland.yst.production.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.yst.production.support.provider.org.service.OrgStoreRpcService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"/rpc/cloudt/sale/salesman"})
public class SalesmanRpcServiceImpl
implements SalesmanRpcService {
    private static final Logger log = LoggerFactory.getLogger(SalesmanRpcServiceImpl.class);
    @Autowired
    private SalesmanInfoRepo salesmanInfoRepo;
    @Autowired
    private SalesmanInfoRepoProc salesmanInfoRepoProc;
    @Autowired
    private RmiSysUDCService rmiSysUDCService;
    @Autowired
    private EmployeeRpcService employeeRpcService;
    @Autowired
    private SalesmanInfoService salesmanInfoService;
    @Autowired
    private SalesmanInfoServiceImpl salesmanInfoServiceImpl;
    @Autowired
    private OrgStoreRpcService orgStoreRpcService;
    @Autowired
    private CrmCustService crmCustService;
    @Autowired
    private StatisticsDealerService statisticsDealerService;
    @Autowired
    private SaleStatisticsService saleStatisticsService;
    @Autowired
    private SearchBeanService searchBeanService;

    public ApiResult<SalesmanInfoDTO> querySalesmanInfo(SalesmanQueryDTO salesmanQueryDTO) {
        Map<String, String> salesmanTypeUDCMap = this.rmiSysUDCService.getCodeMap("yst-supp", UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getCode());
        SalesmanInfoDTO salesmanInfoDTO = new SalesmanInfoDTO();
        if (salesmanQueryDTO.getSalesmanId() != null) {
            Optional salesmanInfoRepoById = this.salesmanInfoRepo.findById(salesmanQueryDTO.getSalesmanId());
            if (salesmanInfoRepoById.isEmpty()) {
                return ApiResult.fail((String)"\u672a\u67e5\u8be2\u5230\u4e1a\u52a1\u5458\u4fe1\u606f");
            }
            SalesmanInfoDO salesmanInfoDO = (SalesmanInfoDO)((Object)salesmanInfoRepoById.get());
            salesmanInfoDTO.setId(salesmanInfoDO.getId());
            salesmanInfoDTO.setSalesmanNo(salesmanInfoDO.getSalesmanNo());
            salesmanInfoDTO.setSalesmanType(salesmanInfoDO.getSalesmanType());
            salesmanInfoDTO.setSalesmanTypeName(salesmanTypeUDCMap.get(salesmanInfoDO.getSalesmanType()));
            salesmanInfoDTO.setOuName(salesmanInfoDO.getOuName());
            salesmanInfoDTO.setOuCode(salesmanInfoDO.getOuCode());
            salesmanInfoDTO.setFileCode(salesmanInfoDO.getFileCode());
            ApiResult detailListByCode = this.employeeRpcService.getDetailListByCode(Set.of(salesmanInfoDO.getSalesmanNo()));
            if (!detailListByCode.isSuccess()) {
                return ApiResult.fail((String)"\u67e5\u8be2\u5458\u5de5\u4fe1\u606f\u5931\u8d25");
            }
            List detailDTOS = (List)detailListByCode.getData();
            if (CollUtil.isEmpty((Collection)detailDTOS)) {
                return ApiResult.ok((Object)salesmanInfoDTO);
            }
            salesmanInfoDTO.setFullName(((SysEmployeeDetailDTO)detailDTOS.get(0)).getFullName());
            salesmanInfoDTO.setPhone(((SysEmployeeDetailDTO)detailDTOS.get(0)).getPhone());
            salesmanInfoDTO.setOrgId(((SysEmployeeDetailDTO.EmployeeOrg)((SysEmployeeDetailDTO)detailDTOS.get(0)).getOrgList().get(0)).getOrgId());
            salesmanInfoDTO.setOrgName(((SysEmployeeDetailDTO.EmployeeOrg)((SysEmployeeDetailDTO)detailDTOS.get(0)).getOrgList().get(0)).getOrgName());
            return ApiResult.ok((Object)salesmanInfoDTO);
        }
        if (salesmanQueryDTO.getSalesmanCode() != null) {
            SalesmanInfoDO salesmanInfoRepoById = this.salesmanInfoRepo.findBySalesmanNo(salesmanQueryDTO.getSalesmanCode());
            if (Optional.ofNullable(salesmanInfoRepoById).isEmpty()) {
                return ApiResult.fail((String)"\u672a\u67e5\u8be2\u5230\u4e1a\u52a1\u5458\u4fe1\u606f");
            }
            salesmanInfoDTO.setId(salesmanInfoRepoById.getId());
            salesmanInfoDTO.setSalesmanNo(salesmanInfoRepoById.getSalesmanNo());
            salesmanInfoDTO.setSalesmanType(salesmanInfoRepoById.getSalesmanType());
            salesmanInfoDTO.setSalesmanTypeName(salesmanTypeUDCMap.get(salesmanInfoRepoById.getSalesmanType()));
            salesmanInfoDTO.setOuName(salesmanInfoRepoById.getOuName());
            salesmanInfoDTO.setOuCode(salesmanInfoRepoById.getOuCode());
            salesmanInfoDTO.setFileCode(salesmanInfoRepoById.getFileCode());
            ApiResult detailListByCode = this.employeeRpcService.getDetailListByCode(Set.of(salesmanInfoRepoById.getSalesmanNo()));
            if (!detailListByCode.isSuccess()) {
                return ApiResult.fail((String)"\u67e5\u8be2\u5458\u5de5\u4fe1\u606f\u5931\u8d25");
            }
            List detailDTOS = (List)detailListByCode.getData();
            if (CollUtil.isEmpty((Collection)detailDTOS)) {
                return ApiResult.ok((Object)salesmanInfoDTO);
            }
            salesmanInfoDTO.setFullName(((SysEmployeeDetailDTO)detailDTOS.get(0)).getFullName());
            salesmanInfoDTO.setPhone(((SysEmployeeDetailDTO)detailDTOS.get(0)).getPhone());
            salesmanInfoDTO.setOrgId(((SysEmployeeDetailDTO.EmployeeOrg)((SysEmployeeDetailDTO)detailDTOS.get(0)).getOrgList().get(0)).getOrgId());
            salesmanInfoDTO.setOrgName(((SysEmployeeDetailDTO.EmployeeOrg)((SysEmployeeDetailDTO)detailDTOS.get(0)).getOrgList().get(0)).getOrgName());
            return ApiResult.ok((Object)salesmanInfoDTO);
        }
        return ApiResult.ok((Object)salesmanInfoDTO);
    }

    public ApiResult<List<SalesmanInfoDTO>> querySalesmanInfoList(SalesmanQueryDTO salesmanQueryDTO) {
        Map<String, String> salesmanTypeUDCMap = this.rmiSysUDCService.getCodeMap("yst-supp", UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getCode());
        ArrayList list = new ArrayList();
        if (salesmanQueryDTO.getSalesmanCodeList() != null) {
            List<SalesmanInfoDO> salesmanInfoDOS = this.salesmanInfoRepoProc.getByIdByCodes(salesmanQueryDTO.getSalesmanCodeList());
            if (CollUtil.isEmpty(salesmanInfoDOS)) {
                return ApiResult.fail((String)"\u672a\u67e5\u8be2\u5230\u4e1a\u52a1\u5458\u4fe1\u606f");
            }
            salesmanInfoDOS.forEach(e -> {
                List detailDTOS;
                SalesmanInfoDTO salesmanInfoDTO = new SalesmanInfoDTO();
                salesmanInfoDTO.setId(e.getId());
                salesmanInfoDTO.setSalesmanNo(e.getSalesmanNo());
                salesmanInfoDTO.setSalesmanType(e.getSalesmanType());
                salesmanInfoDTO.setSalesmanTypeName((String)salesmanTypeUDCMap.get(e.getSalesmanType()));
                salesmanInfoDTO.setOuName(e.getOuName());
                salesmanInfoDTO.setOuCode(e.getOuCode());
                salesmanInfoDTO.setFileCode(e.getFileCode());
                ApiResult detailListByCode = this.employeeRpcService.getDetailListByCode(Set.of(e.getSalesmanNo()));
                if (detailListByCode.isSuccess() && CollUtil.isNotEmpty((Collection)(detailDTOS = (List)detailListByCode.getData()))) {
                    salesmanInfoDTO.setFullName(((SysEmployeeDetailDTO)detailDTOS.get(0)).getFullName());
                    salesmanInfoDTO.setPhone(((SysEmployeeDetailDTO)detailDTOS.get(0)).getPhone());
                    salesmanInfoDTO.setOrgId(((SysEmployeeDetailDTO.EmployeeOrg)((SysEmployeeDetailDTO)detailDTOS.get(0)).getOrgList().get(0)).getOrgId());
                    salesmanInfoDTO.setOrgName(((SysEmployeeDetailDTO.EmployeeOrg)((SysEmployeeDetailDTO)detailDTOS.get(0)).getOrgList().get(0)).getOrgName());
                }
                list.add(salesmanInfoDTO);
            });
        }
        return ApiResult.ok(list);
    }

    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Object> updateSalesmanInfo(SalesmanUpdateDTO salesmanUpdateDTO) {
        Long aLong = this.salesmanInfoRepoProc.updateSalesmanInfo(salesmanUpdateDTO);
        if (aLong < 1L) {
            return ApiResult.fail((String)"\u5934\u50cf\u4fe1\u606f\u66f4\u65b0\u5931\u8d25");
        }
        Optional salesmanInfoDO = this.salesmanInfoRepo.findById(salesmanUpdateDTO.getSalesmanId());
        ApiResult upsert = ApiResult.ok();
        if (salesmanInfoDO.isPresent() && StringUtils.isNotBlank((CharSequence)salesmanUpdateDTO.getPhone())) {
            SalesmanInfoDO infoDO = (SalesmanInfoDO)((Object)salesmanInfoDO.get());
            EmployeeUpsertDTO employeeUpsertDTO = new EmployeeUpsertDTO();
            employeeUpsertDTO.setPhone(salesmanUpdateDTO.getPhone());
            employeeUpsertDTO.setCode(infoDO.getSalesmanNo());
            ApiResult apiResult = this.employeeRpcService.getDetailByCode(infoDO.getSalesmanNo());
            SysEmployeeDetailDTO resultData = (SysEmployeeDetailDTO)apiResult.getData();
            if (apiResult.isSuccess()) {
                upsert = this.employeeRpcService.updateMobile(resultData.getId(), salesmanUpdateDTO.getPhone(), Boolean.valueOf(true));
            }
        }
        return ApiResult.ok((Object)upsert.getData());
    }

    public ApiResult<List<SalesmanInfoAPPRespDTO>> salesmanTeam(SalesmanAPPQueryDTO salesmanAPPQueryDTO) {
        return this.salesmanInfoService.salesmanTeam(salesmanAPPQueryDTO);
    }

    public List<SalesmanInfoAPPRespDTO> assembleUnderlingList(List<EmployeeUnderlingDTO> underlingList, String docMonth, LocalDateTime docTimeStart, LocalDateTime docTimeEnd) {
        if (CollectionUtils.isEmpty(underlingList)) {
            return Collections.EMPTY_LIST;
        }
        List<SalesmanInfoAPPRespDTO> salesmanInfoAPPRespDTOList = underlingList.stream().map(employeeUnderlingDTO -> {
            SalesmanInfoAPPRespDTO salesmanInfo = new SalesmanInfoAPPRespDTO();
            salesmanInfo.setCode(employeeUnderlingDTO.getCode());
            salesmanInfo.setId(employeeUnderlingDTO.getId());
            salesmanInfo.setFullName(employeeUnderlingDTO.getFullName());
            salesmanInfo.setEnabled(employeeUnderlingDTO.getEnabled());
            salesmanInfo.setPhone(employeeUnderlingDTO.getPhone());
            salesmanInfo.setHasUnder(employeeUnderlingDTO.getHasUnderling());
            return salesmanInfo;
        }).collect(Collectors.toList());
        this.assembleSalePerformance(salesmanInfoAPPRespDTOList, docMonth, docTimeStart, docTimeEnd);
        return salesmanInfoAPPRespDTOList;
    }

    public void assembleSalePerformance(List<SalesmanInfoAPPRespDTO> respDTOList, String docMonth, LocalDateTime docTimeStart, LocalDateTime docTimeEnd) {
        List codeList = respDTOList.stream().map(SalesmanInfoAPPRespDTO::getCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        SaleStatisticsDealerQueryVO statisticsDealerQueryVO = new SaleStatisticsDealerQueryVO();
        statisticsDealerQueryVO.setAgentEmpList(codeList);
        statisticsDealerQueryVO.setDocMonth(docMonth);
        statisticsDealerQueryVO.setDocTimeStart(docTimeStart);
        statisticsDealerQueryVO.setDocTimeEnd(docTimeEnd);
        List dealerSumList = this.statisticsDealerService.appSumByEmpCode(statisticsDealerQueryVO);
        SaleStatisticsStoreQueryVO statisticsStoreQueryVO = new SaleStatisticsStoreQueryVO();
        statisticsStoreQueryVO.setAgentEmpList(codeList);
        statisticsStoreQueryVO.setDocMonth(docMonth);
        statisticsStoreQueryVO.setDocTimeStart(docTimeStart);
        statisticsStoreQueryVO.setDocTimeEnd(docTimeEnd);
        List storeSumList = this.saleStatisticsService.queryByCodes(statisticsStoreQueryVO);
        respDTOList.forEach(salesmanDTO -> {
            Optional<SaleStatisticsTeamRespVO> storeOptional;
            Optional<StatisticsDealerAppSumRespVO> dealerOptional = dealerSumList.stream().filter(respVO -> Objects.equals(respVO.getAgentEmpCode(), salesmanDTO.getCode())).findFirst();
            if (dealerOptional.isPresent()) {
                salesmanDTO.setDealerTeamShipQty(dealerOptional.get().getTeamShipTotalQty());
                salesmanDTO.setDealerTeamOrderQty(dealerOptional.get().getTeamOrderTotalQty());
                salesmanDTO.setDealerMyShipQty(dealerOptional.get().getMyShipTotalQty());
                salesmanDTO.setDealerMyOrderQty(dealerOptional.get().getMyOrderTotalQty());
                salesmanDTO.setDealerTotalQty(dealerOptional.get().getDealerTotalQty());
            }
            if ((storeOptional = storeSumList.stream().filter(respVO -> Objects.equals(respVO.getAgentEmp(), salesmanDTO.getCode())).findFirst()).isPresent()) {
                salesmanDTO.setStoreMyShipQty(storeOptional.get().getPersonalPerformance());
                salesmanDTO.setStoreTeamShipQty(storeOptional.get().getTeamPerformance());
            }
        });
    }

    public MapBuilder setMapBuilder(SalesmanAPPQueryDTO param) {
        MapBuilder whereSqlMapBuilder = MapUtils.builder();
        if (StringUtils.isNotBlank((CharSequence)param.getType())) {
            ((MapBuilder)whereSqlMapBuilder.field(SalesmanInfoSearchBean::getSalesmanType, new Object[]{param.getType()})).op((FieldOp)FieldOps.Equal);
        }
        ((MapBuilder)whereSqlMapBuilder.field(SalesmanInfoSearchBean::getEnableStatus, new Object[]{1})).op((FieldOp)FieldOps.Equal);
        return whereSqlMapBuilder;
    }

    public ApiResult<SalemanCustDTO> getSalemanCust(Long id) {
        log.info("\u6839\u636e\u95e8\u5e97\u67e5\u8be2\u5ba2\u6237\u548c\u4e1a\u52a1\u5458\u4fe1\u606f\u53c2\u6570 \u95e8\u5e97id:" + id);
        if (ObjectUtils.isEmpty((Object)id)) {
            return ApiResult.ok();
        }
        OrgStoreDetailRpcDTO storeDetail = this.orgStoreRpcService.get(id);
        log.info("\u6839\u636e\u95e8\u5e97id\u67e5\u8be2\u95e8\u5e97\u4fe1\u606f\u53c2\u6570id:" + id + "\u8fd4\u56de" + JSON.toJSONString((Object)storeDetail));
        if (ObjectUtils.isEmpty((Object)storeDetail) || StringUtils.isEmpty((CharSequence)storeDetail.getPcode())) {
            log.info("\u95e8\u5e97\u4fe1\u606f\u4e3a\u7a7a\u6216\u8005pCode\u4e3a\u7a7a");
            return ApiResult.ok();
        }
        CrmCustSimpleParam param = new CrmCustSimpleParam();
        param.setCustCode(storeDetail.getPcode());
        List list = this.crmCustService.getCustSimpleByParam(param);
        log.info("\u6839\u636e\u5bf9\u5e94\u516c\u53f8\u67e5\u8be2\u5ba2\u6237\u57fa\u672c\u4fe1\u606f\u53c2\u6570,param:{},\u8fd4\u56de list:{}", (Object)param, (Object)list);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return ApiResult.ok();
        }
        LmSaveCustRespVO cust = (LmSaveCustRespVO)list.get(0);
        log.info("\u516c\u53f8\u5bf9\u5e94\u5ba2\u6237\u57fa\u672c\u4fe1\u606f\uff1a-----" + JSON.toJSONString((Object)cust));
        if (ObjectUtils.isEmpty((Object)cust.getAgentEmpId()) || ObjectUtils.isEmpty((Object)cust.getAgentEmpId())) {
            SalemanCustDTO s = CrmCustConvert.INSTANCE.dtoConvertLmSaveCustRespVO(cust);
            return ApiResult.ok((Object)s);
        }
        SalesmanLevelInfoDTO salesmanLevel = this.salesmanInfoService.queryLevelInfo(cust.getAgentEmpId());
        SalemanCustDTO salemanCustDTO = SalesmanInfoConvert.INSTANCE.salesmanCoverLevel(salesmanLevel);
        salemanCustDTO.setPath(salesmanLevel.getSalesman_path());
        salemanCustDTO.setCustAbbr(cust.getCustAbbr());
        salemanCustDTO.setCustName(cust.getCustName());
        salemanCustDTO.setCustCode2(cust.getCustCode2());
        salemanCustDTO.setCustCode(cust.getCustCode());
        salemanCustDTO.setRegion(cust.getRegion());
        salemanCustDTO.setPid(cust.getPid());
        return ApiResult.ok((Object)salemanCustDTO);
    }

    public ApiResult<SalesmanLevelInfoDTO> queryLevelInfo(Long id) {
        return ApiResult.ok((Object)this.salesmanInfoService.queryLevelInfo(id));
    }

    public List<SalesmanInfoSimpleRespVO> simpleQuery(SalesmanInfoSimpleQueryVO param) {
        log.info("\u4e1a\u52a1\u5458\u57fa\u672c\u4fe1\u606f\u67e5\u8be2\u5165\u53c2 {}", (Object)param);
        Map<String, String> regionUDCMap = this.rmiSysUDCService.getCodeMap("yst-supp", UdcEnum.CRM_CUST_REGION_HN_NORTH.getCode());
        Map<String, String> salesmanTypeUDCMap = this.rmiSysUDCService.getCodeMap("yst-sale", UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getCode());
        List<SalesmanInfoSimpleRespVO> simpleRespVOS = this.salesmanInfoRepoProc.simpleQuery(param);
        if (CollUtil.isEmpty(simpleRespVOS)) {
            return new ArrayList<SalesmanInfoSimpleRespVO>();
        }
        Set codes = simpleRespVOS.stream().map(SalesmanInfoSimpleRespVO::getSalesmanNo).collect(Collectors.toSet());
        ApiResult detailListByCode = this.employeeRpcService.getDetailListByCode(codes);
        if (!detailListByCode.isSuccess()) {
            return simpleRespVOS;
        }
        Map<Long, List<SalesmanRegionVO>> salesmanRegionMap = this.salesmanInfoServiceImpl.getSalesmanRegionMap(regionUDCMap, simpleRespVOS.stream().map(SalesmanInfoSimpleRespVO::getId).collect(Collectors.toList()));
        List employeeDetailDTOS = (List)detailListByCode.getData();
        Map<String, SysEmployeeDetailDTO> detailDTOMap = employeeDetailDTOS.stream().collect(Collectors.toMap(SysEmployeeDetailDTO::getCode, v -> v, (v1, v2) -> v1));
        for (SalesmanInfoSimpleRespVO simpleRespVO : simpleRespVOS) {
            SysEmployeeDetailDTO employeeDetailDTO = detailDTOMap.get(simpleRespVO.getSalesmanNo());
            if (Optional.ofNullable(employeeDetailDTO).isPresent()) {
                simpleRespVO.setFullName(employeeDetailDTO.getFullName());
                simpleRespVO.setAreaVO(employeeDetailDTO.getAreaVO());
                simpleRespVO.setAddress(employeeDetailDTO.getAddress());
                simpleRespVO.setPhone(employeeDetailDTO.getPhone());
            }
            simpleRespVO.setJurisdiction(salesmanRegionMap.get(simpleRespVO.getId()));
            simpleRespVO.setSalesmanTypeName(salesmanTypeUDCMap.get(simpleRespVO.getSalesmanType()));
        }
        return simpleRespVOS;
    }

    public ApiResult<List<SalesmanInfoDTO>> querySalesmanInfoByIds(SalesmanQueryDTO salesmanQueryDTO) {
        Map<String, String> salesmanTypeUDCMap = this.rmiSysUDCService.getCodeMap("yst-supp", UdcEnum.SALE_SALESMAN_TYPE_CHIEF.getCode());
        ArrayList list = new ArrayList();
        if (CollUtil.isNotEmpty((Collection)salesmanQueryDTO.getSalesmanIdList())) {
            List<SalesmanInfoDO> salesmanInfoDOS = this.salesmanInfoRepoProc.getByIds(salesmanQueryDTO.getSalesmanIdList());
            if (CollUtil.isEmpty(salesmanInfoDOS)) {
                return ApiResult.fail((String)"\u672a\u67e5\u8be2\u5230\u4e1a\u52a1\u5458\u4fe1\u606f");
            }
            salesmanInfoDOS.forEach(e -> {
                List detailDTOS;
                SalesmanInfoDTO salesmanInfoDTO = new SalesmanInfoDTO();
                salesmanInfoDTO.setId(e.getId());
                salesmanInfoDTO.setSalesmanNo(e.getSalesmanNo());
                salesmanInfoDTO.setSalesmanType(e.getSalesmanType());
                salesmanInfoDTO.setSalesmanTypeName((String)salesmanTypeUDCMap.get(e.getSalesmanType()));
                salesmanInfoDTO.setOuName(e.getOuName());
                salesmanInfoDTO.setOuCode(e.getOuCode());
                salesmanInfoDTO.setFileCode(e.getFileCode());
                ApiResult detailListByCode = this.employeeRpcService.getDetailListByCode(Set.of(e.getSalesmanNo()));
                if (detailListByCode.isSuccess() && CollUtil.isNotEmpty((Collection)(detailDTOS = (List)detailListByCode.getData()))) {
                    salesmanInfoDTO.setFullName(((SysEmployeeDetailDTO)detailDTOS.get(0)).getFullName());
                    salesmanInfoDTO.setPhone(((SysEmployeeDetailDTO)detailDTOS.get(0)).getPhone());
                    salesmanInfoDTO.setOrgId(((SysEmployeeDetailDTO.EmployeeOrg)((SysEmployeeDetailDTO)detailDTOS.get(0)).getOrgList().get(0)).getOrgId());
                    salesmanInfoDTO.setOrgName(((SysEmployeeDetailDTO.EmployeeOrg)((SysEmployeeDetailDTO)detailDTOS.get(0)).getOrgList().get(0)).getOrgName());
                }
                list.add(salesmanInfoDTO);
            });
        }
        return ApiResult.ok(list);
    }
}

