/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.elitescloud.cloudt.system.provider.dto.SysUserRpcDTO;
import com.elitescloud.cloudt.system.provider.param.SysUserRpcDtoParam;
import com.elitesland.yst.production.sale.api.service.shop.BipItemEvalService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipItemEvalParmVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemEvalRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemSkuAttrRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipItemSkuRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipItemEvalAppRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipItemEvalDetailAppRespVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipItemEvalDetailSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipItemEvalSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipItemEvalSimpleSaveVO;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.convert.shop.BipItemConvert;
import com.elitesland.yst.production.sale.convert.shop.BipItemEvalCovert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.BipCompanyManageDO;
import com.elitesland.yst.production.sale.entity.BipCustUserBindDO;
import com.elitesland.yst.production.sale.entity.BipItemDO;
import com.elitesland.yst.production.sale.entity.BipItemEvalDo;
import com.elitesland.yst.production.sale.entity.BipItemPicDO;
import com.elitesland.yst.production.sale.entity.BipItemSkuDO;
import com.elitesland.yst.production.sale.entity.BipOrderDO;
import com.elitesland.yst.production.sale.entity.QBipItemEvalDo;
import com.elitesland.yst.production.sale.event.ItemEvalChangeEvent;
import com.elitesland.yst.production.sale.repo.shop.BipCompanyManageRepo;
import com.elitesland.yst.production.sale.repo.shop.BipCustUserBindRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipItemEvalRepo;
import com.elitesland.yst.production.sale.repo.shop.BipItemEvalRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipItemPicRepo;
import com.elitesland.yst.production.sale.repo.shop.BipItemRepo;
import com.elitesland.yst.production.sale.repo.shop.BipItemSkuRepo;
import com.elitesland.yst.production.sale.repo.shop.BipOrderDRepo;
import com.elitesland.yst.production.sale.repo.shop.BipOrderRepo;
import com.elitesland.yst.production.sale.repo.shop.BipOrderRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysUserService;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BipItemEvalServiceImpl
extends BaseServiceImpl
implements BipItemEvalService {
    private static final Logger log = LoggerFactory.getLogger(BipItemEvalServiceImpl.class);
    @Autowired
    private BipItemEvalRepo bipItemEvalRepo;
    @Autowired
    private BipOrderDRepo bipOrderDRepo;
    @Autowired
    private BipItemRepo bipItemRepo;
    @Autowired
    private BipItemEvalRepoProc bipItemEvalRepoProc;
    @Autowired
    private BipOrderRepo bipOrderRepo;
    @Autowired
    private BipOrderRepoProc bipOrderRepoProc;
    @Autowired
    private BipItemSkuRepo bipItemSkuRepo;
    @Autowired
    private BipItemPicRepo bipItemPicRepo;
    @Autowired
    protected JPAQueryFactory jpaQueryFactory;
    @Autowired
    private RmiSysUserService rmiSysUserService;
    @Autowired
    private BipCustUserBindRepoProc bipCustUserBindRepoProc;
    @Autowired
    private BipCompanyManageRepo bipCompanyManageRepo;
    private final QBipItemEvalDo qBipItemEvalDo = QBipItemEvalDo.bipItemEvalDo;
    private static final String REPLACE = "*";
    private static final String REPLACE_CHAR = "\u661f";

    public PagingVO<BipItemEvalRespVO> findItemEvalPage(BipItemEvalParmVO bipItemEvalParmVO) {
        Predicate predicate = this.where(bipItemEvalParmVO);
        predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)DataAuthJpaUtil.dataAuthJpaPredicate((PathMetadata)this.qBipItemEvalDo.getMetadata()));
        Page page = this.bipItemEvalRepo.findAll(predicate, (Pageable)bipItemEvalParmVO.getPageRequest());
        List list = page.getContent().stream().map(BipItemEvalCovert.INSTANCE::doToRespVO).collect(Collectors.toList());
        List skuIds = list.stream().map(BipItemEvalRespVO::getSkuId).collect(Collectors.toList());
        List<Long> ouIds = list.stream().map(BipItemEvalRespVO::getOuId).collect(Collectors.toList());
        Map<Long, String> skuMap = this.bipItemSkuRepo.findAllById(skuIds).stream().collect(Collectors.toMap(BaseModel::getId, BipItemSkuDO::getSkuCode, (t1, t2) -> t1));
        Map<Long, String> ouMap = this.bipCompanyManageRepo.findAllByOuIdIn(ouIds).stream().collect(Collectors.toMap(BipCompanyManageDO::getOuId, BipCompanyManageDO::getOuName, (t1, t2) -> t1));
        for (BipItemEvalRespVO vo : list) {
            Long itemId = vo.getItemId();
            if (itemId == null) {
                throw new BusinessException("\u5546\u54c1Id\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            Optional optionalBipItemDO = this.bipItemRepo.findById(itemId);
            if (optionalBipItemDO.isPresent()) {
                BipItemDO bipItemDO = (BipItemDO)optionalBipItemDO.get();
                vo.setScoreEval(bipItemDO.getScoreEval());
                vo.setNumEval(bipItemDO.getNumEval());
                vo.setRateEvalGood(bipItemDO.getRateEvalGood());
                vo.setNumEvalGood(bipItemDO.getNumEvalGood());
            }
            vo.setSkuCode(skuMap.get(vo.getSkuId()));
            vo.setOuName(ouMap.get(vo.getOuId()));
            vo.setItemEvalScore(StringUtils.isNotBlank((CharSequence)vo.getItemEvalScore()) ? vo.getItemEvalScore() + REPLACE_CHAR : null);
        }
        return PagingVO.builder().total(page.getTotalElements()).records(list).build();
    }

    public PagingVO<BipItemEvalDetailAppRespVO> findItemEvalAppPage(BipItemEvalParmVO bipItemEvalParmVO) {
        Page page = this.bipItemEvalRepo.findAll(this.where(bipItemEvalParmVO), (Pageable)bipItemEvalParmVO.getPageRequest());
        List<BipItemEvalDetailAppRespVO> list = page.getContent().stream().map(BipItemEvalCovert.INSTANCE::doToAppDetailRespVO).collect(Collectors.toList());
        Map<Long, List<SysUserRpcDTO>> map = this.findUserInfo(list);
        for (BipItemEvalDetailAppRespVO bipItemEvalDetailAppRespVO : list) {
            List<SysUserRpcDTO> sysUserRpcDTOList;
            this.buildAttr(bipItemEvalDetailAppRespVO);
            Long itemId = bipItemEvalDetailAppRespVO.getItemId();
            if (itemId == null) {
                throw new BusinessException("\u5546\u54c1Id\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            if (itemId != null) {
                BipItemDO bipItemDO = (BipItemDO)this.bipItemRepo.findById(itemId).get();
                bipItemEvalDetailAppRespVO.setScoreEval(bipItemDO.getScoreEval());
                bipItemEvalDetailAppRespVO.setNumEval(bipItemDO.getNumEval());
                bipItemEvalDetailAppRespVO.setRateEvalGood(bipItemDO.getRateEvalGood());
                bipItemEvalDetailAppRespVO.setNumEvalGood(bipItemDO.getNumEvalGood());
                bipItemEvalDetailAppRespVO.setItemPicFileCode(bipItemDO.getMainPicFileCode());
            }
            if (!bipItemEvalDetailAppRespVO.getIsPublic().booleanValue()) {
                String userName = bipItemEvalDetailAppRespVO.getCustAccountName();
                bipItemEvalDetailAppRespVO.setCustAccountName(BipItemEvalServiceImpl.hideUserName1(userName));
            }
            if ((sysUserRpcDTOList = map.get(bipItemEvalDetailAppRespVO.getCustAccountId())) != null && !sysUserRpcDTOList.isEmpty()) {
                SysUserRpcDTO sysUserRpcDTO = sysUserRpcDTOList.get(0);
                bipItemEvalDetailAppRespVO.setAvatarCode(sysUserRpcDTO.getAvatarCode());
            }
            if (!StringUtils.isNotBlank((CharSequence)bipItemEvalDetailAppRespVO.getEvalFileCodes())) continue;
            String fileCode = bipItemEvalDetailAppRespVO.getEvalFileCodes();
            List<String> arrayList = Arrays.asList(fileCode.split(","));
            List<FileObjRespVO<?>> fileList = this.getFile(arrayList);
            bipItemEvalDetailAppRespVO.setFileObjRespVOList(fileList);
        }
        return PagingVO.builder().total(page.getTotalElements()).records(list).build();
    }

    public Map<Long, List<SysUserRpcDTO>> findUserInfo(List<BipItemEvalDetailAppRespVO> bipItemEvalDetailAppRespVOS) {
        List userIds = bipItemEvalDetailAppRespVOS.stream().map(BipItemEvalDetailAppRespVO::getCustAccountId).distinct().collect(Collectors.toList());
        SysUserRpcDtoParam sysUserRpcDtoParam = new SysUserRpcDtoParam();
        sysUserRpcDtoParam.setUserIds(userIds);
        List<SysUserRpcDTO> sysUserRpcDTOS = this.rmiSysUserService.findUserRpcDtoByParam(sysUserRpcDtoParam);
        Map<Long, List<SysUserRpcDTO>> map = sysUserRpcDTOS.stream().collect(Collectors.groupingBy(SysUserRpcDTO::getId));
        return map;
    }

    public BipItemEvalAppRespVO findItemEvalByOrderId(Long id) {
        List<BipItemEvalDo> bipItemEvalDoList = this.bipItemEvalRepoProc.findItemEvalByOrderId(id);
        ArrayList<BipItemEvalDetailAppRespVO> bipItemEvalDetailAppRespVOS = new ArrayList<BipItemEvalDetailAppRespVO>();
        BipItemEvalAppRespVO bipItemEvalAppRespVO = new BipItemEvalAppRespVO();
        List<BipItemEvalDetailAppRespVO> bipItemEvalDetailAppRespVOList = bipItemEvalDoList.stream().map(BipItemEvalCovert.INSTANCE::doToAppDetailRespVO).collect(Collectors.toList());
        Map<Long, List<SysUserRpcDTO>> map = this.findUserInfo(bipItemEvalDetailAppRespVOList);
        for (BipItemEvalDetailAppRespVO bipItemEvalDetailAppRespVO : bipItemEvalDetailAppRespVOList) {
            List<SysUserRpcDTO> sysUserRpcDTOList;
            this.buildAttr(bipItemEvalDetailAppRespVO);
            Long itemId = bipItemEvalDetailAppRespVO.getItemId();
            if (itemId == null) {
                throw new BusinessException("\u5546\u54c1Id\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            if (itemId != null) {
                BipItemDO bipItemDO = (BipItemDO)this.bipItemRepo.findById(itemId).get();
                bipItemEvalDetailAppRespVO.setScoreEval(bipItemDO.getScoreEval());
                bipItemEvalDetailAppRespVO.setNumEval(bipItemDO.getNumEval());
                bipItemEvalDetailAppRespVO.setRateEvalGood(bipItemDO.getRateEvalGood());
            }
            if ((sysUserRpcDTOList = map.get(bipItemEvalDetailAppRespVO.getCustAccountId())) != null && !sysUserRpcDTOList.isEmpty()) {
                SysUserRpcDTO sysUserRpcDTO = sysUserRpcDTOList.get(0);
                bipItemEvalDetailAppRespVO.setAvatarCode(sysUserRpcDTO.getAvatarCode());
            }
            if (StringUtils.isNotBlank((CharSequence)bipItemEvalDetailAppRespVO.getEvalFileCodes())) {
                String fileCode = bipItemEvalDetailAppRespVO.getEvalFileCodes();
                List<String> arrayList = Arrays.asList(fileCode.split(","));
                List<FileObjRespVO<?>> fileList = this.getFile(arrayList);
                bipItemEvalDetailAppRespVO.setFileObjRespVOList(fileList);
            }
            bipItemEvalDetailAppRespVOS.add(bipItemEvalDetailAppRespVO);
        }
        BipOrderDO bipOrderDO = (BipOrderDO)this.bipOrderRepo.findById(id).get();
        bipItemEvalAppRespVO.setLogicEvalScore(bipOrderDO.getLogicEvalScore());
        bipItemEvalAppRespVO.setServerEvalScore(bipOrderDO.getServerEvalScore());
        bipItemEvalAppRespVO.setOrderDocNo(bipOrderDO.getDocNo());
        bipItemEvalAppRespVO.setBipItemEvalDetailAppRespVOS(bipItemEvalDetailAppRespVOS);
        return bipItemEvalAppRespVO;
    }

    public void buildAttr(BipItemEvalDetailAppRespVO bipItemEvalDetailAppRespVO) {
        Long skuId = bipItemEvalDetailAppRespVO.getSkuId();
        if (skuId == null) {
            throw new BusinessException("\u5546\u54c1skuID\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        BipItemSkuDO bipItemSkuDO = (BipItemSkuDO)this.bipItemSkuRepo.findById(skuId).get();
        BipItemSkuRespVO bipItemSkuRespVO = BipItemConvert.INSTANCE.sku2DetailRespVO(bipItemSkuDO);
        bipItemSkuRespVO.setAttrList(this.convert2List(bipItemSkuDO.getAttr(), BipItemSkuAttrRespVO.class));
        List<BipItemSkuAttrRespVO> attrList = this.convert2List(bipItemSkuDO.getAttr(), BipItemSkuAttrRespVO.class);
        ArrayList<CallSite> attrStrlist = new ArrayList<CallSite>();
        for (int i = 0; i < attrList.size(); ++i) {
            BipItemSkuAttrRespVO bipItemSkuAttrRespVO = (BipItemSkuAttrRespVO)JSON.parseObject((String)JSON.toJSONString((Object)attrList.get(0)), BipItemSkuAttrRespVO.class);
            if (bipItemSkuAttrRespVO == null) continue;
            attrStrlist.add((CallSite)((Object)(bipItemSkuAttrRespVO.getName() + ":" + bipItemSkuAttrRespVO.getValue())));
        }
        String attstr = String.join((CharSequence)";", attrStrlist);
        bipItemEvalDetailAppRespVO.setItemAttr(attstr);
    }

    public List<BipItemEvalRespVO> findItemEval(BipItemEvalParmVO bipItemEvalParmVO) {
        List list = ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qBipItemEvalDo).from((EntityPath)this.qBipItemEvalDo)).where(this.where(bipItemEvalParmVO))).fetch();
        List<BipItemEvalRespVO> bipItemEvalRespVOS = list.stream().map(BipItemEvalCovert.INSTANCE::doToRespVO).collect(Collectors.toList());
        return bipItemEvalRespVOS;
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveItemEval(BipItemEvalSaveVO bipItemEvalSaveVO) {
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        BipCustUserBindDO bipCustUserBindDO = null;
        if (!Objects.nonNull(currentUserDTO.getUserId())) {
            throw new BusinessException("\u8bf7\u5148\u767b\u5f55!");
        }
        bipCustUserBindDO = this.bipCustUserBindRepoProc.getByUserId(currentUserDTO.getUserId());
        List list = bipItemEvalSaveVO.getBipItemEvalDetailSaveVOS();
        for (BipItemEvalDetailSaveVO bipItemEvalDetailSaveVO2 : list) {
            bipItemEvalDetailSaveVO2.setTel(bipCustUserBindDO.getContactPhone());
            bipItemEvalDetailSaveVO2.setCustAccountId(bipCustUserBindDO.getUserId());
            bipItemEvalDetailSaveVO2.setCustAccountName(bipCustUserBindDO.getUsername());
            bipItemEvalDetailSaveVO2.setOuId(bipCustUserBindDO.getOuId());
            BipItemDO itemDO = (BipItemDO)this.bipItemRepo.findById(bipItemEvalDetailSaveVO2.getItemId()).get();
            bipItemEvalDetailSaveVO2.setItemCode(itemDO.getItemCode());
            BipOrderDO orderDO = (BipOrderDO)this.bipOrderRepo.findById(bipItemEvalDetailSaveVO2.getOrderId()).get();
            bipItemEvalDetailSaveVO2.setDocNo(orderDO.getDocNo());
        }
        this.bipItemEvalRepo.saveAll(BipItemEvalCovert.INSTANCE.savaVosToDos(list));
        BipOrderDO bipOrderDO = (BipOrderDO)this.bipOrderRepo.findById(bipItemEvalSaveVO.getOrderId()).get();
        bipOrderDO.setId(bipItemEvalSaveVO.getOrderId());
        bipOrderDO.setLogicEvalScore(bipItemEvalSaveVO.getLogicEvalScore());
        bipOrderDO.setServerEvalScore(bipItemEvalSaveVO.getServerEvalScore());
        bipOrderDO.setIsEval(true);
        bipOrderDO.setEvalTime(LocalDateTime.now());
        this.bipOrderRepo.save(bipOrderDO);
        List itemIdList = list.stream().map(bipItemEvalDetailSaveVO -> bipItemEvalDetailSaveVO.getItemId()).collect(Collectors.toList());
        for (Long itemId : itemIdList) {
            this.publishEventAsync(new ItemEvalChangeEvent(this, itemId));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateItemEval(List<BipItemEvalDetailSaveVO> bipItemEvalDetailSaveVOList) {
        ArrayList<BipItemEvalDo> bipItemEvalDoList = new ArrayList<BipItemEvalDo>();
        for (BipItemEvalDetailSaveVO bipItemEvalDetailSaveVO : bipItemEvalDetailSaveVOList) {
            if (bipItemEvalDetailSaveVO.getId() == null) {
                throw new BusinessException("\u8bc4\u4ef7id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            BipItemEvalDo bipItemEvalDo = (BipItemEvalDo)this.bipItemEvalRepo.findById(bipItemEvalDetailSaveVO.getId()).get();
            BipItemEvalCovert.INSTANCE.copySavaVoToDo(bipItemEvalDetailSaveVO, bipItemEvalDo);
            bipItemEvalDoList.add(bipItemEvalDo);
        }
        this.bipItemEvalRepo.saveAll(bipItemEvalDoList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateItemEvalIsShow(BipItemEvalSimpleSaveVO bipItemEvalSimpleSaveVO) {
        List ids = bipItemEvalSimpleSaveVO.getIds();
        boolean isShow = bipItemEvalSimpleSaveVO.getIsShow();
        if (ids == null) {
            throw new BusinessException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        this.bipItemEvalRepoProc.updateItmeEvalShow(ids, isShow);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteItemEvalByIds(List<Long> ids) {
        this.bipItemEvalRepo.deleteBipItemEvalDoByIds(ids);
    }

    @Transactional(rollbackFor={Exception.class})
    public void replayItemEval(BipItemEvalDetailSaveVO bipItemEvalDetailSaveVO) {
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        Assert.notNull((Object)bipItemEvalDetailSaveVO.getId(), (String)"\u8bc4\u4ef7\u8868ID\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.bipItemEvalRepo.findById(bipItemEvalDetailSaveVO.getId()).ifPresentOrElse(aDo -> {
            aDo.setReplayName(currentUserDTO.getDetail().getFirstName());
            aDo.setReplayUserId(currentUserDTO.getUserId());
            aDo.setReplayTime(LocalDateTime.now());
            aDo.setReplayContext(bipItemEvalDetailSaveVO.getReplayContext());
            aDo.setIsReplay(true);
            this.bipItemEvalRepo.save(aDo);
        }, () -> {
            throw new BusinessException("\u672a\u627e\u5230\u8be5\u8bc4\u4ef7\u8bb0\u5f55\uff1aID" + bipItemEvalDetailSaveVO.getId());
        });
    }

    public ApiResult<Long> countItemEval(Long itemId, Integer minScore) {
        Long count = minScore == null ? this.bipItemEvalRepoProc.countItemEvalNum(itemId) : this.bipItemEvalRepoProc.countItemEvalNum(itemId, minScore);
        return ApiResult.ok((Object)count);
    }

    public ApiResult<BigDecimal> countItemEvalScore(Long itemId) {
        Long num = this.bipItemEvalRepoProc.countItemEvalNum(itemId);
        if (num == 0L) {
            return ApiResult.ok((Object)BigDecimal.ZERO);
        }
        Integer sum = this.bipItemEvalRepoProc.sumItemEval(itemId);
        if (sum == null) {
            sum = 0;
        }
        BigDecimal score = BigDecimal.valueOf((double)sum.intValue() * 1.0 / (double)num.longValue());
        return ApiResult.ok((Object)score);
    }

    public Predicate where(BipItemEvalParmVO bipItemEvalParmVO) {
        BooleanExpression predicate = this.qBipItemEvalDo.isNotNull();
        if (Objects.nonNull(bipItemEvalParmVO)) {
            if (StringUtils.isNotBlank((CharSequence)bipItemEvalParmVO.getDocNo())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipItemEvalDo.docNo.like("%" + bipItemEvalParmVO.getDocNo() + "%"));
            }
            if (Objects.nonNull(bipItemEvalParmVO.getItemId())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipItemEvalDo.itemId.eq((Object)bipItemEvalParmVO.getItemId()));
            }
            if (StringUtils.isNotBlank((CharSequence)bipItemEvalParmVO.getItemCode())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipItemEvalDo.itemCode.like("%" + bipItemEvalParmVO.getItemCode() + "%"));
            }
            if (StringUtils.isNotBlank((CharSequence)bipItemEvalParmVO.getOuName())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipItemEvalDo.ouName.eq((Object)bipItemEvalParmVO.getOuName()));
            }
            if (StringUtils.isNotBlank((CharSequence)bipItemEvalParmVO.getOuCode())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipItemEvalDo.ouCode.eq((Object)bipItemEvalParmVO.getOuCode()));
            }
            if (bipItemEvalParmVO.getItemEvalScore() != null) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipItemEvalDo.itemEvalScore.eq((Object)bipItemEvalParmVO.getItemEvalScore()));
            }
            if (Objects.nonNull(bipItemEvalParmVO.getOuId())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipItemEvalDo.ouId.eq((Object)bipItemEvalParmVO.getOuId()));
            }
            if (Objects.nonNull(bipItemEvalParmVO.getIsShow())) {
                predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qBipItemEvalDo.isShow.eq(bipItemEvalParmVO.getIsShow()));
            }
        }
        return predicate;
    }

    public BipItemEvalRespVO findItemEval(Long id) {
        BipItemEvalDo bipItemEvalDo = (BipItemEvalDo)this.bipItemEvalRepo.findById(id).get();
        BipItemEvalRespVO vo = BipItemEvalCovert.INSTANCE.doToRespVO(bipItemEvalDo);
        vo.setItemEvalScore(bipItemEvalDo.getItemEvalScore() + REPLACE_CHAR);
        Optional orderDO = this.bipOrderRepo.findById(bipItemEvalDo.getOrderId());
        orderDO.ifPresent(order -> vo.setDocNo(order.getDocNo()));
        List<BipCompanyManageDO> oulist = this.bipCompanyManageRepo.findAllByOuIdIn(Arrays.asList(bipItemEvalDo.getOuId()));
        if (oulist != null && oulist.size() > 0) {
            vo.setOuName(oulist.get(0).getOuName());
        }
        Optional spu = this.bipItemRepo.findById(bipItemEvalDo.getItemId());
        spu.ifPresent(p -> vo.setItemImageCodeUrl(p.getMainPicUrl()));
        Optional sku = this.bipItemRepo.findById(bipItemEvalDo.getSkuId());
        sku.ifPresent(k -> vo.setItemSkuImageCode(k.getMainPicId()));
        if (StringUtils.isNotBlank((CharSequence)vo.getEvalFileCodes())) {
            String fileCode = vo.getEvalFileCodes();
            List<String> arrayList = Arrays.asList(fileCode.split(","));
            vo.setEvalFileCodeList(arrayList);
        }
        if (vo.getItemId() != null) {
            BipItemPicDO pic = this.bipItemPicRepo.findFirstByBipItemIdAndPicAndMain(vo.getItemId(), true, true);
            if (pic != null) {
                vo.setItemImageCode(pic.getFileCode());
            } else {
                BipItemPicDO picture = this.bipItemPicRepo.findFirstByBipItemIdAndPicAndMain(vo.getItemId(), true, false);
                if (picture != null) {
                    vo.setItemImageCode(picture.getFileCode());
                }
            }
        }
        return vo;
    }

    public static String hideUserName1(String username) {
        if (StrUtil.isBlank((CharSequence)username) || username.length() < 2) {
            return username;
        }
        int length = username.length();
        if (length == 2) {
            return username.charAt(0) + REPLACE;
        }
        return username.charAt(0) + "**" + username.charAt(length - 1);
    }
}

