package com.elitesland.yst.production.sale.controller.sal;

import com.elitesland.yst.production.sale.api.service.SalContractRecvService;
import com.elitesland.yst.production.sale.api.vo.param.pro.SalContractRecvPagingParam;
import com.elitesland.yst.production.sale.api.vo.resp.pro.SalContractRecvPageRespVO;
import com.elitesland.yst.production.sale.api.vo.save.SalConRecvImportSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.SalContractImportSaveVO;
import com.elitesland.yst.production.sale.controller.BaseController;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * 项目合同收款计划相关API接口
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/8 8:38 下午
 */
@RestController
@RequestMapping(value = "/contract/recv", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(tags = "销售合同收款计划")
public class SalContractRecvController extends BaseController {

    @Autowired
    private SalContractRecvService salContractRecvService;

    @PostMapping(value = "/query")
    @ApiOperation(value = "销售合同收款计划分页查询")
    @ApiOperationSupport(order = 1)
    public ApiResult<PagingVO<SalContractRecvPageRespVO>> query(@RequestBody SalContractRecvPagingParam pageParam) {
        PagingVO<SalContractRecvPageRespVO> pageResult = salContractRecvService.query(pageParam);
        return ApiResult.ok(pageResult);
    }

    @PostMapping(value = "/ImportConRecvData")
    @ApiOperation(value = "导入合同收款信息数据")
    @ApiOperationSupport(order = 6)
    public ApiResult<Object> parseImportConRecvData(MultipartFile file) {
        List<SalConRecvImportSaveVO> parseData = null;
        try {
            parseData = (List<SalConRecvImportSaveVO>) this.importExcel(file, SalConRecvImportSaveVO.class, 2, 2);
        } catch (Exception e) {
            return ApiResult.fail("解析导入文件失败，请严格按照原始模板数据格式进行导入");
        }
        if (!CollectionUtils.isEmpty(parseData)) {
            return salContractRecvService.conRecvImportData(parseData);
        }
        return ApiResult.ok();
    }
}
