package com.elitesland.yst.production.sale.controller.sal;

import com.alibaba.fastjson.JSONObject;
import com.elitesland.yst.production.sale.api.service.SalProjService;
import com.elitesland.yst.production.sale.api.vo.param.pro.SalProjPagingParam;
import com.elitesland.yst.production.sale.api.vo.param.pro.SalProjQueryParam;
import com.elitesland.yst.production.sale.api.vo.param.pro.SalProjSaveParam;
import com.elitesland.yst.production.sale.api.vo.resp.pro.SalProjDetailRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.pro.SalProjPageRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.pro.SalProjSimpleRespVO;
import com.elitesland.yst.production.sale.api.vo.save.SalContractImportSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.SalProjImportSaveVO;
import com.elitesland.yst.production.sale.controller.BaseController;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import netscape.javascript.JSObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import java.util.List;

/**
 * 项目相关API
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/7 4:32 下午
 */
@RestController
@RequestMapping(value = "/proj", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(tags = "销售项目")
public class SalProjController extends BaseController {

    @Autowired
    private SalProjService salProjService;

    @PostMapping(value = "/query")
    @ApiOperation(value = "项目信息分页查询")
    @ApiOperationSupport(order = 1)
    public ApiResult<PagingVO<SalProjPageRespVO>> query(@RequestBody SalProjPagingParam pageParam) {
        PagingVO<SalProjPageRespVO> result = salProjService.query(pageParam);
        return ApiResult.ok(result);
    }

    @PostMapping(value = "/save")
    @ApiOperation(value = "保存或更新项目信息")
    @ApiOperationSupport(order = 2)
    public ApiResult<JSONObject> saveOrUpdate(@RequestBody @Valid SalProjSaveParam param) {
        return ApiResult.ok(salProjService.save(param));
    }

    @GetMapping(value = "/detail/{id}")
    @ApiOperation(value = "获取项目信息详情")
    @ApiOperationSupport(order = 3)
    public ApiResult<SalProjDetailRespVO> queryOneDetail(@PathVariable("id") Long id) {
        SalProjDetailRespVO result = salProjService.queryOneDetail(id);
        return ApiResult.ok(result);
    }

    @PostMapping(value = "/del")
    @ApiOperation(value = "删除项目")
    @ApiOperationSupport(order = 4)
    public ApiResult<JSObject> deleteProj(@RequestBody List<Long> ids) {
        salProjService.delSalProj(ids);
        return ApiResult.ok();
    }

    @PostMapping(value = "/component")
    @ApiOperation(value = "前端组件查询项目列表")
    @ApiOperationSupport(order = 5)
    public ApiResult<List<SalProjSimpleRespVO>> componentQuery(@RequestBody SalProjQueryParam param) {
        return ApiResult.ok(salProjService.queryByParam(param));
    }

    @PostMapping(value = "/ImportProjData")
    @ApiOperation(value = "合同导入项目信息数据")
    @ApiOperationSupport(order = 6)
    public ApiResult<Object> parseImportProjData(MultipartFile file) {
        List<SalProjImportSaveVO> parseData = null;
        try {
            parseData = (List<SalProjImportSaveVO>) this.importExcel(file, SalProjImportSaveVO.class, 3, 3);
        } catch (Exception e) {
            return ApiResult.fail("解析导入文件失败，请严格按照原始模板数据格式进行导入");
        }
        if (!CollectionUtils.isEmpty(parseData)) {
            return salProjService.projImportData(parseData);
        }
        return ApiResult.ok();
    }

}
