package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.common.convert.BooleanToIntegerConverter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/9/27 09:29
 */
@Entity
@Table(name = "bip_company_manage", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "bip_company_manage", comment = "公司管理")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
@ApiModel(description = "公司管理表")
public class BipCompanyManageDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = -4960760118013935076L;

    @ApiModelProperty("公司ID")
    @Column(name = "ou_id", columnDefinition = "bigInt(20) default null comment 'ou_id'")
    private Long ouId;

    @ApiModelProperty("公司名称")
    @Column(name = "ou_name", columnDefinition = "varchar(255) default null comment '公司名称'")
    private String ouName;

    @ApiModelProperty("公司编码")
    @Column(name = "ou_code", columnDefinition = "varchar(40) default null comment '公司编码'")
    private String ouCode;

    @ApiModelProperty("组织ID")
    @Column(name = "bu_id", columnDefinition = "bigInt(20) default null comment '组织ID'")
    private Long buId;

    @ApiModelProperty("组织名称")
    @Column(name = "bu_name", columnDefinition = "varchar(255) default null comment '组织名称'")
    private String buName;

    @ApiModelProperty("组织编码")
    @Column(name = "bu_code", columnDefinition = "varchar(40) default null comment '组织编码'")
    private String buCode;

    @ApiModelProperty("显示公司名称")
    @Column(name = "view_ou_name", columnDefinition = "varchar(255) default null comment '显示公司名称'")
    private String viewOuName;

    @ApiModelProperty("显示公司状态")
    @Column(name = "view_ou_status", columnDefinition = "tinyint(1) default null comment '显示公司状态'")
    @Convert(converter = BooleanToIntegerConverter.class)
    private Boolean viewOuStatus;

    @ApiModelProperty("客服来源")
    @Column(name = "cust_service_source", columnDefinition = "varchar(255) default null comment '客服来源'")
    private String custServiceSource;

    @ApiModelProperty("客服电话")
    @Column(name = "service_tel", columnDefinition = "varchar(32) default null comment '客服电话'")
    private String serviceTel;

}
