package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.common.convert.BooleanToIntegerConverter;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitesland.yst.production.sale.core.convert.BigDecimalConvert;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

@Entity
@Table(name = "cust_account")
@org.hibernate.annotations.Table(appliesTo = "cust_account", comment = "客户账户信息")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class CustAccountDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -4667455389340858270L;
    @Column(name = "cust_code", columnDefinition = "varchar(40) default null  comment '客户编号'")
    private String custCode;

    @Column(name = "user_name", columnDefinition = "varchar(40) default null  comment '客户登录账号'")
    private String userName;

    @Column(name = "nick_name", columnDefinition = "varchar(40) default null  comment '客户昵称'")
    private String nickName;

    @Column(name = "user_id", columnDefinition = "bigint(18) default null  comment '账号ID'")
    private Long userId;

    @Column(name = "mobile", columnDefinition = "varchar(40) default null  comment '客户手机号'")
    private String mobile;

    @Column(name = "pwd", columnDefinition = "varchar(40) default null  comment '客户登录密码'")
    private String pwd;

    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "balance", columnDefinition = "decimal(20, 4) default null  comment '账户余额'")
    private BigDecimal balance;

    @Column(name = "is_open_account", columnDefinition = "tinyint(1) comment '是否开通账号'")
    private Boolean isOpenAccount;

    @Column(name = "create_account_time", columnDefinition = "datetime default null  comment '发送到系统域生成用户的时间'")
    private LocalDateTime createAccountTime;

    @Column(name = "update_pwd_time", columnDefinition = "datetime default null  comment '密码修改时间'")
    private LocalDateTime updatePwdTime;

    @Column(name = "account_type", columnDefinition = "varchar(40) default null  comment '账户类型'")
    private String accountType;

    @Column(name = "dealer_type", columnDefinition = "varchar(40) default null  comment '经销商类型(一网/二网)'")
    private String dealerType;

    @Column(name = "business_type", columnDefinition = "varchar(256) default null  comment '经营业务类型(整车/配件)'")
    private String businessType;

    @Column(name = "role_code", columnDefinition = "varchar(40) comment '角色编码'")
    private String roleCode;

    @Column(name = "role_Id", columnDefinition = "bigint(20) comment '角色id'")
    private Long roleId;

    @Column(name = "sub_ac_flag", columnDefinition = "tinyint(1) comment '是否为子账号'")
    @Convert(converter = BooleanToIntegerConverter.class)
    private Boolean subAcFlag;

    @Column(name = "enable", columnDefinition = "tinyint(1) comment '是否禁用'")
    @Convert(converter = BooleanToIntegerConverter.class)
    private Boolean enable;

    @Column(name = "is_modify_pwd", columnDefinition = "tinyint(1) comment '是否修改过密码 0否，1是'")
    @Convert(converter = BooleanToIntegerConverter.class)
    private Boolean isModifyPwd;


    @Column(name = "business_type_cust", columnDefinition = "varchar(200) default null  comment '业务类型UDC[yst-sale:BUSINESS_TYPE]'")
    private String businessTypeCust;

}
