package com.elitesland.yst.production.sale.entity;

import com.elitesland.yst.production.sale.core.convert.BigDecimalConvert;
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @author Eric.li (Li Jia Zhe)
 * @date 2021-06-21 16:17
 */
@Entity
@Table(name = "sal_acceptance_d")
@org.hibernate.annotations.Table(appliesTo = "sal_acceptance_d", comment = "合同验收明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class SalAcceptanceDDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -6108338080249481034L;

    @ApiModelProperty(value = "主表ID")
    @Column(name = "mas_id", columnDefinition = "bigint(20) default null  comment '主表ID'")
    private Long masId;

    @ApiModelProperty(value = "销售订单ID")
    @Column(name = "so_id", columnDefinition = "bigint(20) default null  comment '销售订单ID'")
    private Long soId;

    @ApiModelProperty(value = "销售订单号")
    @Column(name = "so_no", columnDefinition = "varchar(40) comment '销售订单号'")
    private String soNo;

    @ApiModelProperty(value = "销售订单明细ID")
    @Column(name = "so_d_id", columnDefinition = "bigint(20) default null  comment '销售订单明细ID'")
    private Long soDId;

    @ApiModelProperty("订单明细行号")
    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "so_line_no", columnDefinition = "decimal(20, 2) default null  comment '行号'")
    private BigDecimal soLineNo;

    @ApiModelProperty(value = "商品ID")
    @Column(name = "item_id", columnDefinition = "bigint(20) default null  comment '商品ID'")
    private Long itemId;

    @ApiModelProperty("商品编码")
    @Column(name = "item_code", columnDefinition = "varchar(40) comment '商品编码'")
    private String itemCode;

    @ApiModelProperty("商品名称")
    @Column(name = "item_name", columnDefinition = "varchar(255) comment '商品名称'")
    private String itemName;

    @ApiModelProperty("商品名称2")
    @Column(name = "item_name2", columnDefinition = "varchar(40) comment '商品名称2'")
    private String itemName2;

    @ApiModelProperty("商品规格")
    @Column(name = "item_spec", columnDefinition = "varchar(255) comment '商品规格'")
    private String itemSpec;

    @ApiModelProperty("商品品牌")
    @Column(name = "item_brand", columnDefinition = "varchar(40) comment '商品品牌'")
    private String itemBrand;

    @ApiModelProperty("单价（含税）")
    @Column(name = "price", columnDefinition = "decimal(20, 8) comment '单价（含税）'")
    private BigDecimal price;

    @ApiModelProperty("税率编码")
    @Column(name = "tax_rate_no", columnDefinition = "varchar(40) comment '税率编码'")
    private String taxRateNo;

    @ApiModelProperty("税率")
    @Column(name = "tax_rate", columnDefinition = "decimal(20, 8) comment '税率'")
    private BigDecimal taxRate;

    @ApiModelProperty("订单金额（含税）")
    @Column(name = "amt", columnDefinition = "decimal(20, 8) comment '订单金额（含税）'")
    private BigDecimal amt;

    @ApiModelProperty("本次验收金额")
    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "ac_amt", columnDefinition = "decimal(20, 2) default null  comment '本次验收金额'")
    private BigDecimal acAmt;

    @ApiModelProperty("本次验收数量")
    @Column(name = "ac_qty", columnDefinition = "decimal(20, 8) default null  comment '本次验收数量'")
    private BigDecimal acQty;

    @ApiModelProperty("本次验收不含税金额")
    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "ac_net_amt", columnDefinition = "decimal(20, 2) default null  comment '本次验收不含税金额'")
    private BigDecimal acNetAmt;

    @ApiModelProperty("本次验收税额")
    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "ac_tax_amt", columnDefinition = "decimal(20, 2) default null  comment '本次验收税额'")
    private BigDecimal acTaxAmt;

    @ApiModelProperty("订单金额(不含税)")
    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "so_net_amt", columnDefinition = "decimal(20, 2) default null  comment '订单金额(不含税)'")
    private BigDecimal soNetAmt;

    @ApiModelProperty("订单税额")
    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "so_tax_amt", columnDefinition = "decimal(20, 2) default null  comment '订单税额'")
    private BigDecimal soTaxAmt;

    @ApiModelProperty("单位")
    @Column(name = "uom", columnDefinition = "varchar(40) comment '单位'")
    private String uom;
}
