package com.elitesland.yst.production.sale.entity;

import com.elitesland.yst.production.sale.core.convert.BigDecimalConvert;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * SAL_INV_APPLYD(销售开票申请明细).
 * <p>
 * 销售开票申请明细
 *
 * @author JinXK
 * @date 2021/6/2 16:59
 */
@Entity
@Table(name = "sal_inv_applyd", indexes = {
        @Index(name = "idx_contract_id", columnList = "contract_id")
})
@org.hibernate.annotations.Table(appliesTo = "sal_inv_applyd", comment = "销售开票申请明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class SalInvApplydDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 1L;

    @Column(name = "mas_id", columnDefinition = "int(10) default 0 comment '主表ID'", nullable = false)
    private Long masId;

    @Column(name = "so_id", columnDefinition = "int(10) default 0 comment '订单ID'")
    private Long soId;

    @Column(name = "so_d_id", columnDefinition = "int(18) default 0 comment '销售明细订单ID'")
    private Long soDId;

    @Column(name = "so_no", columnDefinition = "longtext default null  comment '订单编号'")
    private String soNo;

    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "so_line_no", columnDefinition = "decimal(20, 4) default null  comment '行号'")
    private BigDecimal soLineNo;

    @Column(name = "item_id", columnDefinition = "int(10) default 0 comment '商品ID'")
    private Long itemId;

    @Column(name = "item_code", columnDefinition = "varchar(40) default null  comment '商品编号'")
    private String itemCode;

    @Column(name = "item_name", columnDefinition = "varchar(255) default null  comment '商品名称'")
    private String itemName;

    @Column(name = "item_name2", columnDefinition = "varchar(100) default null  comment '商品名称2'")
    private String itemName2;

    @Column(name = "item_spec", columnDefinition = "longtext default null  comment '商品规格'")
    private String itemSpec;

    @Column(name = "item_brand", columnDefinition = "longtext default null  comment '品牌'")
    private String itemBrand;

    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "so_qty", columnDefinition = "decimal(20, 4) default null  comment '数量'")
    private BigDecimal soQty;

    @Column(name = "so_uom", columnDefinition = "varchar(10) default null  comment '单位'")
    private String soUom;

    @Column(name = "so_tax_rate_no", columnDefinition = "longtext default null  comment '税率编号'")
    private String soTaxRateNo;

    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "so_tax_rate", columnDefinition = "decimal(20, 4) default null  comment '税率'")
    private BigDecimal soTaxRate;

    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "so_tax_amt", columnDefinition = "decimal(20, 4) default null  comment '税额'")
    private BigDecimal soTaxAmt;

    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "so_amt", columnDefinition = "decimal(20, 4) default null  comment '含税金额'")
    private BigDecimal soAmt;

    @Column(name = "apply_qty", columnDefinition = "decimal(20, 4) default null  comment '本次开票数量'")
    private BigDecimal applyQty;

    @Column(name = "apply_amt", columnDefinition = "decimal(20, 4) default null  comment '本次开票金额'")
    private BigDecimal applyAmt;

    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "apply_tax", columnDefinition = "decimal(20, 4) default null  comment '本次开票税额'")
    private BigDecimal applyTax;

    @Column(name = "soa_id", columnDefinition = "bigint(18) default null comment '对账单ID'")
    private Long soaId;

    @Column(name = "soa_detail_id", columnDefinition = "bigint(18) default null comment '对账单明细ID'")
    private Long soaDetailId;

    @Column(name = "soa_no", columnDefinition = "varchar(40) default null  comment '对账单编号'")
    private String soaNo;

    @Column(name = "dod_id", columnDefinition = "bigint(18) default null comment '发货单明细ID'")
    private Long dodId;

    @Column(name = "do_doc_no", columnDefinition = "varchar(40) default null  comment '发货单编号'")
    private String doDocNo;

    @Column(name = "tax_class_desc", columnDefinition = "varchar(100) default null  comment '应税物货应税劳务、服务名称'")
    private String taxClassDesc;

    @Column(name = "tax_class", columnDefinition = "varchar(40) default null  comment '税收分类编码'")
    private String taxClass;

    @Column(name = "apply_net_amt", columnDefinition = "decimal(20, 4) default null  comment '本次开票未税金额'")
    private BigDecimal applyNetAmt;

    @Column(name = "contract_id", columnDefinition = "bigint(20) default null comment '合同ID'")
    private Long contractId;

    @Column(name = "contract_code", columnDefinition = "longtext default null  comment '合同编号'")
    private String contractCode;

    @Column(name = "contract_name", columnDefinition = "longtext default null  comment '合同名称'")
    private String contractName;
}

