package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * SAL_SOA(客户对账单).
 * <p>
 * 客户对账单
 *
 * @auther JinXK
 * @date 2021/7/5 18:08
 */
@Entity
@Table(name = "sal_soa")
@org.hibernate.annotations.Table(appliesTo = "sal_soa", comment = "客户对账单")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class SalSoaDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = -2468586392354735577L;

    @Column(name = "doc_no", columnDefinition = "varchar(40) default null  comment '对账单号'")
    private String docNo;

    @Column(name = "cust_id", columnDefinition = "bigint(18) default null  comment '客户ID'")
    private Long custId;

    @Column(name = "cust_code", columnDefinition = "varchar(40) default null  comment '客户编码'")
    private String custCode;

    @Column(name = "cust_name", columnDefinition = "varchar(200) default null  comment '客户名称'")
    private String custName;

    @Column(name = "ou_id", columnDefinition = "bigint(18) default null comment  '公司ID'")
    private Long ouId;

    @Column(name = "ou_code", columnDefinition = "varchar(40) default null  comment '公司编码'")
    private String ouCode;

    @Column(name = "ou_name", columnDefinition = "varchar(40) default null  comment '公司名称'")
    private String ouName;

    @Column(name = "bu_id", columnDefinition = "bigint(18) default null  comment 'BUID'")
    private Long buId;
    @Column(name = "bu_name", columnDefinition = "varchar(200) default null  comment 'BUNAME'")
    private String buName;


    @Column(name = "soa_date", columnDefinition = "datetime default null  comment '对账日期'")
    private LocalDateTime soaDate;

    @Column(name = "curr_code", columnDefinition = "varchar(40) default null  comment '币种'")
    private String currCode;

    @Column(name = "soa_status", columnDefinition = "varchar(40) default null  comment '对账单状态 //[UDC]SAL:SOA_STATUS'")
    private String soaStatus;

    @Column(name = "apply_emp_id", columnDefinition = "bigint(18) default null  comment '申请人员工ID'")
    private Long applyEmpId;

    @Column(name = "shipped_amt", columnDefinition = "decimal(20, 4) default null  comment '含税发运总金额'")
    private BigDecimal shippedAmt;

    @Column(name = "shipped_net_amt", columnDefinition = "decimal(20, 4) default null  comment '未税发运总金额'")
    private BigDecimal shippedNetAmt;

    @Column(name = "shipped_tax_amt", columnDefinition = "decimal(20, 4) default null  comment '发运税额'")
    private BigDecimal shippedTaxAmt;

    @Column(name = "confirm_amt", columnDefinition = "decimal(20, 4) default null  comment '已签收金额'")
    private BigDecimal confirmAmt;

    @Column(name = "confirm_net_amt", columnDefinition = "decimal(20, 4) default null  comment '未税签收总金额'")
    private BigDecimal confirmNetAmt;

    @Column(name = "confirm_tax_amt", columnDefinition = "decimal(20, 4) default null  comment '签收税额'")
    private BigDecimal confirmTaxAmt;

    @Column(name = "soa_amt", columnDefinition = "decimal(20, 4) default null  comment '对账金额'")
    private BigDecimal soaAmt;

    @Column(name = "soa_net_amt", columnDefinition = "decimal(20, 4) default null  comment '未税对账总金额'")
    private BigDecimal soaNetAmt;

    @Column(name = "soa_tax_amt", columnDefinition = "decimal(20, 4) default null  comment '对账税额'")
    private BigDecimal soaTaxAmt;

    @Column(name = "apply_name", columnDefinition = "varchar(40) default null  comment '申请人姓名'")
    private String applyName;

    @Column(name = "apply_date", columnDefinition = "datetime default null  comment '提交日期'")
    private LocalDateTime applyDate;

    @Column(name = "apply_desc", columnDefinition = "varchar(100) default null  comment '申请描述'")
    private String applyDesc;

    @Column(name = "receipt_id", columnDefinition = "bigint(18) default null  comment '收款单ID'")
    private Long receiptId;

    @Column(name = "receipt_no", columnDefinition = "varchar(40) default null  comment '收款单号'")
    private String receiptNo;

    @Column(name = "inv_apply_id", columnDefinition = "bigint(18) default null  comment '开票申请单ID'")
    private Long invApplyId;

    @Column(name = "inv_apply_no", columnDefinition = "varchar(40) default null  comment '开票申请单号'")
    private String invApplyNo;

    @Column(name = "soa_inv_status", columnDefinition = "varchar(40) default null  comment '对账单开票状态'")
    private String soaInvStatus;

    @Column(name = "soa_receipt_status", columnDefinition = "varchar(40) default null  comment '对账单收款状态'")
    private String soaReceiptStatus;

    @Column(name = "cust_pic", columnDefinition = "varchar(40) default null  comment '客户联系人'")
    private String custPic;

    @Column(name = "cust_pic_tel", columnDefinition = "varchar(40) default null  comment '客户联系人电话'")
    private String custPicTel;

    @Column(name = "apply_emp_tel", columnDefinition = "varchar(40) default null  comment '申请人电话'")
    private String applyEmpTel;

    @Column(name = "inv_apply_amt", columnDefinition = "decimal(20, 4) default null  comment '待开票金额'")
    private BigDecimal invApplyAmt;

    @Column(name = "inv_applying_amt", columnDefinition = "decimal(20, 4) default null  comment '开票中金额'")
    private BigDecimal invApplyingAmt;

    @Column(name = "inv_applyed_amt", columnDefinition = "decimal(20, 4) default null  comment '已开票金额'")
    private BigDecimal invApplyedAmt;

}
