package com.elitesland.yst.production.sale.entity;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.workflow.enums.ProcInstStatus;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;

import lombok.Data;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import org.hibernate.annotations.Where;

/**
 * @author : http://www.chiner.pre
 * @date : 2023-4-10
 * @desc : 任务
 */
@Entity
@Table(name="task_info")
@org.hibernate.annotations.Table(appliesTo = "task_info", comment = "任务")
@Data
@DynamicInsert
@DynamicUpdate
@EqualsAndHashCode(callSuper = true)
@Where(clause = "delete_flag = 0")
public class TaskInfoDO extends BaseModel {

    @Column(name = "code", columnDefinition = "varchar(255) comment '任务编码'")
    private String code;

    @Column(name = "name", columnDefinition = "varchar(255) comment '任务名称'")
    private String name;

    @Column(name = "state", columnDefinition = "varchar(50) comment '任务状态'")
    private String state;

    @Column(name = "delay_flag", columnDefinition = "varchar(255) comment '是否逾期'")
    private String delayFlag;

    @Column(name = "progress", columnDefinition = "decimal(18,2) comment '任务进度'")
    private BigDecimal progress;

    @Column(name = "type", columnDefinition = "varchar(255) comment '任务类型'")
    private String type;

    @Column(name = "ou_code", columnDefinition = "varchar(255) comment '所属公司'")
    private String ouCode;

    @Column(name = "urgency_level", columnDefinition = "varchar(255) comment '紧急程度'")
    private String urgencyLevel;

    @Column(name = "start_time", columnDefinition = "datetime(6) comment '开始时间'")
    private LocalDateTime startTime;

    @Column(name = "end_time", columnDefinition = "datetime(6) comment '结束时间'")
    private LocalDateTime endTime;

    @Column(name = "complete_time", columnDefinition = "datetime(6) comment '完成时间'")
    private LocalDateTime completeTime;

    @Column(name = "repeat_set", columnDefinition = "varchar(255) comment '重复设置'")
    private String repeatSet;

    @Column(name = "repeat_type", columnDefinition = "varchar(255) comment '重复类型（次/天/周/月）'")
    private String repeatType;

    @Column(name = "repeat_interval", columnDefinition = "decimal(18,2) comment '重复间隔'")
    private BigDecimal repeatInterval;

    @Column(name = "appoint_day", columnDefinition = "varchar(255) comment '指定天'")
    private String appointDay;

    @Column(name = "repeat_start_time", columnDefinition = "datetime(6) comment '重复开始时间'")
    private LocalDateTime repeatStartTime;

    @Column(name = "repeat_end_time", columnDefinition = "datetime(6) comment '重复结束时间'")
    private LocalDateTime repeatEndTime;

    @Column(name = "execut_time", columnDefinition = "datetime(6) comment '执行时间'")
    private LocalDateTime executTime;

    @Column(name = "promotion_code", columnDefinition = "varchar(255) comment '活动编码'")
    private String promotionCode;

    @Column(name = "promotion_name", columnDefinition = "varchar(255) comment '活动名称'")
    private String promotionName;

    @Column(name = "force_sign_flag", columnDefinition = "varchar(255) comment '强制签到'")
    private String forceSignFlag;

    @Column(name = "sign_in_range", columnDefinition = "decimal(18,2) comment '签到范围'")
    private BigDecimal signInRange;

    @Column(name = "sign_out_range", columnDefinition = "decimal(18,2) comment '签退范围'")
    private BigDecimal signOutRange;

    @Column(name = "publish_user", columnDefinition = "varchar(255) comment '发布人'")
    private String publishUser;

    @Column(name = "publish_user_id", columnDefinition = "bigint(20) comment '发布人id'")
    private Long publishUserId;

    @Column(name = "publish_user_code", columnDefinition = "varchar(255) comment '发布人code'")
    private String publishUserCode;

    @Column(name = "execut_template", columnDefinition = "varchar(255) comment '执行模板'")
    private String executTemplate;

    @Column(name = "task_desc", columnDefinition = "varchar(255) comment '任务描述'")
    private String taskDesc;

    @Column(name = "file_info", columnDefinition = "varchar(255) comment '文件信息'")
    private String fileInfo;

    @Column(name = "execut_template_id", columnDefinition = "bigint(20) comment '执行模板id'")
    private Long executTemplateId;

    @Column(name = "execut_template_code", columnDefinition = "varchar(255) comment '执行模板code'")
    private String executTemplateCode;

    @Column(name = "execut_template_name", columnDefinition = "varchar(255) comment '执行模板名称'")
    private String executTemplateName;


    @ApiModelProperty("是否关联预算")
    @Comment("是否关联预算")
    @Column(name = "budget_flag", columnDefinition = "tinyint(1) default 0 comment '是否关联预算'")
    private Boolean budgetFlag;

    @ApiModelProperty("预算编码")
    @Comment("预算编码")
    @Column(name = "budget_code", columnDefinition = "varchar(32) default null comment '预算编码'")
    private String budgetCode;

    @ApiModelProperty(value = "预算申请金额")
    @Comment("预算申请金额")
    @Column(name = "budget_apply_amt", precision = 20, scale = 8)
    private BigDecimal budgetApplyAmt;

    @ApiModelProperty(value = "大区编码")
    @Comment("大区编码")
    @Column(name = "area_code")
    private String areaCode;

    @ApiModelProperty(value = "流程实例ID")
    @Comment("流程实例ID")
    @Column(name = "proc_inst_id", length = 64)
    private String procInstId;

    @ApiModelProperty(value = "流程实例状态")
    @Comment("流程实例状态")
    @Column(name = "proc_inst_status", length = 32)
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;

    @ApiModelProperty(value = "提交时间")
    @Comment("提交时间")
    @Column(name = "submit_time", columnDefinition = "datetime(6)")
    private LocalDateTime submitTime;

    @ApiModelProperty(value = "审批通过时间")
    @Comment("审批通过时间")
    @Column(name = "approved_time", columnDefinition = "datetime(6)")
    private LocalDateTime approvedTime;

    @ApiModelProperty(value = "审批意见")
    @Comment("审批意见")
    @Column(name = "approve_comment", length = 500)
    private String approveComment;
}
