package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.time.LocalDateTime;

/**
 * @author : http://www.chiner.pre
 * @date : 2023-4-10
 * @desc : 任务明细表
 */
@Entity
@Table(name = "task_info_dtl")
@org.hibernate.annotations.Table(appliesTo = "task_info_dtl", comment = "任务明细表")
@Data
@DynamicInsert
@DynamicUpdate
@EqualsAndHashCode(callSuper = true)
@Where(clause = "delete_flag = 0")
public class TaskInfoDtlDO extends BaseModel {

    @Column(name = "mas_id", columnDefinition = "bigint(20) comment '关联id'")
    private Long masId;

    @Column(name = "line_no", columnDefinition = "int(10) comment '行号'")
    private Integer lineNo;

    @Column(name = "business_type", columnDefinition = "varchar(255) comment '业务类型'")
    private String businessType;

    @Column(name = "business_code", columnDefinition = "varchar(255) comment '业务编码'")
    private String businessCode;

    @Column(name = "business_id", columnDefinition = "bigint(20) comment '业务id'")
    private Long businessId;

    @Column(name = "business_name", columnDefinition = "varchar(255) comment '业务名称'")
    private String businessName;

    @Column(name = "cust_code2", columnDefinition = "varchar(40) default null  comment '客户号'")
    private String custCode2;

    @Column(name = "dealer_id", columnDefinition = "bigint(20) comment '经销商id'")
    private Long dealerId;

    @Column(name = "dealer_code", columnDefinition = "varchar(255) comment '经销商编码'")
    private String dealerCode;

    @Column(name = "dealer_name", columnDefinition = "varchar(255) comment '经销商名称'")
    private String dealerName;

    @Column(name = "business_time", columnDefinition = "varchar(255) comment '营业时间'")
    private String businessTime;

    @Column(name = "country", columnDefinition = "varchar(255) comment '国家'")
    private String country;

    @Column(name = "province", columnDefinition = "varchar(255) comment '省'")
    private String province;

    @Column(name = "city", columnDefinition = "varchar(255) comment '市'")
    private String city;

    @Column(name = "district", columnDefinition = "varchar(255) comment '区'")
    private String district;

    @Column(name = "address", columnDefinition = "varchar(255) comment '地址'")
    private String address;

    @Column(name = "execut_user", columnDefinition = "varchar(255) comment '执行人'")
    private String executUser;

    @Column(name = "execut_user_id", columnDefinition = "bigint(20) comment '执行人id'")
    private Long executUserId;

    @Column(name = "execut_user_code", columnDefinition = "varchar(255) comment '执行人code'")
    private String executUserCode;

    @Column(name = "complete_time", columnDefinition = "datetime(6) comment '完成时间'")
    private LocalDateTime completeTime;

    @Column(name = "complete_state", columnDefinition = "varchar(255) comment '完成状态'")
    private String completeState;

    @Column(name = "delay_flag", columnDefinition = "varchar(255) comment '是否逾期'")
    private String delayFlag;

    @Column(name = "execut_record_name", columnDefinition = "varchar(255) comment '执行记录'")
    private String executRecordName;

    @Column(name = "execut_record_id", columnDefinition = "bigint(20) comment '执行记录id'")
    private Long executRecordId;

    @Column(name = "execut_record_code", columnDefinition = "varchar(255) comment '执行记录code'")
    private String executRecordCode;

    @Column(name = "x_lon", columnDefinition = "decimal(10,6) comment '经度'")
    private Double xLon;

    @Column(name = "y_lat", columnDefinition = "decimal(10,6) comment '纬度'")
    private Double yLat;

    @Column(name = "coord_type", columnDefinition = "varchar(32) comment '经纬度标准'")
    private String coordType;

    @Column(name = "clock_in_address", columnDefinition = "varchar(500) comment '打卡地址'")
    private String clockInAddress;

    @Column(name = "employee_id", columnDefinition = "bigint(20) default null  comment '业务员员工ID'")
    private Long employeeId;
}
