package com.elitesland.yst.production.sale.event;

import org.springframework.context.ApplicationEvent;

/**
 * 商品上下架事件.
 *
 * @author Kaiser（wang shao）
 * @date 2021/10/14
 */
public class ItemShelfEvent extends ApplicationEvent {

    /**
     * 是否是上架
     */
    private final boolean onShelf;

    /**
     * 商品ID
     */
    private final long bipItemId;

    public ItemShelfEvent(Object source, boolean onShelf, long bipItemId) {
        super(source);
        this.onShelf = onShelf;
        this.bipItemId = bipItemId;
    }

    public boolean isOnShelf() {
        return onShelf;
    }

    public long getBipItemId() {
        return bipItemId;
    }
}
