package com.elitesland.yst.production.sale.event.listener;

import com.alibaba.fastjson.JSON;
import com.elitesland.yst.production.sale.api.dto.BipCartDTO;
import com.elitesland.yst.production.sale.api.service.shop.BipMessageService;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipMessageSaveVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.convert.shop.BipMessageConvert;
import com.elitesland.yst.production.sale.entity.*;
import com.elitesland.yst.production.sale.event.ItemStockUpdateEvent;
import com.elitesland.yst.production.sale.repo.shop.BipCartRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipItemSkuRepo;
import com.elitesland.yst.production.sale.repo.shop.BipMessageRepo;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.concurrent.CompletableFuture;

/**
 * 监听库存
 *
 * @author Shadow（li qun）
 * @since 2021-08-31 16:54
 */
@Component
@Slf4j
@RequiredArgsConstructor
public class CreateMessageAfterChangeListener implements ApplicationListener<ItemStockUpdateEvent> {

    @Autowired
    private BipCartRepoProc bipCartRepoProc;

    @Autowired
    private BipMessageRepo bipMessageRepo;

    private final BipMessageService bipMessageService;

    @Autowired
    private BipItemSkuRepo bipItemSkuRepo;

    private final JPAQueryFactory jpaQueryFactory;

    private QBipItemSkuDO qBipItemSkuDO = QBipItemSkuDO.bipItemSkuDO;
    private QBipItemDO qBipItemDO = QBipItemDO.bipItemDO;
    private QBipCartDO qBipCartDO = QBipCartDO.bipCartDO;

    @Override
    public void onApplicationEvent(ItemStockUpdateEvent event) {

        log.info("监听到库存调整事件：{}, {}", event.getBipItemSkuId(), event.getIncrement());

        CompletableFuture.runAsync(() -> update(event))
                .exceptionally(e -> {
                    log.error("库存调整事件通知购物车的用户消息失败【" + event.getBipItemSkuId() + "】", e);
                    return null;
                });

    }

    private void update(ItemStockUpdateEvent event){

        log.info("库存调整事件入参："+ JSON.toJSONString(event));

        // 库存大于0不做判断
        if (!event.getIncrement()){
            return;
        }

        List<BipCartDTO> carts = bipCartRepoProc.searchCart(event.getBipItemSkuId());

        log.info("库存调整事件购物车："+ JSON.toJSONString(carts));

        // 创建消息
        for (BipCartDTO cart : carts) {

            BipItemSkuDO sku = jpaQueryFactory.select(qBipItemSkuDO).from(qBipItemSkuDO).where(qBipItemSkuDO.id.eq(event.getBipItemSkuId())).fetchOne();
            BipItemDO itemDO = jpaQueryFactory.select(qBipItemDO).from(qBipItemDO).where(qBipItemDO.id.eq(sku.getBipItemId())).fetchOne();
            BipMessageSaveVO param = new BipMessageSaveVO();

            param.setTitle("【到货通知】");
            param.setStatus(UdcEnum.MESSAGE_STATUS_NOTREAD.getValueCode());
            param.setToCustId(cart.getUserId());
            param.setContext("您添加到购物车的商品"+itemDO.getTitle()+"已经有货啦，请尽快下单。");


            BipMessageDO bipMessageDO = BipMessageConvert.INSTANCE.voToDo(param);
            BipMessageDO save = bipMessageRepo.saveAndFlush(bipMessageDO);
            log.info("库存调整事件消息ID："+ JSON.toJSONString(save));
            jpaQueryFactory.update(qBipCartDO).set(qBipCartDO.stockEnough,true).where(qBipCartDO.id.eq(cart.getId())).execute();

        }
    }
}
