package com.elitesland.yst.production.sale.event.listener;

import com.elitesland.yst.production.sale.api.service.FirstSpecialItemService;
import com.elitesland.yst.production.sale.event.ItemShelfEvent;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.concurrent.CompletableFuture;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/10/14
 */
@Component
@Slf4j
public class ItemShelfListener implements ApplicationListener<ItemShelfEvent> {

    @Autowired
    private FirstSpecialItemService firstSpecialItemService;

    @Override
    public void onApplicationEvent(ItemShelfEvent event) {
        log.info("监听到商品上下架事件：{}，{}", event.getBipItemId(), event.isOnShelf());

        // 下架时专区的也下架
        offShelfForSpecial(event);
    }

    private void offShelfForSpecial(ItemShelfEvent event) {
        if (event.isOnShelf()) {
            // 上架的忽略
            return;
        }

        CompletableFuture.runAsync(() -> firstSpecialItemService.updateItemState(List.of(event.getBipItemId())))
                .whenComplete((res, throwable) -> {
                    log.info("专区商品下架处理完毕！");
                    if (throwable != null) {
                        log.error("专区商品下架处理遇到异常：", throwable);
                    }
                });
    }

}
