package com.elitesland.yst.production.sale.repo;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.ExecutRecordDtlQueryParam;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.ExecutRecordDtlRespVO;
import com.elitesland.yst.production.sale.entity.QExecutRecordDtlDO;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author : http://www.chiner.pre
 * @date : 2023-4-12
 * @desc : 执行记录明细表RepoProc
 */
@Component
public class ExecutRecordDtlRepoProc {

    private final QExecutRecordDtlDO qExecutRecordDtlDO = QExecutRecordDtlDO.executRecordDtlDO;
    @Autowired
    private JPAQueryFactory jpaQueryFactory;

    public PagingVO<ExecutRecordDtlRespVO> page(ExecutRecordDtlQueryParam executRecordDtlPageParam) {
        JPAQuery<ExecutRecordDtlRespVO> query = select(ExecutRecordDtlRespVO.class)
                .where(bulidPredicate(executRecordDtlPageParam));
        executRecordDtlPageParam.setPaging(query);
        executRecordDtlPageParam.fillOrders(query, qExecutRecordDtlDO);
        return PagingVO.<ExecutRecordDtlRespVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }


    public Long del(List<Long> ids) {
        Long res = jpaQueryFactory.update(qExecutRecordDtlDO)
                .set(qExecutRecordDtlDO.deleteFlag, 1)
                .where(qExecutRecordDtlDO.id.in(ids))
                .execute();
        return res;
    }


    public ExecutRecordDtlRespVO get(Long id) {
        ExecutRecordDtlRespVO executRecordDtlVO = select(ExecutRecordDtlRespVO.class)
                .where(qExecutRecordDtlDO.id.eq(id))
                .fetchOne();
        return executRecordDtlVO;
    }

    public List<ExecutRecordDtlRespVO> getByMasId(Long id) {
        List<ExecutRecordDtlRespVO> fetch = select(ExecutRecordDtlRespVO.class)
                .where(qExecutRecordDtlDO.masId.eq(id))
                .fetch();
        return fetch;
    }

    public List<ExecutRecordDtlRespVO> getList(ExecutRecordDtlQueryParam executRecordDtlPageParam) {
        List<ExecutRecordDtlRespVO> res = select(ExecutRecordDtlRespVO.class)
                .where(bulidPredicate(executRecordDtlPageParam))
                .fetch();
        return res;
    }


    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qExecutRecordDtlDO.masId,
                qExecutRecordDtlDO.entryTime,
                qExecutRecordDtlDO.leaveTime,
                qExecutRecordDtlDO.signInPosition,
                qExecutRecordDtlDO.signInPositionCode,
                qExecutRecordDtlDO.signOutPosition,
                qExecutRecordDtlDO.signOutPositionCode,
                qExecutRecordDtlDO.signDesc,
                qExecutRecordDtlDO.id,
                qExecutRecordDtlDO.createTime,
                qExecutRecordDtlDO.remark,
                qExecutRecordDtlDO.creator,
                qExecutRecordDtlDO.updater,
                qExecutRecordDtlDO.modifyTime
        )).from(qExecutRecordDtlDO);
    }


    private Predicate bulidPredicate(ExecutRecordDtlQueryParam executRecordDtlPageParam) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder()
                .andEq(null != executRecordDtlPageParam.getMasId(), qExecutRecordDtlDO.masId, executRecordDtlPageParam.getMasId())
                .andEq(null != executRecordDtlPageParam.getEntryTime(), qExecutRecordDtlDO.entryTime, executRecordDtlPageParam.getEntryTime())
                .andEq(null != executRecordDtlPageParam.getLeaveTime(), qExecutRecordDtlDO.leaveTime, executRecordDtlPageParam.getLeaveTime())
                .andEq(StringUtils.isNotBlank(executRecordDtlPageParam.getSignInPosition()), qExecutRecordDtlDO.signInPosition, executRecordDtlPageParam.getSignInPosition())
                .andEq(StringUtils.isNotBlank(executRecordDtlPageParam.getSignInPositionCode()), qExecutRecordDtlDO.signInPositionCode, executRecordDtlPageParam.getSignInPositionCode())
                .andEq(StringUtils.isNotBlank(executRecordDtlPageParam.getSignOutPosition()), qExecutRecordDtlDO.signOutPosition, executRecordDtlPageParam.getSignOutPosition())
                .andEq(StringUtils.isNotBlank(executRecordDtlPageParam.getSignOutPositionCode()), qExecutRecordDtlDO.signOutPositionCode, executRecordDtlPageParam.getSignOutPositionCode())
                .andEq(StringUtils.isNotBlank(executRecordDtlPageParam.getSignDesc()), qExecutRecordDtlDO.signDesc, executRecordDtlPageParam.getSignDesc())
                .build();
        return predicate;
    }
}