package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.api.vo.resp.sal.SalInvApplydRespVO;
import com.elitesland.yst.production.sale.entity.QSalInvApplydDO;
import com.elitesland.yst.production.sale.entity.SalInvApplydDO;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.val;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @auther JinXK
 * @date 2021/6/3 11:28
 */
@Repository
public class SalInvApplydRepoProc {

    @Autowired
    private JPAQueryFactory jpaQueryFactory;

    /**
     * 根据masId查询销售开票申请明细
     */
    public JPAQuery<SalInvApplydRespVO> findBymasId(Long masId) {
        val salInvApplyd = QSalInvApplydDO.salInvApplydDO;

        Predicate predicate = salInvApplyd.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(SalInvApplydRespVO.class,
                salInvApplyd.id,
                salInvApplyd.masId,
                salInvApplyd.soId,
                salInvApplyd.soDId,
                salInvApplyd.soNo,
                salInvApplyd.soLineNo,
                salInvApplyd.itemId,
                salInvApplyd.itemCode,
                salInvApplyd.itemName,
                salInvApplyd.itemSpec,
                salInvApplyd.itemBrand,
                salInvApplyd.soQty,
                salInvApplyd.soUom,
                salInvApplyd.soTaxRate,
                salInvApplyd.soTaxAmt,
                salInvApplyd.soAmt,
                salInvApplyd.applyQty,
                salInvApplyd.applyAmt,
                salInvApplyd.applyTax,
                salInvApplyd.soaId,
                salInvApplyd.soaNo,
                salInvApplyd.dodId,
                salInvApplyd.doDocNo,
                salInvApplyd.soaDetailId,
                salInvApplyd.taxClassDesc,
                salInvApplyd.taxClass,
                salInvApplyd.applyNetAmt,
                salInvApplyd.contractId,
                salInvApplyd.contractCode,
                salInvApplyd.contractName
//                salInvApplyd.remark,
//                salInvApplyd.createUserId,
//                salInvApplyd.createTime,
//                salInvApplyd.modifyUserId,
//                salInvApplyd.modifyTime,
//                salInvApplyd.soTaxRateNo,
//                salInvApplyd.itemName2,
//                salInvApplyd.tenantId

        )).from(salInvApplyd);
        jpaQuery.where(predicate, salInvApplyd.masId.eq(masId));
        jpaQuery.where(predicate, salInvApplyd.deleteFlag.eq(0).or(salInvApplyd.deleteFlag.isNull()));
        return jpaQuery;
    }

    public List<SalInvApplydDO> findBySoCode(String so){
        val salInvApplyd = QSalInvApplydDO.salInvApplydDO;
        return jpaQueryFactory.select(salInvApplyd).from(salInvApplyd).where(salInvApplyd.soNo.eq(so)).fetch();
    }
}
