package com.elitesland.yst.production.sale.rmi.ystinv;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.inv.dto.invwh.InvWhRpcDTO;
import com.elitesland.yst.production.inv.dto.invwh.InvWhRpcDtoParam;
import com.elitesland.yst.production.inv.provider.InvWhProvider;
import com.elitescloud.boot.exception.BusinessException;
//import com.elitesland.yst.inv.provider.InvWhProvider;
//import com.elitesland.yst.inv.vo.resp.InvWhRespVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/6/16 15:42
 */
@Slf4j
@Component
@RequiredArgsConstructor
public class RmiInvWhProviderService {

    private final InvWhProvider invWhProvider;

    public List<InvWhRpcDTO> findBuDtoByParam(List<Long> whIds){
        try {
            InvWhRpcDtoParam param=new InvWhRpcDtoParam();
            param.setWhIds(whIds);
            ApiResult<List<InvWhRpcDTO>> invWhRpcDTOListApiResult = invWhProvider.findWhDTOByParam(param);
            Assert.notNull(invWhRpcDTOListApiResult,"查询仓库失败");
            Assert.isTrue(invWhRpcDTOListApiResult.isSuccess(),"查询仓库失败");

            return CollUtil.isNotEmpty(invWhRpcDTOListApiResult.getData()) ? invWhRpcDTOListApiResult.getData() : new ArrayList<>();
        } catch (Exception e) {
            log.error("远程调用供应链仓库相关服务异常:{}", e.getMessage());
            throw new BusinessException("远程调用供应链仓库查询相关服务异常"+e,e);
        }
    }
}
