package com.elitesland.yst.production.sale.rmi.ystsystem;


import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;
import com.elitescloud.cloudt.system.provider.extend.SysAreaRpcService;
import com.elitescloud.cloudt.system.provider.extend.SysCurrencyRpcService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;

@Slf4j
@Component
public class RmiSysService {

    @Autowired
    private SysAreaRpcService comCurrRpcService;

    @Autowired
    private SysCurrencyRpcService sysCurrencyRpcService;

//    public List<ComCurrRpcDTO> findRpcDtoByParam(ComCurrRpcDtoParam var1){
//        try {
//            return comCurrRpcService.findRpcDtoByParam(var1);
//        }catch (Exception e){
//            log.error("查询币种异常:{}", e.getMessage());
//            throw new BusinessException(ApiCode.FAIL, "查询币种异常");
//        }
//    }

    public ApiResult<List<SysCurrencyRespDTO>> listByCodes(Set<String> codes){
        try {
            return sysCurrencyRpcService.listByCodes(codes);
        }catch (Exception e){
            log.error("查询币种异常:{}", e.getMessage());
            throw new BusinessException(ApiCode.FAIL, "查询币种异常");
        }

    }


}
