package com.elitesland.yst.production.sale.search.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsDealerQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsDealerRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.StatisticsDealerSumRespVO;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/07/04
 * @Version 1.0
 * @Content:
 */
public interface StatisticsDealerSearchService {

    /**
     * 经销商销售业绩分页查询
     *
     * @param pageParam 入参
     * @return 经销商销售业绩信息集合
     */
    PagingVO<SaleStatisticsDealerRespVO> page(SaleStatisticsDealerQueryVO pageParam);

    /**
     * 经销商销售业绩统计汇总
     *
     * @param pageParam 入参
     * @return 统计汇总信息
     */
    StatisticsDealerSumRespVO pageSum(SaleStatisticsDealerQueryVO pageParam);

    /**
     * 经销商销售业绩分页查询-APP端
     *
     * @param pageParam 入参
     * @return 经销商销售业绩信息集合
     */
    PagingVO<SaleStatisticsDealerRespVO> appPage(SaleStatisticsDealerQueryVO pageParam);

    /**
     * 经销商销售业绩统计汇总-APP端
     *
     * @param pageParam 入参
     * @return 统计汇总信息
     */
    StatisticsDealerSumRespVO appPageSum(SaleStatisticsDealerQueryVO pageParam);

    /**
     * 经销商销售业绩详情-头部信息和车型分页明细数据
     *
     * @param pageParam 入参
     * @return 经销商销售业绩详情信息
     */
    PagingVO<SaleStatisticsDealerRespVO> appDetails(SaleStatisticsDealerQueryVO pageParam);
}
