package com.elitesland.yst.production.sale.search.store.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsDealerQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsStoreQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsDealerRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsStoreRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.StatisticsDealerSumRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.StatisticsStoreSumRespVO;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author wz
 * @Date 2023/07/04
 * @Version 1.0
 * @Content:
 */
public interface StatisticsStoreSearchService {

    /**
     * 门店销售业绩分页查询
     *
     * @param pageParam 入参
     * @return 经销商销售业绩信息集合
     */
    PagingVO<SaleStatisticsStoreRespVO> page(SaleStatisticsStoreQueryVO pageParam);

    /**
     * 门店销售业绩统计汇总
     *
     * @param pageParam 入参
     * @return 统计汇总信息
     */
    StatisticsStoreSumRespVO pageSum(SaleStatisticsStoreQueryVO pageParam);

    /**
     * 门店销售业绩分页查询-APP端
     *
     * @param pageParam 入参
     * @return 经销商销售业绩信息集合
     */
    PagingVO<SaleStatisticsStoreRespVO> appPage(SaleStatisticsStoreQueryVO pageParam);

    /**
     * 门店销售业绩统计汇总-APP端
     *
     * @param pageParam 入参
     * @return 统计汇总信息
     */
    StatisticsStoreSumRespVO appPageSum(SaleStatisticsStoreQueryVO pageParam);

    /**
     * 门店销售业绩详情-头部信息和车型分页明细数据
     *
     * @param pageParam 入参
     * @return 经销商销售业绩详情信息
     */
    PagingVO<SaleStatisticsStoreRespVO> appDetails(SaleStatisticsStoreQueryVO pageParam);
}
